<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="modal-dialog modal-lg">
    <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-2x">&times;</i>
            </button>
            <h4 class="modal-title" id="myModalLabel"><?= lang('edit_delivery'); ?></h4>
        </div>
        <?php $attrib = ['data-toggle' => 'validator', 'role' => 'form'];
        echo admin_form_open_multipart('sales/edit_delivery/' . $delivery->id, $attrib); ?>
		<div class="modal-body">
            <p><?= lang('enter_info'); ?></p>

    			<div class="row">
                    <div class="col-md-6">
                        <?php

						if ($Owner || $Admin) {
							?>
								<div class="form-group">
									<?= lang('date', 'date'); ?>
									<?= form_input('date', (isset($_POST['date']) ? $_POST['date'] : $this->sma->hrld($delivery->date)), 'class="form-control datetime" id="date" required="required"'); ?>
								</div>
							<?php
						} ?>
    				</div>
    				<div class="col-md-6">
    				    <div class="form-group">
							<?= lang('status', 'status'); ?>
							<?php
							$opts = ['packing' => lang('packing'), 'delivering' => lang('delivering'), 'delivered' => lang('delivered')];
							?>
							<?= form_dropdown('status', $opts, (isset($_POST['status']) ? $_POST['status'] : $delivery->status), 'class="form-control" id="status" required="required" style="width:100%;"'); ?>
						</div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
							<?= lang('do_reference_no', 'do_reference_no'); ?>
							<?= form_input('do_reference_no', (isset($_POST['do_reference_no']) ? $_POST['do_reference_no'] : $delivery->do_reference_no), 'class="form-control tip" id="do_reference_no" required="required"'); ?>
						</div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group">
							<?= lang('sale_reference_no', 'sale_reference_no'); ?>
							<?= form_input('sale_reference_no', (isset($_POST['sale_reference_no']) ? $_POST['sale_reference_no'] : $delivery->sale_reference_no), 'class="form-control tip" id="sale_reference_no" required="required"'); ?>
						</div>

                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <input type="hidden" value="<?= $delivery->sale_id; ?>" name="sale_id"/>

						<div class="form-group">
							<?= lang('customer', 'customer'); ?>
							<?= form_input('customer', (isset($_POST['customer']) ? $_POST['customer'] : $delivery->customer), 'class="form-control" id="customer" required="required" '); ?>
						</div>
                    </div>

                    <div class="col-md-6">
                       <div class="form-group">
							<?= lang('delivered_by', 'delivered_by'); ?>
							<?= form_input('delivered_by', (isset($_POST['delivered_by']) ? $_POST['delivered_by'] : $delivery->delivered_by), 'class="form-control" id="delivered_by"'); ?>
						</div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
							<?= lang("Driver's Name", "Driver's Name"); ?>
							<?= form_input('drivers_name', (isset($_POST['drivers_name']) ? $_POST['drivers_name'] : $delivery->drivers_name), 'class="form-control" id="drivers_name"'); ?>
						</div>
                    </div>

                    <div class="col-md-6">
                       <div class="form-group">
                            <?= lang("driving_lic", "driving_lic"); ?>
                            <?= form_input('driving_lic', (isset($_POST['driving_lic']) ? $_POST['driving_lic'] : $delivery->driving_lic), 'class="form-control" id="driving_lic"'); ?>
                        </div>
                    </div>
                </div>



                <div class="row">
                    <div class="col-md-6">
                       <div class="form-group">
							<?= lang("Driving Lic.", "Driving Lic."); ?>
							<?= form_input('driving_lic', (isset($_POST['driving_lic']) ? $_POST['driving_lic'] : $delivery->driving_lic), 'class="form-control" id="driving_lic"'); ?>
						</div>

                    </div>

                    <div class="col-md-6">
                       <div class="form-group">
							<?= lang("Vehicle No.", "Vehicle No."); ?>
							<?= form_input('vehicle_no', (isset($_POST['vehicle_no']) ? $_POST['vehicle_no'] : $delivery->vehicle_no), 'class="form-control" id="vehicle_no"'); ?>
						</div>
                    </div>
                </div>


                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                        <?= lang("vehicle_owner", "vehicle_owner"); ?>
                        <?= form_input('vehicle_owner', (isset($_POST['vehicle_owner']) ? $_POST['vehicle_owner'] : $delivery->vehicle_owner), 'class="form-control" id="vehicle_owner"'); ?>
                    </div>

                    </div>

                    <div class="col-md-6">
                       <div class="form-group">
                        <?= lang("vehicle_owners_mobile", "vehicle_owners_mobile"); ?>
                        <?= form_input('vehicle_owners_mobile', (isset($_POST['vehicle_owners_mobile']) ? $_POST['vehicle_owners_mobile'] : $delivery->vehicle_owners_mobile), 'class="form-control" id="vehicle_owners_mobile"'); ?>
                    </div>
                    </div>
                </div>



                 <div class="row">
                    <div class="col-md-6">
                       <div class="form-group">
                        <?= lang('vehicle_owners_address', 'vehicle_owners_address'); ?>
						<?= form_input('vehicle_owners_address', (isset($_POST['vehicle_owners_address']) ? $_POST['vehicle_owners_address'] : $delivery->vehicle_owners_address), 'class="form-control" id="vehicle_owners_address"'); ?>
                        </div>
                    </div>


                     <div class="col-md-6">
                       <div class="form-group">
                        <?= lang('received_by', 'received_by'); ?>
                        <?= form_input('received_by', (isset($_POST['received_by']) ? $_POST['received_by'] : $delivery->received_by), 'class="form-control" id="received_by"'); ?>
                        </div>
                    </div>
                </div>



                 <div class="row" style="background: #9ad9ff;">


                    <?php
                    $inv_items = $this->sales_model->getAllInvoiceItems($delivery->sale_id);

                    //echo "<pre>";  print_r($inv_items);echo "</pre>";
                    ?>


                      <div class="col-md-2">
                         <div class="form-group">
                          <?= lang('rate', 'rate'); ?>
                          <?= form_input('rate', (isset($inv_items[0]->unit_price) ? $inv_items[0]->unit_price : ''), 'class="form-control" disabled id="rate"'); ?>
                          </div>
                      </div>
                    <div class="col-md-2">
                       <div class="form-group">
                        <?= lang('qty', 'qty'); ?> <?= lang('Ton', 'Ton'); ?>/<?= lang('Ft', 'Ft'); ?>
                        <?= form_input('qty', (isset($delivery->qty) ? $delivery->qty : ''), 'class="form-control" id="qty"'); ?>
                        </div>
                    </div>

                    <div class="col-md-2">
                       <div class="form-group">
                        <?= lang('total', 'total'); ?>

                        <?php
                        if($inv_items[0]->unit_price){ $unit_price  = $inv_items[0]->unit_price;}else{$unit_price  = 0;}
                        if($delivery->qty){ $total_items = $delivery->qty;   }else{$total_items = 0;}
                        $total = $unit_price * $total_items;
                        ?>
                        <?= form_input('total', (isset($total) ? $total : ''), 'class="form-control" disabled id="total"'); ?>
                        </div>
                    </div>

                    <div class="col-md-2">
                       <div class="form-group">
                        <?= lang('other_cost', 'other_cost'); ?>
                        <?= form_input('other_cost', (isset($_POST['other_cost']) ? $_POST['other_cost'] : $delivery->other_cost), 'class="form-control" id="other_cost"'); ?>
                        </div>
                    </div>


                     <div class="col-md-2">
                       <div class="form-group">
                        <?= lang('weight_scale_price', 'weight_scale_price'); ?>
                         <?= form_input('weight_scale_price', (isset($_POST['weight_scale_price']) ? $_POST['weight_scale_price'] : $delivery->weight_scale_price), 'class="form-control" id="weight_scale_price"'); ?>
                        </div>
                    </div>

                      <div class="col-md-2">
                       <div class="form-group">
                        <?= lang('transport_fee', 'transport_fee'); ?>
                         <?= form_input('transport_fee', (isset($_POST['transport_fee']) ? $_POST['transport_fee'] : $delivery->transport_fee), 'class="form-control" id="transport_fee"'); ?>
                        </div>
                    </div>



                </div>







            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <?= lang('address', 'address'); ?>
                        <?= form_textarea('address', (isset($_POST['address']) ? $_POST['address'] : $delivery->address), 'class="form-control" id="address" required="required"'); ?>

                    </div>
                </div>

                <div class="col-md-6">
                    <div class="form-group">
                        <?= lang('note', 'note'); ?>
                         <?= form_textarea('note', (isset($_POST['note']) ? $_POST['note'] : $delivery->note), 'class="form-control" id="note"'); ?>
                    </div>
                </div>
            </div>

        </div>

        <div class="modal-footer">
            <?= form_submit('edit_delivery', lang('edit_delivery'), 'class="btn btn-primary"'); ?>
        </div>
    </div>
    <?= form_close(); ?>
</div>
<script type="text/javascript" src="<?= $assets ?>js/custom.js"></script>
<script type="text/javascript" charset="UTF-8">
    $.fn.datetimepicker.dates['sma'] = <?=$dp_lang?>;
</script>
<?= $modal_js ?>
<script type="text/javascript" charset="UTF-8">
    $(document).ready(function () {
        $.fn.datetimepicker.dates['sma'] = <?=$dp_lang?>;


        $(document).on('keypress', '#weight_scale_price', function() {

            var weight_scale_price = parseFloat($(this).val());
            var qty = parseFloat($("#qty").val());
            var grand_total = weight_scale_price * qty;
            $("#grand_total").val(grand_total);
        });

        $(document).on('keyup', '#rate', function() {
            var rate = parseFloat($(this).val());
            var qty = parseFloat($("#qty").val());
            var total = rate * qty;
            $("#total").val(total);
        });


        $(document).on('keyup', '#qty', function() {
            var qty = parseFloat($(this).val());
            var rate = parseFloat($("#rate").val());
            var total = rate * qty;
            $("#total").val(total);
        });

    });
</script>
