<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php

$v = '';
/* if($this->input->post('name')){
  $v .= "&product=".$this->input->post('product');
  } */
if ($this->input->post('product')) {
    $v .= '&product=' . $this->input->post('product');
}
if ($this->input->post('reference_no')) {
    $v .= '&reference_no=' . $this->input->post('reference_no');
}
if ($this->input->post('customer')) {
    $v .= '&customer=' . $this->input->post('customer');
}
if ($this->input->post('biller')) {
    $v .= '&biller=' . $this->input->post('biller');
}
if ($this->input->post('warehouse')) {
    $v .= '&warehouse=' . $this->input->post('warehouse');
}
if ($this->input->post('user')) {
    $v .= '&user=' . $this->input->post('user');
}
if ($this->input->post('serial')) {
    $v .= '&serial=' . $this->input->post('serial');
}
if ($this->input->post('start_date')) {
    $v .= '&start_date=' . $this->input->post('start_date');
}
if ($this->input->post('end_date')) {
    $v .= '&end_date=' . $this->input->post('end_date');
}

?>


<div id="ajax_graphData"></div>

<div class="box">
    <div class="box-header">
        <h2 class="blue"><i class="fa-fw fa fa-heart"></i><?= lang('sales_report'); ?> <?php
            if ($this->input->post('start_date')) {
                echo 'From ' . $this->input->post('start_date') . ' to ' . $this->input->post('end_date');
            }
            ?>
        </h2>

        <div class="box-icon">
            <ul class="btn-tasks">
                <li class="dropdown">
                    <a href="#" class="toggle_up tip" title="<?= lang('hide_form') ?>">
                        <i class="icon fa fa-toggle-up"></i>
                    </a>
                </li>
                <li class="dropdown">
                    <a href="#" class="toggle_down tip" title="<?= lang('show_form') ?>">
                        <i class="icon fa fa-toggle-down"></i>
                    </a>
                </li>
            </ul>
        </div>
        <div class="box-icon">
            <ul class="btn-tasks">
                <li class="dropdown">
                    <a href="#" id="xls" class="tip" title="<?= lang('download_xls') ?>">
                        <i class="icon fa fa-file-excel-o"></i>
                    </a>
                </li>
                <li class="dropdown">
                    <a href="#" id="image" class="tip" title="<?= lang('save_image') ?>">
                        <i class="icon fa fa-file-picture-o"></i>
                    </a>
                </li>
            </ul>
        </div>
    </div>
    <div class="box-content daily_sales_customize">
        <div class="row">
            <div class="col-lg-12">
                <p class="introtext"><?= lang('customize_report'); ?></p>

                <div id="form">

                    <?php echo admin_form_open('reports/sales_with_graph_hourly'); ?>
                    <div class="row">
                        <div class="col-sm-4">
                            <div class="form-group">
                                <?= lang('start_date', 'start_date'); ?>
                                <?php echo form_input('start_date', (isset($_POST['start_date']) ? $_POST['start_date'] : ''), 'class="form-control datetime" id="start_date" autocomplete="off"'); ?>
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="form-group">
                                <?= lang('end_date', 'end_date'); ?>
                                <?php echo form_input('end_date', (isset($_POST['end_date']) ? $_POST['end_date'] : ''), 'class="form-control datetime" id="end_date" autocomplete="off"'); ?>
                            </div>
                        </div>


                        <div hidden class="col-sm-4">
                            <div class="form-group">
                                <?= lang('product', 'suggest_product'); ?>
                                <?php echo form_input('sproduct', (isset($_POST['sproduct']) ? $_POST['sproduct'] : ''), 'class="form-control" id="suggest_product"'); ?>
                                <input type="hidden" name="product" value="<?= isset($_POST['product']) ? $_POST['product'] : '' ?>" id="report_product_id"/>
                            </div>
                        </div>
                        <div hidden class="col-sm-4">
                            <div class="form-group">
                                <label class="control-label" for="reference_no"><?= lang('reference_no'); ?></label>
                                <?php echo form_input('reference_no', (isset($_POST['reference_no']) ? $_POST['reference_no'] : ''), 'class="form-control tip" id="reference_no"'); ?>

                            </div>
                        </div>

                        <div hidden class="col-sm-4">
                            <div class="form-group">
                                <label class="control-label" for="user"><?= lang('created_by'); ?></label>
                                <?php
                                $us[''] = lang('select') . ' ' . lang('user');
                                foreach ($users as $user) {
                                    $us[$user->id] = $user->first_name . ' ' . $user->last_name;
                                }
                                echo form_dropdown('user', $us, (isset($_POST['user']) ? $_POST['user'] : ''), 'class="form-control" id="user" data-placeholder="' . $this->lang->line('select') . ' ' . $this->lang->line('user') . '"');
                                ?>
                            </div>
                        </div>
                        <div hidden class="col-sm-4">
                            <div class="form-group">
                                <label class="control-label" for="customer"><?= lang('customer'); ?></label>
                                <?php echo form_input('customer', (isset($_POST['customer']) ? $_POST['customer'] : ''), 'class="form-control" id="customer" data-placeholder="' . $this->lang->line('select') . ' ' . $this->lang->line('customer') . '"'); ?>
                            </div>
                        </div>
                        <div hidden class="col-sm-4">
                            <div class="form-group">
                                <label class="control-label" for="biller"><?= lang('biller'); ?></label>
                                <?php
                                $bl[''] = lang('select') . ' ' . lang('biller');
                                foreach ($billers as $biller) {
                                    $bl[$biller->id] = $biller->company && $biller->company != '-' ? $biller->company : $biller->name;
                                }
                                echo form_dropdown('biller', $bl, (isset($_POST['biller']) ? $_POST['biller'] : ''), 'class="form-control" id="biller" data-placeholder="' . $this->lang->line('select') . ' ' . $this->lang->line('biller') . '"');
                                ?>
                            </div>
                        </div>
                        <div hidden class="col-sm-4">
                            <div class="form-group">
                                <label class="control-label" for="warehouse"><?= lang('warehouse'); ?></label>
                                <?php
                                $wh[''] = lang('select') . ' ' . lang('warehouse');
                                foreach ($warehouses as $warehouse) {
                                    $wh[$warehouse->id] = $warehouse->name;
                                }
                                echo form_dropdown('warehouse', $wh, (isset($_POST['warehouse']) ? $_POST['warehouse'] : ''), 'class="form-control" id="warehouse" data-placeholder="' . $this->lang->line('select') . ' ' . $this->lang->line('warehouse') . '"');
                                ?>
                            </div>
                        </div>
                        <?php if ($Settings->product_serial) {
                                    ?>
                            <div hidden class="col-sm-4">
                                <div class="form-group">
                                    <?= lang('serial_no', 'serial'); ?>
                                    <?= form_input('serial', '', 'class="form-control tip" id="serial"'); ?>
                                </div>
                            </div>
                        <?php
                                } ?>
                    
                    </div>
                    <div class="form-group">
                        <div
                            class="controls"> <?php echo form_submit('submit_report', $this->lang->line('submit'), 'class="btn btn-primary"'); ?> </div>
                    </div>
                    <?php echo form_close(); ?>

                </div>
                <div class="clearfix"></div>




<script src="https://code.highcharts.com/highcharts.js"></script>
<script src="https://code.highcharts.com/modules/series-label.js"></script>
<script src="https://code.highcharts.com/modules/exporting.js"></script>
<script src="https://code.highcharts.com/modules/export-data.js"></script>
<script src="https://code.highcharts.com/modules/accessibility.js"></script>

<figure class="highcharts-figure">
    <div id="graphChart_timely"></div>
    <p class="highcharts-description">
        
    </p>
</figure>

                <div class="table-responsive">
                    <table id="SlRData"
                           class="table table-bordered table-hover table-striped table-condensed reports-table">
                        <thead>
                        <tr>
                            <th><?= lang('date'); ?></th>                           
                            <th><?= lang('product_qty'); ?></th>
                            <th><?= lang('grand_total'); ?></th>
                            <th><?= lang('total_discount'); ?></th>
                            <th><?= lang('paid'); ?></th>
                            <th><?= lang('balance'); ?></th>
                           
                        </tr>
                        </thead>
                        <tbody>
                        <tr>
                            <td colspan="7" class="dataTables_empty"><?= lang('loading_data_from_server') ?></td>
                        </tr>
                        </tbody>
                        <tfoot class="dtFilter">
                        <tr class="active">
                            <th></th>                           
                            <th><?= lang('product_qty'); ?></th>
                            <th><?= lang('grand_total'); ?></th>
                            <th><?= lang('total_discount'); ?></th>                            
                            <th><?= lang('paid'); ?></th>
                            <th><?= lang('balance'); ?></th>
                           
                        </tr>
                        </tfoot>
                    </table>
                </div>




            </div>
        </div>
    </div>
</div>


<script src="<?= $assets ?>js/jquery.canvasjs.min.js"></script>

<script type="text/javascript" src="<?= $assets ?>js/html2canvas.min.js"></script>

<script type="text/javascript">

    $(document).ready(function () {
        $("#form").show();
        $("#form").removeAttr('style');
        $('#pdf').click(function (event) {
            event.preventDefault();
            window.location.href = "<?=admin_url('reports/getSalesReport/pdf/?v=1' . $v)?>";
            return false;
        });
        $('#xls').click(function (event) {
            event.preventDefault();
            window.location.href = "<?=admin_url('reports/getSalesReport/0/xls/?v=1' . $v)?>";
            return false;
        });
        $('#image').click(function (event) {
            event.preventDefault();
            html2canvas($('.box'), {
                onrendered: function (canvas) {
                    openImg(canvas.toDataURL());
                }
            });
            return false;
        });
    });
</script>


<script>
   
    $(document).ready(function () {
         var comma_separated_start_date ="";
         var elevationData = [];
         var tempArr = [12];
        var timeArr=[];
        var graphData=[];

        function makeArrayOf24hours(value, length) {
            var arr = [], i = length;
            while (i--) {
            arr[i] = value;
            }
             return arr;
        }

        var blank_Arr24hours = makeArrayOf24hours(0, 24);


        oTable = $('#SlRData').dataTable({
            "aaSorting": [[0, "desc"]],
            "aLengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "<?= lang('all') ?>"]],
            "iDisplayLength": <?= $Settings->rows_per_page ?>,
            'bProcessing': true, 'bServerSide': true,
            'sAjaxSource': '<?= admin_url('reports/getSalesReport_hourly_customize/?v=1' . $v) ?>',
            'fnServerData': function (sSource, aoData, fnCallback) {
                aoData.push({
                    "name": "<?= $this->security->get_csrf_token_name() ?>",
                    "value": "<?= $this->security->get_csrf_hash() ?>"
                });
                $.ajax({'dataType': 'json', 'type': 'POST', 'url': sSource, 'data': aoData, 'success': fnCallback});
            },
            'fnRowCallback': function (nRow, aData, iDisplayIndex) {
                nRow.id = aData[7];
                nRow.className = (aData[5] > 0) ? "invoice_link2" : "invoice_link2 warning";
                return nRow;
            },
            "aoColumns": [

            null,  
        
                {
                "bSearchable": false,
                "mRender": pqFormat
            }, 
            {"mRender": currencyFormat}, {"mRender": currencyFormat}, 
             {"mRender": currencyFormat}, {"mRender": currencyFormat}],

            "fnFooterCallback": function (nRow, aaData, iStart, iEnd, aiDisplay) {
                var dateString="",temp_start_date_time="",gtotal = 0,gtotal_discount=0; paid = 0, balance = 0;
                temp_start_date_time =  aaData[aiDisplay[0]][0];
                 var tdArr =  temp_start_date_time.split(" ");
                 var temp_date= tdArr[0];
                for (var i = 0; i < aaData.length; i++) {
                    dateString = aaData[aiDisplay[i]][0];
                    var hourName = getHoursOnly(dateString);
                    var flagArr =  dateString.split(" ");
                    
                    gtotal = parseFloat(aaData[aiDisplay[i]][2]);
                    gtotal_discount += parseFloat(aaData[aiDisplay[i]][3]);
                    paid += parseFloat(aaData[aiDisplay[i]][4]);
                    balance += parseFloat(aaData[aiDisplay[i]][5]);
                    
                     var obj={
                                "x" : new Date(timeArr[i]),
                                "y" : gtotal
                            }  
                        
                      
                        if(flagArr[0]===temp_date){
                              blank_Arr24hours[hourName]=gtotal;
                                console.log("yes"+blank_Arr24hours[hourName]);  
                        }else{
                        graphData.push(blank_Arr24hours);
                        blank_Arr24hours = makeArrayOf24hours(0, 24);
                    }
                     temp_date=flagArr[0];
                   // elevationData.push([timeArr[i],gtotal]);
                  //console.log(temp_date+">>>>>>>"+ flagArr[0]+">>>>>>>"+ aaData[aiDisplay[i]][0]);


                }
                
         
         
                  
               // elevationData.push(tempArr);
              //  showData(elevationData);
              
        
             

                var nCells = nRow.getElementsByTagName('th');
                nCells[2].innerHTML = currencyFormat(parseFloat(gtotal));
                nCells[3].innerHTML = currencyFormat(parseFloat(gtotal_discount));
                nCells[4].innerHTML = currencyFormat(parseFloat(paid));
                nCells[5].innerHTML = currencyFormat(parseFloat(balance));


   console.log(temp_start_date_time);
   temp_start_date_time = new Date(temp_start_date_time).getTime();
 console.log(blank_Arr24hours);
  console.log(graphData);
  console.log(graphData.join(','));
  var aa ='['+graphData.join(',')+']';

   console.log(aa);

                
        function getHoursOnly(datetimeString){
                var dtArr =  datetimeString.split(" ");
                var hour = dtArr[1].substr(0, 1);
                return hour;
        }

            // HIGH CHART 
   
    Highcharts.chart('graphChart_timely', {
    chart: {
        type: 'spline',
        scrollablePlotArea: {
            minWidth: 600,
            scrollPositionX: 1
        }
    },
    title: {
        text: 'Hourly Sales',
        align: 'left'
    },
    subtitle: {
        text: ' ',
        align: 'left'
    },
    xAxis: {
        type: 'datetime',
        labels: {
            overflow: 'justify'
        }
    },
    yAxis: {
        title: {
            text: 'Amount ('+site.settings.symbol+')'
        },
        minorGridLineWidth: 1,
        gridLineWidth: 1,
        alternateGridColor: null,
        plotBands: [{ // Light air
            from: 0,
            to: 1500,
            color: 'rgba(68, 170, 213, 0.1)',
            label: {
                text: 'Hourly Sales',
                style: {
                    color: '#606060'
                }
            }
        }]
    },
    tooltip: {
        valuePrefix: site.settings.symbol
    },
    plotOptions: {
        spline: {
            lineWidth: 2,
            states: {
                hover: {
                    lineWidth: 3
                }
            },
            marker: {
                enabled: true
            },
            pointInterval: 3600000, // one hour
            pointStart:temp_start_date_time
        }
    },
    series: [{
        name: '',
        data:               // set 24 hours data 
           aa
    }],
    navigation: {
        menuItemStyle: {
            fontSize: '12px'
        }
    }
});


            }
         
        }).fnSetFilteringDelay().dtFilter([
            {column_number: 0, filter_default_label: "[<?=lang('date');?> (yyyy-mm-dd)]", filter_type: "text", data: []},
                     
        ], "footer");
       
    });


       // Data generated from http://www.bikeforums.net/professional-cycling-fans/1113087-2017-tour-de-france-gpx-tcx-files.html
  
  //var eArr = showData();
 
</script>
<script type="text/javascript">
    $(document).ready(function () {
         $("#form").slideDown();
        <?php if ($this->input->post('customer')) {
    ?>
        $('#customer').val(<?= $this->input->post('customer') ?>).select2({
            minimumInputLength: 1,
            data: [],
            initSelection: function (element, callback) {
                $.ajax({
                    type: "get", async: false,
                    url: site.base_url + "customers/suggestions/" + $(element).val(),
                    dataType: "json",
                    success: function (data) {
                        callback(data.results[0]);
                    }
                });
            },
            ajax: {
                url: site.base_url + "customers/suggestions",
                dataType: 'json',
                quietMillis: 15,
                data: function (term, page) {
                    return {
                        term: term,
                        limit: 10
                    };
                },
                results: function (data, page) {
                    if (data.results != null) {
                        return {results: data.results};
                    } else {
                        return {results: [{id: '', text: 'No Match Found'}]};
                    }
                }
            }
        });

        $('#customer').val(<?= $this->input->post('customer') ?>);
        <?php
} ?>
        $('.toggle_down').click(function () {
            $("#form").slideDown();
            return false;
        });
        $('.toggle_up').click(function () {
            $("#form").slideUp();
            return false;
        });
    });
</script>




<script type="text/javascript" charset="UTF-8">
$(document).ready(function () {
  $("#start_date").datetimepicker({
       format: site.dateFormats.js_ldate,
        minView: 2,
        maxView: 4,
        autoclose: true
        });


  $("#end_date").datetimepicker({
        format: site.dateFormats.js_ldate,
        minView: 2,
        maxView: 4,
        autoclose: true
        });
});

</script>


