<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Employees_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
    }

  


    public function addEmployee($data)
    {
        if ($this->db->insert('employees', $data)) {
            return true;
        }
        return false;
    }



    public function addEmployees($data)
    {
        if ($this->db->insert_batch('employees', $data)) {
            return true;
        }
        return false;
    }


  

    public function getEmployeeByID($id)
    {
        $q = $this->db->get_where('employees', ['id' => $id], 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return false;
    }


    public function brandHasProducts($brand_id)
    {
        $q = $this->db->get_where('products', ['brand' => $brand_id], 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return false;
    }

   

    public function deleteEmployee($id)
    {
        if ($this->db->delete('employees', ['id' => $id])) {
            return true;
        }
        return false;
    }





    public function updateEmployee($id, $data = [])
    {
        if ($this->db->update('employees', $data, ['id' => $id])) {
            return true;
        }
        return false;
    }

   
}
