<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Myexpenses extends MY_Controller
{
    public function __construct()
    {
        parent::__construct();

        if (!$this->loggedIn) {
            $this->session->set_userdata('requested_page', $this->uri->uri_string());
            $this->sma->md('login');
        }

        if (!$this->Owner) {
           // $this->session->set_flashdata('warning', lang('access_denied'));
            //redirect('admin');
        }
        $this->lang->admin_load('settings', $this->Settings->user_language);
        $this->load->library('form_validation');
        $this->load->admin_model('myexpenses_model');
        $this->upload_path        = 'assets/uploads/';
        $this->thumbs_path        = 'assets/uploads/thumbs/';
        $this->image_types        = 'gif|jpg|jpeg|png|tif';
        $this->digital_file_types = 'zip|psd|ai|rar|pdf|doc|docx|xls|xlsx|ppt|pptx|gif|jpg|jpeg|png|tif';
        $this->allowed_file_size  = '1024';
    }

  


    public function add()
    {
        $this->form_validation->set_message('is_natural_no_zero', $this->lang->line('no_zero_required'));
        $this->form_validation->set_rules('warehouse_id', $this->lang->line('warehouse'), 'required|is_natural_no_zero');
        //$this->form_validation->set_rules('reference', $this->lang->line('reference'), 'required|is_natural_no_zero');
        $this->form_validation->set_rules('amount', $this->lang->line('amount'), 'required|is_natural_no_zero');
		
        if ($this->form_validation->run() == true) {
            if ($this->Owner || $this->Admin) {
                $date = $this->sma->fld(trim($this->input->post('date')));
            } else {
                $date = date('Y-m-d H:i:s');
            }
            $warehouse_id     = $this->input->post('warehouse_id');
            $reference      = $this->input->post('reference');
            $amount           = $this->input->post('amount');
            $note           = $this->input->post('note');
            $status           = $this->input->post('status');
			
            $data           = [
				'date'                 => $date,
                'reference'            => $reference,
                'warehouse_id'         => $warehouse_id,
                'amount'               => $amount,
				'note'            => $note,
				'status'            => $status,
            ];
        } elseif ($this->input->post('add')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect('myexpenses/index');
        }

        if ($this->form_validation->run() == true && $this->myexpenses_model->addMyexpenses($data)) {
            $this->session->set_flashdata('message', lang('added'));
            admin_redirect('myexpenses/index');
        } else {
			$this->data['warehouses'] = $this->site->getAllWarehouses();
            $this->data['error']    = validation_errors() ? validation_errors() : $this->session->flashdata('error');
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'myexpenses/add', $this->data);
        }
    }

   

    public function myexpenses_actions()
    {
        $this->form_validation->set_rules('form_action', lang('form_action'), 'required');

        if ($this->form_validation->run() == true) {
            if (!empty($_POST['val'])) {
                if ($this->input->post('form_action') == 'delete') {
                    foreach ($_POST['val'] as $id) {
                        $this->myexpenses_model->deleteMyexpenses($id);
                    }
                    $this->session->set_flashdata('message', lang('expense_deleted'));
                    redirect($_SERVER['HTTP_REFERER']);
                }

                if ($this->input->post('form_action') == 'export_excel') {
                    $this->load->library('excel');
                    $this->excel->setActiveSheetIndex(0);
                    $this->excel->getActiveSheet()->setTitle(lang('expenses'));
                    $this->excel->getActiveSheet()->SetCellValue('A1', lang('date'));
                    $this->excel->getActiveSheet()->SetCellValue('B1', lang('reference'));
                    $this->excel->getActiveSheet()->SetCellValue('C1', lang('note'));
                    $this->excel->getActiveSheet()->SetCellValue('D1', lang('amount'));

                    $row = 2;
                    foreach ($_POST['val'] as $id) {
                        $expenses = $this->myexpenses_model->getMyexpensesByID($id);
                        $this->excel->getActiveSheet()->SetCellValue('A' . $row, $expenses->date);
                        $this->excel->getActiveSheet()->SetCellValue('B' . $row, $expenses->reference);
                        $this->excel->getActiveSheet()->SetCellValue('C' . $row, $expenses->note);
                         $this->excel->getActiveSheet()->SetCellValue('D' . $row, $expenses->amount);
                        $row++;
                    }

                    $this->excel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
                    $this->excel->getDefaultStyle()->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
                    $filename = 'expenses_' . date('Y_m_d_H_i_s');
                    $this->load->helper('excel');
                    create_excel($this->excel, $filename);
                }
            } else {
                $this->session->set_flashdata('error', lang('no_record_selected'));
                redirect($_SERVER['HTTP_REFERER']);
            }
        } else {
            $this->session->set_flashdata('error', validation_errors());
            redirect($_SERVER['HTTP_REFERER']);
        }
    }


    public function index()
    {
        $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');
        $bc                  = [['link' => base_url(), 'page' => lang('home')], ['link' => admin_url('myexpenses'), 'page' => lang('myexpenses')], ['link' => '#', 'page' => lang('myexpenses')]];
        $meta                = ['page_title' => lang('index'), 'bc' => $bc];
        $this->page_construct('myexpenses/index', $meta, $this->data);
    }



  

     public function delete_myexpenses($id = null)
    {
        if ($this->myexpenses_model->deleteMyexpenses($id)) {
            $this->sma->send_json(['error' => 0, 'msg' => lang('myexpenses_deleted')]);
        }
    }



    public function edit($id = null)
    {
         //$this->form_validation->set_rules('amount', lang('amount'), 'trim|required');
      // $this->sma->checkPermissions(false, true);

        if ($this->input->get('id')) {
            $id = $this->input->get('id');
        }
        $myexpenses_details = $this->myexpenses_model->getMyexpensesByID($id);
		
       
		//$this->sma->print_arrays($myexpenses_details);
		if ($this->input->post('edit')) {
            if ($this->Owner || $this->Admin) {
                $date = $this->sma->fld(trim($this->input->post('date')));
            } else {
                $date = date('Y-m-d H:i:s');
            }
            
            $warehouse_id     = $this->input->post('warehouse_id');
            $reference      = $this->input->post('reference');
            $amount           = $this->input->post('amount');
            $note           = $this->input->post('note');
            $status           = $this->input->post('status');
            
            $data           = [
                'date'                 => $date,
                'reference'            => $reference,
                'warehouse_id'         => $warehouse_id,
                'amount'               => $amount,
                'note'            => $note,
                'status'            => $status,
            ];

            $this->session->set_flashdata('error', validation_errors());
             $this->myexpenses_model->updateMyexpenses($id, $data);
              redirect($_SERVER['HTTP_REFERER']);
        }else {
            $this->data['error']    = validation_errors() ? validation_errors() : $this->session->flashdata('error');
			$this->data['warehouses'] = $this->site->getAllWarehouses();
            $this->data['banks'] = $this->site->getAllBanks();
            $this->data['modal_js'] = $this->site->modal_js();
            $this->data['myexpenses_details']    = $myexpenses_details;
            $this->load->view($this->theme . 'myexpenses/edit', $this->data);
        }
    }

    
    
    public function getAllData()
    {
        $this->load->library('datatables');
        $this->datatables
            ->select('expenses.id,expenses.date, expenses.reference, expenses.note, expenses.amount, expenses.status')
            ->from('expenses')
            ->add_column('Actions', "<div class=\"text-center\"><a href='" . admin_url('myexpenses/edit/$1') . "' data-keyboard='false' data-backdrop='static' data-toggle='modal' data-target='#myModal' class='tip' title='" . lang('edit_expense') . "'><i class=\"fa fa-edit\"></i></a> <a href='#' class='tip po' title='<b>" . lang('delete_expense') . "</b>' data-content=\"<p>" . lang('r_u_sure') . "</p><a class='btn btn-danger po-delete' href='" . admin_url('myexpenses/delete_myexpenses/$1') . "'>" . lang('i_m_sure') . "</a> <button class='btn po-close'>" . lang('no') . "</button>\"  rel='popover'><i class=\"fa fa-trash-o\"></i></a></div>", 'expenses.id');

        echo $this->datatables->generate();
    }
   

    public function import_brands()
    {
        $this->load->helper('security');
        $this->form_validation->set_rules('userfile', lang('upload_file'), 'xss_clean');

        if ($this->form_validation->run() == true) {
            if (isset($_FILES['userfile'])) {
                $this->load->library('upload');
                $config['upload_path']   = 'files/';
                $config['allowed_types'] = 'csv';
                $config['max_size']      = $this->allowed_file_size;
                $config['overwrite']     = true;
                $this->upload->initialize($config);

                if (!$this->upload->do_upload()) {
                    $error = $this->upload->display_errors();
                    $this->session->set_flashdata('error', $error);
                    admin_redirect('myexpenses/index');
                }

                $csv = $this->upload->file_name;

                $arrResult = [];
                $handle    = fopen('files/' . $csv, 'r');
                if ($handle) {
                    while (($row = fgetcsv($handle, 5000, ',')) !== false) {
                        $arrResult[] = $row;
                    }
                    fclose($handle);
                }
                $titles = array_shift($arrResult);
                $keys   = ['name', 'code', 'image'];
                $final  = [];
                foreach ($arrResult as $key => $value) {
                    $final[] = array_combine($keys, $value);
                }

                foreach ($final as $csv_ct) {
                    if (!$this->myexpenses_model->getBrandByName(trim($csv_ct['name']))) {
                        $data[] = [
                            'code'  => trim($csv_ct['code']),
                            'name'  => trim($csv_ct['name']),
                            'image' => trim($csv_ct['image']),
                        ];
                    }
                }
            }

            // $this->sma->print_arrays($data);
        }

        if ($this->form_validation->run() == true && !empty($data) && $this->myexpenses_model->addMyexpensess($data)) {
            $this->session->set_flashdata('message', lang('brands_added'));
            admin_redirect('myexpenses/index');
        } else {
            $this->data['error']    = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['userfile'] = ['name' => 'userfile',
                'id'                          => 'userfile',
                'type'                        => 'text',
                'value'                       => $this->form_validation->set_value('userfile'),
            ];
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'settings/import_brands', $this->data);
        }
    }




 
}
