<?php

defined('BASEPATH') or exit('No direct script access allowed');

class employeesalary extends MY_Controller
{
    public function __construct()
    {
        parent::__construct();

        if (!$this->loggedIn) {
            $this->session->set_userdata('requested_page', $this->uri->uri_string());
            $this->sma->md('login');
        }

        if (!$this->Owner) {
            //$this->session->set_flashdata('warning', lang('access_denied'));
            //redirect('admin');
        }
        $this->lang->admin_load('settings', $this->Settings->user_language);
        $this->load->library('form_validation');
        $this->load->admin_model('employeesalary_model');
        $this->upload_path        = 'assets/uploads/';
        $this->thumbs_path        = 'assets/uploads/thumbs/';
        $this->image_types        = 'gif|jpg|jpeg|png|tif';
        $this->digital_file_types = 'zip|psd|ai|rar|pdf|doc|docx|xls|xlsx|ppt|pptx|gif|jpg|jpeg|png|tif';
        $this->allowed_file_size  = '1024';
    }

  


    public function add()
    {
        $this->form_validation->set_message('is_natural_no_zero', $this->lang->line('no_zero_required'));
        $this->form_validation->set_rules('warehouse', $this->lang->line('warehouse'), 'required|is_natural_no_zero');
        $this->form_validation->set_rules('employee', $this->lang->line('employee'), 'required|is_natural_no_zero');
        $this->form_validation->set_rules('amount', $this->lang->line('amount'), 'required|is_natural_no_zero');
		
        if ($this->form_validation->run() == true) {
            if ($this->Owner || $this->Admin) {
                $date = $this->sma->fld(trim($this->input->post('date')));
            } else {
                $date = date('Y-m-d H:i:s');
            }
            $warehouse_id     = $this->input->post('warehouse');
            $person_id      = $this->input->post('employee');
            $person_type      = 'employee';
            $note           = $this->input->post('note');
            $amount           = $this->input->post('amount');
			
            $data           = [
				'date'                 => $date,
                'person_id'                 => $person_id,
                'person_type'            => $person_type,
                'warehouse_id'         => $warehouse_id,
                'amount'               => $amount,
                'note'               => $note,
            ];
        } elseif ($this->input->post('add')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect('employeesalary/index');
        }

        if ($this->form_validation->run() == true && $this->employeesalary_model->addEmployeesalary($data)) {
            $this->session->set_flashdata('message', lang('brand_added'));
            admin_redirect('employeesalary/index');
        } else {
			$this->data['warehouses'] = $this->site->getAllWarehouses();
            $this->data['banks'] = $this->site->getAllBanks();
            $this->data['error']    = validation_errors() ? validation_errors() : $this->session->flashdata('error');
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'employeesalary/add', $this->data);
        }
    }

   

    public function employeesalary_actions()
    {
        $this->form_validation->set_rules('form_action', lang('form_action'), 'required');

        if ($this->form_validation->run() == true) {
            if (!empty($_POST['val'])) {
                if ($this->input->post('form_action') == 'delete') {
                    foreach ($_POST['val'] as $id) {
                        $this->employeesalary_model->deleteEmployeesalary($id);
                    }
                    $this->session->set_flashdata('message', lang('brands_deleted'));
                    redirect($_SERVER['HTTP_REFERER']);
                }

                if ($this->input->post('form_action') == 'export_excel') {
                    $this->load->library('excel');
                    $this->excel->setActiveSheetIndex(0);
                    $this->excel->getActiveSheet()->setTitle(lang('brands'));
                    $this->excel->getActiveSheet()->SetCellValue('A1', lang('name'));
                    $this->excel->getActiveSheet()->SetCellValue('B1', lang('code'));
                    $this->excel->getActiveSheet()->SetCellValue('C1', lang('image'));

                    $row = 2;
                    foreach ($_POST['val'] as $id) {
                        $brand = $this->site->getBrandByID($id);
                        $this->excel->getActiveSheet()->SetCellValue('A' . $row, $brand->name);
                        $this->excel->getActiveSheet()->SetCellValue('B' . $row, $brand->code);
                        $this->excel->getActiveSheet()->SetCellValue('C' . $row, $brand->image);
                        $row++;
                    }

                    $this->excel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
                    $this->excel->getDefaultStyle()->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
                    $filename = 'brands_' . date('Y_m_d_H_i_s');
                    $this->load->helper('excel');
                    create_excel($this->excel, $filename);
                }
            } else {
                $this->session->set_flashdata('error', lang('no_record_selected'));
                redirect($_SERVER['HTTP_REFERER']);
            }
        } else {
            $this->session->set_flashdata('error', validation_errors());
            redirect($_SERVER['HTTP_REFERER']);
        }
    }


    public function index()
    {
        $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');
        $bc                  = [['link' => base_url(), 'page' => lang('home')], ['link' => admin_url('employeesalary'), 'page' => lang('employeesalary')], ['link' => '#', 'page' => lang('employeesalary')]];
        $meta                = ['page_title' => lang('index'), 'bc' => $bc];
        $this->page_construct('employeesalary/index', $meta, $this->data);
    }



  

     public function delete_employeesalary($id = null)
    {
        if ($this->employeesalary_model->deleteEmployeesalary($id)) {
            $this->sma->send_json(['error' => 0, 'msg' => lang('employeesalary_deleted')]);
        }
    }



    public function edit($id = null)
    {
        $this->form_validation->set_rules('amount', lang('amount'), 'trim|required');
        $employeesalary_details = $this->employeesalary_model->getEmployeesalaryByID($id);
		
		//$this-sma->print_arrays($employeesalary_details);

        if ($this->form_validation->run() == true) {
			if ($this->Owner || $this->Admin) {
                $date = $this->sma->fld(trim($this->input->post('date')));
            } else {
                $date = date('Y-m-d H:i:s');
            }
            $myemployeesalary_id     = $this->input->post('myemployeesalary_id');
            $warehouse_id     = $this->input->post('warehouse');
            $bank      = $this->input->post('bank');
            $cheque_no      = $this->input->post('cheque_no');
            $status           = $this->input->post('status');
            $amount           = $this->input->post('amount');
            $data = [
                'date'                 => $date,
                'bank'                 => $bank,
                'cheque_no'            => $cheque_no,
                'warehouse_id'         => $warehouse_id,
                'amount'               => $amount,
                'status'               => $status,
            ];

         
        } elseif ($this->input->post('edit')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect('employeesalary/index');
        }

        if ($this->form_validation->run() == true && $this->employeesalary_model->updateBrand($id, $data)) {
            $this->session->set_flashdata('message', lang('brand_updated'));
            admin_redirect('employeesalary/index');
        } else {
            $this->data['error']    = validation_errors() ? validation_errors() : $this->session->flashdata('error');
			$this->data['warehouses'] = $this->site->getAllWarehouses();
            $this->data['employees'] = $this->employeesalary_model->getEmployees();
            $this->data['modal_js'] = $this->site->modal_js();
            $this->data['employeesalary_details']    = $employeesalary_details;
            $this->load->view($this->theme . 'employeesalary/edit', $this->data);
        }
    }

    
    
    public function getAllData()
    {
        $this->load->library('datatables');
        $this->datatables
            ->select('salary.id,salary.date, employees.name, salary.note, salary.amount')
            ->from('salary')
             ->join('employees', 'employees.id=salary.person_id', 'left')
            ->add_column('Actions', "<div class=\"text-center\"><a href='" . admin_url('employeesalary/edit/$1') . "' data-keyboard='false' data-backdrop='static' data-toggle='modal' data-target='#myModal' class='tip' title='" . lang('edit_brand') . "'><i class=\"fa fa-edit\"></i></a> <a href='#' class='tip po' title='<b>" . lang('delete_employeesalary') . "</b>' data-content=\"<p>" . lang('r_u_sure') . "</p><a class='btn btn-danger po-delete' href='" . admin_url('employeesalary/delete_employeesalary/$1') . "'>" . lang('i_m_sure') . "</a> <button class='btn po-close'>" . lang('no') . "</button>\"  rel='popover'><i class=\"fa fa-trash-o\"></i></a></div>", 'id');

        echo $this->datatables->generate();
    }
   
	
	

    public function suggestions($term = null, $limit = null)
    {
        // $this->sma->checkPermissions('index');
        if ($this->input->get('term')) {
            $term = $this->input->get('term', true);
        }
        $limit           = $this->input->get('limit', true);
        $rows['results'] = $this->employeesalary_model->getSupplierSuggestions($term, $limit);
        $this->sma->send_json($rows);
    }
	
	public function getSupplier($id = null)
    {
        // $this->sma->checkPermissions('index');
        $row = $this->employeesalary_model->getEmployeeByID($id);
        $this->sma->send_json([['id' => $row->id, 'text' => $row->name."(".$row->phone.")"]]);
    }

    public function getSuppliers()
    {
        $this->sma->checkPermissions('index');

        $this->load->library('datatables');
        $this->datatables
            ->select('id,  name, phone')
            ->from('employees')
            ->add_column('Actions', "<div class=\"text-center\"><a class=\"tip\" title='" . $this->lang->line('list_products') . "' href='" . admin_url('products?supplier=$1') . "'><i class=\"fa fa-list\"></i></a> <a class=\"tip\" title='" . $this->lang->line('list_users') . "' href='" . admin_url('suppliers/users/$1') . "' data-toggle='modal' data-target='#myModal'><i class=\"fa fa-users\"></i></a> <a class=\"tip\" title='" . $this->lang->line('add_user') . "' href='" . admin_url('suppliers/add_user/$1') . "' data-toggle='modal' data-target='#myModal'><i class=\"fa fa-plus-circle\"></i></a> <a class=\"tip\" title='" . $this->lang->line('edit_supplier') . "' href='" . admin_url('suppliers/edit/$1') . "' data-toggle='modal' data-target='#myModal'><i class=\"fa fa-edit\"></i></a> <a href='#' class='tip po' title='<b>" . $this->lang->line('delete_supplier') . "</b>' data-content=\"<p>" . lang('r_u_sure') . "</p><a class='btn btn-danger po-delete' href='" . admin_url('suppliers/delete/$1') . "'>" . lang('i_m_sure') . "</a> <button class='btn po-close'>" . lang('no') . "</button>\"  rel='popover'><i class=\"fa fa-trash-o\"></i></a></div>", 'id');
        //->unset_column('id');
        echo $this->datatables->generate();
    }
	




 
}
