<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title>
        <?php echo e(config('app.name')); ?> - <?php echo $__env->yieldContent('title'); ?>
    </title>

    <?php echo $__env->yieldPushContent('top_css'); ?>

    <!-- CUSTOM STYLE NEW THEME  -->
    <link href="<?php echo e(asset('mk_theme/css/vendors/flatpickr.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('mk_theme/style.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('mk_theme/css/custom.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('mk_theme/css/custom.css')); ?>" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('chosen/prism.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('chosen/chosen.css')); ?>">
    
    <?php echo $__env->yieldPushContent('bottom_css'); ?>
    <!-- CUSTOM STYLE NEW THEME  -->
    <script>

        document.querySelector('html').classList.add('white');
        document.querySelector('html').style.colorScheme = 'white';
    
    </script>


    <?php echo $__env->yieldPushContent('top_js'); ?>

    <?php echo app('Tightenco\Ziggy\BladeRouteGenerator')->generate(); ?>
</head>

 <body
    class="font-inter antialiased bg-gray-100 dark:bg-gray-900 text-gray-600 dark:text-gray-400"
    :class="{ 'sidebar-expanded': sidebarExpanded }"
    x-data="{ sidebarOpen: false, sidebarExpanded: localStorage.getItem('sidebar-expanded') == 'true', transactionOpen: true }"
    @set-transactionopen="transactionOpen = $event.detail"
    x-init="$watch('sidebarExpanded', value => localStorage.setItem('sidebar-expanded', value))"
>
    <script>
    if (localStorage.getItem('sidebar-expanded') == 'true') {
        document.querySelector('body').classList.add('sidebar-expanded');
    } else {
        document.querySelector('body').classList.remove('sidebar-expanded');
    }
    </script>

    <!-- Page wrapper -->
    <div class="flex h-[100dvh] overflow-hidden">
        <?php echo $__env->make('layouts.sidebar-navigation', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <!-- Content area -->
        <div class="relative flex flex-col flex-1 overflow-y-auto overflow-x-hidden bg-white dark:bg-gray-900">

            <main class="grow">
                <?php if(session('registration-success')): ?>
                    <div class="w-full  col-span-12 md:col-span-12 px-6 pt-6">
                        <?php echo e(session('registration-success')); ?>

                    </div>
                <?php endif; ?>
                <?php echo e($slot); ?>                
            </main>
        </div>

    </div>

    <!-- <?php if(request()->routeIs('dashboard')): ?>
    <?php echo $__env->make('elements.mobile-quick-links', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?> -->
    <script src="<?php echo e(asset('mk_theme/js/vendors/alpinejs.min.js')); ?>" defer></script>
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/jquery-datatables-checkboxes@1.2.12/js/dataTables.checkboxes.min.js">
    <script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
    <script src="<?php echo e(asset('js/jquery-numbersinwords.js')); ?>"></script>

    <script src="<?php echo e(asset('chosen/chosen.jquery.js')); ?>" type="text/javascript"></script>
    <script src="<?php echo e(asset('chosen/init.js')); ?>" type="text/javascript" charset="utf-8"></script>


    <script src="<?php echo e(asset('js/custom.js')); ?>"></script>
    <script>
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });
    </script>

    <?php echo $__env->yieldPushContent('bottom_js'); ?>

</body>

</html><?php /**PATH /home/mounent/public_html/soft.mounent.com/resources/views/layouts/app.blade.php ENDPATH**/ ?>