@csrf
<input type="hidden" name="id" id="supplier_id" value="{{ $supplier->id }}">

<div class="mb-5">
    <label class="font-weight-bold">
        {{ __('translation.Supplier Name') }} <x-form.required-mark />
    </label>
    <x-input type="text" name="supplier_name" value="{{ $supplier->supplier_name ?? old('supplier_name')}}" required/>
</div>

<div class="flex flex-col md:flex-row md:gap-x-5">
    <div class="mb-5 md:w-3/4">
        <label class="font-weight-bold">
            {{ __('translation.Email') }}
        </label>
        <x-input type="text" name="email" id="email" value="{{ $supplier->email ?? old('email')}}"/>
    </div>
    <div class="mb-5 md:w-3/4">
        <label class="font-weight-bold">
            {{ __('translation.Phone') }}
        </label>
        <x-input type="text" name="phone" id="phone" value="{{ $supplier->phone ?? old('phone')}}"/>
    </div>
</div>

<div class="mb-5">
    <label class="font-weight-bold">
        {{ __('translation.Address') }}
    </label>
    <x-form.textarea name="address" rows="3">{{ $supplier->address ?? old('address') }}</x-form.textarea>
</div>

<div class="mb-5">
    <label class="font-weight-bold">
        {{ __('translation.Note') }}
    </label>
    <x-form.textarea name="note" rows="3">{{ $supplier->note ?? old('note') }}</x-form.textarea>
</div>

<div class="flex justify-end py-6">
    <x-button type="reset" color="gray" class="mr-1" id="__btnCancelModalUpdate">
        {{ __('translation.Cancel') }}
    </x-button>
    <x-button type="submit" color="blue" id="__btnUpdateSubmit">
        {{ __('translation.Update') }}
    </x-button>
</div>

<script>
    $(document).ready(function() {
        $('#__btnCancelModalUpdate').click(function() {
            $('body').removeClass('modal-open');
            $('#__modalUpdate').addClass('modal-hide');
        });
    });

</script>
