<x-app-layout>
    @section('title', 'Users')

    @push('top_css')
        <link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
        <link type="text/css" href="https://cdn.jsdelivr.net/npm/jquery-datatables-checkboxes@1.2.12/css/dataTables.checkboxes.css" rel="stylesheet" />
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" />
        <link rel="stylesheet" href="{{ asset('css/typeaheadjs.css') }}">

        <link rel="stylesheet" href="{{ asset('chosen/prism.css')}}">
        <link rel="stylesheet" href="{{ asset('chosen/chosen.css')}}">

    @endpush

    <style>
        .table thead th {
            vertical-align: bottom;
            border: 1px solid #2c3545;
            background: #0c1830;
            color: #e1d492;
        }

        .table td, .table th {
            padding: 0.15rem .75rem;
            vertical-align: top;
            border-top: 1px solid #dee2e6;
            font-size: 13px;
        }

        .table td p, .table th p {
            font-size: 12px;
            letter-spacing: 1.5px;
        }
        .font-bold{
            font-weight:600 !important;
        }

        .table td {
            vertical-align: middle;
            border: 1px solid #2c3545;
            position: relative;
        }

        .removeItem {
            padding: .15rem .5rem;
            font-size: 0.675rem;
        }

        td [type=text] {
            padding: 0 5px;
            height: 30px;
            font-weight: 100;
            width: 70px;
            font-size: 12px;
            letter-spacing: 2px;
        }

        #__product_id_QR_scanner {
            box-shadow: inset 0px 1px 6px 0px #000000 !important;
        }

      </style>
    <x-card title="Users ({{ number_format($userCount) }})">
        <div class="mt-6">

            <div class="flex flex-col sm:flex-row sm:justify-between items-start mb-4">
                <div class="w-full md:w-3/5 lg:w-3/5 mb-6 sm:mb-0">
                    <div class="flex flex-col sm:flex-row space-x-2">
                        @if(Auth::user()->role != '') @endif
                        <div class="sm:mr-2">
                            <button type="button" id="BtnInsertProduct" color="green" class="inline-flex items-center justify-center text-sm font-medium leading-5 rounded-full px-3 py-1 border border-gray-200 dark:border-gray-700/60 hover:border-gray-300 dark:hover:border-gray-600 shadow-sm bg-white dark:bg-gray-800 text-gray-500 dark:text-gray-400 transition">
                                <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v3m0 0v3m0-3h3m-3 0H9m12 0a9 9 0 11-18 0 9 9 0 0118 0z" />
                                </svg>
                                <span class="ml-2">Add User</span>
                            </button>
                        </div>
                        <div class="sm:mr-2">
                            <button id='bulk_delete' type='button' class="inline-flex items-center justify-center text-sm font-medium leading-5 rounded px-3 py-1 border border-gray-200 dark:border-gray-700/60 hover:border-gray-300 dark:hover:border-gray-600 shadow-sm bg-red-500/20 text-red-700 transition">Bulk Delete</button>
                        </div>
                        
                    </div>
                </div>
            </div>

        </div>



        
        <div class="flex flex-wrap -m-1 justify-end space-x-2">
            <!-- <div>
                <select id="__unitId" name="unit_id" class="form-select rounded w-full py-1">
                    <option value="">Select Unit</option>
                    @if($shops)
                        @foreach($shops as $row)
                        <option value='{{$row->id}}'>{{$row->name}} ({{$row->location}})</option>
                        @endforeach
                    @endif
                </select>
            </div> -->
            <div class="mb-5">
                <input id='__role' type='hidden' value=''>
                <ul class="__statusFilter flex flex-wrap -m-1 justify-end">
                    <li class="m-1">
                        <button data-role='' class="inline-flex items-center justify-center text-sm font-medium leading-5 rounded px-3 py-1 border border-gray-200 dark:border-gray-700/60 hover:border-gray-300 dark:hover:border-gray-600 shadow-sm dark:bg-green-800 text-green-500 dark:text-gray-400 transition">View All</button>
                    </li>
                    <li class="m-1">
                        <button data-role='superadmin' class="inline-flex items-center justify-center text-sm font-medium leading-5 rounded px-3 py-1 border border-gray-200 dark:border-gray-700/60 hover:border-gray-300 dark:hover:border-gray-600 shadow-sm dark:bg-green-800 text-green-500 dark:text-gray-400 transition">Superadmin</button>
                    </li>
                    <li class="m-1">
                        <button data-role='admin' class="inline-flex items-center justify-center text-sm font-medium leading-5 rounded px-3 py-1 border border-gray-200 dark:border-gray-700/60 hover:border-gray-300 dark:hover:border-gray-600 shadow-sm dark:bg-green-800 text-green-500 dark:text-gray-400 transition">Admin</button>
                    </li>
                    <li class="m-1">
                        <button data-role='staff' class="inline-flex items-center justify-center text-sm font-medium leading-5 rounded px-3 py-1 border border-gray-200 dark:border-gray-700/60 hover:border-gray-300 dark:hover:border-gray-600 shadow-sm dark:bg-green-800 text-green-500 dark:text-gray-400 transition">Staff</button>
                    </li>
                </ul>
            </div>
        </div>

        <div class="w-full overflow-x-auto">
            <table class="w-full" id="datatable">
                <thead>
                <tr class="rounded-lg text-sm font-medium text-gray-700 text-left">
                    <th></th>
                    <th class="px-4 py-2">Registered</th>
                    <th class="px-4 py-2">Full Name</th>
                    <th class="px-4 py-2">Phone</th>
                    <th class="px-4 py-2">Email</th>
                    <th class="px-4 py-2">P.Unit</th>
                    <th class="px-4 py-2">Role</th>                    
                    
                    <th class="px-4 py-2 text-center">
                        {{ __('translation.Actions') }}
                    </th>
                </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>
    </x-card>

    <div class="modalArea modal-insertProduct modal-hide">    
        <div class="overflow-auto fixed  inset-0 z-10 flex items-center justify-center">
            <div class="bg-violet rounded-lg shadow-lg overflow-auto max-w-lg w-full max-h-full" x-transition:enter="ease-out duration-300" x-transition:enter-start="opacity-0 scale-90" x-transition:enter-end="opacity-100 scale-100">
            
            <!-- Modal header -->
            <div class="px-5 py-3 border-b border-gray-200 dark:border-gray-700/60">
                <div class="flex justify-between items-center">
                    <div class="font-semibold text-gray-800 dark:text-gray-100">Insert User</div>
                    <button type='button' class="__closeModal text-gray-400 dark:text-gray-500 hover:text-gray-500 dark:hover:text-gray-400">
                        <div class="sr-only">Close</div>
                        <svg class="fill-current" width="16" height="16" viewBox="0 0 16 16">
                            <path d="M7.95 6.536l4.242-4.243a1 1 0 111.415 1.414L9.364 7.95l4.243 4.242a1 1 0 11-1.415 1.415L7.95 9.364l-4.243 4.243a1 1 0 01-1.414-1.415L6.536 7.95 2.293 3.707a1 1 0 011.414-1.414L7.95 6.536z" />
                        </svg>
                    </button>
                </div>
            </div>

            <form method="POST" id="form-insert-user" enctype="multipart/form-data">

            </form>

            </div>
        </div>
    </div>
    <div class="modalArea modal-editProduct modal-hide">    
        <div class="overflow-auto fixed  inset-0 z-10 flex items-center justify-center">
            <div class="bg-violet rounded-lg shadow-lg overflow-auto max-w-lg w-full max-h-full" x-transition:enter="ease-out duration-300" x-transition:enter-start="opacity-0 scale-90" x-transition:enter-end="opacity-100 scale-100">
            
            <!-- Modal header -->
            <div class="px-5 py-3 border-b border-gray-200 dark:border-gray-700/60">
                <div class="flex justify-between items-center">
                    <div class="font-semibold text-gray-800 dark:text-gray-100">Edit User</div>
                    <button type='button' class="__closeModal text-gray-400 dark:text-gray-500 hover:text-gray-500 dark:hover:text-gray-400">
                        <div class="sr-only">Close</div>
                        <svg class="fill-current" width="16" height="16" viewBox="0 0 16 16">
                            <path d="M7.95 6.536l4.242-4.243a1 1 0 111.415 1.414L9.364 7.95l4.243 4.242a1 1 0 11-1.415 1.415L7.95 9.364l-4.243 4.243a1 1 0 01-1.414-1.415L6.536 7.95 2.293 3.707a1 1 0 011.414-1.414L7.95 6.536z" />
                        </svg>
                    </button>
                </div>
            </div>

            <form method="POST" id="form-edit-user" enctype="multipart/form-data">

            </form>

            </div>
            </div>
    </div>

     <!-- DELETE Modal -->        
    <div class="modalArea modal-deleteProduct modal-hide">    
        <div class="overflow-auto fixed  inset-0 z-10 flex items-center justify-center">
            <div class="bg-violet rounded-lg shadow-lg overflow-auto max-w-lg w-full max-h-full" x-transition:enter="ease-out duration-300" x-transition:enter-start="opacity-0 scale-90" x-transition:enter-end="opacity-100 scale-100">
            
            <!-- Modal header -->
            <div class="px-5 py-3 border-b border-gray-200 dark:border-gray-700/60">
                <div class="flex justify-between items-center">
                    <div class="font-semibold text-gray-800 dark:text-gray-100">Delete Product</div>
                    <button class="__closeModal text-gray-400 dark:text-gray-500 hover:text-gray-500 dark:hover:text-gray-400">
                        <div class="sr-only">Close</div>
                        <svg class="fill-current" width="16" height="16" viewBox="0 0 16 16">
                            <path d="M7.95 6.536l4.242-4.243a1 1 0 111.415 1.414L9.364 7.95l4.243 4.242a1 1 0 11-1.415 1.415L7.95 9.364l-4.243 4.243a1 1 0 01-1.414-1.415L6.536 7.95 2.293 3.707a1 1 0 011.414-1.414L7.95 6.536z" />
                        </svg>
                    </button>
                </div>
            </div>

            <!-- DELETE Modal content -->
            <form id="form-delete-user" method="POST"></form>

            </div>
        </div>
    </div>




         <!-- DELETE Modal -->        
         <div class="modalArea modal-deleteBulkUser modal-hide">    
            <div class="overflow-auto fixed  inset-0 z-10 flex items-center justify-center">
                <div class="bg-violet rounded-lg shadow-lg overflow-auto max-w-lg w-full max-h-full" x-transition:enter="ease-out duration-300" x-transition:enter-start="opacity-0 scale-90" x-transition:enter-end="opacity-100 scale-100">
                
                    <!-- Modal header -->
                    <div class="px-5 py-3 border-b border-gray-200 dark:border-gray-700/60">
                        <div class="flex justify-between items-center">
                            <div class="font-semibold text-gray-800 dark:text-gray-100">Bulk Delete User</div>
                            <button class="__closeModal text-gray-400 dark:text-gray-500 hover:text-gray-500 dark:hover:text-gray-400">
                                <div class="sr-only">Close</div>
                                <svg class="fill-current" width="16" height="16" viewBox="0 0 16 16">
                                    <path d="M7.95 6.536l4.242-4.243a1 1 0 111.415 1.414L9.364 7.95l4.243 4.242a1 1 0 11-1.415 1.415L7.95 9.364l-4.243 4.243a1 1 0 01-1.414-1.415L6.536 7.95 2.293 3.707a1 1 0 011.414-1.414L7.95 6.536z" />
                                </svg>
                            </button>
                        </div>
                    </div>

                    <!-- DELETE Modal content -->
                    <form id="form-bulk-delete-user" method="POST">
                        @csrf
                        <input id="bulk_ids" type="hidden" name="bulk_ids" value="" />

                        <div class="p-5 flex space-x-4" id="message">
                            <!-- Icon -->
                            <div class="w-10 h-10 rounded-full flex items-center justify-center shrink-0 bg-gray-100 dark:bg-gray-700">
                                <svg class="shrink-0 fill-current text-red-500" width="16" height="16" viewBox="0 0 16 16">
                                    <path d="M8 0C3.6 0 0 3.6 0 8s3.6 8 8 8 8-3.6 8-8-3.6-8-8-8zm0 12c-.6 0-1-.4-1-1s.4-1 1-1 1 .4 1 1-.4 1-1 1zm1-3H7V4h2v5z" />
                                </svg>
                            </div>

                            <!-- Content -->
                            <div>
                                <!-- Modal header -->
                                <div class="mb-2">
                                    <div class="text-lg font-semibold text-gray-800 dark:text-gray-100">Delete Selected Items ?</div>
                                </div>
                                <!-- Modal content -->

                                <div class="mb-3 last:mb-0">
                                    <ul class="text-sm">
                                        <li>
                                            <span class="flex items-center p-2 text-gray-800 dark:text-gray-100 hover:bg-gray-100 dark:hover:bg-gray-700/20 rounded-lg" @click="searchOpen = false" @focus="searchOpen = true" @focusout="searchOpen = false">
                                                <svg class="fill-current text-gray-400 dark:text-gray-500 shrink-0 mr-3" width="16" height="16" viewBox="0 0 16 16">
                                                    <path d="M14 0H2c-.6 0-1 .4-1 1v14c0 .6.4 1 1 1h8l5-5V1c0-.6-.4-1-1-1zM3 2h10v8H9v4H3V2z"></path>
                                                </svg>
                                                <span>
                                                    <span class="font-medium">Total Items :</span> &nbsp; 
                                                    <span id='selected_items' class="text-gray-600 dark:text-gray-400"></span>
                                                </span>
                                            </span>
                                        </li>
                                    </ul>
                                </div>
                                <div class="text-sm mb-10">
                                    <div class="space-y-2 text-gray-600 dark:text-gray-400">
                                        <p>If you confirm then it will be removed.</p>
                                    </div>
                                </div>                                   

                                <!-- Modal footer -->
                                <div class="flex flex-wrap justify-end space-x-2">
                                    <button type="button" class="__closeModal btn-sm border-gray-200 dark:border-gray-700/60 hover:border-gray-300 dark:hover:border-gray-600 text-gray-800 dark:text-gray-300">Cancel</button>
                                    <button type="submit" class="btn-sm bg-red-500 hover:bg-red-600 text-white">Yes, Delete it</button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>




@push('bottom_js')
<script src="https://cdn.jsdelivr.net/npm/typeahead.js@0.11.1/dist/typeahead.bundle.min.js"></script>
    <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>    
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.0/jquery.validate.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/jquery-datatables-checkboxes@1.2.12/js/dataTables.checkboxes.min.js"></script>
    
    <script src="{{ asset('js/lc_select.js') }}"></script>
    <script src="{{ asset('chosen/chosen.jquery.js')}}" type="text/javascript"></script>
    <script src="{{ asset('chosen/init.js')}}" type="text/javascript" charset="utf-8"></script>

        <script>
            
            const userTableUrl = '{{ route('data users') }}';
            var userTable = '';

            const loadRmTable = () => {
                userTable = $('#datatable').DataTable({
                    "autoWidth": false, // might need this
                    processing: true,
                    serverSide: true,
                    bDestroy: true,
                    pageLength: 100,
                    pagingType: 'numbers',
                    columnDefs: [
                        {
                            'targets': 0,
                            'checkboxes': {
                                'selectRow': true
                            }
                        }
                    ],
                    select: {
                        style: 'multi'
                    },
                    bDeferRender: true,
                    ajax: {
                        type: 'GET',
                        url: userTableUrl                   ,
                        data: {
                            role: $('#__role').val(),
                            unitId: $('#__unitId').val(),
                        }
                    },
                    columns: [
                        {
                            name: 'checkbox',
                            data: 'id'
                        },
                        {
                            name: 'created_at',
                            data: 'created_at',
                            width: "160px" ,
                            orderable: true
                        },
                        {
                            name: 'name',
                            data: 'name',
                            className: 'text-left',
                            orderable: true
                        },
                        {
                            name: 'phone',
                            data: 'phone',
                            className: 'text-left',
                            orderable: true
                        },
                        {
                            name: 'email',
                            data: 'email',  
                            className: 'text-left',
                            orderable: true
                        },                        
                        {
                            name: 'shop_name',
                            data: 'shop_name',  
                            className: 'text-left',
                            orderable: true
                        },                                               
                        {
                            name: 'staff_role',
                            data: 'staff_role',
                            className: 'text-left',  
                            orderable: true
                        },
                        {
                            name: 'actions',
                            data: 'actions',
                            orderable: false
                        }
                    ]
                });
            }

            loadRmTable();

            const sortProductTable = sortBy => {
                switch (sortBy) {
                    case 'part_no_asc':
                        userTable.order([0, 'asc']).draw();
                        break;

                    case 'part_no_desc':
                        userTable.order([0, 'desc']).draw();
                        break;

                    case 'price_asc':
                        userTable.order([1, 'asc']).draw();
                        break;

                    case 'price_desc':
                        userTable.order([1, 'desc']).draw();
                        break;

                    case 'quantity_asc':
                        userTable.order([2, 'asc']).draw();
                        break;

                    case 'quantity_desc':
                        userTable.order([2, 'desc']).draw();
                        break;

                    default:
                        userTable.order([0, 'asc']).draw();
                        break;
                }
            }

            $('#__sortByToolbar').on('change', function() {
                let sortByValue = $(this).val();
                sortProductTable(sortByValue);
            });

            $(".__statusFilter button").click(function() {
                $('.__statusFilter button').removeClass('active');
                $(this).addClass('active');
                $('#__role').val($(this).data('role'));
                loadRmTable();
            });

            $('#__unitId').on('change', function() {
                loadRmTable();
            });



            $(document).on('click', '#BtnInsertProduct', function(event) {
                event.preventDefault();
        
                $('.modal-insertProduct').show();
                $.ajax({
                    url: '{{ route("form-insert-modal-user") }}',
                    type: 'post',
                    data: {
                        'id': $(this).data('id'),
                        '_token': $('meta[name=csrf-token]').attr('content')
                    }
                }).done(function(result) {                    
                    $('#form-insert-user').html(result);
                });         
            });

            $(document).on('submit', '#form-insert-user', function(event) {
                event.preventDefault();

                var $msgSuccess = $('#form-insert-user #msg-success');
                var $errorList = $('#form-insert-user #error-list');

                // Clear existing errors (if any)
                $errorList.empty();

                var formData = new FormData($(this)[0]);
                console.log(formData);
                $.ajax({
                    url: '{{ route('user.insert') }}',
                    type: 'post',
                    data: formData,
                    contentType: false,
                    processData: false, // Add this line to prevent default processing of FormData
                    success: function(response) {
                        $("#msg-success").html(response.message);                            
                        $msgSuccess.show();
                        // Hide the modal after 3 seconds (1000 ms)
                        setTimeout(function() {
                            //$('#add-user-modal').hide();
                           // location.reload();
                        }, 1000);
                        
                    },
                    error: function(error) {
                        $errorList.show();
                        var errorData = error.responseJSON;
                        console.error('result:', errorData.errors);
                        // Display errors on the UI (you can customize how to show these)
                        for (const [key, message] of Object.entries(errorData.errors)) {
                            // Assuming you have a way to show these errors in your UI
                            $errorList.append('<li>' + message + '</li>');                                    
                        }
                    }

                })
            });

            $(document).on('click', '#BtnEditProduct', function(event) {
                event.preventDefault();
                $('.modal-editProduct').show();
                $.ajax({
                    url: '{{ route('data users') }}?id=' + $(this).data('id'),
                    type: 'get',
                    data: {
                        'id': $(this).data('id'),
                        '_token': $('meta[name=csrf-token]').attr('content')
                    }
                }).done(function(result) {                    
                    $('#form-edit-user').html(result);
                });         
            });

            $(document).on('submit', '#form-edit-user', function(event) {
                event.preventDefault();

                var $msgSuccess = $('#form-edit-user #msg-success');
                var $errorList = $('#form-edit-user #error-list');

                // Clear existing errors (if any)
                $errorList.empty();

                var formData = new FormData($(this)[0]);
                console.log(formData);
                $.ajax({
                    url: '{{ route('user.update') }}',
                    type: 'post',
                    data: formData,
                    contentType: false,
                    processData: false, // Add this line to prevent default processing of FormData
                    success: function(response) {
                        $("#msg-success").html(response.message);                            
                        $msgSuccess.show();
                        // Hide the modal after 3 seconds (1000 ms)
                        setTimeout(function() {
                            //$('#add-user-modal').hide();
                            location.reload();
                        }, 1000);
                        
                    },
                    error: function(error) {
                        $errorList.show();
                        var errorData = error.responseJSON;
                        console.error('result:', errorData.errors);
                        // Display errors on the UI (you can customize how to show these)
                        for (const [key, message] of Object.entries(errorData.errors)) {
                            // Assuming you have a way to show these errors in your UI
                            $errorList.append('<li>' + message + '</li>');                                    
                        }
                    }

                })
            });


            $(document).on('click', '#BtnDeleteProduct', function(event) {
                event.preventDefault();
        
                $('.modal-deleteProduct').show();
                $.ajax({
                    url: '{{ route('form-delete-modal-user') }}',
                    type: 'post',
                    data: {
                        'id': $(this).data('id'),
                        '_token': $('meta[name=csrf-token]').attr('content')
                    }
                }).done(function(result) {
                    $('#form-delete-user').html(result);
                });         
            });

            $(document).on('click', '.__closeModal', function(event) {
                event.preventDefault();
                //$('.modal-update').addClass('modal-hide');
                $('.modalArea').hide(); // Hide the modal
            });


            $(document).on('submit', '#form-delete-user', function(event) {
                event.preventDefault();
                var $message = $('#form-delete-user #message');

                var formData = new FormData($(this)[0]);
                //console.log(formData);
                $.ajax({
                    url: '{{ route('user.delete') }}',
                    type: 'post',
                    data: formData,
                    contentType: false,
                    processData: false, // Add this line to prevent default processing of FormData
                    success: function(response) {
                        if(response.status==1){
                            $("#message").html(response.message);                            
                            $message.show();
                            // Hide the modal after 3 seconds (1000 ms)
                            setTimeout(function() {
                                //$('#add-user-modal').hide();
                                location.reload();
                            }, 1000);
                        }else{
                            $message.show();
                                // Assuming you have a way to show these errors in your UI
                            $message.html(response.message);                                    
                            
                        }
                        
                        
                    },
                    error: function(error) {
                        $errorList.show();
                        var errorData = error.responseJSON;
                        console.error('result:', errorData.errors);
                        // Display errors on the UI (you can customize how to show these)
                        for (const [key, message] of Object.entries(errorData.errors)) {
                            // Assuming you have a way to show these errors in your UI
                            $errorList.append('<li>' + message + '</li>');                                    
                        }
                    }

                })
            });


            $(document).on('click', '#bulk_delete', function() {

                var rows_selected = $('#datatable').DataTable().column(0).checkboxes.selected();

                var arr = [];
                $.each(rows_selected, function(index, rowId){
                    arr[index]=rowId;
                                //datatable.cell(index,8).data(status);
                            });

    

                if(arr.length === 0){
                    alert("Please select at least 1 row");
                    return;
                }else{
                    $('.modal-deleteBulkUser').show();
                    $("#bulk_ids").val(arr);                   
                    $("#selected_items").text(arr.length);
                }               
                });


                $(document).on('submit', '#form-bulk-delete-user', function(event) {
                event.preventDefault();
                var $message = $('#form-bulk-delete-user #message');

                var formData = new FormData($(this)[0]);
                //console.log(formData);
                $.ajax({
                    url: '{{ route('bulk-delete-user') }}',
                    type: 'post',
                    data: formData,
                    contentType: false,
                    processData: false, // Add this line to prevent default processing of FormData
                    success: function(response) {
                        if(response.status==1){
                            $message.html(response.message);                            
                            $message.show();
                            // Hide the modal after 3 seconds (1000 ms)
                            setTimeout(function() {
                                //$('#add-user-modal').hide();
                                location.reload();
                            }, 1000);
                        }else{
                            $message.show();
                                // Assuming you have a way to show these errors in your UI
                            $message.html(response.message);                                    
                            
                        }
                        
                        
                    },
                    error: function(error) {
                        $errorList.show();
                        var errorData = error.responseJSON;
                        console.error('result:', errorData.errors);
                        // Display errors on the UI (you can customize how to show these)
                        for (const [key, message] of Object.entries(errorData.errors)) {
                            // Assuming you have a way to show these errors in your UI
                            $errorList.append('<li>' + message + '</li>');                                    
                        }
                    }

                })
            });



        </script>


    @endpush
</x-app-layout>
