@csrf

<div class="px-5 py-4">
<div class="text-sm">
    <div id='msg-success' class="font-medium text-green-700  dark:text-green-700 mb-3">
    </div>
    <ul id="error-list" class="text-red-500 mb-3"></ul>
</div>

<div class="space-y-3">

    <div class="flex flex-wrap items-center space-x-4">
        <div class="shadow-sm rounded-xl">
            <label class="block text-sm font-medium mb-1" for="name">Fullname</label>
            <input type="text" id="name" class="form-input w-full" name="name"
                placeholder="Enter Full Name" value="" autocomplete="off" />
        </div>

        <div class="shadow-sm rounded-xl">
            <label class="block text-sm font-medium mb-1" for="phone">Phone</label>
            <input type="text" id="phone" class="form-input w-full" name="phone"
                placeholder="Enter Phone" value="" autocomplete="off" />
        </div>
    </div>

    <div class="flex flex-wrap items-center space-x-4">
        <div class="shadow-sm rounded-xl">
            <label class="block text-sm font-medium mb-1" for="email">Email</label>
            <input type="text" id="email" class="form-input w-full" name="email"
                placeholder="Enter Email" value="" autocomplete="off" />
        </div>

        <div class="shadow-sm rounded-xl">
            <label class="block text-sm font-medium mb-1" for="username">Username</label>
            <input type="text" id="username" class="form-input w-full" name="username"
                placeholder="Enter Username" value="" autocomplete="off" />
        </div>
    </div>

    
    <div class="flex flex-wrap items-center space-x-4">
        <div class="shadow-sm rounded-xl">
            <label class="block text-sm font-medium mb-1" for="password">Password</label>
            <input type="text" id="password" class="form-input w-full" name="password"
                placeholder="Enter Password" value="" autocomplete="off" />
        </div>

        <div class="shadow-sm rounded-xl">
            <label class="block text-sm font-medium mb-1" for="password_confirmation">Confirm Password</label>
            <input type="text" id="password_confirmation" class="form-input w-full" name="password_confirmation"
                placeholder="Enter Confirm Password" value="" autocomplete="off" />
        </div>
    </div>

    <!-- Select -->
    <div>
        <label class="block text-sm font-medium mb-1" for="role">Role</label>
        <select name="role" class="form-select w-full">
            <option value="">Select Role</option>
            @if($roles)
                @foreach ($roles as $role)
                    <option value="{{ $role->id }}"> {{ $role->name }} </option>
                @endforeach
            @endif
        </select>
    </div>

    <!-- Checkbox -->
    <div class="w-full">
        <label class="block text-sm font-medium mb-1" for="shop_id">Shop</label>  
        <div class="flex flex-wrap items-center -m-3"> 
        
        @if($shops)  
            @foreach($shops as $row)                   
                <div class="m-3">
                    <!-- Start -->
                    <label class="flex items-center">
                        <input type="checkbox" name="shop_id[]" value='{{$row->id}}' class="form-checkbox" />
                        <span class="text-sm ml-2">{{$row->name}} ({{$row->location}})</span>
                    </label>
                    <!-- End -->
                </div>
            @endforeach
        @endif
        </div>
    </div>
</div>
</div>
<!-- Modal footer -->
<div class="px-5 py-4 border-t border-gray-200 dark:border-gray-700/60">
<div class="flex flex-wrap justify-end space-x-2">
    <button
        class="__closeModal btn-sm border-gray-200 dark:border-gray-700/60 hover:border-gray-300 dark:hover:border-gray-600 text-gray-800 dark:text-gray-300">Cancel</button>
    <button type="submit"
        class="btn-sm bg-gray-900 text-gray-100 hover:bg-gray-800 dark:bg-gray-100 dark:text-gray-800 dark:hover:bg-white">Save</button>
</div>
</div>

<script>
    $(".chosen-select").chosen({no_results_text: "Oops, nothing found!"}); 

    $(".datepicker-1").datepicker({
        dateFormat: 'dd-mm-yy'
    });

    var selectedRmsToList = [];
            var rmSource = {!!$raw_materials->toJson() !!};
            //console.log(rmSource);

            
    var rmHandlers = (row) => {
        row.find('.quantity, .rm-price, .tdiscount').on('keyup', function() {
            let currentRow = $(this).closest('tr');            
        });
    }
    // Initial calculation
    $('tbody.main tr').each(function(){
        rmHandlers($(this));
    });

    var deleteRmRow = (button) => {
      const row = button.closest('tr');
      row.remove();
    }

        
    var substringMatcher = function(strs) {
        return function findMatches(q, cb) {
            var matches, substringRegex;
            matches = [];

            substrRegex = new RegExp(q, 'i');

            $.each(strs, function(i, str) {
                if (substrRegex.test(str)) {
                    matches.push(str);
                }
            });

            cb(matches);
        };
    };


    var initializeTypeAheadField = () => {

        $('#__rm_id_QR_scanner').typeahead({
          
            hint: true,
            minLength: 1,
            highlight: true
        }, {
            source: substringMatcher(rmSource),
            limit: 15
        });
    }

    initializeTypeAheadField();


    $('#__rm_id_QR_scanner').on('typeahead:selected', function(event, selectedItem) {
        renderRmToList(selectedItem);
    });


    var renderRmToList = typeAheadValue => {

        
        if (typeAheadValue !== '') {
            $.ajax({
                type: 'GET',
                data: {
                    term: typeAheadValue
                },
                url: '{{ route('get_qr_code_raw_material') }}',
                success: function(responseJson) {
                    //console.log(responseJson);
                    if (responseJson.status === 1) {
                        //$('#error_modal').modal('show');
                    }
              
                    if (responseJson.status === 3) {
                        let lastRow = $('#invoice-container tbody');
                        let newRow = $('#__templateRmItem tr').clone();
                        // Update index in the cloned row
                        newRow.find('.index').text($('#invoice-container tr').length); // Update index based on current row count
                        let rm = responseJson.raw_material;

                        let rmQuantity = 0;
                        
                        
                       

                        //if (selectedRmsToList.indexOf(rm.id) === -1) {

                            selectedRmsToList.push(rm.id);

                            console.log(rm);
                            newRow.attr('class','rowNo_'+rm.id); 
                       
                            newRow.find('.rm-id').val(rm.id || 0);
                            // Reset input values for the new row
                            newRow.find('.rm_name').html(rm.name || '');                            
                            newRow.find('.user').html(rmQuantity || 0);
                            newRow.find('.rm-price').val(rm.price || 0);
                            newRow.find('.rm-price').attr('min',rm.price || 0);
                            newRow.find('.tdiscount').val('');
                            newRow.find('.rm_unit').html(rm.unit || ''); 

                            
                        //     if (selectedRmsToList.indexOf(rm.id) > -1) {
                        //     let userAdjustElement = $(`.rowNo_${rm.id} .quantity`);
                        //     let currentValue = parseInt(userAdjustElement.val());
                        //     let increasedValue = currentValue + 1;
                        //     //userAdjustElement.val(increasedValue);
                        //     userAdjustElement.val(increasedValue);
                        // }


                            lastRow.prepend(newRow);

                            // Attach event handlers to the new row
                            rmHandlers(newRow);
                            
                            // Recalculate totals after adding the new row

                            $('#__noRmWrapper').hide();
                   
                        //}


                        

                        $('#__rm_id_QR_scanner').typeahead('destroy');
                        $('#__rm_id_QR_scanner').val(null);

                            
                        initializeTypeAheadField();

                        $('#__rm_id_QR_scanner').focus();

                    }
                }
            });
        }
    }

</script>

