@csrf
<input type="hidden" name='id' value='{{$user->id}}'>
<div class="px-5 py-4">
<div class="text-sm">
    <div id='msg-success' class="font-medium text-green-700  dark:text-green-700 mb-3">
    </div>
    <ul id="error-list" class="text-red-500 mb-3"></ul>
</div>

<div class="space-y-3">

    <div class="flex flex-wrap items-center space-x-4">
        <div class="shadow-sm rounded-xl">
            <label class="block text-sm font-medium mb-1" for="name">Fullname</label>
            <input type="text" id="name" class="form-input w-full" name="name"
                placeholder="Enter Full Name" value="{{$user->name}}" autocomplete="off" />
        </div>

        <div class="shadow-sm rounded-xl">
            <label class="block text-sm font-medium mb-1" for="phone">Phone</label>
            <input type="text" id="phone" class="form-input w-full" name="phone"
                placeholder="Enter Phone" value="{{$user->phone}}" autocomplete="off">
        </div>
    </div>

    <div class="flex flex-wrap items-center space-x-4">
        <div class="shadow-sm rounded-xl">
            <label class="block text-sm font-medium mb-1" for="email">Email</label>
            <input type="text" id="email" class="form-input w-full" name="email"
                placeholder="Enter Email" value="{{$user->email}}" autocomplete="off">
        </div>

        <div class="shadow-sm rounded-xl">
            <label class="block text-sm font-medium mb-1" for="username">Username</label>
            <input type="text" id="username" class="form-input w-full" name="username"
                placeholder="Enter Username" value="{{$user->username}}" >
        </div>
    </div>

    
    <div class="flex flex-wrap items-center space-x-4">
        <div class="shadow-sm rounded-xl">
            <label class="block text-sm font-medium mb-1" for="password">Password</label>
            <input type="password" id="password" class="form-input w-full" name="password"
                placeholder="Enter Password" value="">
        </div>

        <div class="shadow-sm rounded-xl">
            <label class="block text-sm font-medium mb-1" for="password_confirmation">Confirm Password</label>
            <input type="password" id="password_confirmation" class="form-input w-full" name="password_confirmation"
                placeholder="Enter Confirm Password" value="">
        </div>
    </div>

    <!-- Select -->
    <div>
        <label class="block text-sm font-medium mb-1" for="role">Role</label>
        <select name="role" class="form-select w-full">
            <option value="">Select Role</option>
            @if($roles)
                @foreach ($roles as $role)
                    <option @if($role->name==$user->role) selected @endif value="{{ $role->id }}">{{ $role->name }} </option>
                @endforeach
            @endif
        </select>
    </div>

    <!-- Checkbox -->
    <div class="w-full">
        <label class="block text-sm font-medium mb-1" for="shop_id">Shop</label>  
        <div class="flex flex-wrap items-center -m-3"> 
        
        @if($shops)  
            @foreach($shops as $row) 
            @php 
            $arr_shop_id = explode(",",$user->shop_id); 

            @endphp                 
                <div class="m-3">
                    <!-- Start -->
                    <label class="flex items-center">
                        <input @if(in_array($row->id,$arr_shop_id)) checked @endif type="checkbox" name="shop_id[]" value='{{$row->id}}' class="form-checkbox" />
                        <span class="text-sm ml-2">{{$row->name}} ({{$row->location}})</span>
                    </label>
                    <!-- End -->
                </div>
            @endforeach
        @endif
        </div>
    </div>
</div>
</div>
<!-- Modal footer -->
<div class="px-5 py-4 border-t border-gray-200 dark:border-gray-700/60">
<div class="flex flex-wrap justify-end space-x-2">
    <button
        class="__closeModal btn-sm border-gray-200 dark:border-gray-700/60 hover:border-gray-300 dark:hover:border-gray-600 text-gray-800 dark:text-gray-300">Cancel</button>
    <button type="submit"
        class="btn-sm bg-gray-900 text-gray-100 hover:bg-gray-800 dark:bg-gray-100 dark:text-gray-800 dark:hover:bg-white">Save</button>
</div>
</div>

<script>
    $(".chosen-select").chosen({no_results_text: "Oops, nothing found!"}); 

    $(".datepicker-1").datepicker({
        dateFormat: 'dd-mm-yy'
    });
</script>

