@csrf

<div class="px-5 py-4">
<div class="text-sm">
    <div id='msg-success' class="font-medium text-green-700  dark:text-green-700 mb-3">
    </div>
    <ul id="error-list" class="text-red-500 mb-3"></ul>
</div>

<div class="space-y-3">
    <!-- Select -->
    <!-- <div>
        <label class="block text-sm font-medium mb-1" for="unit_id">Shop</label>
        <select name="unit_id" class="form-select w-full">
            <option value="">Select Unit</option>
            @if($shops)
                @foreach($shops as $row)
                <option value='{{$row->id}}'>{{$row->name}} ({{$row->location}})</option>
                @endforeach
            @endif
        </select>
    </div> -->
    <!-- Radio -->
    <div class="flex flex-wrap items-center -m-3">                       
        <div class="m-3">
            <!-- Start -->
            <label class="flex items-center">
                <input type="radio" name="stock_type" value='1' class="form-radio" />
                <span class="text-sm ml-2">Add To Stock</span>
            </label>
            <!-- End -->
        </div>

        <div class="m-3">
            <!-- Start -->
            <label class="flex items-center">
                <input type="radio" name="stock_type" value='0' class="form-radio" />
                <span class="text-sm ml-2">Remove From Stock</span>
            </label>
            <!-- End -->
        </div>

        <div class="m-3">
            <!-- Start -->
            <label class="flex items-center">
                <input type="radio" name="stock_type" value='2' class="form-radio" />
                <span class="text-sm ml-2">Defect Stock</span>
            </label>
            <!-- End -->
        </div>

    </div>




    <div class="shadow-sm rounded-xl">
        <input type="text" class="form-input w-full" id="__product_id_QR_scanner" placeholder="Enter Product Name or Product Code"
        autocomplete="off" />
    </div>

    <div class="invoice" id="invoice-container">
        <table id="table" class="table table-striped w-full">
            <thead>
            <tr>
                
                <th class="hide-elements" style="width: 20px;"></th>
                <th>#</th>
                <th class="text-left">Name</th>
                <th>Stock</th>            
                <th style="width: 82px;">Quntity</th>

            </tr>
            </thead>
            <tbody id="__productListWrapper">
            </tbody>

        </table>
    </div>

    <div id="__noProductWrapper">
        <div class="w-full py-4 rounded-lg text-center">
            <span class="font-bold text-base text-gray-500">
                --- {{ __('translation.No Product Added') }} ---
            </span>
        </div>
    </div>

    <div>
        <label class="block text-sm font-medium mb-1" for="unit_id">Note</label>
        <textarea class="form-textarea w-full p-5" name="defect_note"></textarea>
    </div>

</div>
</div>
<!-- Modal footer -->
<div class="px-5 py-4 border-t border-gray-200 dark:border-gray-700/60">
<div class="flex flex-wrap justify-end space-x-2">
    <button
        class="__closeModal btn-sm border-gray-200 dark:border-gray-700/60 hover:border-gray-300 dark:hover:border-gray-600 text-gray-800 dark:text-gray-300">Cancel</button>
    <button type="submit"
        class="btn-sm bg-gray-900 text-gray-100 hover:bg-gray-800 dark:bg-gray-100 dark:text-gray-800 dark:hover:bg-white">Save</button>
</div>
</div>


<table class="hidden">
        <tbody id="__templateProductItem" class="">
        <tr>
            <td class="text-right hide-elements">
                <input type="hidden" name="product_id[]" class="product-id" value="">
                <button onclick="deleteProductRow(this)" class="removeItem btn bg-white dark:bg-gray-800 border-gray-200 dark:border-gray-700/60 hover:border-gray-300 dark:hover:border-gray-600">
                    <span class="sr-only">Delete</span>
                    <svg class="w-8 h-8 fill-current text-red-500 shrink-0" viewBox="0 0 33 32">
                        <path d="M13 15h2v6h-2zM17 15h2v6h-2z"></path>
                        <path d="M20 9c0-.6-.4-1-1-1h-6c-.6 0-1 .4-1 1v2H8v2h1v10c0 .6.4 1 1 1h12c.6 0 1-.4 1-1V13h1v-2h-4V9zm-6 1h4v1h-4v-1zm7 3v9H11v-9h10z"></path>
                    </svg>
                </button>
            </td>


            <td class="index text-center">
              1
            </td>
            <td>
            <p class="font-bold m-0"> 
                <span class="product_name"></span> 
            </p>
            
            </td>
            <td class="text-center">
              <span class="stock">0</span>
            </td>

            <td class="text-center">
            <input type="text" class="form-input quantity text-center" name="quantity[]" value="1" onClick="this.select();">     
            </td>
  
        </tr>
       </tbody>
    </table>
     
<script>
    var selectedProductsToList = [];
            var productSource = {!!$products->toJson() !!};
            //console.log(productSource);

            
    var productHandlers = (row) => {
        row.find('.quantity, .product-price, .tdiscount').on('keyup', function() {
            let currentRow = $(this).closest('tr');            
        });
    }
    // Initial calculation
    $('tbody.main tr').each(function(){
        productHandlers($(this));
    });

    var deleteProductRow = (button) => {
      const row = button.closest('tr');
      row.remove();
    }

        
    var substringMatcher = function(strs) {
        return function findMatches(q, cb) {
            var matches, substringRegex;
            matches = [];

            substrRegex = new RegExp(q, 'i');

            $.each(strs, function(i, str) {
                if (substrRegex.test(str)) {
                    matches.push(str);
                }
            });

            cb(matches);
        };
    };


    var initializeTypeAheadField = () => {

        $('#__product_id_QR_scanner').typeahead({
          
            hint: true,
            minLength: 1,
            highlight: true
        }, {
            source: substringMatcher(productSource),
            limit: 15
        });
    }

    initializeTypeAheadField();


    $('#__product_id_QR_scanner').on('typeahead:selected', function(event, selectedItem) {
        renderProductToList(selectedItem);
    });


    var renderProductToList = typeAheadValue => {

        
        if (typeAheadValue !== '') {
            $.ajax({
                type: 'GET',
                data: {
                    term: typeAheadValue
                },
                url: '{{ route('get_qr_code_product') }}',
                success: function(responseJson) {
                    console.log(responseJson);
                    if (responseJson.status === 1) {
                        //$('#error_modal').modal('show');
                    }
              
                    if (responseJson.status === 3) {
                        let lastRow = $('#invoice-container tbody');
                        let newRow = $('#__templateProductItem tr').clone();
                        // Update index in the cloned row
                        newRow.find('.index').text($('#invoice-container tr').length); // Update index based on current row count
                        let product = responseJson.product;

                        let productQuantity = 0;
                        
                        productQuantity = product.check_in - product.check_out - product.defect - product.sales_quantity;
                        
                        
                        if (product.product_code !== null) {
                            product_code = product.product_code;
                        }else{
                            product_code = '';
                        }

                        //if (selectedProductsToList.indexOf(product.id) === -1) {

                            selectedProductsToList.push(product.id);

                            
                            newRow.attr('class','rowNo_'+product.id); 
                       
                            newRow.find('.product-id').val(product.id || 0);
                            // Reset input values for the new row
                            newRow.find('.product_name').html(product.product_name || '');                            
                            newRow.find('.stock').html(productQuantity || 0);
                            newRow.find('.cost-price').val(product.cost_price || 0);
                            newRow.find('.product-price').val(product.price || 0);
                            newRow.find('.product-price').attr('min',product.price || 0);
                            newRow.find('.tdiscount').val('');

                            
                        //     if (selectedProductsToList.indexOf(product.id) > -1) {
                        //     let stockAdjustElement = $(`.rowNo_${product.id} .quantity`);
                        //     let currentValue = parseInt(stockAdjustElement.val());
                        //     let increasedValue = currentValue + 1;
                        //     //stockAdjustElement.val(increasedValue);
                        //     stockAdjustElement.val(increasedValue);
                        // }


                            lastRow.prepend(newRow);

                            // Attach event handlers to the new row
                            productHandlers(newRow);
                            
                            // Recalculate totals after adding the new row

                            $('#__noProductWrapper').hide();
                   
                        //}


                        

                        $('#__product_id_QR_scanner').typeahead('destroy');
                        $('#__product_id_QR_scanner').val(null);

                            
                        initializeTypeAheadField();

                        $('#__product_id_QR_scanner').focus();

                    }
                }
            });
        }
    }

</script>

