<x-app-layout>
    @section('title', 'Assign Permissions')

    @if(\App\Models\Role::checkRolePermissions('Can access menu: Manage Users - Role Management'))
    <x-card class="mt-0">
        <div class="" style="margin-top: -2rem">
            @include('seller.staff_roles.menu')
        </div>
        <hr>

        <card class="bg-gray-500 ">
            <div class="card-title my-4">
                <h4><strong>Assign Permissions</strong></h4>
            </div>
            <div class="mt-6">
                @if(session('success'))
                <x-alert-success>{{ session('success') }}</x-alert-success>
                @endif
                @if ($errors->any())
                <x-alert-danger>
                    <ul class="mt-3 list-disc list-inside text-sm text-red-600">
                        @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </x-alert-danger>
                @endif
            </div>

            <div class="container">
                {!! Form::model($role, ['method' => 'POST','route' => ['assign_permission.save', $role->id]]) !!}
                <div class="row">
                    <div class="w-full">
                        <div class="mb-2">
                            <div class="flex flex-row items-center justify-between mb-2">
                                <h2 class="block whitespace-nowrap text-yellow-500 text-base font-bold">
                                    Products
                                </h2>
                                <hr class="w-full ml-3 relative -top-1 border border-r-0 border-b-0 border-l-0 border-yellow-300">
                            </div>
                        </div>

                        <div class="mb-4 ml-5">
                            <div class="flex flex-row gap-x-4">
                                <label for="add_product">
                                    <input type="checkbox" name="permission[]" id="add_product" value="add_product"
                                        @if(in_array("add_product",$rolePermissions)) checked @endif
                                    class="relative top-[0.10rem]">
                                    <span class="ml-1 cursor-pointer">Add Product</span>
                                </label>
                                <label for="edit_product">
                                    <input type="checkbox" name="permission[]" id="edit_product" value="edit_product"
                                        @if(in_array("edit_product",$rolePermissions)) checked @endif
                                    class="relative top-[0.10rem]">
                                    <span class="ml-1 cursor-pointer">Edit Product</span>
                                </label> 
                                <label for="delete_product">
                                    <input type="checkbox" name="permission[]" id="delete_product" value="delete_product"
                                        @if(in_array("delete_product",$rolePermissions)) checked @endif
                                    class="relative top-[0.10rem]">
                                    <span class="ml-1 cursor-pointer">Delete Product</span>
                                </label>
                                 
                                <label for="add_remove_stock_product">
                                    <input type="checkbox" name="permission[]" id="add_remove_stock_product" value="add_remove_stock_product"
                                        @if(in_array("add_remove_stock_product",$rolePermissions)) checked @endif
                                    class="relative top-[0.10rem]">
                                    <span class="ml-1 cursor-pointer">Add/Remove Stock</span>
                                </label>
                            </div>
                        </div>
                    </div>

                    <div class="w-full">
                        <div class="mb-2">
                            <div class="flex flex-row items-center justify-between mb-2">
                                <h2 class="block whitespace-nowrap text-yellow-500 text-base font-bold">
                                    Sales
                                </h2>
                                <hr class="w-full ml-3 relative -top-1 border border-r-0 border-b-0 border-l-0 border-yellow-300">
                            </div>
                        </div>

                        <div class="mb-4 ml-5">
                            <div class="flex flex-row gap-x-4">
                                <label for="create_sale">
                                    <input type="checkbox" name="permission[]" id="create_sale" value="create_sale"
                                        @if(in_array("create_sale",$rolePermissions)) checked @endif
                                    class="relative top-[0.10rem]">
                                    <span class="ml-1 cursor-pointer">Create New</span>
                                </label>
                                <label for="edit_sale">
                                    <input type="checkbox" name="permission[]" id="edit_sale" value="edit_sale"
                                        @if(in_array("edit_sale",$rolePermissions)) checked @endif
                                    class="relative top-[0.10rem]">
                                    <span class="ml-1 cursor-pointer">Edit Sale</span>
                                </label> 
                                <label for="delete_sale">
                                    <input type="checkbox" name="permission[]" id="delete_sale" value="delete_sale"
                                        @if(in_array("delete_sale",$rolePermissions)) checked @endif
                                    class="relative top-[0.10rem]">
                                    <span class="ml-1 cursor-pointer">Delete Sale</span>
                                </label>
                            </div>
                        </div>
                    </div>

                    <div class="w-full">
                        <div class="mb-2">
                            <div class="flex flex-row items-center justify-between mb-2">
                                <h2 class="block whitespace-nowrap text-yellow-500 text-base font-bold">
                                    Purchases
                                </h2>
                                <hr class="w-full ml-3 relative -top-1 border border-r-0 border-b-0 border-l-0 border-yellow-300">
                            </div>
                        </div>

                        <div class="mb-4 ml-5">
                            <div class="flex flex-row gap-x-4">
                                <label for="create_purchase">
                                    <input type="checkbox" name="permission[]" id="create_purchase" value="create_purchase"
                                        @if(in_array("create_purchase",$rolePermissions)) checked @endif
                                    class="relative top-[0.10rem]">
                                    <span class="ml-1 cursor-pointer">Create New</span>
                                </label>
                                <label for="edit_purchase">
                                    <input type="checkbox" name="permission[]" id="edit_purchase" value="edit_purchase"
                                        @if(in_array("edit_purchase",$rolePermissions)) checked @endif
                                    class="relative top-[0.10rem]">
                                    <span class="ml-1 cursor-pointer">Edit Purchase</span>
                                </label> 
                                <label for="delete_purchase">
                                    <input type="checkbox" name="permission[]" id="delete_purchase" value="delete_purchase"
                                        @if(in_array("delete_purchase",$rolePermissions)) checked @endif
                                    class="relative top-[0.10rem]">
                                    <span class="ml-1 cursor-pointer">Delete Purchase</span>
                                </label>
                            </div>
                        </div>
                    </div>

                    <div class="w-full">
                        <div class="mb-2">
                            <div class="flex flex-row items-center justify-between mb-2">
                                <h2 class="block whitespace-nowrap text-yellow-500 text-base font-bold">
                                    Customers
                                </h2>
                                <hr class="w-full ml-3 relative -top-1 border border-r-0 border-b-0 border-l-0 border-yellow-300">
                            </div>
                        </div>

                        <div class="mb-4 ml-5">
                            <div class="flex flex-row gap-x-4">
                                <label for="add_customer">
                                    <input type="checkbox" name="permission[]" id="add_customer" value="add_customer"
                                        @if(in_array("add_customer",$rolePermissions)) checked @endif
                                    class="relative top-[0.10rem]">
                                    <span class="ml-1 cursor-pointer">Add Customer</span>
                                </label>
                                <label for="edit_customer">
                                    <input type="checkbox" name="permission[]" id="edit_customer" value="edit_customer"
                                        @if(in_array("edit_customer",$rolePermissions)) checked @endif
                                    class="relative top-[0.10rem]">
                                    <span class="ml-1 cursor-pointer">Edit Customer</span>
                                </label> 
                                <label for="delete_customer">
                                    <input type="checkbox" name="permission[]" id="delete_customer" value="delete_customer"
                                        @if(in_array("delete_customer",$rolePermissions)) checked @endif
                                    class="relative top-[0.10rem]">
                                    <span class="ml-1 cursor-pointer">Delete Customer</span>
                                </label>
                            </div>
                        </div>
                    </div>

                    <div class="w-full">
                        <div class="mb-2">
                            <div class="flex flex-row items-center justify-between mb-2">
                                <h2 class="block whitespace-nowrap text-yellow-500 text-base font-bold">
                                    Suppliers
                                </h2>
                                <hr class="w-full ml-3 relative -top-1 border border-r-0 border-b-0 border-l-0 border-yellow-300">
                            </div>
                        </div>

                        <div class="mb-4 ml-5">
                            <div class="flex flex-row gap-x-4">
                                <label for="add_supplier">
                                    <input type="checkbox" name="permission[]" id="add_supplier" value="add_supplier"
                                        @if(in_array("add_supplier",$rolePermissions)) checked @endif
                                    class="relative top-[0.10rem]">
                                    <span class="ml-1 cursor-pointer">Add Supplier</span>
                                </label>
                                <label for="edit_supplier">
                                    <input type="checkbox" name="permission[]" id="edit_supplier" value="edit_supplier"
                                        @if(in_array("edit_supplier",$rolePermissions)) checked @endif
                                    class="relative top-[0.10rem]">
                                    <span class="ml-1 cursor-pointer">Edit Supplier</span>
                                </label> 
                                <label for="delete_supplier">
                                    <input type="checkbox" name="permission[]" id="delete_supplier" value="delete_supplier"
                                        @if(in_array("delete_supplier",$rolePermissions)) checked @endif
                                    class="relative top-[0.10rem]">
                                    <span class="ml-1 cursor-pointer">Delete Supplier</span>
                                </label>
                            </div>
                        </div>
                    </div>

                    <div class="w-full">
                        <div class="mb-2">
                            <div class="flex flex-row items-center justify-between mb-2">
                                <h2 class="block whitespace-nowrap text-yellow-500 text-base font-bold">
                                    Employees
                                </h2>
                                <hr class="w-full ml-3 relative -top-1 border border-r-0 border-b-0 border-l-0 border-yellow-300">
                            </div>
                        </div>

                        <div class="mb-4 ml-5">
                            <div class="flex flex-row gap-x-4">
                                <label for="add_employee">
                                    <input type="checkbox" name="permission[]" id="add_employee" value="add_employee"
                                        @if(in_array("add_employee",$rolePermissions)) checked @endif
                                    class="relative top-[0.10rem]">
                                    <span class="ml-1 cursor-pointer">Add Employee</span>
                                </label>
                                <label for="edit_employee">
                                    <input type="checkbox" name="permission[]" id="edit_employee" value="edit_employee"
                                        @if(in_array("edit_employee",$rolePermissions)) checked @endif
                                    class="relative top-[0.10rem]">
                                    <span class="ml-1 cursor-pointer">Edit Employee</span>
                                </label> 
                                <label for="delete_employee">
                                    <input type="checkbox" name="permission[]" id="delete_employee" value="delete_employee"
                                        @if(in_array("delete_employee",$rolePermissions)) checked @endif
                                    class="relative top-[0.10rem]">
                                    <span class="ml-1 cursor-pointer">Delete Employee</span>
                                </label>
                            </div>
                        </div>
                    </div>

                    <div class="w-full">
                        <div class="mb-2">
                            <div class="flex flex-row items-center justify-between mb-2">
                                <h2 class="block whitespace-nowrap text-yellow-500 text-base font-bold">
                                    Lenders
                                </h2>
                                <hr class="w-full ml-3 relative -top-1 border border-r-0 border-b-0 border-l-0 border-yellow-300">
                            </div>
                        </div>

                        <div class="mb-4 ml-5">
                            <div class="flex flex-row gap-x-4">
                                <label for="add_lender">
                                    <input type="checkbox" name="permission[]" id="add_lender" value="add_lender"
                                        @if(in_array("add_lender",$rolePermissions)) checked @endif
                                    class="relative top-[0.10rem]">
                                    <span class="ml-1 cursor-pointer">Add Lender</span>
                                </label>
                                <label for="edit_lender">
                                    <input type="checkbox" name="permission[]" id="edit_lender" value="edit_lender"
                                        @if(in_array("edit_lender",$rolePermissions)) checked @endif
                                    class="relative top-[0.10rem]">
                                    <span class="ml-1 cursor-pointer">Edit Lender</span>
                                </label> 
                                <label for="delete_lender">
                                    <input type="checkbox" name="permission[]" id="delete_lender" value="delete_lender"
                                        @if(in_array("delete_lender",$rolePermissions)) checked @endif
                                    class="relative top-[0.10rem]">
                                    <span class="ml-1 cursor-pointer">Delete Lender</span>
                                </label>
                            </div>
                        </div>
                    </div>
                  
                    <hr>
                    <div class="w-full text-center">
                        <x-button-link href="{{ route('role') }}" color="gray" class="mr-1">
                            {{ __('translation.Back') }}
                        </x-button-link>
                        <x-button type="submit" color="blue">
                            {{ __('translation.Submit') }}
                        </x-button>
                    </div>
                </div>
                {!! Form::close() !!}
            </div>
        </card>
    </x-card>
    @endif

    @push('bottom_js')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.0/jquery.validate.js"></script>
    @endpush

</x-app-layout>