<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name') }} - Money Receipt</title>

    <link rel="preconnect" href="https://fonts.googleapis.com/" crossorigin>
    <link rel="preconnect" href="https://cdn.jsdelivr.net/" crossorigin>
    <link rel="preconnect" href="https://cdnjs.cloudflare.com/" crossorigin>
    <link rel="preconnect" href="https://code.jquery.com/" crossorigin>
    <link rel="dns-prefetch" href="https://fonts.googleapis.com/">
    <link rel="dns-prefetch" href="https://cdn.jsdelivr.net/">
    <link rel="dns-prefetch" href="https://cdnjs.cloudflare.com/">
    <link rel="dns-prefetch" href="https://code.jquery.com/">

    <!-- Fonts and Icons -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Nunito:wght@400;600;700&display=swap">

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/animate.css@4.1.1/animate.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/jquery-ui-dist@1.12.1/jquery-ui.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.19/dist/sweetalert2.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/jquery-timepicker@1.3.3/jquery.timepicker.min.css">
    

    <link rel="stylesheet" href="{{ asset('css/app.css?_=' . rand()) }}">

    <script src="https://cdn.jsdelivr.net/npm/jquery@3.6.0/dist/jquery.min.js"></script>
    <script src="{{ asset('js/dodo-modal.js?_=' . rand()) }}"></script>
    <link rel="stylesheet" href="{{ asset('css/buyer_page.css') }}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    
</head>

@php

$logo_url = '';

@endphp

<body class="font-sans antialiased min-h-screen bg-gray-100">

    <main class="mt-10">

        <div class="w-11/12 sm:w-3/5 xl:max-w-3xl mx-auto">
            <div id="printArea" class="w-full mx-auto">
                <style>
                    table {
                        border-collapse: collapse;
                    }

                    td {
                        border: 1px solid #cbb6b6;
                    }
                    .h5, h5 {
                        font-size: 1.25rem;
                    }

                    .h1, .h2, .h3, .h4, .h5, .h6, h1, h2, h3, h4, h5, h6 {
                        margin-bottom: .5rem;
                        font-weight: 500;
                        line-height: 1.2;
                    }
                    .h-50 {
                        height: 50% !important;
                    }
                </style>
                <header class="mt-6">
                    <p class="text-sm text-right text-gray-800 font-bold leading-tight relative mb-1">
                        Invoice Date : {{date('Y-m-d H:i:s')}}
                    </p>
                    <div class="w-11/12 sm:w-full xl:max-w-3xl mx-auto flex">
                        <div class="w-1/4 sm:w-32 xl:w-28 mx-auto">
                            <img src="{{ asset('img/al-aksha.jpg') }}" class="h-20 xl:h-80 w-auto">
                        </div>
                        
                        <div class="w-1/4 sm:w-32 xl:w-28 mx-auto">
                            <img src="{{ $shop_details->logo_url }}" alt="{{ $logo_url }}" class="h-20 h-auto">
                        </div>
                        
                        

                        <div class="w-2/4 sm:w-32 xl:w-28 mx-auto">
                            <img src="{{ asset('qrcodes/'.$orderManagement->service_id.'.svg') }}" class="h-50 xl:h-80 w-auto">
                        </div>
                    </div>
                    
                    <div class="w-11/12 sm:w-3/5 xl:max-w-3xl mx-auto">
                        
                        <h1 class="text-xl text-center text-gray-800 font-bold leading-tight relative top-1">
                            {{$shop_details->name}}
                        </h1>
                        <p class="text-sm text-center text-gray-800 font-bold leading-tight relative mb-1">
                            {{$shop_details->address}}
                        </p>
                        <p class="text-sm text-center text-gray-800 font-bold leading-tight relative mb-1">
                            Phone:  {{$shop_details->phone}}
                        </p>
                        <p class="text-sm text-center text-gray-800 font-bold leading-tight relative">
                            E-mail: {{$shop_details->email}}
                        </p>
                    </div>
                    
                    
                   
                </header>
                <x-card.card-default>
                    <x-card.body>
                            <input type="hidden" name="service_id" value="{{$orderManagement->service_id}}">
                            <div id="__confirmOrderStepContentWrapper">

                                <x-section.section>
                                    <x-section.body>
                                        <div class="w-full">
                                            <table class="w-full -mt-1">
                                                <tbody>
                                                    <tr>
                                                        <td class="p-2" style="width:175px">
                                                            <span class="font-bold">
                                                                Name
                                                            </span>
                                                        </td>
                                                        <td class="p-2" style="width:350px" colspan=3>
                                                            {{$orderManagement->customer->customer_name}}
                                                        </td>
                                                    </tr>

                                                    <tr>
                                                        <td class="p-2" style="width:200px">
                                                            <span class="font-bold" >
                                                                Father's/Husband Name
                                                            </span>
                                                        </td>
                                                        <td class="p-2" style="width:350px" colspan=3>
                                                            {{$orderManagement->customer->father_or_husband_name}}
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td class="p-2">
                                                            <span class="font-bold">
                                                                NID No.
                                                            </span>
                                                        </td>
                                                        <td class="p-2" style="width:355px">
                                                            {{$orderManagement->customer->nid_number}}
                                                        </td>

                                                        <td class="p-2" style="width:55px">
                                                            <span class="font-bold">
                                                                DOB
                                                            </span>
                                                        </td>
                                                        <td class="p-2" style="width:155px">
                                                            {{$orderManagement->customer->dob}}
                                                        </td>

                                                    </tr>

                                                    <tr>
                                                        <td class="p-2">
                                                            <span class="font-bold">
                                                                Address
                                                            </span>
                                                        </td>
                                                        <td class="p-2" colspan=3>
                                                            @php
                                                            $present_district = '';
                                                            $present_thana = '';
                                                            $present_postoffice = '';
                                                            $present_postcode = '';
                                                            if(!empty($orderManagement->customer->present_address)){
                                                                $arr_present_address =
                                                                json_decode($orderManagement->customer->present_address);
                                                                $present_district =
                                                                isset($arr_present_address->present_district) ?
                                                                $arr_present_address->present_district : '-';
                                                                $present_thana = isset($arr_present_address->present_thana) ?
                                                                $arr_present_address->present_thana : '-';
                                                                $present_postoffice =
                                                                isset($arr_present_address->present_postoffice) ?
                                                                $arr_present_address->present_postoffice : '-';
                                                                $present_postcode =
                                                                isset($arr_present_address->present_postcode) ?
                                                                $arr_present_address->present_postcode : '-';
                                                            }
                                                            @endphp
                                                            @if(!empty($orderManagement->customer->present_address))
                                                                <span class="font-bold">District : </span>
                                                                {{$present_district}},
                                                                <span class="font-bold">Thana : </span> {{$present_thana}},
                                                                <span class="font-bold">Post Office : </span>
                                                                {{$present_postoffice}},
                                                                <span class="font-bold">Post Code : </span>
                                                                {{$present_postcode}}
                                                            @endif
                                                        </td>

                                                    </tr>

                                                    <tr>
                                                        <td class="p-2">
                                                            <span class="font-bold">
                                                                Cell Phone
                                                            </span>
                                                        </td>
                                                        <td class="p-2" colspan=3>
                                                            {{$orderManagement->customer->contact_phone}}
                                                        </td>

                                                    </tr>

                                                </tbody>
                                            </table>
                                        </div>
                                    </x-section.body>
                                </x-section.section>

                                <x-section.section>
                                    <h5 class="text-left font-bold">
                                        Vehicle Information
                                    </h5>
                                    <x-section.body>
                                        <div class="w-full">
                                            <table class="w-full -mt-1">
                                                <tbody>
                                                    <tr>
                                                        <td class="p-2 font-bold">
                                                            Chassis No.
                                                        </td>
                                                        <td class="p-2 font-bold">
                                                            {{$orderManagement->service_details[0]->product->chassis_no}}
                                                        </td>
                                                    </tr>

                                                    <tr>
                                                        <td class="p-2 font-bold">
                                                            Engine No.
                                                        </td>
                                                        <td class="p-2 font-bold">
                                                            {{$orderManagement->service_details[0]->product->engine_no}}
                                                        </td>
                                                    </tr>

                                                    <tr>
                                                        <td class="p-2 font-bold">
                                                            Model
                                                        </td>
                                                        <td class="p-2 font-bold">
                                                            {{$orderManagement->service_details[0]->product->model_details->name}}
                                                        </td>
                                                    </tr>

                                                    <tr>
                                                        <td class="p-2 font-bold">
                                                            Brand
                                                        </td>
                                                        <td class="p-2 font-bold">
                                                            {{$orderManagement->service_details[0]->product->size_details->name}}
                                                        </td>
                                                    </tr>

                                                    
                                                </tbody>
                                            </table>
                                        </div>
                                    </x-section.body>
                                </x-section.section>

                                <x-section.section>
                                    <x-section.body>
                                        <div class="w-full">
                                            <table class="w-full -mt-1">
                                                <tbody>
                                             
      
            @php $total_paid_amount = ''; @endphp
            @if($manualPaymentSum > 0)
                @php $total_paid_amount = $manualPaymentSum - $manualRefundedSum; @endphp
                
            @endif


            @if(empty($paymentDetailsOthers) AND $manualPaymentSum == 0)
                @php $total_paid_amount = 0; @endphp
                
            @endif

       
        
            @php $total_pending_amount = ''; @endphp
            @if($manualPaymentSum > 0)
                @php $total_pending_amount = $orderManagement->in_total - ($manualPaymentSum - $manualRefundedSum); @endphp
            @endif

           

            @if(empty($paymentDetailsOthers) AND $manualPaymentSum == 0)
                @php $total_pending_amount = $orderManagement->in_total; @endphp
            @endif

      
        @if(!empty($manualRefundedSum) AND $manualRefundedSum > 0)
            Refunded Amount : <strong id="refunded_amount">Tk.
            @php $total_pending_amount = $manualRefundedSum; @endphp
        
        @endif
             
                                                    <tr>
                                                        <td class="p-2 font-bold text-center" style="width:150px">
                                                            Payable Amount 
                                                        </td>
                                                        <td class="p-2 text-right font-bold">
                                                            {{number_format($orderManagement->in_total,2)}}
                                                        </td>
                                                    </tr>

                                                    <tr>
                                                        <td class="p-2 font-bold text-center" style="width:150px">
                                                            Paid
                                                        </td>
                                                        <td class="p-2 text-right font-bold">
                                                        {{number_format($paymentDeatails->amount,2)}}
                                                        </td>
                                                    </tr>
                                                   @if($total_paid_amount>$paymentDeatails->amount)         
                                                        <tr>
                                                            <td class="p-2 font-bold text-center" style="width:150px">
                                                                Total Paid Amount
                                                            </td>
                                                            <td class="p-2 text-right font-bold">
                                                            {{number_format($total_paid_amount,2)}}
                                                            </td>
                                                        </tr>
                                                    @endif

                                                @if(($orderManagement->in_total-$paymentDeatails->amount)>0)       
                                                    <tr>
                                                        <td class="p-2 font-bold text-center" style="width:150px">
                                                            Due
                                                        </td>
                                                        <td class="p-2 text-right font-bold">
                                                        {{number_format(($total_pending_amount),2)}}
                                                        </td>
                                                    </tr>
                                                @endif

                                                <tr>
                                                <td class="p-2 font-bold text-center" style="width:150px">
                                                     In Words
                                                </td>
                                                <td class="p-2 text-right font-bold text-capitalize" style="text-transform: capitalize;">
                                                {{ $money = App\Http\Controllers\SettingController::takaInWord($paymentDeatails->amount);}} Only.
                                                </td>
                                            </tr>
                                            </tbody>
                                            </table>
                                            <br/>
                                            <table class="w-full mt-10">
                                                <tbody>

                                                <tr >
                                                        <td class="p-10 font-bold" style="border:none;">
                                                            
                                                        </td>
                                                    </tr>

                                                    <tr >
                                                        <td class="p-2 font-bold text-right" style="border:none;">
                                                            Authorized Signature
                                                        </td>
                                                    </tr>

                                                
                                                </tbody>
                                            </table>
                                        </div>
                                    </x-section.body>
                                </x-section.section>

                                <div class="pb-3">
                                    <div class="flex items-center justify-center gap-1">
                                        <x-button type="submit" color="green"  onclick="printDiv()">
                                            <i class="fa fa-print"></i>
                                            <span class="ml-2">
                                                Print
                                            </span>

                                        </x-button>
                                    </div>
                                </div>
                            </div>
                    </x-card.body>
                </x-card.card-default>
            </div>
        </div>
    </main>


    <footer class="w-full">
        <div class="text-center py-6">
            <span class="text-gray-500">Powered By</span>
            <a href="" target="_blank" class="no-underline hover:underline text-gray-900 font-bold">
                TechCityIT,Bhairab</a>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/jquery-ui-dist@1.12.1/jquery-ui.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.19/dist/sweetalert2.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/jquery-timepicker@1.3.3/jquery.timepicker.min.js"></script>
    

    <!-- Script to print the content of a div -->
    <script>

    function printDiv() {

        
        var myStyle = '<link rel="stylesheet" href="{{ asset('css/app.css?_=' . rand()) }}">'
        var divContents = document.getElementById("printArea").innerHTML;
        var a = window.open('', '', 'height=600, width=900');
        a.document.write('<html>'+myStyle);
        a.document.write('<body >');
        a.document.write(divContents);
        a.document.write('</body></html>');
        a.document.close();
        a.print();
    }
    </script>


</body>

</html>