<x-app-layout>

    @section('title')
        {{ __('translation.Create Service') }}
    @endsection

    @push('top_css')
        <link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
       
        <link rel="stylesheet" href="{{ asset('css/typeaheadjs.css') }}">
        <link rel="stylesheet" href="{{ asset('css/custom_css.css') }}">
    @endpush

    @if (in_array('Can access menu: Order Management', session('assignedPermissions')))

    <div class="col-span-12">
        <x-card.card-default>
            <x-card.header>
                <x-card.back-button href="{{ route('service.index') }}" />
                <x-card.title>
                        {{ __('translation.Create New Service') }}
                    
                </x-card.title>
            </x-card.header>
            <x-card.body>

                <x-alert-danger class="mb-6 alert hidden" id="__alertDanger">
                    <div id="__alertDangerContent"></div>
                </x-alert-danger>

                <form action="#" method="post" id="__formCreateOrder" enctype="multipart/form-data">
                    @csrf

                    <input type="hidden" name="service_id" value="{{ $service_id }}">

                    <x-section.section style="margin-bottom:1rem !important">
                        <x-section.title>
                            {{ __('translation.Customer Details') }}
                        </x-section.title>
                        <x-section.body>
            
                            <div class="mb-4">
                                <label for="__tax_enable_CreateOrder" class="block mb-2">
                                    {{ __('translation.Customer Type') }} <x-form.required-mark/>
                                </label>
                                <div class="flex flex-row gap-x-4">
                                    <x-form.input-radio name="customer_type" id="" value="existing" checked='true'>
                                        Existing
                                    </x-form.input-radio>
                                    <x-form.input-radio name="customer_type" id="" value="new">
                                        New
                                    </x-form.input-radio>
                                </div>
                            </div>
                        </x-section.body>
                    </x-section.section>


                    <x-section.section class="xl:mb-12">
                        <x-section.title>
                            {{ __('translation.Customer Info') }}
                            <small class="ml-2 text-yellow-500">
                                {{ __('translation.Search by name first') }}
                            </small>
                        </x-section.title>
                        <x-section.body>
                            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-2 gap-4 sm:gap-x-8">
                             <div id="wrapper_existing">
                                <div class="mb-4">
                                    <label for="__tax_enable_CreateOrder" class="block mb-2">
                                        {{ __('translation.Customer') }} <x-form.required-mark/>
                                    </label>
                                    <div class="flex flex-row gap-x-4">
                                        <x-select name="customer_id" class="customer form-select" style="width: 100%">
                                        <option value="">Select Customer</option>
                                        @if($customers)
                                            @foreach($customers as $customer)
                                                <option value="{{$customer->id}}">{{$customer->customer_name}} -> {{$customer->contact_phone}}</option>
                                            @endforeach
                                        @endif
                                    </x-select>
                                    </div>
                                </div>
                            </div>
                            
                            <div id="wrapper_new" class="mb-4">
                                <div class="grid grid-cols-2 sm:grid-cols-2 lg:grid-cols-2 gap-4 sm:gap-x-8">
                                    <div>
                                        <label for="__tax_enable_CreateOrder" class="block mb-2">
                                            {{ __('translation.Customer Name') }} <x-form.required-mark/>
                                        </label>
                                        <div class="flex flex-row gap-x-4">
                                        <x-input type="text" name="customer_name" id="customer_name" />                                        
                                        </div>
                                    </div>

                                    <div>
                                        <label for="__tax_enable_CreateOrder" class="block mb-2">
                                            {{ __('translation.Phone') }} <x-form.required-mark/>
                                        </label>
                                        <div class="flex flex-row gap-x-4">
                                            <x-input type="text" name="contact_phone" id="contact_phone" />     
                                           
                                        </div>
                                    </div>
                                </div>

                            </div>

                            
                            </div>
                        </x-section.body>
                    </x-section.section>

                    <x-section.section>
                        <x-section.title-with-button titleText="Products">
                            <x-button-sm type="button" color="red" class="ml-3 relative -top-1" id="__btnClearProductList">
                                {{ __('translation.Reset') }}
                            </x-button-sm>
                        </x-section.title-with-button>
                        <x-section.body>

                        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-2 gap-4 sm:gap-x-8">
                             <div id="wrapper_existing">
                                <div class="mb-4">
                                    <label for="__tax_enable_CreateOrder" class="block mb-2">
                                        {{ __('translation.Select RAM') }} <x-form.required-mark/>
                                    </label>
                                    <div class="flex flex-row gap-x-4">
                                        <x-select name="ram_id" class="ram_id" style="width: 100%">
                                        <option value="">Select Ram</option>
                                            <option value="1">RAM 1</option>
                                            <option value="2">RAM 2</option>
                                            <option value="3">RAM 3</option>
                                            <option value="4">RAM 4</option>
                                            <option value="5">RAM 5</option>
                                          
                                    </x-select>
                                    </div>
                                </div>
                            </div>
                           
                        </x-section.body>
                    </x-section.section>

                    <x-section.section id="__shipping_methods_wrapper">
                        <x-section.title>
                            {{ __('translation.Services') }}
                        </x-section.title>
                        <x-section.body>

                            <div id="__shippingMethodButtonWrapper" class="mb-7">
                                <x-button-sm type="button" color="blue" id="__btnAddNewShippingMethod">
                                    <i class="fas fa-plus"></i>
                                    <span class="ml-2">
                                        Add New
                                    </span>
                                </x-button-sm>
                            </div>

                            <div id="__shippingMethodListWrapper"></div>

                            <div id="__noServicesWrapper">
                                <div class="w-full py-4 rounded-lg text-center">
                                    <span class="font-bold text-base text-gray-500">
                                        <!-- --- {{ __('translation.No Shipping Methods Available') }} --- -->
                                    </span>
                                </div>
                            </div>
                        </x-section.body>
                    </x-section.section>

          

                    <x-section.section id="__payment_details_wrapper">
                        <x-section.title>
                            {{ __('translation.Payment Details') }}
                        </x-section.title>
                        <x-section.body>
                            
                            <x-input type="hidden" name="base_amount" id="__base_amount" />
                            <div class="mt-8" id="__PaymentTypeWrapper" style="
                                background: #97dfd2;
                                padding: 50px 20px;
                            ">
                                <div class="grid grid-cols-1 gap-4">
                                    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4 sm:gap-x-8">
                                        <div>
                                            <x-label for="DownPayment">
                                                {{ __('translation.Paid') }}
                                            </x-label>
                                            <x-input type="text" name="paid" id="__paid" />
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </x-section.body>
                    </x-section.section>

                    <x-section.section id="__payment_method_wrapper">
                        <x-section.title>
                            {{ __('translation.Payment Details') }}
                        </x-section.title>
                        <x-section.body>

                        <div class="grid grid-cols-3 sm:grid-cols-1 lg:grid-cols-3 gap-4 sm:gap-x-8 mt-4">
                            <div>
                                <x-label for="payment_method_id">
                                    {{ __('translation.Payment Method') }}
                                </x-label>
                                <x-select id="__payment_method" name="payment_method_id" style="width: 100%">
                                    <option disabled selected value="0">
                                        - {{ __('translation.Payment Method') }} -
                                    </option>
                                    @if($payment_methods)
                                        @foreach($payment_methods as $pm)
                                            <option value="{{$pm->id}}">{{$pm->name}}</option>
                                        @endforeach
                                    @endif
                                </x-select>
                            </div>

                            <div id="_bankOrMobileDetailsWrapper" class="lg:col-span-1">
                            </div>

                            <div id="_AccountNoWrapper" class="lg:col-span-1">
                            </div>

                        </div>

                        </x-section.body>
                    </x-section.section>

                    <x-section.section>
                        <x-section.title>
                            {{ __('translation.Cart Totals') }}
                        </x-section.title>
                        <x-section.body>
                            <div class="w-full lg:w-1/2 lg:mx-auto">
                                <table class="w-full -mt-1">
                                    <tbody>
                                        <tr>
                                            <td class="pr-3 py-1">
                                                Sub Total
                                            </td>
                                            <td class="py-1">
                                                <span class="text-white">-</span>
                                                <span class="font-bold">
                                                    {{ currency_symbol('BDT') }}
                                                </span>
                                            </td>
                                            <td class="pl-3 py-1 text-right">
                                                <span class="font-bold" id="__subTotalCurrency">
                                                    0
                                                </span>
                                            </td>
                                        </tr>

                                        <tr>
                                            <td class="pr-3 py-1">
                                                Discount
                                            </td>
                                            <td class="py-1">
                                                <span class="text-gray-900">-</span>
                                                <span class="font-bold">
                                                    {{ currency_symbol('BDT') }}
                                                </span>
                                            </td>
                                            <td class="pl-3 py-1 text-right">
                                                <span class="font-bold" id="__discountCurrency">
                                                    0
                                                </span>
                                            </td>
                                        </tr>
                                        <tr id="__taxRateRowCartTotals" style="display: none">
                                            <td class="pr-3 py-1">
                                                {{ $taxRateSetting->tax_name ?? '' }} (<span id="__taxRateCartTotal">{{ currency_number($taxRateSetting->tax_rate ?? 0, 2) . '%' }}</span>)
                                            </td>
                                            <td class="py-1">
                                                <span class="text-white">-</span>
                                                <span class="font-bold">
                                                    {{ currency_symbol('BDT') }}
                                                </span>
                                            </td>
                                            <td class="pl-3 py-1 text-right">
                                                <span class="font-bold" id="__taxRateCurrency">
                                                    0
                                                </span>
                                            </td>
                                        </tr>

                                        <tr>
                                            <td class="pr-3 py-1 font-bold text-green-500">
                                                Paid
                                            </td>
                                            <td class="py-1">
                                                <span class="text-white">-</span>
                                                <span class="font-bold">
                                                    {{ currency_symbol('BDT') }}
                                                </span>
                                            </td>
                                            <td class="pl-3 py-1 text-right">
                                                <span class="font-bold text-green-500" id="__paidCurrency">
                                                    0
                                                </span>
                                            </td>
                                        </tr>


                                        <tr>
                                            <td colspan="3" class="pt-1 border border-dashed border-r-0 border-b-0 border-l-0 border-gray-400"></td>
                                        </tr>
                                        <tr>
                                            <td class="pr-3 py-1 font-bold text-red-500">
                                                Total Due Amount
                                            </td>
                                            <td class="py-1">
                                                <span class="text-white">-</span>
                                                <span class="font-bold text-red-500">
                                                    {{ currency_symbol('BDT') }}
                                                </span>
                                            </td>
                                            <td class="pl-3 py-1 text-right">
                                                <span class="font-bold text-red-500" id="__grandTotalCurrency">
                                                    0
                                                </span>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </x-section.body>
                    </x-section.section>

                    <div class="text-center pb-4">
                        <x-button type="button" color="gray" class="mr-1" id="__btnCancelCreateOrder">
                            {{ __('translation.Cancel') }}
                        </x-button>
                        <x-button type="submit" color="blue" id="__btnSubmitCreateOrder">
                            {{ __('translation.Create Order') }}
                        </x-button>
                    </div>

                </form>
            </x-card.body>
        </x-card.card-default>
    </div>

    @endif

    <x-modal.modal-small class="modal-hide" id="__modalCancelCreateOrder">
        <x-modal.header>
            <x-modal.title>
                {{ __('translation.Confirm') }}
            </x-modal.title>
        </x-modal.header>
        <x-modal.body>
            <div class="mb-5">
                <p class="text-center">
                    {{ __('translation.Are you sure to cancel this order') . '?' }}
                </p>
            </div>
            <div class="pb-3 text-center">
                <x-button type="button" color="gray" id="__btnCloseModalCancelCreateOrder">
                    {{ __('translation.No, Close') }}
                </x-button>
                <x-button-link href="{{ route('service.index') }}" color="red">
                    {{ __('translation.Yes, Continue') }}
                </x-button-link>
            </div>
        </x-modal.body>
    </x-modal.modal-small>


    <x-modal.modal-small class="modal-hide" id="__modalRemoveShippingItem">
        <x-modal.header>
            <x-modal.title>
                {{ __('translation.Confirm') }}
            </x-modal.title>
        </x-modal.header>
        <x-modal.body>
            <div class="mb-5">
                <p class="text-center">
                    {{ __('translation.Are you sure to remove this shipping method') . '?' }}
                </p>
            </div>
            <div class="text-center pb-5">
                <x-button type="button" color="gray" id="__btnNoModalRemoveShippingItem">
                    {{ __('translation.No, Close') }}
                </x-button>
                <x-button type="button" color="red" id="__btnYesModalRemoveShippingItem">
                    {{ __('translation.Yes, Remove') }}
                </x-button>
            </div>
        </x-modal.body>
    </x-modal.modal-small>





    <div id="__templateShippingItem" class="hidden">
        <div class="mb-4 pb-3 border border-t-0 border-r-0 border-l-0 border-dashed border-gray-300" id="__shippingMethodItem_{item_id}">
            <div class="flex flex-row items-start">
                <div>
                    <input type="checkbox" name="services[]" id="__service_{item_id}" value="{shipping_cost_name}" class="shipping-method__id-radio-field" data-id="{item_id}" checked="true">
                    <input type="hidden" name="service_price[{shipping_cost_name}]" value="{price}" class="shiping-method__price-field">
                    <input type="hidden" name="service_discount[{shipping_cost_name}]" value="0" class="shiping-method__discount-field">
                </div>
                <div class="ml-2">
                    <div class="flex flex-col lg:flex-row lg:items-center shipping-method__content-wrapper">
                        <div class="flex flex-col sm:flex-row sm:items-center">
                            <div class="mb-2 sm:mb-0">
                                <label for="__service_{item_id}" class="ml-1">
                                {shipping_cost_name}
                                </label>
                            </div>
                            <div class="hidden sm:block ml-6">
                                -
                            </div>
                            <div class="sm:ml-2">
                                <span class="font-bold shipping-method__price-display">
                                    {{ currency_symbol('BDT') }} {priceString}
                                </span>
                                <button type="button" class="ml-2 bg-transparent border-0 outline-none focus:outline-none font-bold text-blue-500 shipping-method__btn-product-discount" data-id="{item_id}">
                                    {{ __('translation.Discount Cost') }}
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <div id="__templateRemoveButtonShippingItem" class="hidden">
        <div class="hidden lg:block ml-3">
            -
        </div>
        <div class="lg:ml-2 mt-3 lg:mt-0">
            <button type="button" class="ml-2 bg-transparent border-0 outline-none focus:outline-none font-bold text-red-500 shipping-method__btn-remove-item" data-id="{item_id}">
                {{ __('translation.Remove') }}
            </button>
        </div>
    </div>


    <x-modal.modal-small id="__modalAddDiscount" class="modal-hide">
        <x-modal.header>
            <x-modal.title>
                {{ __('translation.Product Discount Price') }}
            </x-modal.title>
        </x-modal.header>
        <x-modal.body>
            <div class="pb-6">

                <input type="hidden" id="__productCodeAddDiscount">

                <div class="mb-5">
                    <div class="grid grid-cols-1 gap-4">
                        <div>
                            <label class="mb-0">
                                {{ __('translation.Original Price') }} <x-form.required-mark/> :
                            </label>
                            <x-input type="number" id="__currentPriceAddDiscount" min="0" step="0.001" class="bg-gray-200" readonly />
                        </div>
                        <div>
                            <label class="mb-0">
                                {{ __('translation.Discount Price') }} <x-form.required-mark/> :
                            </label>
                            <x-input type="number" id="__discountPriceAddDiscount" min="0" step="0.001" />
                        </div>
                    </div>
                </div>
                <div class="text-center flex flex-col items-center">
                    <div>
                        <x-button type="button" color="red-text" id="__btnResetDiscountModalAddDiscount" class="mb-2">
                            {{ __('translation.Reset Discount') }}
                        </x-button>
                    </div>
                    <div class="text-center">
                        <x-button type="button" color="gray" id="__btnCancelModalAddDiscount" class="mb-2">
                            {{ __('translation.Cancel') }}
                        </x-button>
                        <x-button type="button" color="blue" id="__btnSaveModalAddDiscount">
                            {{ __('translation.Save Changes') }}
                        </x-button>
                    </div>
                </div>
            </div>
        </x-modal.body>
    </x-modal.modal-small>


    <x-modal.modal-small id="__modalAddShippingDiscount" class="modal-hide">
        <x-modal.header>
            <x-modal.title>
                {{ __('translation.Shipping Discount Cost') }}
            </x-modal.title>
        </x-modal.header>
        <x-modal.body>
            <div class="pb-6">

                <input type="hidden" id="__shippingIdAddShippingDiscount">

                <div class="mb-5">
                    <div class="grid grid-cols-1 gap-4">
                        <div>
                            <label class="mb-0">
                                {{ __('translation.Original Cost') }} <x-form.required-mark/> :
                            </label>
                            <x-input type="number" id="__currentPriceAddShippingDiscount" min="0" step="0.001" class="bg-gray-200" readonly />
                        </div>
                        <div>
                            <label class="mb-0">
                                {{ __('translation.Discount Cost') }} <x-form.required-mark/> :
                            </label>
                            <x-input type="number" id="__discountPriceAddShippingDiscount" min="0" step="0.001" />
                        </div>
                    </div>
                </div>
                <div class="text-center flex flex-col items-center">
                    <div>
                        <x-button type="button" color="red-text" id="__btnResetDiscountModalAddShippingDiscount" class="mb-2">
                            {{ __('translation.Reset Discount') }}
                        </x-button>
                    </div>
                    <div class="text-center">
                        <x-button type="button" color="gray" id="__btnCancelModalAddShippingDiscount" class="mb-2">
                            {{ __('translation.Cancel') }}
                        </x-button>
                        <x-button type="button" color="blue" id="__btnSaveModalAddShippingDiscount">
                            {{ __('translation.Save Changes') }}
                        </x-button>
                    </div>
                </div>
            </div>
        </x-modal.body>
    </x-modal.modal-small>



    <x-modal.modal-small id="__modalNewShippingMethod" class="modal-hide">
        <x-modal.header>
            <x-modal.title>
                {{ __('translation.New Service') }}
            </x-modal.title>
        </x-modal.header>
        <x-modal.body>
            <div class="pb-6">

                <form action="#" method="post" id="__formNewShippingMethod">
                    <div class="mb-5">
                        <div class="grid grid-cols-1 gap-4">
                            <div>
                                <label class="mb-0">
                                    {{ __('translation.Name') }} <x-form.required-mark/> :
                                </label>
                                <x-input type="text" name="name" id="__nameNewShippingMethod" autocomplete="off" required />
                            </div>
                            <div>
                                <label class="mb-0">
                                    {{ __('translation.Cost') }} <x-form.required-mark/> :
                                </label>
                                <x-input type="number" name="price" id="__priceNewShippingMethod" step="0.001" autocomplete="off" required />
                            </div>
                        </div>
                    </div>
                    <div class="text-center">
                        <x-button type="reset" color="gray" id="__btnCancelModalNewShippingMethod" class="mb-2">
                            {{ __('translation.Cancel') }}
                        </x-button>
                        <x-button type="submit" color="blue" id="__btnSaveModalNewShippingMethod">
                            {{ __('translation.Save') }}
                        </x-button>
                    </div>
                </form>

            </div>
        </x-modal.body>
    </x-modal.modal-small>


    <x-modal.modal-medium id="__modalOrderCreated" class="modal-hide">
        <x-modal.header>
            <x-modal.title>
                {{ __('translation.Order Created') }}
            </x-modal.title>
            <button type="button" id="__btnCancelCreateOrder" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </x-modal.header>
        <x-modal.body>
            <div class="pb-6">

                <div class="mb-5">
                    <div class="grid grid-cols-12 gap-2 py-2">
                        <div class="col-span-3">
                            {{ __('translation.Order ID') }}
                        </div>
                        <div class="col-span-1">:</div>
                        <div class="col-span-8">
                            <span class="font-bold" id="__orderIdOrderCreated"></span>
                        </div>
                    </div>
                    <!-- <div class="grid grid-cols-12 gap-2 py-2">
                        <div class="col-span-3">
                            {{ __('translation.Buyer Link') }}
                        </div>
                        <div class="col-span-1">:</div>
                        <div class="col-span-8">
                            <p class="font-bold text-blue-500 underline cursor-pointer break-new-line" id="__publicUrlOrderCreated"></p>
                        </div>
                    </div> -->
                </div>
                <div class="mb-5">
                    <table class="w-full -mt-1">
                        <tbody>
                            <tr>
                                <td class="pr-3 py-1 w-1/2">
                                    Sub Total
                                </td>
                                <td class="py-1 w-6">
                                    <span class="text-white">-</span>
                                    <span class="font-bold">
                                        {{ currency_symbol('BDT') }}
                                    </span>
                                </td>
                                <td class="pl-3 py-1 text-right">
                                    <span class="font-bold" id="__subTotalOrderCreated">
                                        0
                                    </span>
                                </td>
                            </tr>
                            <!-- <tr>
                                <td class="pr-3 py-1">
                                    Shipping Cost
                                </td>
                                <td class="py-1">
                                    <span class="text-white">-</span>
                                    <span class="font-bold">
                                        {{ currency_symbol('BDT') }}
                                    </span>
                                </td>
                                <td class="pl-3 py-1 text-right">
                                    <span class="font-bold" id="__shippingCostOrderCreated">
                                        0
                                    </span>
                                </td>
                            </tr> -->
                            <tr>
                                <td class="pr-3 py-1">
                                    Discount
                                </td>
                                <td class="py-1">
                                    <span class="text-gray-900">-</span>
                                    <span class="font-bold">
                                        {{ currency_symbol('BDT') }}
                                    </span>
                                </td>
                                <td class="pl-3 py-1 text-right">
                                    <span class="font-bold" id="__discountTotalOrderCreated">
                                        0
                                    </span>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="3" class="pt-1 border border-dashed border-r-0 border-b-0 border-l-0 border-gray-400"></td>
                            </tr>
                            <tr>
                                <td class="pr-3 py-1 font-bold text-red-500">
                                    Total Amount
                                </td>
                                <td class="py-1">
                                    <span class="text-white">-</span>
                                    <span class="font-bold text-red-500">
                                        {{ currency_symbol('BDT') }}
                                    </span>
                                </td>
                                <td class="pl-3 py-1 text-right">
                                    <span class="font-bold text-red-500" id="__totalAmountOrderCreated">
                                        0
                                    </span>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <div class="text-center">
                    <x-button-link href="" id="money_receipt" target="_money_receipt" color="blue" class="mb-1">
                        {{ __('translation.Print Invoice') }}
                    </x-button>
                    
                    <x-button-link href="{{ route('service.index') }}" color="blue" class="mb-1">
                        {{ __('translation.All Orders') }}
                    </x-button-link>
                    <x-button type="button" color="green" id="__btnEditOrderCreated" class="mb-1">
                        {{ __('translation.Edit Order') }}
                    </x-button>
                    <x-button type="button" color="yellow" id="__btnCopyBuyerLinkOrderCreated" class="mb-1" data-clipboard-text="#">
                        {{ __('translation.Copy Customer Link') }}
                    </x-button>
                </div>

            </div>
        </x-modal.body>
    </x-modal.modal-medium>


    @push('bottom_js')
        <script src="https://cdn.jsdelivr.net/npm/typeahead.js@0.11.1/dist/typeahead.bundle.min.js"></script>
        
        <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/clipboard@2.0.8/dist/clipboard.min.js"></script>
        <script src="{{ asset('js/delayKeyup.js?_=' . rand()) }}"></script>

        <script>
            const orderStoreUrl = '{{ route('service.store') }}';
            const selectTwoShopUrl = '{{ route('shop.select') }}';
            const getCustomerInfoUrl = '{{ route('customer-phone.show') }}';

            const getShippingCostsUrl = '{{ route('shipper.shipping-cost.weight') }}';

            const enterKeyCode = 13;
            const BDTSymbol = '{{ currency_symbol('BDT') }}';

            const textCreateOrder = '{{ __('translation.Create Order') }}';
            const textProcessing = '{{ __('translation.Processing') }}';
            const textCustomerFound = '{{ __('translation.Customer found') }}';
            let textCustomerNotFound = '';

            var selectedProductsToList = [];
            var productSource = {!! $products->toJson() !!};
    

            var latestShippingId = 0;

            var subTotal = 0;
            var shippingCost = 0;
            var discountTotal = 0;
            var totalAmount = 0;

            var weightTotal = 0;

            const selectedCategory = {
                id: 0,
                name: ''
            };

            const selectedSubCategory = {
                id: 0,
                name: ''
            };

            const subCategoryParams = {
                page: 1,
                search: null
            };

            const companyAddress = {
                provinceCode: -1,
				districtCode: -1,
				subDistrictCode: -1
            };


            $(window).on('load', function() {
                $('input[type="text"]').val('');
                $('input[type="number"]').val('');
                $('select').val('');
                $('#__shop_idCreateOrder').val('').trigger('change');
            });


            $('#__shop_idCreateOrder').select2({
                placeholder: '- Select Shop -',
                width: 'resolve',
                ajax: {
                    type: 'GET',
                    url: selectTwoShopUrl,
                    data: function(params) {
                        return {
                            search: params.term,
                            page: params.page || 1
                        };
                    },
                    delay: 500
                }
            });


            const substringMatcher = function(strs) {
                return function findMatches(q, cb) {
                    var matches, substringRegex;
                    matches = [];

                    substrRegex = new RegExp(q, 'i');

                    $.each(strs, function(i, str) {
                        if (substrRegex.test(str)) {
                            matches.push(str);
                        }
                    });

                    cb(matches);
                };
            };


            const initializeTypeAheadField = () => {
                
                $('#__product_id_QR_scanner').typeahead({
                    hint: true,
                    minLength: 1,
                    highlight: true
                }, {
                    source: substringMatcher(productSource)
                });
            }

            initializeTypeAheadField();


            $('#__product_id_QR_scanner').on('typeahead:selected', function(event, selectedItem) {
                renderProductToList(selectedItem);
            });


            const renderProductToList = typeAheadValue => {                
                
                if (typeAheadValue !== '') {                    
                    $.ajax({
                        type: 'GET',
                        data: {
                            term: typeAheadValue
                        },
                        url: '{{ route('get_qr_code_product') }}',
                        success: function(responseJson) {
                            if (responseJson.status === 1) {
                                $('#error_modal').modal('show');
                            }

                            if (responseJson.status === 3) {
                                let templateProductItemElement = $('#__templateProductItem').clone();
                                let product = responseJson.product;

                                let productQuantity = 0;
                                if (typeof(product.get_quantity.quantity) !== 'undefined') {
                                    productQuantity = product.get_quantity.quantity;
                                }

                            


                                if (selectedProductsToList.indexOf(product.chassis_no) === -1) {
                                    selectedProductsToList.push(product.chassis_no);

                                    templateProductItemElement.html(function(index, html) {
                                        return html.replace('src="#"', 'src="'+ product.image_url +'"');
                                    });

                                    templateProductItemElement.html(function(index, html) {
                                        return html.replaceAll('{product_id}', product.id);
                                    });

                                    templateProductItemElement.html(function(index, html) {
                                        return html.replaceAll('{chassis_no}', product.chassis_no);
                                    });

                                    templateProductItemElement.html(function(index, html) {
                                        return html.replaceAll('{engine_no}', product.engine_no);
                                    });

                                    templateProductItemElement.html(function(index, html) {
                                        return html.replaceAll('{price}', product.price);
                                    });

                                    templateProductItemElement.html(function(index, html) {
                                        return html.replaceAll('{priceString}', product.price.toLocaleString());
                                    });

                                    templateProductItemElement.html(function(index, html) {
                                        return html.replaceAll('{qty}', productQuantity.toLocaleString());
                                    });

                                    
                                    $('#__base_amount').val(product.price);
                                    $('#__paid').val(product.price);
                                    $('#__noProductWrapper').hide();
                                    $('#__shipping_methods_wrapper').show();
                                    $('#__text_details_wrapper').show();
                                    $('#__payment_details_wrapper').show();
                                    $('#__payment_method_wrapper').show();
                                    
                                    
                                    $('#__productListWrapper').prepend(templateProductItemElement.html());
                                }

                                let $productItemWrapper = $('#__row_ProductItem_' + product.chassis_no);
                                let $oldPriceDisplayElement = $productItemWrapper.find('.product-old-price');
                                                              

                                if (selectedProductsToList.indexOf(product.chassis_no) > -1) {
                                    let stockAdjustElement = $(`#__row_ProductItem_${product.chassis_no} .product-qty__field`);
                                    let currentValue = parseInt(stockAdjustElement.val());

                                    let increasedValue = currentValue + 1;
                                    stockAdjustElement.val(increasedValue);
                                }

                                $('#__product_id_QR_scanner').typeahead('destroy');
                                $('#__product_id_QR_scanner').val(null);
                                initializeTypeAheadField();

                                $('#__product_id_QR_scanner').focus();

                                calculateCartTotal();
                                fetchAvailableShippingMethods();
                            }
                        }
                    });
                }
            }

            
            $(document).on('keypress', '#__product_id_QR_scanner', function(event) {
                let keyboardCode = event.keyCode || event.which;

                if (keyboardCode == 13) { // enter key
                    event.preventDefault();

                    let typeAheadValue = $(this).val();
                    
                    renderProductToList(typeAheadValue);

                    return false;
                }
            });

            $(document).on('keyup', '#__total_price', function(event) {                    
                calculateCartTotal();
                calcualateInstallment();
            });
            $(document).on('keyup', '#__paid', function(event) {                    
                calculateCartTotal();
                calcualateInstallment();
            });
            $(document).on('keyup', '#__total_installment', function(event) {                    
                calculateCartTotal();
                calcualateInstallment();
            });

            function calcualateInstallment(){
                let total_price = $("#__total_price").val();
                let total_installment = $("#__total_installment").val();
                let paid =  0 ;

                if($("#__paid").val().length > 0 && $("#__paid").val() != ''){
                    paid =  parseFloat($("#__paid").val()).toFixed(2);
                }


                let amount_per_installment = parseFloat(total_price).toFixed(2);
                if(total_installment.length > 0 && paid.length > 0){
                    amount_per_installment = parseFloat((total_price - paid)/total_installment).toFixed(2);
                }else{
                    amount_per_installment = parseFloat(total_price).toFixed(2);
                }

                if (amount_per_installment != null && amount_per_installment !== ""){
                    $("#__amount_per_installment").val(amount_per_installment);
                }
                
               // $("#__subTotalCurrency").html(parseFloat(total_price).toFixed(2));
                $("#__paidCurrency").html(paid);
                //$("#__grandTotalCurrency").html((total_price - paid).toFixed(2));
                
            }

            const removeProductItem = el => {
                const productCode = el.getAttribute('data-code');

                selectedProductsToList.splice(selectedProductsToList.indexOf(productCode), 1);

                $(`#__row_ProductItem_${productCode}`).remove();

               

                calculateCartTotal();
                fetchAvailableShippingMethods();
            }


            
            

            $('#__payment_method').change(function() {
                if($(this).val()==1){
                    $("#_bankOrMobileDetailsWrapper").hide();
                    $("#_AccountNoWrapper").hide();
                    $("#bank_or_mobile_wallet_id").val('');
                    $("#account_no_id").val('');
                
                }else{
                    $("#_bankOrMobileDetailsWrapper").show();
                    $("#_AccountNoWrapper").show();
                }
                $.ajax({
                    url: '{{ route('load-bank-or-mobile-dropdown') }}',
                    type: 'post',
                    data: {
                        'id': $(this).val(),
                        '_token': $('meta[name=csrf-token]').attr('content')
                    }
                }).done(function(result) {
                    $('#_bankOrMobileDetailsWrapper').html(result);       
                });

            });

            $('#bank_or_mobile_wallet_id').on('change', function() {
                $.ajax({
                    url: '{{ route('load-bank-or-mobile-account-dropdown') }}',
                    type: 'post',
                    data: {
                        'bank_or_mobile_wallet_id': $(this).val(),
                        '_token': $('meta[name=csrf-token]').attr('content')
                    }
                }).done(function(result) {
                    $('#_AccountNoWrapper').html(result);
                });
            });


            $('body').on('keyup', '.product-qty__field', function() {
                let productCode = $(this).data('product-code');

                let qtyValue = parseInt($(this).val());
                if (isNaN(qtyValue)) {
                    qtyValue = 0;
                }

                if (qtyValue < 0) {
                    alert('Minimum quantity is 1');

                    $(this).val(1);
                    return;
                }

                calculateCartTotal();
                fetchAvailableShippingMethods();
            });


            $('body').on('change', '.product-qty__field', function() {
                let productCode = $(this).data('product-code');

                let qtyValue = parseInt($(this).val());
                if (isNaN(qtyValue)) {
                    qtyValue = 0;
                }

                /**
                 *  Fixing bug
                 *  When user try to edit by deleting the value first
                 */
                if (qtyValue <= 0) {
                    alert('Minimum quantity is 1');

                    $(this).val(1);
                    return;
                }

                calculateCartTotal();
                fetchAvailableShippingMethods();
            });


            const calculateCartTotal = _ => {
                subTotal = 0;
                shippingCost = 0;
                discountTotal = 0;
                totalAmount = 0;
                weightTotal = 0;

                /**
                 * --------------------------------
                 * Calculate the product section
                 * --------------------------------
                 */
                $('#__productListWrapper').find('.product-id__field').each(function() {
                    let productCode = $(this).data('product-code');
                    let $productItemWrapper = $('#__row_ProductItem_' + productCode);

                    let productPrice = parseFloat($productItemWrapper.find('.product-price__field').val());
                    if (isNaN(productPrice)) {
                        productPrice = 0;
                    }

                    let productQty = parseInt($productItemWrapper.find('.product-qty__field').val());
                    if (isNaN(productQty)) {
                        productQty = 0;
                    }

                    let productWeight = parseInt($productItemWrapper.find('.product-weight__field').val());
                    if (isNaN(productWeight)) {
                        productWeight = 0;
                    }

                    let dropshipPrice = parseFloat($productItemWrapper.find('.dropship-price__field').val());
                    if (isNaN(dropshipPrice)) {
                        dropshipPrice = 0;
                    }

                    let productDiscount;
                    
                    
                        productDiscount = parseFloat($productItemWrapper.find('.product-discount__field').val());
                        if (isNaN(productDiscount)) {
                            productDiscount = 0;
                        }
                    

                    subTotal += productPrice * productQty;
                    discountTotal += productDiscount * productQty;

                    weightTotal += productWeight * productQty;
                });

                /**
                 * ----------------------------------
                 * Calculate the shipping section
                 * ----------------------------------
                 */
                $('#__shippingMethodListWrapper').find('.shipping-method__id-radio-field').each(function() {
                    let itemId = $(this).data('id');

                    let $shippingItemWrapper = $('#__shippingMethodItem_' + itemId);
                    let $nameField = $shippingItemWrapper.find('.shiping-method__name-field');
                    let $priceField = $shippingItemWrapper.find('.shiping-method__price-field');
                    let $discountField = $shippingItemWrapper.find('.shiping-method__discount-field');


                    if ($(this).is(':checked')) {
                        let priceValue = parseFloat($priceField.val());
                        if (isNaN(priceValue)) {
                            priceValue = 0;
                        }

                        let discountValue = parseFloat($discountField.val());
                        if (isNaN(discountValue)) {
                            discountValue = 0;
                        }

                        shippingCost += priceValue;
                        discountTotal += discountValue;
                    }
                });



                let paid_amount = 0;
                var payment_type = $('input[type=radio][name=payment_type]:checked').val();
                if(payment_type=='installment'){
                    total_price = $("#__total_price").val();
                    subTotal = parseFloat(total_price);
                }

                let subTotalAndShippingCost = subTotal + shippingCost;
     
                
                paid_amount = parseFloat($("#__paid").val());
                if (isNaN(paid_amount)) {
                    paid_amount = 0;
                }
                totalAmount = subTotalAndShippingCost - discountTotal - paid_amount;

                $('#__subTotalCurrency').html(subTotal.toLocaleString());
                $('#__paidCurrency').html(paid_amount);
                
                $('#__discountCurrency').html(discountTotal.toLocaleString());
                $('#__shippingCostCurrency').html(shippingCost.toLocaleString());
                $('#__grandTotalCurrency').html(totalAmount.toLocaleString());
            }


            const fetchAvailableShippingMethods = _ => {
                latestShippingId = 0;

                if (selectedProductsToList.length > 0) {
                    $.ajax({
                        type: 'GET',
                        url: `${getShippingCostsUrl}?weight=${weightTotal}`,
                        beforeSend: function() {
                        },
                        success: function(responseData) {
                            let data = responseData.data;
                            let shippingCosts = data.shipping_costs;

                            $('#__shippingMethodButtonWrapper').show();

                            if (shippingCosts.length > 0) {
                                $('#__shippingMethodListWrapper').html(null);

                                shippingCosts.map((shippingCost, idx) => {
                                    let $templateShippingItem = $('#__templateShippingItem').clone();

                                    latestShippingId = idx;

                                    renderShippingItem({
                                        itemId: latestShippingId,
                                        shippingId: shippingCost.id,
                                        shippingCostName: shippingCost.name,
                                        shippingCostPrice: shippingCost.price,
                                        shipperName: shippingCost.shipper.name
                                    });
                                });
                            }

                            shippingCost = 0;
                        },
                        error: function(error) {
                            alert(`Something went wrong with shipping cost`);
                        }
                    });
                }
            }


            $('body').on('click', 'input[name="service_id"]', function() {
                let selectedShippingId = $(this).val();
                let $shippingItemWrapper = $('#__shippingMethodItem_' + selectedShippingId);

                let $shippingCostPriceElement = $shippingItemWrapper.find('.shiping-method__price-field');
                let shippingCost = parseFloat($shippingCostPriceElement.val());
                if (isNaN(shippingCost)) {
                    shippingCost = 0;
                }

                totalAmount = subTotal + shippingCost - discountTotal;

                $('#__shippingCostCurrency').html(shippingCost.toLocaleString());
                $('#__grandTotalCurrency').html(totalAmount.toLocaleString());
            });


            /**
             * Product Discount
             */
            $('body').on('click', '.btn-product-discount', function() {
                let productCode = $(this).data('product-code');

                let $productItemWrapper = $('#__row_ProductItem_' + productCode);
                let $productPriceElement = $productItemWrapper.find('.product-price__field');
                let $productDiscountElement = $productItemWrapper.find('.product-discount__field');

                let originPriceValue = $productPriceElement.val();
                let discountPriceValue = parseFloat($productDiscountElement.val());
                if (isNaN(discountPriceValue)) {
                    discountPriceValue = 0;
                }

                let discountPriceModalField = '';
                if (discountPriceValue > 0) {
                    discountPriceModalField = originPriceValue - discountPriceValue;
                }

                $('#__modalAddDiscount').doModal('open');

                $('#__currentPriceAddDiscount').val(originPriceValue);
                $('#__discountPriceAddDiscount').val(discountPriceModalField);
                $('#__discountPriceAddDiscount').focus();

                $('#__productCodeAddDiscount').val(productCode);
            });


            $('#__btnCancelModalAddDiscount').on('click', function() {
                $('#__modalAddDiscount').doModal('close');

                $('#__currentPriceAddDiscount').val('');
                $('#__discountPriceAddDiscount').val('');
                $('#__productCodeAddDiscount').val('');
            });


            $('body').on('click', '#__btnSaveModalAddDiscount', function() {
                let productCode = $('#__productCodeAddDiscount').val();

                let $productItemWrapper = $('#__row_ProductItem_' + productCode);
                let $oldPriceDisplayElement = $productItemWrapper.find('.product-old-price');
                let $productPriceElement = $productItemWrapper.find('.product-price__field');
                let $productDiscountElement = $productItemWrapper.find('.product-discount__field');
                let $btnAddDiscountElement = $productItemWrapper.find('.btn-product-discount');

                let productOldPrice = parseFloat($productPriceElement.val());

                let discountPrice = parseFloat($('#__discountPriceAddDiscount').val());
                if (isNaN(discountPrice)) {
                    discountPrice = 0;
                }

                if (productOldPrice - 1 < discountPrice) {
                    alert(`Maximum discount price for this product is ${BDTSymbol} ${productOldPrice - 1}`);
                    return;
                }

                if (discountPrice < 0) {
                    alert(`Minimum discount price is ${BDTSymbol} 0.`);
                    return;
                }

                productDiscountValue = productOldPrice - discountPrice;

                $oldPriceDisplayElement.removeClass('line-through');
                $btnAddDiscountElement.html(`Discount Price`);
                if (discountPrice >= 0) {
                    $oldPriceDisplayElement.addClass('line-through');
                    $btnAddDiscountElement.html(`Discount Price : ${BDTSymbol} ${discountPrice}`);
                }

                $productDiscountElement.val(productDiscountValue);
                calculateCartTotal();

                $('#__modalAddDiscount').doModal('close');

                $('#__currentPriceAddDiscount').val(discountPrice);
                $('#__discountPriceAddDiscount').val(discountPrice);
                $('#__productCodeAddDiscount').val(discountPrice);
            });


            $('body').on('click', '#__btnResetDiscountModalAddDiscount', function() {
                let productCode = $('#__productCodeAddDiscount').val();

                let $productItemWrapper = $('#__row_ProductItem_' + productCode);
                let $oldPriceDisplayElement = $productItemWrapper.find('.product-old-price');
                let $productPriceElement = $productItemWrapper.find('.product-price__field');
                let $productDiscountElement = $productItemWrapper.find('.product-discount__field');
                let $btnAddDiscountElement = $productItemWrapper.find('.btn-product-discount');

                let productOldPrice = parseFloat($productPriceElement.val());

                $oldPriceDisplayElement.removeClass('line-through');
                $btnAddDiscountElement.html(`Discount Price`);

                $productDiscountElement.val(0);
                calculateCartTotal();

                $('#__modalAddDiscount').doModal('close');

                $('#__currentPriceAddDiscount').val('');
                $('#__discountPriceAddDiscount').val('');
                $('#__productCodeAddDiscount').val('');
            });


            /*
            * -----------------------
            * Shipping Method Price
            * -----------------------
            */
            $('body').on('click', '.shipping-method__btn-product-discount', function() {
                let shippingId = $(this).data('id');

                let $shippingItemWrapper = $('#__shippingMethodItem_' + shippingId);
                let $shippingPriceElement = $shippingItemWrapper.find('.shiping-method__price-field');
                let $shippingDiscountPriceElement = $shippingItemWrapper.find('.shiping-method__discount-field');

                let originalShippingCost = $shippingPriceElement.val();
                let discountShippingCost = $shippingDiscountPriceElement.val();
                if (isNaN(discountShippingCost)) {
                    discountShippingCost = 0;
                }

                let discountCostFieldModal = '';
                if (discountShippingCost > 0) {
                    discountCostFieldModal = originalShippingCost - discountShippingCost;
                }

                $('#__modalAddShippingDiscount').doModal('open');

                $('#__currentPriceAddShippingDiscount').val(originalShippingCost);
                $('#__discountPriceAddShippingDiscount').val(discountCostFieldModal);

                $('#__discountPriceAddShippingDiscount').focus();

                $('#__shippingIdAddShippingDiscount').val(shippingId);
            });


            $('#__btnCancelModalAddShippingDiscount').on('click', function() {
                $('#__modalAddShippingDiscount').doModal('close');

                $('#__currentPriceAddShippingDiscount').val('');
                $('#__discountPriceAddShippingDiscount').val('');
                $('#__shippingIdAddShippingDiscount').val('');
            });


            $('body').on('click', '#__btnResetDiscountModalAddShippingDiscount', function() {
                let shippingId = $('#__shippingIdAddShippingDiscount').val();

                let $shippingItemWrapper = $('#__shippingMethodItem_' + shippingId);
                let $oldPriceDisplayElement = $shippingItemWrapper.find('.shipping-method__price-display');
                let $productPriceElement = $shippingItemWrapper.find('.shiping-method__price-field');
                let $productDiscountElement = $shippingItemWrapper.find('.shiping-method__discount-field');
                let $btnAddDiscountElement = $shippingItemWrapper.find('.shipping-method__btn-product-discount');

                let productOldPrice = parseFloat($productPriceElement.val());

                $oldPriceDisplayElement.removeClass('line-through');
                $btnAddDiscountElement.html(`Discount Cost`);

                $productDiscountElement.val(0);
                calculateCartTotal();

                $('#__modalAddShippingDiscount').doModal('close');

                $('#__currentPriceAddShippingDiscount').val('');
                $('#__discountPriceAddShippingDiscount').val('');
                $('#__shippingIdAddShippingDiscount').val('');
            });


            $('body').on('click', '#__btnSaveModalAddShippingDiscount', function() {
                let shippingId = $('#__shippingIdAddShippingDiscount').val();

                let $shippingMethodItemWrapper = $('#__shippingMethodItem_' + shippingId);
                let $oldPriceDisplayElement = $shippingMethodItemWrapper.find('.shipping-method__price-display');
                let $shippingCostElement = $shippingMethodItemWrapper.find('.shiping-method__price-field');
                let $productDiscountElement = $shippingMethodItemWrapper.find('.shiping-method__discount-field');
                let $btnAddDiscountElement = $shippingMethodItemWrapper.find('.shipping-method__btn-product-discount');

                let shippingOldPrice = parseFloat($shippingCostElement.val());

                let discountPrice = parseFloat($('#__discountPriceAddShippingDiscount').val());
                if (isNaN(discountPrice)) {
                    discountPrice = 0;
                }

                if (shippingOldPrice - 1 < discountPrice) {
                    alert(`Maximum discount cost for this shipping is ${BDTSymbol} ${shippingOldPrice - 1}`);
                    return;
                }

                if (discountPrice < 0) {
                    alert(`Minimum discount cost is ${BDTSymbol} 0.`);
                    return;
                }

                shippingDiscountValue = shippingOldPrice - discountPrice;

                $oldPriceDisplayElement.removeClass('line-through');
                $btnAddDiscountElement.html(`Discount Cost`);
                if (discountPrice >= 0) {
                    $oldPriceDisplayElement.addClass('line-through');
                    $btnAddDiscountElement.html(`Discount Cost : ${BDTSymbol} ${discountPrice}`);
                }

                $productDiscountElement.val(shippingDiscountValue);
                calculateCartTotal();

                $('#__modalAddShippingDiscount').doModal('close');

                $('#__currentPriceAddShippingDiscount').val('');
                $('#__discountPriceAddShippingDiscount').val('');
                $('#__shippingIdAddShippingDiscount').val('');
            });


            /**
             * -------------------------------------------
             * Add New Shipping Method
             * -------------------------------------------
             */

            $('#__btnAddNewShippingMethod').on('click', function() {
                $('#__modalNewShippingMethod').doModal('open');
            });


            $('#__btnCancelModalNewShippingMethod').on('click', function() {
                $('#__modalNewShippingMethod').doModal('close');
            });


            $('#__formNewShippingMethod').on('submit', function(event) {
                event.preventDefault();

                let formData = new FormData($(this)[0]);
                latestShippingId += 1;

                renderShippingItem({
                    itemId: latestShippingId,
                    shippingId: 0,
                    shippingCostName: formData.get('name'),
                    shippingCostPrice: parseFloat(formData.get('price')),
                    shipperName: 'Custom'
                }, true);

                calculateCartTotal();

                $('#__modalNewShippingMethod').doModal('close');

                $(this)[0].reset();

                return false;
            });


            const renderShippingItem = ({
                itemId = 0,
                shippingId,
                shippingCostName,
                shippingCostPrice,
                shipperName
            }, isCustomShipping = false) => {
                let $templateShippingItem = $('#__templateShippingItem').clone();

                latestShippingId = itemId;

                $templateShippingItem.html(function(index, html) {
                    return html.replaceAll('{item_id}', itemId);
                });

                $templateShippingItem.html(function(index, html) {
                    return html.replaceAll('{shipping_id}', shippingId);
                });

                $templateShippingItem.html(function(index, html) {
                    return html.replaceAll('{shipping_cost_name}', shippingCostName);
                });

                $templateShippingItem.html(function(index, html) {
                    return html.replaceAll('{shipper_name}', shipperName);
                });

                $templateShippingItem.html(function(index, html) {
                    return html.replaceAll('{price}', shippingCostPrice);
                });

                $templateShippingItem.html(function(index, html) {
                    return html.replaceAll('{priceString}', shippingCostPrice.toLocaleString());
                });

                $('#__shippingMethodListWrapper').append($templateShippingItem.html());


                if (isCustomShipping === true) {
                    addRemoveButtonToShippingMethod(itemId);
                }
            }


            const addRemoveButtonToShippingMethod = itemId => {
                $removeButtonTemplate = $('#__templateRemoveButtonShippingItem').clone();
                $shippingMethodItem = $('#__shippingMethodItem_' + itemId);

                $removeButtonTemplate.html(function(index, html) {
                    return html.replaceAll('{item_id}', itemId);
                });

                $shippingMethodItem
                    .find('.shipping-method__content-wrapper')
                    .append(
                        $removeButtonTemplate.html()
                    );
            }


            $('body').on('change', '.shipping-method__id-radio-field', function() {
                let itemId = $(this).data('id');
                let $shippingItemWrapper = $('#__shippingMethodItem_' + itemId);
                let $selectedInputField = $shippingItemWrapper.find('.shiping-method__selected-input-field');

                $('.shiping-method__selected-input-field').each(function() {
                    $(this).val(0);
                });

                $selectedInputField.val(0);
                if ($(this).is(':checked')) {
                    $selectedInputField.val(1);
                }

                calculateCartTotal();
            });


            $('body').on('click', '.shiping-method__enable-checkbox-field', function() {
                let itemId = $(this).data('id');

                let $shippingItemWrapper = $('#__shippingMethodItem_' + itemId);
                let $shippingRadioField = $shippingItemWrapper.find('.shipping-method__id-radio-field');
                let $shippingIdField = $shippingItemWrapper.find('.shipping-method__id-input--field');
                let $nameField = $shippingItemWrapper.find('.shiping-method__name-field');
                let $priceField = $shippingItemWrapper.find('.shiping-method__price-field');
                let $discountField = $shippingItemWrapper.find('.shiping-method__discount-field');
                let $selectedInputField = $shippingItemWrapper.find('.shiping-method__selected-input-field');

                $shippingRadioField.prop('checked', false);

                $shippingRadioField.attr('disabled', true);
                $shippingIdField.attr('disabled', true);
                $nameField.attr('disabled', true);
                $priceField.attr('disabled', true);
                $discountField.attr('disabled', true);
                $selectedInputField.attr('disabled', true);

                $selectedInputField.val(0);

                if ($(this).is(':checked')) {
                    $shippingRadioField.attr('disabled', false);
                    $shippingIdField.attr('disabled', false);
                    $nameField.attr('disabled', false);
                    $priceField.attr('disabled', false);
                    $discountField.attr('disabled', false);
                    $selectedInputField.attr('disabled', false);
                }

                calculateCartTotal();
            });


            $('body').on('click', '.shipping-method__btn-remove-item', function() {
                let itemId = $(this).data('id');

                $('#__modalRemoveShippingItem').doModal('open');

                $('#__btnYesModalRemoveShippingItem').attr('data-id', itemId);
            });


            $('#__btnNoModalRemoveShippingItem').on('click', function() {
                $('#__btnYesModalRemoveShippingItem').removeAttr('data-id');

                $('#__modalRemoveShippingItem').doModal('close');
            });


            $('#__btnYesModalRemoveShippingItem').on('click', function() {
                let itemId = $(this).data('id');

                $('#__shippingMethodItem_' + itemId).remove();

                calculateCartTotal();

                $('#__modalRemoveShippingItem').doModal('close');
            });

            /***
             *
             * Store the data
             * Using ajax
             *
             */
            $('#__formCreateOrder').on('submit', function(event) {
                event.preventDefault();

                let formData = new FormData($(this)[0]);

                $.ajax({
                    type: 'POST',
                    url: orderStoreUrl,
                    data: formData,
                    processData: false,
                    contentType: false,
                    beforeSend: function() {
                        $('.alert').addClass('hidden');
                        $('#__alertSuccessContent').html(null);
                        $('#__alertDangerContent').html(null);

                        $('#__btnCancelCreateOrder').attr('disabled', true);
                        $('#__btnSubmitCreateOrder').attr('disabled', true).html(textProcessing);
                    },
                    success: function(responseData) {
                        let orderResult = responseData.data;

                        // $('#__alertSuccessContent').html(responseData.message);
                        // $('#__alertSuccess').removeClass('hidden');

                        $('#__orderIdOrderCreated').html(`#${orderResult.orderId}`);
                        $('#__publicUrlOrderCreated')
                            .attr('data-href', orderResult.publicUrl)
                            .html(orderResult.publicUrl);
                        $("#money_receipt").attr('href', orderResult.moneyReceipt);
                        $('#__subTotalOrderCreated').html(orderResult.subTotal.toLocaleString());
                        $('#__shippingCostOrderCreated').html(orderResult.shippingCost.toLocaleString());
                        $('#__discountTotalOrderCreated').html(orderResult.discountTotal.toLocaleString());
                        $('#__totalAmountOrderCreated').html(orderResult.totalAmount.toLocaleString());

                        $('#__btnEditOrderCreated').attr('data-href', orderResult.editUrl);
                        $('#__btnCopyBuyerLinkOrderCreated').attr('data-clipboard-text', orderResult.publicUrl);

                        $('#__modalOrderCreated').doModal('open');

                        $('#__btnCancelCreateOrder').attr('disabled', false);
                        $('#__btnSubmitCreateOrder').attr('disabled', false).html(textCreateOrder);
                    },
                    error: function(error) {
                        let responseJson = error.responseJSON;

                        $('html, body').animate({
                            scrollTop: 0
                        }, 500);

                        $('#__btnCancelCreateOrder').attr('disabled', false);
                        $('#__btnSubmitCreateOrder').attr('disabled', false).html(textCreateOrder);

                        if (error.status == 422) {
                            let errorFields = Object.keys(responseJson.errors);
                            errorFields.map(field => {
                                $('#__alertDangerContent').append(
                                    $('<span/>', {
                                        class: 'block mb-1',
                                        html: `- ${responseJson.errors[field][0]}`
                                    })
                                );
                            });

                        } else {
                            $('#__alertDangerContent').html(responseJson.message);

                        }

                        $('#__alertDanger').removeClass('hidden');
                    }
                });

                return false;
            });


            


            $('#__btnCloseModalCancelCreateOrder').on('click', function() {
                $('#__modalCancelCreateOrder').doModal('close');
            });


            var copyBuyerLink = new ClipboardJS('#__btnCopyBuyerLinkOrderCreated');
            copyBuyerLink.on('success', function(event) {
                alert('URL Copied.');
                event.clearSelection();
            });


            $('body').on('click', '#__publicUrlOrderCreated', function() {
                let publicUrl = $(this).data('href');
                window.open(publicUrl, '_blank');
            });



            $('body').on('click', '#__btnCancelCreateOrder', function() {                
                $('#__modalOrderCreated').doModal('close');
            });

            $('body').on('click', '#__btnEditOrderCreated', function() {
                let editUrl = $(this).data('href');
                window.location.href = editUrl;
            });

        </script>

        <script>
            $("#wrapper_existing").show();
            $("#wrapper_new").hide();
            $('input[type=radio][name=customer_type]').on('click', function() {
                //Reset customer dropdown
                $('.customer').val(null).trigger('change');
                if($(this).val()==='existing'){
                    $("#wrapper_existing").show();
                    $("#wrapper_new").hide();
                }else{
                    $("#wrapper_existing").hide();
                    $("#wrapper_new").show();
                }
            });

            $('.customer').on('change', function() {
             
                values = [];
                $('.customer').find(":selected").each(function(){
                    if($(this).val()) {values.push($(this).val()); }
                });
                $("#customer_id").val(values);
                
            });


            $('input[type=radio][name=payment_type]').on('click', function() {
                if($(this).val()==='installment'){
                    $(".btn-product-discount").hide();                    
                }else{
                    $(".btn-product-discount").show();
                }

                // Load Customer 
                $.ajax({
                    url: '{{ route('load-payment-type-data') }}',
                    type: 'POST',
                    data : {paymentType: $(this).val()},
                    success: function(data) {
                        console.log(data);
                        $('#__PaymentTypeWrapper').empty();
                        $('#__PaymentTypeWrapper').html(data);
                        resetAmount();
                        calculateCartTotal();
                    }
                });
                
            });

        function resetAmount(){
            base_amount = $("#__base_amount").val();
            $("#__total_price").val(base_amount);
            var payment_type = $('input[type=radio][name=payment_type]:checked').val();
            if(payment_type=='installment'){
                $("#__paid").val(null);
            }else{
                $("#__paid").val(base_amount);
            }
            
            $("#__total_installment").val(null);
            $("#__amount_per_installment").val(null);
            $("#__subTotalCurrency").html(base_amount);
            
        }    
            
        $(document).ready(function() {
            $('.customer').select2({
                placeholder: '- Select Customer -',
                width: 'resolve'
            });

            $('.ram_id').select2({
                placeholder: '- Select RAM -',
                width: 'resolve'
            });
            $('#__payment_method').select2({
                placeholder: '- Select Payment Method -',
                width: 'resolve'
            });

            $('#bank_id').select2({
                placeholder: '- Select A Bank -',
                width: 'resolve'
            });

            $('#mobile_banking_id').select2({
                placeholder: '- Select Mobile Wallet -',
                width: 'resolve'
            });
            
        });
        </script>


        <script src="{{ asset('pages/seller/service/create/tax_invoice.js?_=' . rand()) }}"></script>
    @endpush

</x-app-layout>
