@csrf
<input type="hidden" name='id' value='{{$rmStock->id}}'>
<div class="px-5 py-4">
<div class="text-sm">
    <div id='msg-success' class="font-medium text-green-700  dark:text-green-700 mb-3">
    </div>
    <ul id="error-list" class="text-red-500 mb-3"></ul>
</div>

<div class="space-y-3">

    <div class="shadow-sm rounded-xl">
        <label class="block text-sm font-medium mb-1" for="stock_date">Date</label>
        <input type="text" id="stock_date" class="form-input datepicker-1 w-full" name="stock_date"
            placeholder="Enter Date" value="{{$rmStock->stock_date}}" autocomplete="off" />
    </div>

    <!-- Select -->
    <!-- <div>
        <label class="block text-sm font-medium mb-1" for="shop_id">Shop</label>
        <select name="shop_id" class="form-select w-full">
            <option value="">Select Unit</option>
            @if($shops)
                @foreach($shops as $row)
                <option value='{{$row->id}}' @if($rmStock->shop_id==$row->id) selected @endif>{{$row->name}} ({{$row->location}})</option>
                @endforeach
            @endif
        </select>
    </div> -->
    <!-- Radio -->
    <div class="flex flex-wrap items-center -m-3">                       
        <div class="m-3">
            <!-- Start -->
            <label class="flex items-center">
                <input type="radio" name="stock_status" @if($rmStock->stock_status==1) checked @endif value='1' class="form-radio" />
                <span class="text-sm ml-2">Send</span>
            </label>
            <!-- End -->
        </div>

        <div class="m-3">
            <!-- Start -->
            <label class="flex items-center">
                <input type="radio" name="stock_status" @if($rmStock->stock_status==0) checked @endif value='0' class="form-radio" />
                <span class="text-sm ml-2">Back</span>
            </label>
            <!-- End -->
        </div>

        <div class="m-3">
            <!-- Start -->
            <label class="flex items-center">
                <input type="radio" name="stock_status" @if($rmStock->stock_status==2) checked @endif value='2' class="form-radio" />
                <span class="text-sm ml-2">Defect Stock</span>
            </label>
            <!-- End -->
        </div>

    </div>




    <!-- <div class="shadow-sm rounded-xl">
        <input type="text" class="form-input w-full" id="__rm_id_QR_scanner" placeholder="Enter Rm Name or Rm Code"
        autocomplete="off" />
    </div> -->

    <div class="invoice" id="invoice-container">
        <table id="table" class="table table-striped w-full">
            <thead>
            <tr>
                
                <th class="hide-elements" style="width: 20px;"></th>
                <th>#</th>
                <th>Name</th>
                <th class="hidden">Stock</th>            
                <th style="width: 82px;">Quntity</th>

            </tr>
            </thead>
            <tbody id="__productListWrapper">
                @if($rmStock)
                    <tr>
                        <td class="text-right hide-elements">
                            <input type="hidden" name="raw_material_id[]" class="raw_material_id" value="{{$rmStock->raw_material_id}}">
                            <button onclick="deleteProductRow(this)" class="removeItem btn bg-white dark:bg-gray-800 border-gray-200 dark:border-gray-700/60 hover:border-gray-300 dark:hover:border-gray-600">
                                <span class="sr-only">Delete</span>
                                <svg class="w-8 h-8 fill-current text-red-500 shrink-0" viewBox="0 0 33 32">
                                    <path d="M13 15h2v6h-2zM17 15h2v6h-2z"></path>
                                    <path d="M20 9c0-.6-.4-1-1-1h-6c-.6 0-1 .4-1 1v2H8v2h1v10c0 .6.4 1 1 1h12c.6 0 1-.4 1-1V13h1v-2h-4V9zm-6 1h4v1h-4v-1zm7 3v9H11v-9h10z"></path>
                                </svg>
                            </button>
                        </td>


                        <td class="index">
                        1
                        </td>
                        <td>
                        <p class="font-bold m-0"> 
                            <span class="product_code">{{$rmStock->raw_material->name}}</span> 
                        </p>
                        
                        </td>
                        <td class="text-center hidden">
                        <span class="stock"></span>
                        </td>

                        <td class="text-center">
                        <input type="text" class="form-input quantity text-center" name="quantity[]" value="{{$rmStock->quantity}}" onClick="this.select();">     
                        </td>
            
                    </tr>
                @endif
            </tbody>

        </table>
    </div>

    <div id="__noProductWrapper">
        <div class="w-full py-4 rounded-lg text-center">
            <span class="font-bold text-base text-gray-500">
                --- {{ __('translation.No Product Added') }} ---
            </span>
        </div>
    </div>

    <div>
        <label class="block text-sm font-medium mb-1" for="unit_id">Note</label>
        <textarea class="form-textarea w-full p-5" name="defect_note"></textarea>
    </div>

</div>
</div>
<!-- Modal footer -->
<div class="px-5 py-4 border-t border-gray-200 dark:border-gray-700/60">
<div class="flex flex-wrap justify-end space-x-2">
    <button
        class="__closeModal btn-sm border-gray-200 dark:border-gray-700/60 hover:border-gray-300 dark:hover:border-gray-600 text-gray-800 dark:text-gray-300">Cancel</button>
    <button type="submit"
        class="btn-sm bg-gray-900 text-gray-100 hover:bg-gray-800 dark:bg-gray-100 dark:text-gray-800 dark:hover:bg-white">Save</button>
</div>
</div>


<table class="hidden">
        <tbody id="__templateRmItem" class="">
        <tr>
            <td class="text-right hide-elements">
                <input type="hidden" name="raw_material_id[]" class="raw_material_id" value="">
                <button onclick="deleteProductRow(this)" class="removeItem btn bg-white dark:bg-gray-800 border-gray-200 dark:border-gray-700/60 hover:border-gray-300 dark:hover:border-gray-600">
                    <span class="sr-only">Delete</span>
                    <svg class="w-8 h-8 fill-current text-red-500 shrink-0" viewBox="0 0 33 32">
                        <path d="M13 15h2v6h-2zM17 15h2v6h-2z"></path>
                        <path d="M20 9c0-.6-.4-1-1-1h-6c-.6 0-1 .4-1 1v2H8v2h1v10c0 .6.4 1 1 1h12c.6 0 1-.4 1-1V13h1v-2h-4V9zm-6 1h4v1h-4v-1zm7 3v9H11v-9h10z"></path>
                    </svg>
                </button>
            </td>


            <td class="index">
              1
            </td>
            <td>
            <p class="font-bold m-0"> 
                <span class="rm_name"></span> 
            </p>
            
            </td>
            <td class="text-center hidden">
              <span class="stock">0</span>
            </td>

            <td class="text-center">
            <input type="text" class="form-input quantity text-center" name="quantity[]" value="1" onClick="this.select();">     
            </td>
  
        </tr>
       </tbody>
    </table>
     
<script>
    $(".datepicker-1").datepicker({
        dateFormat: 'dd-mm-yy'
    });
    var selectedRmsToList = [];
            var rmSource = {!!$raw_materials->toJson() !!};
            //console.log(rmSource);

            
    var rmHandlers = (row) => {
        row.find('.quantity, .product-price, .tdiscount').on('keyup', function() {
            let currentRow = $(this).closest('tr');            
        });
    }
    // Initial calculation
    $('tbody.main tr').each(function(){
        rmHandlers($(this));
    });

    var deleteProductRow = (button) => {
      const row = button.closest('tr');
      row.remove();
    }

       
    var substringMatcher = function(strs) {
        return function findMatches(q, cb) {
            var matches, substringRegex;
            matches = [];

            substrRegex = new RegExp(q, 'i');

            $.each(strs, function(i, str) {
                if (substrRegex.test(str)) {
                    matches.push(str);
                }
            });

            cb(matches);
        };
    };


    var initializeTypeAheadField = () => {

        $('#__rm_id_QR_scanner').typeahead({
          
            hint: true,
            minLength: 1,
            highlight: true
        }, {
            source: substringMatcher(rmSource),
            limit: 15
        });
    }

    initializeTypeAheadField();


    $('#__rm_id_QR_scanner').on('typeahead:selected', function(event, selectedItem) {
        renderRmToList(selectedItem);
    });


    var renderRmToList = typeAheadValue => {

        
        if (typeAheadValue !== '') {
            $.ajax({
                type: 'GET',
                data: {
                    term: typeAheadValue
                },
                url: '{{ route('get_qr_code_raw_material') }}',
                success: function(responseJson) {
                    //console.log(responseJson);
                    if (responseJson.status === 1) {
                        //$('#error_modal').modal('show');
                    }
              
                    if (responseJson.status === 3) {
                        let lastRow = $('#invoice-container tbody');
                        let newRow = $('#__templateRmItem tr').clone();
                        // Update index in the cloned row
                        newRow.find('.index').text($('#invoice-container tr').length); // Update index based on current row count
                        let rm = responseJson.raw_material;

                        let rmQuantity = 0;
                        
                        
                       

                        //if (selectedRmsToList.indexOf(rm.id) === -1) {

                            selectedRmsToList.push(rm.id);

                            console.log(rm);
                            newRow.attr('class','rowNo_'+rm.id); 
                       
                            newRow.find('.rm-id').val(rm.id || 0);
                            // Reset input values for the new row
                            newRow.find('.rm_name').html(rm.name || '');                            
                            newRow.find('.stock').html(rmQuantity || 0);
                            newRow.find('.rm-price').val(rm.price || 0);
                            newRow.find('.rm-price').attr('min',rm.price || 0);
                            newRow.find('.tdiscount').val('');

                            
                        //     if (selectedRmsToList.indexOf(rm.id) > -1) {
                        //     let stockAdjustElement = $(`.rowNo_${rm.id} .quantity`);
                        //     let currentValue = parseInt(stockAdjustElement.val());
                        //     let increasedValue = currentValue + 1;
                        //     //stockAdjustElement.val(increasedValue);
                        //     stockAdjustElement.val(increasedValue);
                        // }


                            lastRow.prepend(newRow);

                            // Attach event handlers to the new row
                            rmHandlers(newRow);
                            
                            // Recalculate totals after adding the new row

                            $('#__noRmWrapper').hide();
                   
                        //}


                        

                        $('#__rm_id_QR_scanner').typeahead('destroy');
                        $('#__rm_id_QR_scanner').val(null);

                            
                        initializeTypeAheadField();

                        $('#__rm_id_QR_scanner').focus();

                    }
                }
            });
        }
    }

</script>

