<x-app-layout>
    @section('title')
    {{ __('translation.Summary') }}
    @endsection

    @push('top_css')
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/jquery-ui-dist@1.12.1/jquery-ui.min.css">
    <link rel="stylesheet"
        href="https://cdn.jsdelivr.net/npm/jquery-datatables-checkboxes@1.2.12/css/dataTables.checkboxes.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.19/dist/sweetalert2.min.css">
    
    <link rel="stylesheet" href="{{ asset('css/custom_css.css') }}">
    @endpush

    @push('bottom_css')
    <link rel="stylesheet" href="{{ asset('css/datatable-custom-toolbar.css?_=' . rand()) }}">

    <style>
    .summary tr td {
        padding: 0.5rem !important;
        border: 1px solid #9d9696;
    }

    .grand_total td {
        background: #a3ffeb;
        border: 1px solid #9d9696;
    }

    .cash {
        background: #ffffb6 !important;
    }
    </style>
    @endpush


    <div class="col-span-12">

        <div class="md:flex md:justify-between md:items-center">
            <div>
                <h1 class="text-xl text-gray-800 font-bold leading-tight">Daily Summary Report</h1>
            </div>
        </div>

        <div class="col-span-12">
            <div class="mb-6">
                <div class="w-full bg-white rounded-md shadow py-5 mb-6">
                    <div class="px-5">
                        <div class="flex flex-row overflow-x-auto">
                            <div class="lg:col-span-2">
                                <x-label>
                                    {{ __('translation.Payment Date') }}
                                    <x-form.required-mark />
                                </x-label>
                                <x-input type="text" autocomplete=off name="payment_date" id="payment_date"
                                    class="datepicker-1" value="{{$payment_date}}" required />
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-12">
                <x-card.card-default>
                    <x-card.body>
                        @if($cashIn)
                        @foreach ($cashIn as $row)
                        @if(!empty($row->payment_method))
                        @php
                        $arrCashIn[$row->type][$row->payment_method->name]=$row->total;
                        @endphp
                        @endif
                        @endforeach
                        @endif

                        @if($cashOut)
                        @foreach ($cashOut as $row)
                        @if(!empty($row->payment_method))
                        @php
                        $arrCashOut[$row->type][$row->payment_method->name]=$row->total;
                        @endphp
                        @endif
                        @endforeach
                        @endif


                        <div class="w-full mb-10">
                            <div
                                class="py-4 border-0 sm:border border-solid border-gray-300 rounded-md bg-white sm:bg-gray-50">
                                <div class="mb-5" id="summaryWrapper">
                                    <div
                                        class="w-full sm:col-span-1 lg:col-span-4 grid grid-cols-1 lg:grid-cols-1 gap-4 sm:gap-x-8 px-5 sm:mx-auto">
                                        <div class="nav justify-content-center grid grid-cols-1">
                                            
                                            <div class="flex flex-row items-center justify-between mb-2">
                                                <h2 class="block whitespace-nowrap text-yellow-500 text-base font-bold">
                                                    Cash In
                                                </h2>
                                                <hr class="w-full ml-3 relative -top-1 border border-r-0 border-b-0 border-l-0 border-yellow-300">
                                            </div>
                                            <table class="summary">
                                                <tr
                                                    class="nav-item border border-solid border-gray-300 rounded-md bg-green-200">
                                                    <td style="width:25%"><strong>Type</strong></td>
                                                    <td style="width:10%" class="cash text-right"><strong>Cash</strong>
                                                    </td>
                                                    <td style="width:10%" class="text-right"><strong>Banking</strong>
                                                    </td>
                                                    <td style="width:10%" class="text-right"><strong>Mobile
                                                            Banking</strong></td>
                                                    <td style="width:10%" class="text-right"><strong>Total</strong></td>
                                                </tr>
                                                @php
                                                $arr_cash_in_total = array() ;
                                                $arr_banking_in_total = array() ;
                                                $arr_banking_in_total = array() ;
                                                $arr_mobile_banking_in_total = array() ;
                                                @endphp
                                                @if(!empty($arrCashIn))
                                                @foreach ($arrCashIn as $type=>$payment)
                                                <tr
                                                    class="nav-item border border-solid border-gray-300 rounded-md bg-green-200">
                                                    <td>{{ ucwords(str_replace("_"," ",$type))}}</td>
                                                    <td class="cash text-right">
                                                        @isset($payment['Cash'])
                                                        {{ $payment['Cash']}}
                                                        @endisset
                                                    </td>
                                                    <td class="text-right">
                                                        @isset($payment['Banking'])
                                                        {{ $payment['Banking']}}
                                                        @endisset
                                                    </td>
                                                    <td class="text-right">
                                                        @isset($payment['Mobile Banking'])
                                                        {{ $payment['Mobile Banking']}}
                                                        @endisset
                                                    </td>
                                                    <td class="text-right">
                                                        @php
                                                        $total = 0 ;
                                                        if(isset($payment['Cash'])){
                                                        $total += $payment['Cash'];
                                                        }
                                                        if(isset($payment['Banking'])){
                                                        $total += $payment['Banking'];
                                                        }
                                                        if(isset($payment['Mobile Banking'])){
                                                        $total += $payment['Mobile Banking'];
                                                        }
                                                        @endphp
                                                        {{$total}}
                                                    </td>
                                                </tr>

                                                @php
                                                if(isset($payment['Cash'])){
                                                $arr_cash_in_total[] = $payment['Cash'];
                                                }
                                                if(isset($payment['Banking'])){
                                                $arr_banking_in_total[] = $payment['Banking'];
                                                }
                                                if(isset($payment['Mobile Banking'])){
                                                $arr_mobile_banking_in_total[] = $payment['Mobile Banking'];
                                                }
                                                @endphp
                                                @endforeach
                                                @endif

                                                <tr
                                                    class="grand_total nav-item border border-solid border-gray-300 rounded-md bg-green-200">
                                                    <td><strong>Total</strong></td>
                                                    <td class="cash text-right">
                                                        <strong>{{array_sum($arr_cash_in_total)}}</strong></td>
                                                    <td class="text-right">
                                                        <strong>{{array_sum($arr_banking_in_total)}}</strong></td>
                                                    <td class="text-right">
                                                        <strong>{{array_sum($arr_mobile_banking_in_total)}}</strong>
                                                    </td>
                                                    <td class="text-right">
                                                        <strong>{{array_sum($arr_cash_in_total)+array_sum($arr_banking_in_total)+array_sum($arr_mobile_banking_in_total)}}
                                                        </strong></td>
                                                </tr>

                                            </table>
                                        </div>

                                        <div class="nav justify-content-center grid grid-cols-1">
                                            <span class="mb-2">Cash Out</span>
                                            <table class="summary">
                                                <tr
                                                    class="nav-item border border-solid border-gray-300 rounded-md bg-red-200">
                                                    <td style="width:25%"><strong>Type</strong></td>
                                                    <td style="width:10%" class="cash text-right"><strong>Cash</strong>
                                                    </td>
                                                    <td style="width:10%" class="text-right"><strong>Banking</strong>
                                                    </td>
                                                    <td style="width:10%" class="text-right"><strong>Mobile
                                                            Banking</strong></td>
                                                    <td style="width:10%" class="text-right"><strong>Total</strong></td>
                                                </tr>
                                                @php
                                                $arr_cash_out_total = array() ;
                                                $arr_banking_out_total = array() ;
                                                $arr_mobile_banking_out_total = array() ;
                                                @endphp
                                                @if(!empty($arrCashOut))
                                                @foreach ($arrCashOut as $type=>$payment)
                                                <tr
                                                    class="nav-item border border-solid border-gray-300 rounded-md bg-red-200">
                                                    <td>{{ ucwords(str_replace("_"," ",$type))}}</td>
                                                    <td class="cash text-right">
                                                        @isset($payment['Cash'])
                                                        {{ $payment['Cash']}}
                                                        @endisset
                                                    </td>
                                                    <td class="text-right">
                                                        @isset($payment['Banking'])
                                                        {{ $payment['Banking']}}
                                                        @endisset
                                                    </td>
                                                    <td class="text-right">
                                                        @isset($payment['Mobile Banking'])
                                                        {{ $payment['Mobile Banking']}}
                                                        @endisset
                                                    </td>
                                                    <td class="text-right">
                                                        @php
                                                        $total = 0 ;
                                                        if(isset($payment['Cash'])){
                                                        $total += $payment['Cash'];
                                                        }
                                                        if(isset($payment['Banking'])){
                                                        $total += $payment['Banking'];
                                                        }
                                                        if(isset($payment['Mobile Banking'])){
                                                        $total += $payment['Mobile Banking'];
                                                        }
                                                        @endphp
                                                        {{$total}}
                                                    </td>
                                                </tr>

                                                @php
                                                if(isset($payment['Cash'])){
                                                $arr_cash_out_total[] = $payment['Cash'];
                                                }
                                                if(isset($payment['Banking'])){
                                                $arr_banking_out_total[] = $payment['Banking'];
                                                }
                                                if(isset($payment['Mobile Banking'])){
                                                $arr_mobile_banking_out_total[] = $payment['Mobile Banking'];
                                                }
                                                @endphp

                                                @endforeach
                                                @endif

                                                @if($expenses)
                                                @foreach ($expenses as $expense)
                                                <tr
                                                    class="nav-item border border-solid border-gray-300 rounded-md bg-red-200">
                                                    <td>Expense</td>
                                                    <td class="cash text-right">
                                                        @isset($expense->total)
                                                        {{ $expense->total}}
                                                        @endisset
                                                    </td>
                                                    <td class="text-right">

                                                    </td>
                                                    <td class="text-right">

                                                    </td>
                                                    <td class="text-right">
                                                        @php
                                                        $total = 0 ;
                                                        if(isset($payment['Cash'])){
                                                        $total += $expense->total;
                                                        }
                                                        @endphp
                                                        {{$total}}
                                                    </td>
                                                </tr>

                                                @php
                                                if(isset($expense->total)){
                                                $arr_cash_out_total[] = $expense->total;
                                                }
                                                @endphp

                                                @endforeach
                                                @endif
                                                <tr
                                                    class="grand_total nav-item border border-solid border-gray-300 rounded-md bg-green-200">
                                                    <td><strong>Total</strong></td>
                                                    <td class="cash text-right">
                                                        <strong>{{array_sum($arr_cash_out_total) > 0 ? array_sum($arr_cash_out_total) : ''}}</strong>
                                                    </td>
                                                    <td class="text-right">
                                                        <strong>{{array_sum($arr_banking_out_total) > 0 ? array_sum($arr_banking_out_total) : ''}}</strong>
                                                    </td>
                                                    <td class="text-right">
                                                        <strong>{{array_sum($arr_mobile_banking_out_total) > 0 ? array_sum($arr_mobile_banking_out_total) : ''}}</strong>
                                                    </td>
                                                    <td class="text-right">
                                                        <strong>{{array_sum($arr_cash_out_total)+array_sum($arr_banking_out_total)+array_sum($arr_mobile_banking_out_total)}}
                                                        </strong></td>
                                                </tr>
                                                <tr
                                                    class="grand_total nav-item border border-solid border-gray-300 rounded-md bg-green-200">
                                                    <td colspan=4><strong>Cash In Hand</strong></td>
                                                    <td class="text-right"><strong>{{
                                                        (array_sum($arr_cash_out_total)+array_sum($arr_banking_out_total)+array_sum($arr_mobile_banking_out_total)) - 
                                                        (array_sum($arr_cash_out_total)+array_sum($arr_banking_out_total)+array_sum($arr_mobile_banking_out_total))
                                                    }} </strong></td>
                                                </tr>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>


                        <div class="flex flex-col sm:flex-row sm:justify-between items-start mt-10"
                            id="datatable-sales">
                            <div class="w-full sm:mb-0">
                                <h4 class="text-center">Sales Details</h4>
                                <div class="flex flex-col sm:flex-row">
                                    <div class="w-full sm:w-1/4 xl:ml-1 mb-1 sm:mb-0 relative -top-1">
                                        <x-input type="text" id="searchbar-receive" placeholder="Search"></x-input>
                                    </div>

                                    <div class="w-full sm:w-1/2 flex flex-col sm:flex-row">

                                    </div>

                                </div>
                            </div>
                        </div>

                        <div class="w-full overflow-x-auto mb-10">
                            <table class="w-full" id="__SalesTable">
                                <thead>
                                    <tr>
                                        <th>
                                            {{ __('translation.Date') }}
                                        </th>

                                        <th>
                                            {{ __('translation.Customer Name') }}
                                        </th>


                                        <th>
                                            {{ __('translation.Products') }}
                                        </th>

                                        <th>
                                            {{ __('translation.Services') }}
                                        </th>
                                        
                                        <th>
                                            {{ __('translation.Discount') }}
                                        </th>

                                        <th>
                                            {{ __('translation.Total') }}
                                        </th>
                                    </tr>
                                </thead>
                                <tbody></tbody>
                            </table>
                        </div>

                        <div class="w-full overflow-x-auto mb-10">
                        <table class="w-full" id="__ReceivePaymentTable">
                                <thead>
                                <tr class="rounded-lg text-sm font-medium text-gray-700 text-left">
                                    <th></th>
                                    <th class="px-4 py-2 text-center">
                                        {{ __('translation.Date') }}
                                    </th>
                                    <th class="px-4 py-2 text-center">
                                        {{ __('translation.Type') }}
                                    </th>

                                    <th class="px-4 py-2 text-center">
                                        {{ __('translation.From') }}
                                    </th>
                                    
                                    <th class="px-4 py-2 text-center">
                                        {{ __('translation.Payment Method') }}
                                    </th>

                                    <th class="px-4 py-2 text-center">
                                        {{ __('translation.Note') }}
                                    </th>

                                    <th class="px-4 py-2 text-center">
                                        {{ __('translation.Total') }}
                                    </th>
                                </tr>
                                </thead>
                                <tbody></tbody>
                            </table>
                        </div>

                        <div class="flex flex-col sm:flex-row sm:justify-between items-start mt-10" id="">
                            <div class="w-full sm:mb-0">
                                <h4 class="text-center">Payment Details</h4>
                            </div>
                        </div>

                        <div class="w-full overflow-x-auto">
                            <table class="w-full" id="__PaymentTable">
                                <thead>
                                <tr class="rounded-lg text-sm font-medium text-gray-700 text-left">
                                    <th></th>
                                    <th class="px-4 py-2 text-center">
                                        {{ __('translation.Date') }}
                                    </th>
                                    <th class="px-4 py-2 text-center">
                                        {{ __('translation.Type') }}
                                    </th>

                                    <th class="px-4 py-2 text-center">
                                        {{ __('translation.Pay To') }}
                                    </th>
                                    
                                    <th class="px-4 py-2 text-center">
                                        {{ __('translation.Payment Method') }}
                                    </th>

                                    <th class="px-4 py-2 text-center">
                                        {{ __('translation.Note') }}
                                    </th>

                                    <th class="px-4 py-2 text-center">
                                        {{ __('translation.Total') }}
                                    </th>
                                </tr>
                                </thead>
                                <tbody></tbody>
                            </table>
                        </div>

                        <div class="flex flex-col sm:flex-row sm:justify-between items-start mt-10"
                            id="datatable-receive">
                            <div class="w-full sm:mb-0">
                                <h4 class="text-center">Purchase Details</h4>
                                <div class="flex flex-col sm:flex-row">
                                    <div class="w-full sm:w-1/4 xl:ml-1 mb-1 sm:mb-0 relative -top-1">
                                        <x-input type="text" id="searchbar-expense" placeholder="Search"></x-input>
                                    </div>

                                    <div class="w-full sm:w-1/2 flex flex-col sm:flex-row">

                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="overflow-x-auto">
                            <table class="w-full" id="__purchaseOrderTable">
                                <thead>
                                    <tr>
                                        <th>
                                            {{ __('translation.Date') }}
                                        </th>

                                        <th>
                                            {{ __('translation.Buyer Name') }}
                                        </th>


                                        <th>
                                            {{ __('translation.Details') }}
                                        </th>
                                        <th>
                                            {{ __('translation.Status') }}
                                        </th>
                                        <th>
                                            {{ __('translation.Total') }}
                                        </th>

                                    </tr>
                                </thead>
                                <tbody></tbody>
                            </table>
                        </div>


                        <div class="flex flex-col sm:flex-row sm:justify-between items-start mt-10"
                            id="datatable-receive">
                            <div class="w-full sm:mb-0">
                                <h4 class="text-center">Expense Details</h4>
                                <div class="flex flex-col sm:flex-row">
                                    <div class="w-full sm:w-1/4 xl:ml-1 mb-1 sm:mb-0 relative -top-1">
                                        <x-input type="text" id="searchbar-expense" placeholder="Search"></x-input>
                                    </div>

                                    <div class="w-full sm:w-1/2 flex flex-col sm:flex-row">

                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="w-full overflow-x-auto mb-10">
                            <table class="w-full" id="__ExpenseTable">
                                <thead>
                                    <tr class="bg-blue-500">
                                        <th>Date</th>
                                        <th>Name</th>
                                        <th>Amount</th>
                                    </tr>
                                </thead>
                                <tbody></tbody>
                            </table>
                        </div>

                    </x-card.body>
                </x-card.card-default>
            </div>
        </div>
    </div>


    @push('bottom_js')
    <script src="https://cdn.jsdelivr.net/npm/jquery-datatables-checkboxes@1.2.12/js/dataTables.checkboxes.min.js">
    </script>
    <script src="https://cdn.jsdelivr.net/npm/jquery-ui-dist@1.12.1/jquery-ui.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.19/dist/sweetalert2.min.js"></script>
    

    <script>
    $(".datepicker-1").datepicker({
        dateFormat: 'dd-mm-yy'
    });

    const customerType = '{{ $customerType }}';
    const paymentDatatableUrl = '{{ route('payments') }}';
    const receivePaymentDatatableUrl = '{{ route('data receive-payments') }}';
    const salesDatatableUrl = '{{ route('sales_list') }}';
    const purchaseDatatableUrl = '{{ route('purchases') }}';

    const expenseDatatableUrl = '{{ route('data expenses') }}';

    var paymentTable = '';
    var receivePaymentTable = '';
    var purchaseTable = '';
    var expensentTable = '';
    var payment_date = '{{$payment_date}}';

    const loadSummaryTable = (payment_date='') => {
        $('#summaryWrapper').html('');
        $.ajax({
            url: '{{ route('ajax-summary') }}',
            type: "POST",
            data: {
                payment_date: payment_date
            },
            success: function(result) {
                $('#summaryWrapper').html(result);
            }
        });
    }


    const loadSalesTable = (order_date = '', customer_id = -1) => {

        salesTable = $('#__SalesTable').DataTable({
            dom: '<<"datatable_buttons"><rt>lip>',
            bDestroy: true,
            processing: true,
            serverSide: true,
            ajax: {
                type: 'POST',
                url: salesDatatableUrl,
                data: {
                    order_date: order_date,
                    customerId: customer_id,
                }
            },
            columnDefs: [],
            order: [
                [1, 'desc']
            ],
            columns: [{
                    name: 'date',
                    data: 'date'
                },

                {
                    name: 'customer_name',
                    data: 'customer_name'
                },
                {
                    name: 'product_details',
                    data: 'product_details'
                },

                {
                    name: 'service_details',
                    data: 'service_details'
                },
                {
                    name: 'total_discount',
                    data: 'total_discount'
                },
                
                {
                    name: 'total',
                    data: 'total'
                },
            ]
        });
    }

    const loadPaymentTable = (payment_date = '', pm = -1) => {
        paymentTable = $('#__PaymentTable').DataTable({
            "autoWidth": false, // might need this
                    processing: true,
                    serverSide: true,
                    bDestroy: true,
                    pageLength: 100,
                    pagingType: 'numbers',
                    columnDefs: [
                        {
                            'targets': 0,
                            'checkboxes': {
                                'selectRow': true
                            }
                        }
                    ],
                    select: {
                        style: 'multi'
                    },
                    bDeferRender: true,
                    ajax: {
                        type: 'GET',
                        url: '{{ route('data receive-payments') }}',
                        data: {
                            statusId: $('#__statusId').val(),
                            unitId: $('#__unitId').val(),
                        }
                    },
                    columns: [
                        {
                            name: 'checkbox',
                            data: 'id'
                        },
                        {
                            name: 'date',
                            data: 'date',
                            width: "110px" ,
                            className: "text-left" ,
                            orderable: true
                        },
                        {
                            name: 'type',
                            data: 'type',
                            className: "text-left" ,
                            orderable: true
                        },
                        {
                            name: 'from',
                            data: 'from',
                            className: "text-left" ,
                            orderable: true
                        },
                        {
                            name: 'payment_method',
                            data: 'payment_method',  
                            orderable: true
                        },                        
                        {
                            name: 'note',
                            data: 'note',  
                            orderable: true
                        },                                               
                        {
                            name: 'paid',
                            data: 'paid',  
                            orderable: true
                        }
                    ]
                });
    }

    const loadReceivePaymentTable = (payment_date = '',) => {
        receivePaymentTable = $('#__ReceivePaymentTable').DataTable({
            "autoWidth": false, // might need this
                    processing: true,
                    serverSide: true,
                    bDestroy: true,
                    pageLength: 100,
                    pagingType: 'numbers',
                    columnDefs: [
                        {
                            'targets': 0,
                            'checkboxes': {
                                'selectRow': true
                            }
                        }
                    ],
                    select: {
                        style: 'multi'
                    },
                    bDeferRender: true,
                    ajax: {
                        type: 'GET',
                        url: '{{ route('data receive-payments') }}',
                        data: {
                            statusId: $('#__statusId').val(),
                            unitId: $('#__unitId').val(),
                        }
                    },
                    columns: [
                        {
                            name: 'checkbox',
                            data: 'id'
                        },
                        {
                            name: 'date',
                            data: 'date',
                            width: "110px" ,
                            className: "text-left" ,
                            orderable: true
                        },
                        {
                            name: 'type',
                            data: 'type',
                            className: "text-left" ,
                            orderable: true
                        },
                        {
                            name: 'from',
                            data: 'from',
                            className: "text-left" ,
                            orderable: true
                        },
                        {
                            name: 'payment_method',
                            data: 'payment_method',  
                            orderable: true
                        },                        
                        {
                            name: 'note',
                            data: 'note',  
                            orderable: true
                        },                                               
                        {
                            name: 'paid',
                            data: 'paid',  
                            orderable: true
                        }
                    ]
                });
    }


    const loadPurchaseOrderTable = (payment_date = '') => {

        purchaseTable = $('#__purchaseOrderTable').dataTable({
            dom: '<<"datatable_buttons"><rt>lip>',
            bDestroy: true,
            processing: true,
            serverSide: true,
            // ajax: url,
            "ajax": {
                "url": purchaseDatatableUrl,
                data: {
                    supplierId: $("#supplier_id").val(),
                    start_date: payment_date,
                    end_date: payment_date
                },
                "dataSrc": function(json) {
                    for (var i = 0, ien = json.data.length; i < ien; i++) {
                        json.data[i][0] = json.data[i][0];
                    }
                    console.log(json);
                    return json.data;
                }
            },
            columns: [{
                    name: 'date',
                    data: 'date'
                },

                {
                    name: 'supplier_name',
                    data: 'supplier_name'
                },


                {
                    name: 'details',
                    data: 'details'
                },

                {
                    name: 'status',
                    data: 'status'
                },
                {
                    name: 'total',
                    data: 'total'
                },
            ],
            pagingType: 'numbers',
            columnDefs: [{
                    targets: [4],
                    orderable: true,
                    className: 'text-right'
                },

            ],
            order: [
                [0, 'desc']
            ]
        });
    }



    const loadExpenseTable = (payment_date = '') => {
        expenseTable = $('#__ExpenseTable').DataTable({
            dom: '<<"datatable_buttons"><rt>lip>',
            bDestroy: true,
            processing: true,
            serverSide: true,
            ajax: {
                type: 'GET',
                url: expenseDatatableUrl,
                data: {
                    payment_date: payment_date
                }
            },
            columnDefs: [],
            order: [
                [1, 'desc']
            ],
            columns: [{
                    name: 'entry_date',
                    data: 'entry_date'
                },
                {
                    name: 'name',
                    data: 'name'
                },
                {
                    name: 'amount',
                    data: 'amount'
                }
            ]
        });
    }

    loadSummaryTable(payment_date);
    loadSalesTable(payment_date);
    loadReceivePaymentTable(payment_date);
    loadPaymentTable(payment_date);
    loadPurchaseOrderTable(payment_date);
    loadExpenseTable(payment_date);


    $('#payment-method-payment').select2({
        width: 'resolve'
    });

    $('#payment-method-receive').select2({
        width: 'resolve'
    });

    $("#payment_date").change(function() {
        $('#payment-method-payment').val(null).trigger('change');
        $('#payment-method-receive').val(null).trigger('change');
        payment_date = $("#payment_date").val();
        loadSummaryTable(payment_date);
        loadSalesTable(payment_date);
        loadReceivePaymentTable(payment_date);
        loadPaymentTable(payment_date);
        loadExpenseTable(payment_date);
        loadPurchaseOrderTable(payment_date);

    });

    $("#payment-method-payment").change(function() {
        payment_date = $("#payment_date").val();
        payment_method = $(this).val();
        loadPaymentTable(payment_date, payment_method);
    });

    $("#payment-method-receive").change(function() {
        payment_date = $("#payment_date").val();
        payment_method = $(this).val();
        loadReceivePaymentTable(payment_date, payment_method);
    });


    $("#searchbar-receive").keyup(function() {
        paymentTable.search(this.value).draw();
    });

    $("#searchbar-payment").keyup(function() {
        paymentTable.search(this.value).draw();
    });

    $("#searchbar-expense").keyup(function() {
        paymentTable.search(this.value).draw();
    });
    </script>
    @endpush

</x-app-layout>