<x-app-layout>
    @section('title')
        {{ __('translation.Customer Report') }}
    @endsection

    @push('top_css')
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/jquery-ui-dist@1.12.1/jquery-ui.min.css">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/jquery-datatables-checkboxes@1.2.12/css/dataTables.checkboxes.css">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.19/dist/sweetalert2.min.css">
        
        <link rel="stylesheet" href="{{ asset('css/custom_css.css') }}">
    @endpush

    @push('bottom_css')
        <link rel="stylesheet" href="{{ asset('css/datatable-custom-toolbar.css?_=' . rand()) }}">

        <style>
            .summary tr td {
                padding: 0.5rem !important;
                border: 1px solid #9d9696;
            }

            .grand_total td{
                background:#a3ffeb;
                border: 1px solid #9d9696;
            }

            .cash{
                background:#ffffb6 !important;
            }


        </style>
    @endpush


        <div class="col-span-12">

            <div class="md:flex md:justify-between md:items-center">
                <div>
                    <h1 class="text-xl text-gray-800 font-bold leading-tight">Stock Report</h1>
                </div>
            </div>

            <div class="col-span-12">
                <div class="mb-6">
                    <div class="w-full bg-white rounded-md shadow py-5 mb-6">
                        <div class="px-5">
                            <div class="flex flex-col sm:flex-row">
                                <div class="w-full sm:w-1/4 xl:ml-1 mb-1 sm:mb-0 relative -top-1">
                                    <x-select class="text-sm dropdown" name="product-id" id="productId">
                                        <option value="">- Select Product -</option>
                                        @if($products)
                                            @foreach ($products as $row )
                                                <option value="{{$row->id}}">{{$row->part_no}}</option>
                                            @endforeach
                                        @endif
                                    </x-select>
                                </div>
                                
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <div class="w-full mb-10">
                <div class="py-4 border-0 sm:border border-solid border-gray-300 rounded-md bg-white sm:bg-gray-50">
                    <div class="mb-5" id="summaryWrapper">
                    </div>
                </div>
            </div>

            <!-- <div class="row">
                <div class="col-lg-12">
                    <x-card.card-default>
                        <x-card.body>
                            <div class="flex flex-col sm:flex-row sm:justify-between items-start mt-10" id="datatable-receive">
                                <div class="w-full sm:mb-0">
                                    <h4 class="text-center">Sales Details</h4>
                                    <div class="flex flex-col sm:flex-row">
                                        <div class="w-full sm:w-1/4 xl:ml-1 mb-1 sm:mb-0 relative -top-1">
                                            <x-input type="text" id="searchbar-receive" placeholder="Search"></x-input>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="w-full overflow-x-auto mb-10">
                                <table class="w-full" id="__SalesTable">
                                    <thead>
                                    <tr class="bg-blue-500">
                                        <th class="px-4 py-2 text-white">Sale Date</th>
                                        <th class="px-4 py-2 text-white">Part Name</th>
                                        <th class="px-4 py-2 text-white">Part No</th>
                                        <th class="px-4 py-2 text-white">Quantity</th>
                                    </tr>
                                    </thead>
                                    <tbody></tbody>
                                </table>
                            </div>

                            <div class="flex flex-col sm:flex-row sm:justify-between items-start mt-10" id="">
                                <div class="w-full sm:mb-0">
                                    <h4 class="text-center">Purchase Details</h4>
                                    <div class="flex flex-col sm:flex-row">
                                        <div class="w-full sm:w-1/4 xl:ml-1 mb-1 sm:mb-0 relative -top-1">
                                            <x-input type="text" id="searchbar-payment" placeholder="Search"></x-input>
                                        </div>

                                        <div class="w-full sm:w-1/2 flex flex-col sm:flex-row">

                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="w-full overflow-x-auto">
                                <table class="w-full" id="__purchaseDataTable">
                                    <thead>
                                    <tr class="bg-blue-500">
                                        <th class="px-4 py-2 text-white">Date</th>
                                        <th class="px-4 py-2 text-white">Part No</th>
                                        <th class="px-4 py-2 text-white text-center">
                                            Quantity
                                        </th>
                                    </tr>
                                    </thead>
                                    <tbody></tbody>
                                </table>
                            </div>
                        </x-card.body>
                    </x-card.card-default>
                </div>
            </div> -->
        </div>


    @push('bottom_js')
        <script src="https://cdn.jsdelivr.net/npm/jquery-ui-dist@1.12.1/jquery-ui.min.js"></script>
        
        <script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
        <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
        <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
    <script>
       
            const salesDatatableUrl = '{{ route('sale-details-list') }}';
            const purchaseDatatableUrl = '{{ route('purchase-details-list') }}';

            var salesTable = '';
            var receivePaymentTable = '';
            var productId = '';
            var payment_date = '';

            
            const loadSalesTable = (productId='',start_date='',end_date='') => {
                salesTable = $('#__SalesTable').DataTable({
                    dom: '<<"datatable_buttons"><rt>lip>',
                    bDestroy: true,
                    processing: true,
                    serverSide: true,
                    pageLength : "25",
                    ajax: {
                        type: 'GET',
                        url: salesDatatableUrl,
                        data: {
                            start_date: start_date,
                            end_date: end_date,
                            productId: productId,
                        }
                    },
                    columnDefs : [
                    ],
                    order: [
                        [1, 'desc']
                    ],
                    columns: [
                        {
                            name: 'date',
                            data: 'date'
                        },
                        {
                            name: 'part_name',
                            data: 'part_name'
                        },

                        {
                            name: 'part_no',
                            data: 'part_no'
                        },


                        {
                            name: 'quantity',
                            data: 'quantity'
                        }
                    ]
                });
            }




            const loadReceivePaymentTable = (productId='',start_date='',end_date='') => {
                receivePaymentTable = $('#__purchaseDataTable').DataTable({
                    dom: '<<"datatable_buttons"><rt>lip>',
                    bDestroy: true,
                    processing: true,
                    serverSide: true,
                    pageLength : "25",
                    ajax: {
                        type: 'GET',
                        url: purchaseDatatableUrl,
                        data: {
                            start_date: start_date,
                            end_date: end_date,
                            productId: productId,
                        }
                    },
                    columnDefs : [
                    ],
                    order: [
                        [1, 'desc']
                    ],
                    columns: [
                        {
                            name: 'date',
                            data: 'date'
                        },
                        {
                            name: 'part_no',
                            data: 'part_no'
                        },
                        {
                            name: 'quantity',
                            data: 'quantity'
                        }
                    ]
                });
            }

            $('.date_rangepicker').daterangepicker({
                "showDropdowns": true,
                "linkedCalendars": false,
                opens: 'left',
                locale: {
                format: 'DD-MM-YYYY',
                "separator": " to ",
                }
            }, function(start, end, label) {
                $("#start_date").val(start.format('DD-MM-YYYY'));
                $("#end_date").val(end.format('DD-MM-YYYY'));
                loadSummaryTable(productId,start.format('DD-MM-YYYY'),end.format('DD-MM-YYYY'));
                loadSalesTable(productId,start.format('DD-MM-YYYY'),end.format('DD-MM-YYYY'));
                loadReceivePaymentTable(productId,start.format('DD-MM-YYYY'),end.format('DD-MM-YYYY'));
                
                console.log("A new date selection was made: " + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD'));
            });

            $('.date_rangepicker').on('cancel.daterangepicker', function(ev, picker) {
            //do something, like clearing an input
            $('.date_rangepicker').val('');
            $("#start_date").val('');
            $("#end_date").val('');
                start_date = '';
                end_date = '';

                loadSummaryTable(productId,start_date,end_date);
                loadSalesTable(productId,start_date,end_date);
                loadReceivePaymentTable(productId,start_date,end_date);
            });

            //set default value empty 
            $('.date_rangepicker').val('');


            $('#productId').select2({
                width: 'resolve'
            });

            $('#payment-method-receive').select2({
                width: 'resolve'
            });

            $("#productId").change(function() {
                $('#payment-method-receive').val(null).trigger('change');
                productId = $("#productId").val();
                start_date = $("#start_date").val();
                end_date = $("#end_date").val();


                loadSummaryTable(productId,start_date,end_date);
                loadSalesTable(productId,start_date,end_date);
                loadReceivePaymentTable(productId,start_date,end_date);
            });
           


            $("#payment_date").change(function() {
                $('#payment-method-receive').val(null).trigger('change');
                productId = $("#productId").val();               
                start_date = $("#start_date").val();
                end_date = $("#end_date").val();

                loadSummaryTable(productId,start_date,end_date);
                loadSalesTable(productId,start_date,end_date);
                loadReceivePaymentTable(productId,start_date,end_date);
            });


             $("#payment-method-receive").change(function() {
                productId = $("#productId").val();
                start_date = $("#start_date").val();
                end_date = $("#end_date").val();
                loadSalesTable(productId,start_date,end_date);
                loadReceivePaymentTable(productId,start_date,end_date);
            });




            $("#searchbar-receive").keyup(function() {
              //  paymentTable.search(this.value).draw();
            });





            const loadSummaryTable = (productId='',start_date='',end_date='') => {
                 $('#summaryWrapper').html('');
                $.ajax({
                    url: '{{ route('stock-summary') }}',
                    type: "POST",
                    data: {
                        productId: productId,
                        start_date: start_date,
                        end_date: end_date
                    },
                    success: function (result) {
                        $('#summaryWrapper').html(result);
                    }
                });
            }

            start_date = $("#start_date").val();
            end_date = $("#end_date").val();
            loadSummaryTable(productId,start_date,end_date);
            loadSalesTable(productId,start_date,end_date);
            loadReceivePaymentTable(productId,start_date,end_date);

        </script>
    @endpush

</x-app-layout>
