<x-app-layout>
    @section('title')
        {{ __('translation.Sales') }}
    @endsection

    @push('top_css')
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/jquery-ui-dist@1.12.1/jquery-ui.min.css">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/jquery-datatables-checkboxes@1.2.12/css/dataTables.checkboxes.css">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.19/dist/sweetalert2.min.css">
        
        <link rel="stylesheet" href="{{ asset('css/custom_css.css') }}">
    @endpush

    @push('bottom_css')
        <link rel="stylesheet" href="{{ asset('css/datatable-custom-toolbar.css?_=' . rand()) }}">

        <style>
            .sales tr td {
                padding: 0.5rem !important;
                border: 1px solid #9d9696;
            }

            .grand_total td{
                background:#a3ffeb;
                border: 1px solid #9d9696;
            }

            .cash{
                background:#ffffb6 !important;
            }


        </style>
    @endpush


        <div class="col-span-12">

            <div class="md:flex md:justify-between md:items-center">
                <div>
                    <h1 class="text-xl text-gray-800 font-bold leading-tight">Daily Sales Report</h1>
                </div>
            </div>

            <div class="col-span-12">
                <div class="mb-6">
                    <div class="w-full bg-white rounded-md shadow py-5 mb-6">
                        <div class="px-5">
                            <div class="flex flex-row overflow-x-auto">
                                <div class="lg:col-span-2">
                                    <x-label>
                                        {{ __('translation.Date') }} <x-form.required-mark/>
                                    </x-label>
                                    <x-input type="text" autocomplete=off name="order_date" id="order_date" class="datepicker-1" value="{{$order_date}}" required />
                                </div>

                                <div class="w-full lg:w-1/4 mb-6 lg:mb-0 lg:ml-2">
                                    <x-label>
                                        {{ __('translation.Select Customer Name') }} <x-form.required-mark/>
                                    </x-label>
                                    <x-select name="customer_id" id="customer_id" style="width: 100%">
                                        <option disabled selected value="0">
                                            - {{ __('translation.Select Customer Name') }} -
                                        </option>
                                        @foreach ($customers as $customer)
                                            <option value="{{ $customer->id }}">
                                                {{ $customer->customer_name }}
                                            </option>
                                        @endforeach
                                    </x-select>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-lg-12">
                    <x-card.card-default>
                        <x-card.body>
                            <div class="flex flex-col sm:flex-row sm:justify-between items-start mt-10" id="datatable-receive">
                                <div class="w-full sm:mb-0">
                                    <h4 class="text-center">Sales Details</h4>
                                    <div class="flex flex-col sm:flex-row">
                                        <div class="w-full sm:w-1/4 xl:ml-1 mb-1 sm:mb-0 relative -top-1">
                                            <x-input type="text" id="searchbar-sales" placeholder="Search"></x-input>
                                        </div>

                                        <div class="w-full sm:w-1/2 flex flex-col sm:flex-row">

                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="w-full overflow-x-auto mb-10">
                                <table class="w-full" id="__SalesTable">
                                    <thead>
                                    <tr class="bg-blue-500">
                                        <th class="px-4 py-2 text-white">Sales Date</th>
                                        <th class="px-4 py-2 text-white">Customer Name</th>
                                        <th class="px-4 py-2 text-white">Details</th>
                                        <th class="px-4 py-2 text-white text-center">
                                            Total
                                        </th>
                                    </tr>
                                    </thead>
                                    <tbody></tbody>
                                </table>
                            </div>
                       

                        </x-card.body>
                    </x-card.card-default>
                </div>
            </div>
        </div>


    @push('bottom_js')
        <script src="https://cdn.jsdelivr.net/npm/jquery-datatables-checkboxes@1.2.12/js/dataTables.checkboxes.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/jquery-ui-dist@1.12.1/jquery-ui.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.19/dist/sweetalert2.min.js"></script>
        
        

        <script>

            $(".datepicker-1").datepicker({
                dateFormat: 'dd-mm-yy'
            });

            const salesDatatableUrl = '{{ route('sales_list') }}';

            var salesTable = '';
            var order_date = '{{$order_date}}';
                
            const loadSalesTable = (order_date='',customerId = 0) => {
                salesTable = $('#__SalesTable').DataTable({
                    dom: '<<"datatable_buttons"><rt>lip>',
                    bDestroy: true,
                    processing: true,
                    serverSide: true,
                    ajax: {
                        type: 'GET',
                        url: salesDatatableUrl,
                        data: {
                            order_date: order_date,
                            customerId: customerId,
                        }
                    },
                    columnDefs : [
                    ],
                    order: [
                        [1, 'desc']
                    ],
                    columns: [
                        {
                            name: 'date',
                            data: 'date'
                        },

                        {
                            name: 'buyer_name',
                            data: 'buyer_name'
                        },


                        {
                            name: 'details',
                            data: 'details'
                        },
                        {
                            name: 'total',
                            data: 'total'
                        },
                    ]
                });
            }


            loadSalesTable(order_date);


         

            $("#order_date").change(function() {
                $('#customer_id').val(null).trigger('change');
                order_date = $("#order_date").val();
                loadSalesTable(order_date);
            });

             $("#customer_id").change(function() {
                order_date = $("#order_date").val();
                customer_id = $(this).val();
                loadSalesTable(order_date,customer_id);
            });


            $("#searchbar-sales").keyup(function() {
                salesTable.search(this.value).draw();
            });
            

        </script>
    @endpush

</x-app-layout>
