<x-app-layout>
    @section('title')
        {{ __('translation.Salary Report') }}
    @endsection

    @push('top_css')
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/jquery-ui-dist@1.12.1/jquery-ui.min.css">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/jquery-datatables-checkboxes@1.2.12/css/dataTables.checkboxes.css">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.19/dist/sweetalert2.min.css">
        
        <link rel="stylesheet" href="{{ asset('css/custom_css.css') }}">
    @endpush

    @push('bottom_css')
        <link rel="stylesheet" href="{{ asset('css/datatable-custom-toolbar.css?_=' . rand()) }}">

        <style>
            .summary tr td {
                padding: 0.3rem 0.7rem !important;
                border: 1px solid #8a8b8d;
                color: #555;
            }

            .grand_total td{
                background:#a3ffeb;
                border: 1px solid #8a8b8d;
            }

            .cash{
                background:#ffffb6 !important;
            }


        </style>
    @endpush


        <x-card title="Salary Report">

            <div class="col-span-12">
                <div class="mb-6">
                    <div class="w-full  rounded-md shadow py-5 mb-6">
                        <div class="px-5">
                            <div class="flex flex-col sm:flex-row space-x-2">
                                <div class="w-full sm:w-1/4 xl:ml-1 mb-1 sm:mb-0 relative -top-1">
                                    <x-select class="text-sm dropdown chosen-select " name="employee-id" id="employee_id">
                                        <option value="">- Select Employee -</option>
                                        @if($employees)
                                            @foreach ($employees as $row )
                                                <option value="{{$row->id}}">{{$row->employee_name}}</option>
                                            @endforeach
                                        @endif
                                    </x-select>
                                </div>
                                <div class="w-full sm:w-1/4 xl:ml-1 mb-1 sm:mb-0 relative -top-1">
                                    <x-input type="text" name="payment_date" id="payment_date" class="form-select date_rangepicker" placeholder="Select Date" />
                                    <x-input type="hidden" name="start_date" id="start_date" placeholder="Select Date" />
                                    <x-input type="hidden" name="end_date" id="end_date" placeholder="Select Date" />
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <div class="w-full mb-10">
                <div class="py-4 border-0 sm:border border-solid border-gray-300 rounded-md  sm:bg-gray-50">
                    <div class="mb-5" id="summaryWrapper">
                        <div class="w-full sm:col-span-1 lg:col-span-4 grid grid-cols-1 lg:grid-cols-1 gap-4 sm:gap-x-8 px-5 sm:mx-auto">
                            <div class="nav justify-content-center grid grid-cols-1">
                                <span class="mb-2">Salary Details</span>
                                <table class="summary">


                                <tr class="grand_total nav-item border border-solid border-gray-300 rounded-md bg-green-200">
                                    <td style="width:10%" class="text-right"><strong>Total Paid</strong></td>
                                    <td style="width:10%" class="text-right"><strong>@isset($payments->total) {{ number_format($payments->total,2) }} @endisset  </strong></td>
                                </tr>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-lg-12">
                    <x-card.card-default>
                        <x-card.body>

                            <div class="flex flex-col sm:flex-row sm:justify-between items-start mt-10" id="">
                                <div class="w-full sm:mb-0">
                                    <h4 class="text-center">Payment Details</h4>
                                    <div class="flex flex-col sm:flex-row">
                                        <div class="w-full sm:w-1/4 xl:ml-1 mb-1 sm:mb-0 relative -top-1">
                                            <x-input type="text" id="searchbar-payment" placeholder="Search"></x-input>
                                        </div>

                                        <div class="w-full sm:w-1/2 flex flex-col sm:flex-row">

                                        </div>

                                        <div class="w-full sm:w-1/4 relative -top-1 sm:justify-end" >
                                            <x-select class="text-sm dropdown" name="payment-method-payment" id="payment-method-payment">
                                                <option value="">- Select Payment Method -</option>
                                                @if($payment_methods)
                                                    @foreach ($payment_methods as $row )
                                                        <option value="{{$row->id}}">{{$row->name}}</option>
                                                    @endforeach
                                                @endif

                                            </x-select>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="w-full overflow-x-auto">
                                <table class="w-full" id="__PaymentTable">
                                    <thead>
                                    <tr class="bg-blue-500">
                                        <th class="px-4 py-2 text-white">Payment Date</th>
                                        <th class="px-4 py-2 text-white">Employee Name</th>
                                        <th class="px-4 py-2 text-white">Payment Method</th>
                                        <th class="px-4 py-2 text-white text-center">
                                            Total
                                        </th>
                                    </tr>
                                    </thead>
                                    <tbody></tbody>
                                </table>
                            </div>
                        </x-card.body>
                    </x-card.card-default>
                </div>
            </div>
        </x-card>


    @push('bottom_js')
        <script src="https://cdn.jsdelivr.net/npm/jquery-ui-dist@1.12.1/jquery-ui.min.js"></script>
        
        <script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
        <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
        <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />

        <script>

            const PaymentDatatableUrl = '{{ route('salaries_list') }}';

            var paymentTable = '';
            var employee_id = '';
            var payment_date = '';



            const loadPaymentTable = (employee_id='',start_date='',end_date='') => {
                paymentTable = $('#__PaymentTable').DataTable({
                    dom: '<<"datatable_buttons"><rt>lip>',
                    bDestroy: true,
                    processing: true,
                    serverSide: true,
                    ajax: {
                        type: 'GET',
                        url: PaymentDatatableUrl,
                        data: {
                            start_date: start_date,
                            end_date: end_date,
                            employee_id: employee_id,
                            type : "employee"
                        }
                    },
                    columnDefs : [
                    ],
                    order: [
                        [1, 'desc']
                    ],
                    columns: [
                        {
                            name: 'date',
                            data: 'date'
                        },
                        {
                            name: 'employee_name',
                            data: 'employee_name'
                        },
                        {
                            name: 'payment_method_id',
                            data: 'payment_method_id'
                        },
                        {
                            data: 'total',
                            name: 'total'
                        }
                    ]
                });
            }

            $('.date_rangepicker').daterangepicker({
                "showDropdowns": true,
                "linkedCalendars": false,
                opens: 'left',
                locale: {
                format: 'DD-MM-YYYY',
                "separator": " to ",
                }
            }, function(start, end, label) {
                $("#start_date").val(start.format('DD-MM-YYYY'));
                $("#end_date").val(end.format('DD-MM-YYYY'));
                loadSummaryTable(employee_id,start.format('DD-MM-YYYY'),end.format('DD-MM-YYYY'));
                loadPaymentTable(employee_id,start.format('DD-MM-YYYY'),end.format('DD-MM-YYYY'));
                
                console.log("A new date selection was made: " + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD'));
            });

            $('.date_rangepicker').on('cancel.daterangepicker', function(ev, picker) {
            //do something, like clearing an input
            $('.date_rangepicker').val('');
            $("#start_date").val('');
            $("#end_date").val('');
                start_date = '';
                end_date = '';

                loadSummaryTable(employee_id,start_date,end_date);
                loadPaymentTable(employee_id,start_date,end_date);
            });

            //set default value empty 
            $('.date_rangepicker').val('');

        


            $("#employee_id").change(function() {
                $('#payment-method-receive').val(null).trigger('change');
                employee_id = $("#employee_id").val();
                start_date = $("#start_date").val();
                end_date = $("#end_date").val();

                loadSummaryTable(employee_id,start_date,end_date);
                loadPaymentTable(employee_id,start_date,end_date);
            });

            $("#payment_date").change(function() {
                $('#payment-method-receive').val(null).trigger('change');
                employee_id = $("#employee_id").val();
                start_date = $("#start_date").val();
                end_date = $("#end_date").val();

                loadSummaryTable(employee_id,start_date,end_date);
                loadPaymentTable(employee_id,start_date,end_date);
            });


             $("#payment-method-receive").change(function() {
                employee_id = $("#employee_id").val();
                start_date = $("#start_date").val();
                end_date = $("#end_date").val();
                loadSummaryTable(employee_id,start_date,end_date);
                loadPaymentTable(employee_id,start_date,end_date);
            });




            $("#searchbar-receive").keyup(function() {
              //  paymentTable.search(this.value).draw();
            });





            const loadSummaryTable = (employee_id='',start_date='',end_date='') => {
                 $('#summaryWrapper').html('');
                $.ajax({
                    url: '{{ route('salary-summary') }}',
                    type: "POST",
                    data: {
                        type: 'salary',
                        employee_id: employee_id,
                        start_date: start_date,
                        end_date: end_date
                    },
                    success: function (result) {
                        $('#summaryWrapper').html(result);
                    }
                });
            }

            start_date = $("#start_date").val();
            end_date = $("#end_date").val();
            loadSummaryTable(employee_id,start_date,end_date);
            loadPaymentTable(employee_id,start_date,end_date);


        </script>
    @endpush

</x-app-layout>
