<x-app-layout>
    @section('title')
    {{ __('translation.Profit/Category Report') }}
    @endsection

    @push('top_css')
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/jquery-ui-dist@1.12.1/jquery-ui.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/jquery-datatables-checkboxes@1.2.12/css/dataTables.checkboxes.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.19/dist/sweetalert2.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/css/select2.min.css">
    <link rel="stylesheet" href="{{ asset('css/custom_css.css') }}">
    @endpush

    @push('bottom_css')
    <link rel="stylesheet" href="{{ asset('css/datatable-custom-toolbar.css?_=' . rand()) }}">

    <style>
    .summary tr td {
        padding: 0.5rem !important;
        border: 1px solid #9d9696;
        color: #333;
    }

    .grand_total td {
        background: #a3ffeb;
        border: 1px solid #9d9696;
    }

    .cash {
        background: #ffffb6 !important;
    }
    </style>
    @endpush
    <x-card class="mt-0">

        <div class="col-span-12">

            <div class="md:flex md:justify-between md:items-center">
                <div class="w-full sm:col-span-1 lg:col-span-4 grid grid-cols-1 lg:grid-cols-1 gap-4 sm:gap-x-8 px-5 sm:mx-auto">
                    <h1 class="text-xl text-gray-800 font-bold leading-tight">Profit</h1>
                </div>
            </div>


            <div class="col-span-12">
            <div class="mb-6">
                <div class="w-full bg-custom rounded-md shadow py-5 mb-6">
                    <div class="px-5">
                        <div class="flex flex-row ">
                            <div class="lg:col-span-2 mr-2">
                                <x-label>
                                    {{ __('translation.Payment Date') }}
                                    <x-form.required-mark />
                                </x-label>
                                <x-input type="text" name="payment_date" id="payment_date" class="date_rangepicker" placeholder="Select Date" />
                                <x-input type="hidden" name="start_date" id="start_date" placeholder="Select Date" />
                                <x-input type="hidden" name="end_date" id="end_date" placeholder="Select Date" />
                            </div>

                            <!-- <div id="category_wrapper" class="lg:col-span-2">
                                <x-label>
                                    {{ __('translation.Category') }}
                                    <x-form.required-mark />
                                </x-label>
                                <select class='w-full h-9 px-3 py-2 rounded-0 shadow-sm outline-none focus:outline-none border border-solid border-indigo-300 focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50 mt-1' name="category_id" id="category_id">
                                    @if($categories)
                                        <option value=''>All</option>
                                        @foreach($categories as $item)
                                            <option value='{{$item->id}}'>{{$item->cat_name}}</option>
                                        @endforeach
                                    @endif
                                </select>
                            </div> -->
                        </div>
                    </div>
                </div>
            </div>
        </div>





            <div id="summaryWrapper"
                class="w-full sm:col-span-1 lg:col-span-4 grid grid-cols-1 lg:grid-cols-1 gap-4 sm:gap-x-8 px-5 sm:mx-auto">
                <div class="flex flex-row items-center justify-between mb-2">
                    <h2 class="block whitespace-nowrap text-green-500 text-base font-bold">
                        Profit Per Category
                    </h2>
                    <hr class="w-full ml-3 relative -top-1 border border-r-0 border-b-0 border-l-0 border-yellow-300">
                </div>

                <table class="summary">
                    <thead>
                        <tr class="nav-item border border-solid border-gray-300 rounded-md">
                            <td style="width:25%;background-color: #173956;color: #fff;" class="text-center"><strong>Category</strong></td>
                            <td style="width:25%;background-color: #173956;color: #fff;" class="text-center"><strong>Sale's Price</strong></td>
                            <td style="width:25%;background-color: #173956;color: #fff;" class="text-center"><strong>Cost Price</strong></td>
                            <td style="width:25%;background-color: #173956;color: #fff;" class="text-center"><strong>Profit</strong></td>                  
                        </tr>
                    </thead>
                    <tbody>
                    @if($saleDetails)
                        @php 
                        $total_cost_price=0;
                        $total_sales_price=0;
                        $total_profit=0;
                        @endphp
                        @foreach($saleDetails as $row)
                        <tr class="nav-item border border-solid border-gray-300 rounded-md">
                            <td style="background-color: #b7b9a1;" class="text-center"><strong>{{$row->cat_name}}</strong></td>
                            <td style="background-color: #b7b9a1;" class="text-center"><strong>{{number_format($row->totalPrice,2)}}</strong></td>
                            <td style="background: #bf9176;" class="text-center"><strong>{{number_format($row->totalCostPrice,2)}}</strong></td>
                            <td style="background: #68adb1;" class="text-center"><strong>{{number_format(($row->totalPrice-$row->totalCostPrice),2)}}</strong></td>
                        </tr>
                        @php 
                        $total_cost_price += $row->totalCostPrice;
                        $total_sales_price += $row->totalPrice;
                        $total_profit += $row->totalPrice-$row->totalCostPrice;
                        @endphp
                        @endforeach
                    @endif

                        <tr class="nav-item border border-solid border-gray-300 rounded-md">
                            <td style="background-color: #8c9345;" colspan=3> <strong>Category Profit Total</strong></td>
                            <td style="background: #8c9345;" class="text-center"><strong>{{number_format($total_profit,2)}}</strong></td>
                        </tr>

                        <tr class="nav-item border border-solid border-gray-300 rounded-md">
                            <td style="background-color: #8c9345;" colspan=3> <strong>Services Total</strong></td>
                            <td style="background: #8c9345;" class="text-center"><strong>{{number_format($sales->servicesTotal,2)}}</strong></td>
                        </tr>

                        <tr class="nav-item border border-solid border-gray-300 rounded-md">
                            <td style="background: #020426;color: #a39696;" colspan=3> <strong>Total Profit</strong></td>
                            <td style="background: #020426;color: #a39696;" class="text-center"><strong>{{number_format($total_profit+$sales->servicesTotal,2)}}</strong></td>
                        </tr>

                    </tbody>
                </table>
                
            </div>
        </div>
    </x-card>


    @push('bottom_js')
    <script src="https://cdn.jsdelivr.net/npm/jquery-ui-dist@1.12.1/jquery-ui.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/js/select2.min.js"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />

    <script>
    

    var paymentTable = '';
    var receivePaymentTable = '';
    var purchaseTable = '';
    var expensentTable = '';
    start_date = $("#start_date").val();
    end_date = $("#end_date").val();
    const profitLossSummaryTable = () => {
        $('#summaryWrapper').html('');
        $.ajax({
            url: '{{ route('ajax-profit-category-summary') }}',
            type: "POST",
            data: {
                start_date: $("#start_date").val(),
                end_date: $("#end_date").val(),
                category_id : $("#category_id").val()
            },
            success: function(result) {
                $('#summaryWrapper').html(result);
            }
        });
    }

    $('.date_rangepicker').daterangepicker({
                "showDropdowns": true,
                "linkedCalendars": false,
                opens: 'right',
                locale: {
                format: 'DD-MM-YYYY',
                "separator": " to ",
                }
            }, function(start, end, label) {
                $("#start_date").val(start.format('DD-MM-YYYY'));
                $("#end_date").val(end.format('DD-MM-YYYY'));

                profitLossSummaryTable();
                console.log("A new date selection was made: " + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD'));
            });

            $('.date_rangepicker').on('cancel.daterangepicker', function(ev, picker) {
            //do something, like clearing an input
            $('.date_rangepicker').val('');
            $("#start_date").val('');
            $("#end_date").val('');
                start_date = '';
                end_date = '';
                profitLossSummaryTable();
            });

            //set default value empty 
            $('.date_rangepicker').val('');


            $("#category_id").change(function() {
                profitLossSummaryTable();

            });
    </script>
    @endpush

</x-app-layout>