<x-app-layout>
    @section('title')
        {{ __('translation.Partner Report') }}
    @endsection

    @push('top_css')
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/jquery-ui-dist@1.12.1/jquery-ui.min.css">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/jquery-datatables-checkboxes@1.2.12/css/dataTables.checkboxes.css">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.19/dist/sweetalert2.min.css">
        
        <link rel="stylesheet" href="{{ asset('css/custom_css.css') }}">
    @endpush

    @push('bottom_css')
        <link rel="stylesheet" href="{{ asset('css/datatable-custom-toolbar.css?_=' . rand()) }}">

        <style>
            .summary tr td {
                padding: 0.3rem 0.7rem !important;
                border: 1px solid #8a8b8d;
                color: #555;
            }

            .grand_total td{
                background:#a3ffeb;
                border: 1px solid #8a8b8d;
            }

            .cash{
                background:#ffffb6 !important;
            }


        </style>
    @endpush

    <x-card title="Partner Report">
        <div class="col-span-12">
            <div class="w-full rounded-md shadow py-5 mb-6">
                <div class="px-5">
                    <div class="flex flex-col sm:flex-row space-x-2">
                        <div class="w-full sm:w-1/4 xl:ml-1 mb-1 sm:mb-0 relative -top-1">
                            <x-select class="text-sm form-select chosen-select" name="partner-id" id="partner_id">
                                <option value="">- Select Partner -</option>
                                @if($partners)
                                    @foreach ($partners as $row )
                                        <option value="{{$row->id}}">{{$row->name}}</option>
                                    @endforeach
                                @endif
                            </x-select>
                        </div>
                        <div class="w-full sm:w-1/4 xl:ml-1 mb-1 sm:mb-0 relative -top-1">
                            <x-input type="text" name="payment_date" id="payment_date" class="date_rangepicker form-input" placeholder="Select Date" />
                            <x-input type="hidden" name="start_date" id="start_date" placeholder="Select Date" />
                            <x-input type="hidden" name="end_date" id="end_date" placeholder="Select Date" />
                        </div>
                    </div>
                </div>
            </div>
            


            <div class="w-full mb-10">
                <div class="py-4 border-0 sm:border border-solid border-gray-300 rounded-md sm:bg-gray-50">
                    <div class="mb-5" id="summaryWrapper">
                    </div>
                </div>
            </div>

            

            <div class="row">
                <div class="col-lg-12">
                    <x-card.card-default>
                        <x-card.body>
                            <div class="flex flex-col sm:flex-row sm:justify-between items-start mt-10" id="datatable-receive">
                                <div class="w-full sm:mb-0">
                                    <h4 class="text-center">Receive Details</h4>
                                </div>
                            </div>

                            <div class="w-full overflow-x-auto">
                                <table class="w-full" id="__ReceivePaymentTable">
                                    <thead>
                                    <tr class="rounded-lg text-sm font-medium text-gray-700 text-left">
                                        <th></th>
                                        <th class="px-4 py-2 text-center">
                                            {{ __('translation.Date') }}
                                        </th>
                                        <th class="px-4 py-2 text-center">
                                            {{ __('translation.Type') }}
                                        </th>

                                        <th class="px-4 py-2 text-center">
                                            {{ __('translation.Pay To') }}
                                        </th>
                                        
                                        <th class="px-4 py-2 text-center">
                                            {{ __('translation.Payment Method') }}
                                        </th>

                                        <th class="px-4 py-2 text-center">
                                            {{ __('translation.Note') }}
                                        </th>

                                        <th class="px-4 py-2 text-center">
                                            {{ __('translation.Total') }}
                                        </th>
                                    </tr>
                                    </thead>
                                    <tbody></tbody>
                                </table>
                            </div>

                          

                            
                            
                            <div class="flex flex-col sm:flex-row sm:justify-between items-start mt-10" id="">
                                <div class="w-full sm:mb-0">
                                    <h4 class="text-center">Payment Details</h4>
                                </div>
                            </div>

                            <div class="w-full overflow-x-auto">
                                <table class="w-full" id="__PaymentTable">
                                    <thead>
                                    <tr class="rounded-lg text-sm font-medium text-gray-700 text-left">
                                        <th></th>
                                        <th class="px-4 py-2 text-center">
                                            {{ __('translation.Date') }}
                                        </th>
                                        <th class="px-4 py-2 text-center">
                                            {{ __('translation.Type') }}
                                        </th>

                                        <th class="px-4 py-2 text-center">
                                            {{ __('translation.Pay To') }}
                                        </th>
                                        
                                        <th class="px-4 py-2 text-center">
                                            {{ __('translation.Payment Method') }}
                                        </th>

                                        <th class="px-4 py-2 text-center">
                                            {{ __('translation.Note') }}
                                        </th>

                                        <th class="px-4 py-2 text-center">
                                            {{ __('translation.Total') }}
                                        </th>
                                    </tr>
                                    </thead>
                                    <tbody></tbody>
                                </table>
                            </div>
                        </x-card.body>
                    </x-card.card-default>
                </div>
            </div>
        </div>
    </x-card>

    @push('bottom_js')
        <script src="https://cdn.jsdelivr.net/npm/jquery-ui-dist@1.12.1/jquery-ui.min.js"></script>
        
        <script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
        <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
        <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />

        <script>

            


            var purchasesTable = '';
            var paymentTable = '';
            var partner_id = '';
            var start_date = '';
            var end_date = '';

  
            const receivePaymentDatatableUrl = '{{ route('data receive-payments') }}';
            const PaymentDatatableUrl = '{{ route('data payments') }}';
            var paymentTable = '';

            var purchasesTable = '';
            var paymentTable = '';
            var partner_id = '';
            var start_date = '';
            var end_date = '';

            const loadSummaryTable = (partner_id='',start_date='',end_date='') => {
                 $('#summaryWrapper').html('');
                $.ajax({
                    url: '{{ route('partner-summary') }}',
                    type: "POST",
                    data: {
                        partner_id: partner_id,
                        start_date: start_date,
                        end_date: end_date
                    },
                    success: function (result) {
                        $('#summaryWrapper').html(result);
                    }
                });
            }


   
            const loadReceivePaymentTable = (partner_id='',start_date='',end_date='') => {
                paymentTable = $('#__ReceivePaymentTable').DataTable({
                    "autoWidth": false, // might need this
                    processing: true,
                    serverSide: true,
                    bDestroy: true,
                    pageLength: 100,
                    pagingType: 'numbers',
                    columnDefs: [
                        {
                            'targets': 0,
                            'checkboxes': {
                                'selectRow': true
                            }
                        }
                    ],
                    select: {
                        style: 'multi'
                    },
                    bDeferRender: true,
                    ajax: {
                        type: 'GET',
                        url: receivePaymentDatatableUrl                   ,
                        data: {
                            type: 'partner',
                            partner_id: partner_id,
                            start_date: start_date,
                            end_date: end_date
                        }
                    },
                    columns: [
                        {
                            name: 'checkbox',
                            data: 'id'
                        },
                        {
                            name: 'date',
                            data: 'date',
                            width: "110px" ,
                            className: "text-left" ,
                            orderable: true
                        },
                        {
                            name: 'type',
                            data: 'type',
                            className: "text-left" ,
                            orderable: true
                        },
                        {
                            name: 'from',
                            data: 'from',
                            className: "text-left" ,
                            orderable: true
                        },
                        {
                            name: 'payment_method',
                            data: 'payment_method',  
                            orderable: true
                        },                        
                        {
                            name: 'note',
                            data: 'note',  
                            orderable: true
                        },                                               
                        {
                            name: 'paid',
                            data: 'paid',  
                            orderable: true
                        },
                    ]
                });
            }


           

            const loadPaymentTable = (partner_id='',start_date='',end_date='') => {
                paymentTable = $('#__PaymentTable').DataTable({
                    "autoWidth": false, // might need this
                    processing: true,
                    serverSide: true,
                    bDestroy: true,
                    pageLength: 100,
                    pagingType: 'numbers',
                    columnDefs: [
                        {
                            'targets': 0,
                            'checkboxes': {
                                'selectRow': true
                            }
                        }
                    ],
                    select: {
                        style: 'multi'
                    },
                    bDeferRender: true,
                    ajax: {
                        type: 'GET',
                        url: PaymentDatatableUrl                   ,
                        data: {
                            type: 'partner',
                            partner_id: partner_id,
                            start_date: start_date,
                            end_date: end_date
                        }
                    },
                    columns: [
                        {
                            name: 'checkbox',
                            data: 'id'
                        },
                        {
                            name: 'date',
                            data: 'date',
                            width: "110px" ,
                            className: "text-left" ,
                            orderable: true
                        },
                        {
                            name: 'type',
                            data: 'type',
                            className: "text-left" ,
                            orderable: true
                        },
                        {
                            name: 'from',
                            data: 'from',
                            className: "text-left" ,
                            orderable: true
                        },
                        {
                            name: 'payment_method',
                            data: 'payment_method',  
                            orderable: true
                        },                        
                        {
                            name: 'note',
                            data: 'note',  
                            orderable: true
                        },                                               
                        {
                            name: 'paid',
                            data: 'paid',  
                            orderable: true
                        },
                    ]
                });
            }

       


            $('.date_rangepicker').daterangepicker({
                "showDropdowns": true,
                "linkedCalendars": false,
                opens: 'left',
                locale: {
                format: 'DD-MM-YYYY',
                "separator": " to ",
                }
            }, function(start, end, label) {
                $("#start_date").val(start.format('DD-MM-YYYY'));
                $("#end_date").val(end.format('DD-MM-YYYY'));
                loadSummaryTable(partner_id,start.format('DD-MM-YYYY'),end.format('DD-MM-YYYY'));
                loadReceivePaymentTable(partner_id,start.format('DD-MM-YYYY'),end.format('DD-MM-YYYY'));
                loadPaymentTable(partner_id,start.format('DD-MM-YYYY'),end.format('DD-MM-YYYY'));
                console.log("A new date selection was made: " + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD'));
            });

            $('.date_rangepicker').on('cancel.daterangepicker', function(ev, picker) {
            //do something, like clearing an input
            $('.date_rangepicker').val('');
            $("#start_date").val('');
            $("#end_date").val('');
                start_date = '';
                end_date = '';

                loadSummaryTable(partner_id,start_date,end_date);
                loadReceivePaymentTable(partner_id,start_date,end_date);
                loadPaymentTable(partner_id,start_date,end_date);
            });

            //set default value empty 
            $('.date_rangepicker').val('');



            $("#partner_id").change(function() {
                partner_id = $("#partner_id").val();
                start_date = $("#start_date").val();
                end_date = $("#end_date").val();

                loadSummaryTable(partner_id,start_date,end_date);
                loadReceivePaymentTable(partner_id,start_date,end_date);
                loadPaymentTable(partner_id,start_date,end_date);
            });

          

            $("#payment-method").change(function() {
                paymentTable.search(this.value).draw();
            });



            $("#searchbar-purchase").keyup(function() {
                purchasesTable.search(this.value).draw();
            });
            $("#searchbar-payment").keyup(function() {
                paymentTable.search(this.value).draw();
            });





            

            start_date = $("#start_date").val();
            end_date = $("#end_date").val();
            loadSummaryTable(partner_id,start_date,end_date);
            loadReceivePaymentTable(partner_id,start_date,end_date);
            loadPaymentTable(partner_id,start_date,end_date);

        </script>
    @endpush

</x-app-layout>
