<x-app-layout>
    @section('title')
    {{ __('translation.Profit/Loss Report') }}
    @endsection

    @push('top_css')
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/jquery-ui-dist@1.12.1/jquery-ui.min.css">
    <link rel="stylesheet"
        href="https://cdn.jsdelivr.net/npm/jquery-datatables-checkboxes@1.2.12/css/dataTables.checkboxes.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.19/dist/sweetalert2.min.css">
    
    <link rel="stylesheet" href="{{ asset('css/custom_css.css') }}">
    @endpush

    @push('bottom_css')
    <link rel="stylesheet" href="{{ asset('css/datatable-custom-toolbar.css?_=' . rand()) }}">

    <style>
    .summary tr td {
        padding: 0.5rem !important;
        border: 1px solid #9d9696;
    }

    .grand_total td {
        background: #a3ffeb;
        border: 1px solid #9d9696;
    }

    .cash {
        background: #ffffb6 !important;
    }
    </style>
    @endpush
    <x-card class="mt-0">

        <div class="col-span-12">

            <div class="md:flex md:justify-between md:items-center">
                <div class="w-full sm:col-span-1 lg:col-span-4 grid grid-cols-1 lg:grid-cols-1 gap-4 sm:gap-x-8 px-5 sm:mx-auto">
                    <h1 class="text-xl text-gray-800 font-bold leading-tight">Initial Transaction</h1>
                </div>
            </div>




            @php
            $arrSumReceivable = array();
            $arrSumPayable = array();
            
            $arrTransaction = array();
            @endphp
            @if($initialTransaction)
            @foreach ($initialTransaction as $row)
            @php
            $arrTransaction[$row->transaction_type][$row->type]= $row->total;
            @endphp
            @endforeach

            @endif
          


            <div
                class="w-full sm:col-span-1 lg:col-span-4 grid grid-cols-1 lg:grid-cols-1 gap-4 sm:gap-x-8 px-5 sm:mx-auto">

                <div class="nav justify-content-center grid grid-cols-1">
                    <div class="flex flex-row items-center justify-between mb-2">
                        <h2 class="block whitespace-nowrap text-green-500 text-base font-bold">
                            Payment Receivable
                        </h2>
                        <hr
                            class="w-full ml-3 relative -top-1 border border-r-0 border-b-0 border-l-0 border-yellow-300">
                    </div>
                    <table class="summary">
                        <tr class="nav-item border border-solid border-gray-300 rounded-md bg-green-200">
                            <td style="width:25%"><strong>Type</strong></td>
                            <td style="width:10%" class="text-right"><strong>Total</strong></td>
                        </tr>
                        @if(isset($arrTransaction['receivable']))
                        @foreach ($arrTransaction['receivable'] as $type=>$total)
                        @php
                        $arrSumReceivable[]=$total;
                        @endphp
                        

                        <tr class="nav-item border border-solid border-gray-300 rounded-md bg-green-200">
                            <td>{{ $type}}</td>
                            <td class="text-right">{{number_format($total,2)}}</td>
                        </tr>

                        @endforeach
                        @endif

                        <tr class="nav-item border border-solid border-gray-300 rounded-md bg-green-200">
                            <td><strong>Total</strong></td>
                            <td class="text-right">
                                <strong>{{number_format(array_sum($arrSumReceivable),2)}}</strong>
                            </td>
                        </tr>
                    </table>
                </div>

                <div class="nav justify-content-center grid grid-cols-1">
                    <div class="flex flex-row items-center justify-between mb-2">
                        <h2 class="block whitespace-nowrap text-green-500 text-base font-bold">
                            Payment Payable
                        </h2>
                        <hr
                            class="w-full ml-3 relative -top-1 border border-r-0 border-b-0 border-l-0 border-yellow-300">
                    </div>
                    <table class="summary">
                        <tr class="nav-item border border-solid border-gray-300 rounded-md bg-red-200">
                            <td style="width:25%"><strong>Type</strong></td>
                            <td style="width:10%" class="text-right"><strong>Total</strong></td>
                        </tr>
                        @if(isset($arrTransaction['payable']))
                        @foreach ($arrTransaction['payable'] as $type=>$total)
                        @php
                        $arrSumPayable[]=$total;
                        @endphp
                        

                        <tr class="nav-item border border-solid border-gray-300 rounded-md bg-red-200">
                            <td>{{ $type}}</td>
                            <td class="text-right">{{number_format($total,2)}}</td>
                        </tr>

                        @endforeach
                        @endif

                        <tr class="nav-item border border-solid border-gray-300 rounded-md bg-red-200">
                            <td><strong>Total</strong></td>
                            <td class="text-right">
                                <strong>{{number_format(array_sum($arrSumPayable),2)}}</strong>
                            </td>
                        </tr>
                    </table>
                </div>

            </div>
        </div>
    </x-card>


    @push('bottom_js')
    <script src="https://cdn.jsdelivr.net/npm/jquery-ui-dist@1.12.1/jquery-ui.min.js"></script>
    
    <script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js">
    </script>
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
    @endpush

</x-app-layout>