<x-app-layout>
    @section('title')
        {{ __('translation.Coupon Report') }}
    @endsection

    @push('top_css')
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/jquery-ui-dist@1.12.1/jquery-ui.min.css">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/jquery-datatables-checkboxes@1.2.12/css/dataTables.checkboxes.css">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.19/dist/sweetalert2.min.css">
        
        <link rel="stylesheet" href="{{ asset('css/custom_css.css') }}">
    @endpush

    @push('bottom_css')
        <link rel="stylesheet" href="{{ asset('css/datatable-custom-toolbar.css?_=' . rand()) }}">

        <style>
            .summary tr td {
                padding: 0.5rem !important;
                border: 1px solid #9d9696;
            }

            .grand_total td{
                background:#a3ffeb;
                border: 1px solid #9d9696;
            }

            .cash{
                background:#ffffb6 !important;
            }


        </style>
    @endpush


        <div class="col-span-12">

            <div class="md:flex md:justify-between md:items-center">
                <div>
                    <h1 class="text-xl text-gray-800 font-bold leading-tight">Coupon Report</h1>
                </div>
            </div>

            <div class="col-span-12">
                <div class="mb-6">
                    <div class="w-full bg-white rounded-md shadow py-5 mb-6">
                        <div class="px-5">
                            <div class="flex flex-col sm:flex-row">
                                <div class="w-full sm:w-1/4 xl:ml-1 mb-1 sm:mb-0 relative -top-1">
                                    <x-input type="text" name="payment_date" id="payment_date" class="date_rangepicker" placeholder="Select Date" />
                                    <x-input type="hidden" name="start_date" id="start_date" placeholder="Select Date" />
                                    <x-input type="hidden" name="end_date" id="end_date" placeholder="Select Date" />
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <div class="w-full mb-10">
                <div class="py-4 border-0 sm:border border-solid border-gray-300 rounded-md bg-white sm:bg-gray-50">
                    <div class="mb-5" id="summaryWrapper">
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-lg-12">
                    <x-card.card-default>
                        <x-card.body>
                            <div class="flex flex-col sm:flex-row sm:justify-between items-start mt-10" id="datatable-receive">
                                <div class="w-full sm:mb-0">
                                    <h4 class="text-center">Service/Coupon</h4>
                                    <div class="flex flex-col sm:flex-row">
                                        <div class="w-full sm:w-1/4 xl:ml-1 mb-1 sm:mb-0 relative -top-1">
                                            <x-input type="text" id="searchbar-receive" placeholder="Search"></x-input>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="w-full overflow-x-auto mb-10">
                                <table class="w-full" id="__SalesTable">
                                    <thead>
                                    <tr class="bg-blue-500">
                                        <th class="px-4 py-2 text-white">Date</th>
                                        <th class="px-4 py-2 text-white">Total</th>
                                    </tr>
                                    </thead>
                                    <tbody></tbody>
                                </table>
                            </div>

                            <div class="flex flex-col sm:flex-row sm:justify-between items-start mt-10" id="">
                                <div class="w-full sm:mb-0">
                                    <h4 class="text-center">Coupon Payments</h4>
                                </div>
                            </div>

                            <div class="w-full overflow-x-auto">
                                <table class="w-full" id="_couponPymentTable">
                                    <thead>
                                    <tr class="bg-blue-500">
                                        <th class="px-4 py-2 text-white">Payment Date</th>
                                        <th class="px-4 py-2 text-white">Total Coupon</th>
                                        <th class="px-4 py-2 text-white">Payment Method</th>
                                        <th class="px-4 py-2 text-white text-center">
                                            Total
                                        </th>
                                    </tr>
                                    </thead>
                                    <tbody></tbody>
                                </table>
                            </div>
                        </x-card.body>
                    </x-card.card-default>
                </div>
            </div>
        </div>


    @push('bottom_js')
        <script src="https://cdn.jsdelivr.net/npm/jquery-ui-dist@1.12.1/jquery-ui.min.js"></script>
        
        <script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
        <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
        <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
    <script>
       
            const couponDatatableUrl = '{{ route('coupon_table') }}';
            const receivePaymentDatatableUrl = '{{ route('receive_payments_coupon') }}';

            var couponTable = '';
            var receivePaymentTable = '';
            var customerId = '';
            var payment_date = '';

            
            const loadSalesTable = (customerId='',start_date='',end_date='') => {
                couponTable = $('#__SalesTable').DataTable({
                    dom: '<<"datatable_buttons"><rt>lip>',
                    bDestroy: true,
                    processing: true,
                    serverSide: true,
                    ajax: {
                        type: 'GET',
                        url: couponDatatableUrl,
                        data: {
                            start_date: start_date,
                            end_date: end_date,
                            customerId: customerId,
                        }
                    },
                    columnDefs : [
                    ],
                    order: [
                        [1, 'desc']
                    ],
                    columns: [
                        {
                            name: 'date',
                            data: 'date'
                        },
                        {
                            name: 'total_coupon',
                            data: 'total_coupon'
                        }
                    ]
                });
            }




            const loadReceivePaymentTable = (customerId='',start_date='',end_date='') => {
                receivePaymentTable = $('#_couponPymentTable').DataTable({
                    dom: '<<"datatable_buttons"><rt>lip>',
                    bDestroy: true,
                    processing: true,
                    serverSide: true,
                    ajax: {
                        type: 'GET',
                        url: receivePaymentDatatableUrl,
                        data: {
                            start_date: start_date,
                            end_date: end_date,
                            customerId: customerId,
                        }
                    },
                    columnDefs : [
                    ],
                    order: [
                        [1, 'desc']
                    ],
                    columns: [
                        {
                            name: 'date',
                            data: 'date'
                        },
                        {
                            name: 'total_coupon',
                            data: 'total_coupon'
                        },
                        {
                            name: 'payment_method',
                            data: 'payment_method'
                        },
                        {
                            data: 'paid',
                            name: 'paid'
                        }
                    ]
                });
            }

            $('.date_rangepicker').daterangepicker({
                "showDropdowns": true,
                "linkedCalendars": false,
                opens: 'left',
                locale: {
                format: 'DD-MM-YYYY',
                "separator": " to ",
                }
            }, function(start, end, label) {
                $("#start_date").val(start.format('DD-MM-YYYY'));
                $("#end_date").val(end.format('DD-MM-YYYY'));
                loadSummaryTable(customerId,start.format('DD-MM-YYYY'),end.format('DD-MM-YYYY'));
                loadSalesTable(customerId,start.format('DD-MM-YYYY'),end.format('DD-MM-YYYY'));
                loadReceivePaymentTable(customerId,start.format('DD-MM-YYYY'),end.format('DD-MM-YYYY'));
                
                console.log("A new date selection was made: " + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD'));
            });

            $('.date_rangepicker').on('cancel.daterangepicker', function(ev, picker) {
            //do something, like clearing an input
            $('.date_rangepicker').val('');
            $("#start_date").val('');
            $("#end_date").val('');
                start_date = '';
                end_date = '';

                loadSummaryTable(customerId,start_date,end_date);
                loadSalesTable(customerId,start_date,end_date);
                loadReceivePaymentTable(customerId,start_date,end_date);
            });

            //set default value empty 
            $('.date_rangepicker').val('');


            $('#customerId').select2({
                width: 'resolve'
            });

            $('#payment-method-receive').select2({
                width: 'resolve'
            });

            $("#customerId").change(function() {
                $('#payment-method-receive').val(null).trigger('change');
                customerId = $("#customerId").val();
                start_date = $("#start_date").val();
                end_date = $("#end_date").val();


                loadSummaryTable(customerId,start_date,end_date);
                loadSalesTable(customerId,start_date,end_date);
                loadReceivePaymentTable(customerId,start_date,end_date);
            });
           


            $("#payment_date").change(function() {
                $('#payment-method-receive').val(null).trigger('change');
                customerId = $("#customerId").val();               
                start_date = $("#start_date").val();
                end_date = $("#end_date").val();

                loadSummaryTable(customerId,start_date,end_date);
                loadSalesTable(customerId,start_date,end_date);
                loadReceivePaymentTable(customerId,start_date,end_date);
            });


             $("#payment-method-receive").change(function() {
                customerId = $("#customerId").val();
                start_date = $("#start_date").val();
                end_date = $("#end_date").val();
                loadSalesTable(customerId,start_date,end_date);
                loadReceivePaymentTable(customerId,start_date,end_date);
            });




            $("#searchbar-receive").keyup(function() {
              //  paymentTable.search(this.value).draw();
            });





            const loadSummaryTable = (customerId='',start_date='',end_date='') => {
                 $('#summaryWrapper').html('');
                $.ajax({
                    url: '{{ route('coupon-summary') }}',
                    type: "POST",
                    data: {
                        customerId: customerId,
                        start_date: start_date,
                        end_date: end_date
                    },
                    success: function (result) {
                        $('#summaryWrapper').html(result);
                    }
                });
            }

            start_date = $("#start_date").val();
            end_date = $("#end_date").val();
            loadSummaryTable(customerId,start_date,end_date);
            loadSalesTable(customerId,start_date,end_date);
            loadReceivePaymentTable(customerId,start_date,end_date);

        </script>
    @endpush

</x-app-layout>
