@php
$arrCashOut = array();
$arrCashIn = array();
@endphp
@if($cashIn)
@foreach ($cashIn as $row)
@php
$arrCashIn[$row->type][$row->payment_method->name]= $row->total;
@endphp
@endforeach

@endif

@if($cashOut)
@foreach ($cashOut as $row)
@php
$payment_method = $row->payment_method ? $row->payment_method->name : 'Cash';
$arrCashOut[$row->type][$payment_method]=$row->total;
@endphp
@endforeach
@endif


<div class="w-full sm:col-span-1 lg:col-span-4 grid grid-cols-1 lg:grid-cols-1 gap-4 sm:gap-x-8 px-5 sm:mx-auto">

    <div class="nav justify-content-center grid grid-cols-1">
        <div class="flex flex-row items-center justify-between mb-2">
            <h2 class="block whitespace-nowrap text-green-500 text-base font-bold">
                Cash In
            </h2>
            <hr class="w-full ml-3 relative -top-1 border border-r-0 border-b-0 border-l-0 border-yellow-300">
        </div>
        <table class="summary">
            <tr class="nav-item border border-solid border-gray-300 rounded-md bg-green-200">
                <td style="width:25%"><strong>Type</strong></td>
                <td style="width:10%" class="cash text-right"><strong>Cash</strong></td>
                <td style="width:10%" class="text-right"><strong>Banking</strong></td>
                <td style="width:10%" class="text-right"><strong>Mobile Banking</strong></td>
                <td style="width:10%" class="text-right"><strong>Total</strong></td>
            </tr>
            @php
            $arr_cash_in_total = array() ;
            $arr_banking_in_total = array() ;
            $arr_banking_in_total = array() ;
            $arr_mobile_banking_in_total = array() ;
            @endphp
            @if($arrCashIn)
            @foreach ($arrCashIn as $type=>$payment)

            <tr class="nav-item border border-solid border-gray-300 rounded-md bg-green-200">
                <td>
                @if($type=='') 
                    From Customer
                @else  
                    {{ ucwords(str_replace("_"," ",$type))}}
                @endif
            
            </td>
                <td class="cash text-right">
                    @isset($payment['Cash'])
                    {{ number_format($payment['Cash'],2)}}
                    @endisset
                </td>
                <td class="text-right">
                    @isset($payment['Banking'])
                    {{ number_format($payment['Banking'],2)}}
                    @endisset
                </td>
                <td class="text-right">
                    @isset($payment['Mobile Banking'])
                    {{ number_format($payment['Mobile Banking'],2)}}
                    @endisset
                </td>
                <td class="text-right">
                    @php
                    $total = 0 ;
                    if(isset($payment['Cash'])){
                    $total += $payment['Cash'];
                    }
                    if(isset($payment['Banking'])){
                    $total += $payment['Banking'];
                    }
                    if(isset($payment['Mobile Banking'])){
                    $total += $payment['Mobile Banking'];
                    }
                    @endphp
                    {{number_format($total,2)}}
                </td>
            </tr>

            @php
            if(isset($payment['Cash'])){
            $arr_cash_in_total[] = $payment['Cash'];
            }
            if(isset($payment['Banking'])){
            $arr_banking_in_total[] = $payment['Banking'];
            }
            if(isset($payment['Mobile Banking'])){
            $arr_mobile_banking_in_total[] = $payment['Mobile Banking'];
            }
            @endphp
            @endforeach
            @endif

            <tr class="grand_total nav-item border border-solid border-gray-300 rounded-md bg-green-200">
                <td><strong>Total</strong></td>
                <td class="cash text-right"><strong>{{ number_format(array_sum($arr_cash_in_total),2) }}</strong></td>
                <td class="text-right"><strong>{{number_format(array_sum($arr_banking_in_total),2) }}</strong></td>
                <td class="text-right"><strong>{{number_format(array_sum($arr_mobile_banking_in_total),2)}}</strong>
                </td>
                <td class="text-right">
                    <strong>{{number_format(array_sum($arr_cash_in_total)+array_sum($arr_banking_in_total)+array_sum($arr_mobile_banking_in_total),2)}}
                    </strong>
                </td>
            </tr>

        </table>
    </div>

    <div class="nav justify-content-center grid grid-cols-1">
        <div class="flex flex-row items-center justify-between mb-2">
            <h2 class="block whitespace-nowrap text-red-500 text-base font-bold">
                Cash Out
            </h2>
            <hr class="w-full ml-3 relative -top-1 border border-r-0 border-b-0 border-l-0 border-yellow-300">
        </div>
        <table class="summary">
            <tr class="nav-item border border-solid border-gray-300 rounded-md bg-red-200">
                <td style="width:25%"><strong>Type</strong></td>
                <td style="width:10%" class="cash text-right"><strong>Cash</strong></td>
                <td style="width:10%" class="text-right"><strong>Banking</strong></td>
                <td style="width:10%" class="text-right"><strong>Mobile Banking</strong></td>
                <td style="width:10%" class="text-right"><strong>Total</strong></td>
            </tr>
            @php
            $arr_cash_out_total = array() ;
            $arr_banking_out_total = array() ;
            $arr_mobile_banking_out_total = array() ;
            @endphp
            @if($arrCashOut)
            @foreach ($arrCashOut as $type=>$payment)
            <tr class="nav-item border border-solid border-gray-300 rounded-md bg-red-200">
                <td>{{ ucwords(str_replace("_"," ",$type))}}</td>
                <td class="cash text-right">
                    @isset($payment['Cash'])
                    {{ number_format($payment['Cash'],2)}}
                    @endisset
                </td>
                <td class="text-right">
                    @isset($payment['Banking'])
                    {{ number_format($payment['Banking'],2)}}
                    @endisset
                </td>
                <td class="text-right">
                    @isset($payment['Mobile Banking'])
                    {{ number_format($payment['Mobile Banking'],2)}}
                    @endisset
                </td>
                <td class="text-right">
                    @php
                    $total = 0 ;
                    if(isset($payment['Cash'])){
                    $total += $payment['Cash'];
                    }
                    if(isset($payment['Banking'])){
                    $total += $payment['Banking'];
                    }
                    if(isset($payment['Mobile Banking'])){
                    $total += $payment['Mobile Banking'];
                    }
                    @endphp
                    {{number_format($total,2)}}
                </td>
            </tr>

            @php
            if(isset($payment['Cash'])){
            $arr_cash_out_total[] = $payment['Cash'];
            }
            if(isset($payment['Banking'])){
            $arr_banking_out_total[] = $payment['Banking'];
            }
            if(isset($payment['Mobile Banking'])){
            $arr_mobile_banking_out_total[] = $payment['Mobile Banking'];
            }
            @endphp

            @endforeach
            @endif

            @if($expenses)
            @foreach ($expenses as $expense)
            <tr class="nav-item border border-solid border-gray-300 rounded-md bg-red-200">
                <td>Expense</td>
                <td class="cash text-right">
                    @isset($expense->total)
                    {{ $expense->total}}
                    @endisset
                </td>
                <td class="text-right">

                </td>
                <td class="text-right">

                </td>
                <td class="text-right">
                    @php
                    $total = 0 ;
                    if(isset($payment['Cash'])){
                    $total += $expense->total;
                    }
                    @endphp
                    {{$total}}
                </td>
            </tr>

            @php
            if(isset($expense->total)){
            $arr_cash_out_total[] = $expense->total;
            }
            @endphp

            @endforeach
            @endif
            <tr class="grand_total nav-item border border-solid border-gray-300 rounded-md bg-green-200">
                <td><strong>Total</strong></td>
                <td class="cash text-right">
                    <strong>{{array_sum($arr_cash_out_total) > 0 ? number_format(array_sum($arr_cash_out_total),2) : ''}}</strong>
                </td>
                <td class="text-right">
                    <strong>{{array_sum($arr_banking_out_total) > 0 ? number_format(array_sum($arr_banking_out_total),2) : ''}}</strong>
                </td>
                <td class="text-right">
                    <strong>{{array_sum($arr_mobile_banking_out_total) > 0 ? number_format(array_sum($arr_mobile_banking_out_total),2) : ''}}</strong>
                </td>
                <td class="text-right">
                    <strong>{{number_format(array_sum($arr_cash_out_total)+array_sum($arr_banking_out_total)+array_sum($arr_mobile_banking_out_total),2)}}
                    </strong></td>
            </tr>

            <tr class="nav-item border border-solid  rounded-md" style="background:#f3dd72 !important">
                <td colspan=1><strong>Cash In Hand</strong></td>
                <td class="text-right"><strong>{{
                            number_format((array_sum($arr_cash_in_total)) - 
                            (array_sum($arr_cash_out_total))
                            ,2)
                        }} </strong></td>
            </tr>
        </table>
    </div>

</div>