@csrf
<input type="hidden" name='id' value='{{$receive_payment->id}}'>
<input type="hidden" name='type' value='{{$receive_payment->type}}'>
<link rel="stylesheet" href="{{ asset('chosen/chosen.css')}}">
<div class="px-5 py-4">
    <div class="text-sm">
        <div id='msg-success' class="font-medium text-green-700  dark:text-green-700 mb-3">
        </div>
        <ul id="error-list" class="text-red-500 mb-3"></ul>
    </div>

    <div class="space-y-3">
        <div class="w-full grid gap-5 md:grid-cols-3">
            <div class="shadow-sm rounded-xl">
                <label class="block text-sm font-medium mb-1" for="payment_date">Payment Date</label>
                <input type="text" id="payment_date" class="form-input datepicker-1 w-full" name="payment_date"
                    placeholder="Enter Payment Date" value="{{$receive_payment->payment_date}}" autocomplete="off" />
            </div>

            @if(Auth::user()->role !=='staff')    
                <!-- <div>
                    <label class="block text-sm font-medium mb-1" for="shop_id">Shop <span class="text-red-500">*</span></label>
                    <select id="__unitId" name="shop_id" class="form-select chosen-select rounded w-full py-2">
                        <option value="">Select Unit</option>
                        @if($shops)
                            @foreach($shops as $row)
                            <option @if($receive_payment->shop_id==$row->id) selected @endif value='{{$row->id}}'>{{$row->name}} ({{$row->location}})</option>
                            @endforeach
                        @endif
                    </select>
                </div> -->
            @endif

            <!-- Select -->
            <div class="">
                <x-label>
                    {{ __('translation.Partners') }}
                </x-label>

                <select id="partner_id" class="form-select chosen-select w-full" name="partner_id">
                    <option disabled selected value="0">
                        - {{ __('translation.Partners') }} -
                    </option>
                    @if($partners)
                        @foreach($partners as $partner)
                            <option @if($receive_payment->partner_id==$partner->id) selected @endif  value="{{$partner->id}}">{{$partner->name}}</option>
                        @endforeach
                    @endif
                </select>
            </div>
            
            <!-- Select -->
            <div class="">
                <x-label>
                    {{ __('translation.Payment Method') }}
                </x-label>

                <select id="__payment_method" class="form-select chosen-select w-full" name="payment_method_id">
                    <option disabled selected value="0">
                        - {{ __('translation.Payment Method') }} -
                    </option>
                    @if($payment_methods)
                        @foreach($payment_methods as $pm)
                            <option @if($receive_payment->payment_method_id==$pm->id) selected @endif  value="{{$pm->id}}">{{$pm->name}}</option>
                        @endforeach
                    @endif
                </select>
            </div>
        </div>

        <div class="w-full grid gap-5 md:grid-cols-2">
                <div id="_bankOrMobileDetailsWrapper" class="w-full">
                    @if($receive_payment->bank_or_mobile_wallet_id)
                        <x-label>Bank/Mobile Account</x-label>
                        <select class='form-select chosen-select w-full px-2' id="bank_or_mobile_wallet_id" name="bank_or_mobile_wallet_id">
                            <option></option>

                            @if (isset($banks_or_mobiles))
                                @foreach ($banks_or_mobiles as $item)
                                    <option @if($receive_payment->bank_or_mobile_wallet_id==$item->id) selected @endif value="{{$item->id}}">{{$item->name}}</option>
                                @endforeach
                            @endif
                        </select>
                    @endif
                </div>

                <div id="_AccountNoWrapper" class="w-full">
                @if($receive_payment->bank_or_mobile_wallet_id)
                    <x-label>Account No</x-label>
                    <select id="account_no_id" name="account_no_id" class='form-select chosen-select w-full px-2'>
                        <option></option>

                        @if (isset($accounts))
                            @foreach ($accounts as $item)
                                <option value="{{$item->id}}" @if($receive_payment->account_no_id==$item->id) selected @endif>{{$item->account_no}}</option>
                            @endforeach
                        @endif
                    </select>
                @endif
            </div>
        </div>

        <div id="__ajaxFormLoad" class="mt-4 flex flex-wrap items-center space-y-3">
               
            </div>

            <!-- <div class="flex justify-left space-x-4 inline-flex items-center justify-center text-sm font-medium leading-5 rounded px-3 py-1 border border-gray-200 dark:border-gray-700/60 hover:border-gray-300 dark:hover:border-gray-600 shadow-sm bg-red-500/20 text-red-700 transition">
                <div>
                    <label class="block text-sm font-medium" for="unit_id">{{ __('translation.Total Due') }}</label>
                </div>
                <div class="font-bold text-black-500" id="__previousDue"> 0.00</div>
            </div> -->
       

            <div class="w-full">
                <x-label>
                    {{ __('translation.Paid') }}
                </x-label>
                <input type="text" class='w-full form-input' autocomplete="off" onclick="this.select()" name="fake-paid" id="fake-paid" value="{{App\Http\Controllers\SettingController::takaBDFormat($receive_payment->paid)}}">
                <input type="hidden" class='w-full form-input' name="paid" id="paid" value="{{$receive_payment->paid}}">
                <div class="mt-4"><strong>Taka In Word:</strong> <span id="takaInWord"></span></div>
            </div>
        </div>

        <div class='mt-2'>
            <label class="block text-sm font-medium mb-1" for="unit_id">Note</label>
            <textarea class="form-textarea w-full p-5" name="notes">{{$receive_payment->notes}}</textarea>
        </div>

    </div>
</div>
<!-- Modal footer -->
<div class="px-5 py-4 border-t border-gray-200 dark:border-gray-700/60">
    <div class="flex flex-wrap justify-end space-x-2">
        <button
            class="__closeModal btn-sm border-gray-200 dark:border-gray-700/60 hover:border-gray-300 dark:hover:border-gray-600 text-gray-800 dark:text-gray-300">Cancel</button>
        <button type="submit"
            class="btn-sm bg-gray-900 text-gray-100 hover:bg-gray-800 dark:bg-gray-100 dark:text-gray-800 dark:hover:bg-white">Save</button>
    </div>
</div>



<script>

$(".chosen-select").chosen({no_results_text: "Oops, nothing found!"}); 

$(".datepicker-1").datepicker({
    dateFormat: 'dd-mm-yy'
});



var loadDuePayment = (lender_id = '') => {
    // $.ajax({
    //     url: '{{ route('customer-due') }}',
    //     type: 'post',
    //     data: {
    //         'lender_id': lender_id,
    //         '_token': $('meta[name=csrf-token]').attr('content')
    //     }
    // }).done(function(result) {
    //     $('#__previousDue').html(result);
    // });
}

loadDuePayment($('#lender_id').val());

$('#lender_id').change(function() {
    loadDuePayment($(this).val());
});

$(document).on('keyup', '#fake-paid', function(event) {
    var input_val = $(this).val();
    input_val = numberToCurrency(input_val);
    $(this).val(input_val);
    var withoutComma = $(this).val().replace(/,/g, "");
    $('#paid').val(withoutComma);
    $('#takaInWord').moneyinwords(withoutComma, 'US', 'USD');
});

$('#__btnSubmitPayment').addClass('hidden');




$('#__payment_method').change(function() {
            if($(this).val()=='1'){
                $("#bank_or_mobile_wallet_id").val('');
                $("#_AccountNoWrapper").html('');
                $("#account_no_id").val('');
                
            }
            $.ajax({
                url: '{{ route('load-bank-or-mobile-dropdown') }}',
                type: 'post',
                data: {
                    'id': $(this).val(),
                    '_token': $('meta[name=csrf-token]').attr('content')
                }
            }).done(function(result) {
                $('#_bankOrMobileDetailsWrapper').html(result);       
            });

        });


$('#bank_or_mobile_wallet_id').on('change', function() {
    $.ajax({
        url: '{{ route('load-bank-or-mobile-account-dropdown') }}',
        type: 'post',
        data: {
            'bank_or_mobile_wallet_id': $(this).val(),
            '_token': $('meta[name=csrf-token]').attr('content')
        }
    }).done(function(result) {
        $('#_AccountNoWrapper').html(result);
    });
});
</script>