<x-app-layout>
    @section('title', 'Raw Materials')

    @push('top_css')
        <link type="text/css" href="https://cdn.jsdelivr.net/npm/jquery-datatables-checkboxes@1.2.12/css/dataTables.checkboxes.css" rel="stylesheet" />
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" />
        <link rel="stylesheet" href="{{ asset('css/typeaheadjs.css') }}">
    @endpush

    <style>
        .table thead th {
            vertical-align: bottom;
            border: 1px solid #2c3545;
            background: #0c1830;
            color: #e1d492;
        }

        .table td, .table th {
            padding: 0.15rem .75rem;
            vertical-align: top;
            border-top: 1px solid #dee2e6;
            font-size: 13px;
        }

        .table td p, .table th p {
            font-size: 12px;
            letter-spacing: 1.5px;
        }
        .font-bold{
            font-weight:600 !important;
        }

        .table td {
            vertical-align: middle;
            border: 1px solid #2c3545;
            position: relative;
        }

        .removeItem {
            padding: .15rem .5rem;
            font-size: 0.675rem;
        }

        td [type=text] {
            padding: 0 5px;
            height: 30px;
            font-weight: 100;
            width: 70px;
            font-size: 12px;
            letter-spacing: 2px;
        }

        #__product_id_QR_scanner {
            box-shadow: inset 0px 1px 6px 0px #000000 !important;
        }

      </style>
    <x-card title="Raw Materials ({{ number_format($totalUnit) }})">
        <div class="mt-6">

            <div class="flex flex-col sm:flex-row sm:justify-between items-start mb-4">
                <div class="w-full md:w-3/5 lg:w-3/5 mb-6 sm:mb-0">
                    <div class="flex flex-col sm:flex-row">
                        @if(Auth::user()->role != '') @endif
                        <div class="sm:mr-2">
                        <button type="button" id="BtnInsert" color="green" class="inline-flex items-center justify-center text-sm font-medium leading-5 rounded-full px-3 py-1 border border-gray-200 dark:border-gray-700/60 hover:border-gray-300 dark:hover:border-gray-600 shadow-sm bg-white dark:bg-gray-800 text-gray-500 dark:text-gray-400 transition">
                            <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v3m0 0v3m0-3h3m-3 0H9m12 0a9 9 0 11-18 0 9 9 0 0118 0z" />
                            </svg>
                            <span class="ml-2">Add Raw Material</span>
                        </button>
                        </div>
                        
                    </div>
                </div>
            </div>

        </div>

        <div class="w-full overflow-x-auto">
            <table class="w-full" id="datatable">
                <thead>
                <tr class="rounded-lg text-sm font-medium text-gray-700 text-left">
                    <th></th>
                    <th class="px-4 py-2 text-left">
                        {{ __('translation.Name') }}
                    </th>

                    <th class="px-4 py-2 text-center">
                        {{ __('translation.Unit') }}
                    </th>

                    <th class="px-4 py-2 text-center">
                        {{ __('translation.Status') }}
                    </th>
                    
                    <th class="px-4 py-2 text-center">
                        {{ __('translation.Actions') }}
                    </th>
                </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>
    </x-card>

    <div class="modalArea modal-insert modal-hide">    
        <div class="overflow-auto fixed  inset-0 z-10 flex items-center justify-center">
            <div class="bg-violet rounded-lg shadow-lg overflow-auto max-w-lg w-full max-h-full" x-transition:enter="ease-out duration-300" x-transition:enter-start="opacity-0 scale-90" x-transition:enter-end="opacity-100 scale-100">
            
            <!-- Modal header -->
            <div class="px-5 py-3 border-b border-gray-200 dark:border-gray-700/60">
                <div class="flex justify-between items-center">
                    <div class="font-semibold text-gray-800 dark:text-gray-100">Add Raw Material</div>
                    <button type='button' class="__closeModal text-gray-400 dark:text-gray-500 hover:text-gray-500 dark:hover:text-gray-400">
                        <div class="sr-only">Close</div>
                        <svg class="fill-current" width="16" height="16" viewBox="0 0 16 16">
                            <path d="M7.95 6.536l4.242-4.243a1 1 0 111.415 1.414L9.364 7.95l4.243 4.242a1 1 0 11-1.415 1.415L7.95 9.364l-4.243 4.243a1 1 0 01-1.414-1.415L6.536 7.95 2.293 3.707a1 1 0 011.414-1.414L7.95 6.536z" />
                        </svg>
                    </button>
                </div>
            </div>

            <form method="POST" id="form-insert-raw-material" enctype="multipart/form-data">

            </form>

            </div>
        </div>
    </div>
    <div class="modalArea modal-edit modal-hide">    
        <div class="overflow-auto fixed  inset-0 z-10 flex items-center justify-center">
            <div class="bg-violet rounded-lg shadow-lg overflow-auto max-w-lg w-full max-h-full" x-transition:enter="ease-out duration-300" x-transition:enter-start="opacity-0 scale-90" x-transition:enter-end="opacity-100 scale-100">
            
            <!-- Modal header -->
            <div class="px-5 py-3 border-b border-gray-200 dark:border-gray-700/60">
                <div class="flex justify-between items-center">
                    <div class="font-semibold text-gray-800 dark:text-gray-100">Edit</div>
                    <button type='button' class="__closeModal text-gray-400 dark:text-gray-500 hover:text-gray-500 dark:hover:text-gray-400">
                        <div class="sr-only">Close</div>
                        <svg class="fill-current" width="16" height="16" viewBox="0 0 16 16">
                            <path d="M7.95 6.536l4.242-4.243a1 1 0 111.415 1.414L9.364 7.95l4.243 4.242a1 1 0 11-1.415 1.415L7.95 9.364l-4.243 4.243a1 1 0 01-1.414-1.415L6.536 7.95 2.293 3.707a1 1 0 011.414-1.414L7.95 6.536z" />
                        </svg>
                    </button>
                </div>
            </div>

            <form method="POST" id="form-edit-raw-material" enctype="multipart/form-data">

            </form>

            </div>
            </div>
    </div>

     <!-- DELETE Modal -->        
    <div class="modalArea modal-deleteProduct modal-hide">    
        <div class="overflow-auto fixed  inset-0 z-10 flex items-center justify-center">
            <div class="bg-violet rounded-lg shadow-lg overflow-auto max-w-lg w-full max-h-full" x-transition:enter="ease-out duration-300" x-transition:enter-start="opacity-0 scale-90" x-transition:enter-end="opacity-100 scale-100">
            
            <!-- Modal header -->
            <div class="px-5 py-3 border-b border-gray-200 dark:border-gray-700/60">
                <div class="flex justify-between items-center">
                    <div class="font-semibold text-gray-800 dark:text-gray-100">Delete Raw Material</div>
                    <button class="__closeModal text-gray-400 dark:text-gray-500 hover:text-gray-500 dark:hover:text-gray-400">
                        <div class="sr-only">Close</div>
                        <svg class="fill-current" width="16" height="16" viewBox="0 0 16 16">
                            <path d="M7.95 6.536l4.242-4.243a1 1 0 111.415 1.414L9.364 7.95l4.243 4.242a1 1 0 11-1.415 1.415L7.95 9.364l-4.243 4.243a1 1 0 01-1.414-1.415L6.536 7.95 2.293 3.707a1 1 0 011.414-1.414L7.95 6.536z" />
                        </svg>
                    </button>
                </div>
            </div>

            <!-- DELETE Modal content -->
            <form id="form-delete-raw-material" method="POST"></form>

            </div>
        </div>
    </div>




@push('bottom_js')
        <script src="https://cdn.jsdelivr.net/npm/typeahead.js@0.11.1/dist/typeahead.bundle.min.js"></script>    
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.0/jquery.validate.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/jquery-datatables-checkboxes@1.2.12/js/dataTables.checkboxes.min.js"></script>
        
        <script src="{{ asset('js/lc_select.js') }}"></script>

        <script>
            
            const tableUrl = '{{ route('data raw-materials') }}';
            var shopTable = '';

            const loadProductTable = (statusId) => {
                shopTable = $('#datatable').DataTable({
                    processing: true,
                    serverSide: true,
                    bDestroy: true,
                    pageLength: 100,
                    pagingType: 'numbers',
                    columnDefs: [
                        {
                            'targets': 0,
                            'checkboxes': {
                                'selectRow': true
                            }
                        }
                    ],
                    select: {
                        style: 'multi'
                    },
                    bDeferRender: true,
                    ajax: {
                        type: 'GET',
                        url: tableUrl                   ,
                        data: {
                            statusId: statusId
                        }
                    },
                    columns: [
                        {
                            name: 'checkbox',
                            data: 'id'
                        },
                        {
                            name: 'name',
                            data: 'name',
                            orderable: true,
                            className:'text-left'
                        },
                        {
                            name: 'unit',
                            data: 'unit',  
                            orderable: true
                        },                       
                        {
                            name: 'status',
                            data: 'status',  
                            orderable: true
                        },
                        {
                            name: 'actions',
                            data: 'actions',
                            orderable: false
                        }
                    ]
                });
            }

            loadProductTable();



            $(document).on('click', '#BtnInsert', function(event) {
                event.preventDefault();
        
                $('.modal-insert').show();
                $.ajax({
                    url: '{{ route("form-insert-modal-raw-material") }}',
                    type: 'post',
                    data: {
                        'id': $(this).data('id'),
                        '_token': $('meta[name=csrf-token]').attr('content')
                    }
                }).done(function(result) {                    
                    $('#form-insert-raw-material').html(result);
                });         
            });

            $(document).on('submit', '#form-insert-raw-material', function(event) {
                event.preventDefault();

                var $msgSuccess = $('#form-insert-raw-material #msg-success');
                var $errorList = $('#form-insert-raw-material #error-list');

                // Clear existing errors (if any)
                $errorList.empty();

                var formData = new FormData($(this)[0]);
              
                $.ajax({
                    url: '{{ route('raw-material.insert') }}',
                    type: 'post',
                    data: formData,
                    contentType: false,
                    processData: false, // Add this line to prevent default processing of FormData
                    success: function(response) {
                        $("#msg-success").html(response.message);                            
                        $msgSuccess.show();
                        // Hide the modal after 3 seconds (1000 ms)
                        setTimeout(function() {
                            //$('#add-raw-material-modal').hide();
                            location.reload();
                        }, 1000);
                        
                    },
                    error: function(error) {
                        $errorList.show();
                        var errorData = error.responseJSON;
                        console.error('result:', errorData.errors);
                        // Display errors on the UI (you can customize how to show these)
                        for (const [key, message] of Object.entries(errorData.errors)) {
                            // Assuming you have a way to show these errors in your UI
                            $errorList.append('<li>' + message + '</li>');                                    
                        }
                    }

                })
            });

            $(document).on('click', '#BtnEdit', function(event) {
                event.preventDefault();
                $('.modal-edit').show();
                $.ajax({
                    url: '{{ route('data raw-materials') }}?id=' + $(this).data('id'),
                    type: 'get',
                    data: {
                        'id': $(this).data('id'),
                        '_token': $('meta[name=csrf-token]').attr('content')
                    }
                }).done(function(result) {                    
                    $('#form-edit-raw-material').html(result);
                });         
            });

$(document).on('submit', '#form-edit-raw-material', function(event) {
    event.preventDefault();

    var $msgSuccess = $('#form-edit-raw-material #msg-success');
    var $errorList = $('#form-edit-raw-material #error-list');

    // Clear existing errors (if any)
    $errorList.empty();

    var formData = new FormData($(this)[0]);
    console.log(formData);
    $.ajax({
        url: '{{ route('raw-material.update') }}',
        type: 'post',
        data: formData,
        contentType: false,
        processData: false, // Add this line to prevent default processing of FormData
        success: function(response) {
            $("#msg-success").html(response.message);                            
            $msgSuccess.show();
            // Hide the modal after 3 seconds (1000 ms)
            setTimeout(function() {
                //$('#add-raw-material-modal').hide();
                location.reload();
            }, 1000);
            
        },
        error: function(error) {
            $errorList.show();
            var errorData = error.responseJSON;
            console.error('result:', errorData.errors);
            // Display errors on the UI (you can customize how to show these)
            for (const [key, message] of Object.entries(errorData.errors)) {
                // Assuming you have a way to show these errors in your UI
                $errorList.append('<li>' + message + '</li>');                                    
            }
        }

    })
});


    $(document).on('click', '#BtnDelete', function(event) {
        event.preventDefault();
  
        $('.modal-deleteProduct').show();
        $.ajax({
            url: '{{ route('form-delete-modal-raw-material') }}',
            type: 'post',
            data: {
                'id': $(this).data('id'),
                '_token': $('meta[name=csrf-token]').attr('content')
            }
        }).done(function(result) {
            $('#form-delete-raw-material').html(result);
        });         
    });

    $(document).on('click', '.__closeModal', function(event) {
        event.preventDefault();
        //$('.modal-update').addClass('modal-hide');
        $('.modalArea').hide(); // Hide the modal
    });


$(document).on('submit', '#form-delete-raw-material', function(event) {
    event.preventDefault();
    var $message = $('#form-delete-raw-material #message');

    var formData = new FormData($(this)[0]);
    //console.log(formData);
    $.ajax({
        url: '{{ route('raw-material.delete') }}',
        type: 'post',
        data: formData,
        contentType: false,
        processData: false, // Add this line to prevent default processing of FormData
        success: function(response) {
            if(response.status==1){
                $("#message").html(response.message);                            
                $message.show();
                // Hide the modal after 3 seconds (1000 ms)
                setTimeout(function() {
                    //$('#add-raw-material-modal').hide();
                    location.reload();
                }, 1000);
            }else{
                $message.show();
                    // Assuming you have a way to show these errors in your UI
                $message.html(response.message);                                    
                
            }
            
            
        },
        error: function(error) {
            $errorList.show();
            var errorData = error.responseJSON;
            console.error('result:', errorData.errors);
            // Display errors on the UI (you can customize how to show these)
            for (const [key, message] of Object.entries(errorData.errors)) {
                // Assuming you have a way to show these errors in your UI
                $errorList.append('<li>' + message + '</li>');                                    
            }
        }

    })
});



        </script>


    @endpush
</x-app-layout>
