@csrf
<input type="hidden" name='id' value='{{$purchase->id}}'>
<div class="px-5 py-4">
    <div class="text-sm">
        <div id='msg-success' class="font-medium text-green-700  dark:text-green-700 mb-3">
        </div>
        <ul id="error-list" class="text-red-500 mb-3"></ul>
    </div>
<div class="px-0 py-4">
    <div class="flex flex-wrap justify-between items-end gap-y-2 gap-x-4">
        <div id="dashboard-card-08-legend" class="grow mb-1">
            <div class="text-gray-500 dark:text-gray-500 font-semibold text-left">{{$purchase->supplier->supplier_name}}</div>
            @if($purchase->supplier->phone)
                <div class="text-gray-500 dark:text-gray-500 font-semibold text-left">
                    <span class='text-xs italic text-gray-500 align-middle'>{{$purchase->supplier->phone}}</span>
                </div>
            @endif
            @if($purchase->supplier->address)
                <div class="text-gray-500 dark:text-gray-500 font-semibold text-left">
                <span class='text-xs italic text-gray-500 align-middle'>{{$purchase->supplier->address}}</span>
                </div>
            @endif
        </div>
        <div class="flex items-start">
            <div class="modal-purchase-total text-2xl font-bold text-gray-800 dark:text-gray-100 mr-2">৳{{App\Http\Controllers\SettingController::takaBDFormat($purchase->in_total)}} </div>           
        </div>
    </div>
</div>
<div class="space-y-3">
    <div class="invoice" id="invoice-container">
        <table id="table" class="table table-striped w-full">
            <thead>
            <tr>
                <th class="hide-elements" style="width: 20px;">#</th>
                <th class="text-left">Name</th>           
                <th style="width: 82px;">Quntity</th>                
                <th>Price</th> 
                <th style="width: 82px;">Total</th> 
            </tr>
            </thead>
            <tbody id="__productListWrapper">
                    @if($purchase->purchase_details)
                        @foreach($purchase->purchase_details as $item)
                            <tr>
                                <td class="index">
                                    {{ $loop->iteration }}
                                </td>
                                <td>
                                <p class="font-bold m-0"> 
                                    {{$item->raw_material['name']}} 
                                </p>
                                
                                </td>
                                <td class="text-center">
                                {{$item->quantity}} 
                                </td>

                                <td class="text-center">
                                {{App\Http\Controllers\SettingController::takaBDFormat($item->price)}} 
                                </td>

                                <td class="text-center">
                                {{App\Http\Controllers\SettingController::takaBDFormat($item->quantity*$item->price)}} 
                                </td>
                    
                            </tr>
                        @endforeach
                        <tr>
                                <td class="index font-bold" colspan=4>
                                    Total
                                </td>

                                <td class="text-center font-bold">
                                {{App\Http\Controllers\SettingController::takaBDFormat($purchase->raw_material_price_total)}} 
                                </td>
                                
                    
                            </tr>
                    @endif
           
            </tbody>

        </table>
    </div>
    
    @if($purchase->extra_charge_total)
        <div class="invoice" id="invoice-container">
            <div class="text-gray-500 dark:text-gray-500 font-semibold text-left">Other Cost</div>
            <table id="table" class="extra_charges_table table table-striped w-full">
                <thead>
                <tr>
                    <th class="hide-elements" style="width: 20px;">#</th>
                    <th class="text-left">Name</th>
                    <th style="width: 82px;">Total</th> 
                </tr>
                </thead>
                <tbody id="__productListWrapper">
                    @foreach($purchase->extra_charges as $item)
                        <tr>
                            <td class="index">
                                {{ $loop->iteration }}
                            </td>
                            <td>
                                <p class="font-bold m-0"> 
                                    {{$item->name}} 
                                </p>
                            </td>

                            <td class="text-center">
                            {{App\Http\Controllers\SettingController::takaBDFormat($item->price)}} 
                            </td>
                
                        </tr>
                    @endforeach
                    <tr>
                        <td class="index font-bold" colspan=2>
                            Total
                        </td>

                        <td class="text-center font-bold">
                        {{App\Http\Controllers\SettingController::takaBDFormat($purchase->extra_charge_total)}} 
                        </td>
                    </tr>
                </tbody>

            </table>
        </div>
    @endif


</div>
</div>
<!-- Modal footer -->
<div class="px-5 py-4 border-t border-gray-200 dark:border-gray-700/60">
<div class="flex flex-wrap justify-end space-x-2">
    <button
        class="__closeModal btn-sm border-gray-200 dark:border-gray-700/60 hover:border-gray-300 dark:hover:border-gray-600 text-gray-800 dark:text-gray-300">Cancel</button>
    <button type="submit"
        class="btn-sm bg-gray-900 text-gray-100 hover:bg-gray-800 dark:bg-gray-100 dark:text-gray-800 dark:hover:bg-white">Save</button>
</div>
</div>
