<div id="message"></div>
@csrf
<input type="hidden" name="id" value="{{$purchase->id}}" id="id" />

<div class="p-5" id="msg-success">
    <div class="flex space-x-4">
        <!-- Icon -->
        <div class="w-10 h-10 rounded-full flex items-center justify-center shrink-0 bg-gray-100 dark:bg-gray-700">
            <svg class="shrink-0 fill-current text-red-500" width="16" height="16" viewBox="0 0 16 16">
                <path
                    d="M8 0C3.6 0 0 3.6 0 8s3.6 8 8 8 8-3.6 8-8-3.6-8-8-8zm0 12c-.6 0-1-.4-1-1s.4-1 1-1 1 .4 1 1-.4 1-1 1zm1-3H7V4h2v5z" />
            </svg>
        </div>

        <div class="mt-1">
            <div class="text-lg font-semibold text-gray-800 dark:text-gray-100">Delete This Stock ?</div>
        </div>
    </div>


    <!-- Content -->
    <div>
        <!-- Modal header -->
        
        <!-- Modal content -->

        <div class="px-0 py-4">
            <div class="flex flex-wrap justify-between items-end gap-y-2 gap-x-4">
                <div id="dashboard-card-08-legend" class="grow mb-1">
                    <div class="text-gray-500 dark:text-gray-500 font-semibold text-left">
                        {{$purchase->supplier->supplier_name}}</div>
                    @if($purchase->supplier->phone)
                    <div class="text-gray-500 dark:text-gray-500 font-semibold text-left">
                        <span class='text-xs italic text-gray-500 align-middle'>{{$purchase->supplier->phone}}</span>
                    </div>
                    @endif
                    @if($purchase->supplier->address)
                    <div class="text-gray-500 dark:text-gray-500 font-semibold text-left">
                        <span class='text-xs italic text-gray-500 align-middle'>{{$purchase->supplier->address}}</span>
                    </div>
                    @endif
                </div>
                <div class="flex items-start">
                    <div class="modal-purchase-total text-2xl font-bold text-gray-800 dark:text-gray-100 mr-2">
                        ৳{{App\Http\Controllers\SettingController::takaBDFormat($purchase->in_total)}} </div>
                </div>
            </div>
        </div>
        <div class="space-y-3">
            <div class="invoice" id="invoice-container">
                <table id="table" class="table table-striped w-full">
                    <thead>
                        <tr>
                            <th class="hide-elements" style="width: 20px;">#</th>
                            <th class="text-left">Name</th>
                            <th style="width: 82px;">Quntity</th>
                            <th>Price</th>
                            <th style="width: 82px;">Total</th>
                        </tr>
                    </thead>
                    <tbody id="__productListWrapper">
                        @if($purchase->purchase_details)
                        @foreach($purchase->purchase_details as $item)
                        <tr>
                            <td class="index text-gray-600 dark:text-gray-400">
                                {{ $loop->iteration }}
                            </td>
                            <td>
                                <p class="font-bold m-0 text-gray-600 dark:text-gray-400">
                                    {{$item->product['product_name']}}
                                </p>

                            </td>
                            <td class="text-center text-gray-600 dark:text-gray-400">
                                {{$item->quantity}}
                            </td>

                            <td class="text-center text-gray-600 dark:text-gray-400">
                                {{App\Http\Controllers\SettingController::takaBDFormat($item->price)}}
                            </td>

                            <td class="text-center text-gray-600 dark:text-gray-400">
                                {{App\Http\Controllers\SettingController::takaBDFormat($item->quantity*$item->price)}}
                            </td>

                        </tr>
                        @endforeach
                        <tr>
                            <td class="index font-bold text-gray-600 dark:text-gray-400" colspan=4>
                                Total
                            </td>

                            <td class="text-center font-bold text-gray-600 dark:text-gray-400">
                                {{App\Http\Controllers\SettingController::takaBDFormat($purchase->product_price_total)}}
                            </td>


                        </tr>
                        @endif

                    </tbody>

                </table>
            </div>

            @if($purchase->extra_charge_total)
            <div class="invoice" id="invoice-container">
                <div class="text-gray-500 dark:text-gray-500 font-semibold text-left">Other Cost</div>
                <table id="table" class="extra_charges_table table table-striped w-full">
                    <thead>
                        <tr>
                            <th class="hide-elements" style="width: 20px;">#</th>
                            <th class="text-left">Name</th>
                            <th style="width: 82px;">Total</th>
                        </tr>
                    </thead>
                    <tbody id="__productListWrapper">
                        @foreach($purchase->extra_charges as $item)
                        <tr>
                            <td class="index text-gray-600 dark:text-gray-400">
                                {{ $loop->iteration }}
                            </td>
                            <td>
                                <p class="font-bold text-gray-600 dark:text-gray-400 m-0">
                                    {{$item->name}}
                                </p>
                            </td>

                            <td class="text-center text-gray-600 dark:text-gray-400">
                                {{App\Http\Controllers\SettingController::takaBDFormat($item->price)}}
                            </td>

                        </tr>
                        @endforeach
                        <tr>
                            <td class="index font-bold text-gray-600 dark:text-gray-400" colspan=2>
                                Total
                            </td>

                            <td class="text-center font-bold text-gray-600 dark:text-gray-400">
                                {{App\Http\Controllers\SettingController::takaBDFormat($purchase->extra_charge_total)}}
                            </td>
                        </tr>
                    </tbody>

                </table>
            </div>
            @endif


        </div>
        <div class="text-sm mb-10">
            <div class="space-y-2 text-gray-600 dark:text-gray-400">
                <p>If you confirm then it will be removed.</p>
            </div>
        </div>

        <!-- Modal footer -->
        <div class="flex flex-wrap justify-end space-x-2">
            <button type="button"
                class="__closeModal btn-sm border-gray-200 dark:border-gray-700/60 hover:border-gray-300 dark:hover:border-gray-600 text-gray-800 dark:text-gray-300">Cancel</button>
            <button type="submit" class="btn-sm bg-red-500 hover:bg-red-600 text-white">Yes, Delete it</button>
        </div>
    </div>
</div>

<script>
$(".datepicker-1").datepicker({
    dateFormat: 'dd-mm-yy'
});
</script>