<x-app-layout>

    @section('title')
    {{ __('translation.Edit Purchase') }}
    @endsection

    @push('top_css')
    <link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
   
    <link rel="stylesheet" href="{{ asset('css/typeaheadjs.css') }}">
    <link rel="stylesheet" href="{{ asset('css/custom_css.css') }}">
    <style>
.table thead th {
    vertical-align: bottom;
    border: 1px solid #2c3545;
    background: #0c1830;
    color: #e1d492;
}

.table td, .table th {
    padding: 0.15rem .75rem;
    vertical-align: top;
    border-top: 1px solid #dee2e6;
    font-size: 13px;
}

.table td p, .table th p {
    font-size: 12px;
    letter-spacing: 1.5px;
}
.font-bold{
    font-weight:600 !important;
}

.table td {
    vertical-align: middle;
    border: 1px solid #2c3545;
    position: relative;
}

#total-tdiscount{
    width: 100%;
    height: 32px;
    background: #7ac0e1;
    border: none;
    color: black;
}

.removeItem {
    position: absolute;
    top: 4px;
    left: 5px;
    padding: .15rem .5rem;
    font-size: 0.675rem;
}

td [type=text] {
    padding: 0 5px;
    height: 30px;
    font-weight: 100;
    font-size: 12px;
    letter-spacing: 2px;
}


      .text-right {
        text-align: right
      }




      .currency {
            display: inline-block;
            width: 0.65em;
            height: 1.2em;
            margin-left: 3px;
            --svg: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 384 512'%3E%3Cpath fill='%23000' d='M36 32.3C18.4 30.1 2.4 42.5.2 60S10.5 93.6 28 95.8l7.9 1c16 2 28 15.6 28 31.8L64 160H32c-17.7 0-32 14.3-32 32s14.3 32 32 32h32v160c0 53 43 96 96 96h32c106 0 192-86 192-192v-32c0-53-43-96-96-96h-16c-17.7 0-32 14.3-32 32s14.3 32 32 32h16c17.7 0 32 14.3 32 32v32c0 70.7-57.3 128-128 128h-32c-17.7 0-32-14.3-32-32V224h32c17.7 0 32-14.3 32-32s-14.3-32-32-32h-32v-31.5c0-48.4-36.1-89.3-84.1-95.3l-7.9-1z'/%3E%3C/svg%3E");
            background-color: currentColor;
            -webkit-mask-image: var(--svg);
            mask-image: var(--svg);
            -webkit-mask-repeat: no-repeat;
            mask-repeat: no-repeat;
            -webkit-mask-size: 100% 100%;
            mask-size: 100% 100%;
            }

      </style>
    @endpush

    @if (in_array('create_sale', session('assignedPermissions')))
    <div class="px-4 sm:px-6 lg:px-8 py-8 w-full max-w-9xl mx-auto">

        <div class="px-0 pb-3 rounded-lg flex rounded-lg">
            <div class="text-center">
                <!-- Start -->
                <ul class="inline-flex flex-wrap text-sm font-medium">
                    <li class="flex items-center">
                        <a class="text-gray-500 dark:text-gray-400 hover:text-violet-500 dark:hover:text-violet-500" href="{{route('purchases')}}">Purchases</a>
                        <svg class="fill-current text-gray-400 dark:text-gray-600 mx-3" width="16" height="16" viewBox="0 0 16 16">
                            <path d="M6.6 13.4L5.2 12l4-4-4-4 1.4-1.4L12 8z"></path>
                        </svg>
                    </li>
                    <li class="flex items-center">
                        <span class="text-gray-500 dark:text-gray-400">Edit</span>
                    </li>
                </ul>
                <!-- End -->
            </div>
        </div>
   
        <x-alert-success class="mb-6 alert hidden" id="__alertSuccess">
            <div id="__alertSuccessContent"></div>
        </x-alert-success>
        

        <x-alert-danger class="mb-6 alert hidden" id="__alertDanger">
            <div id="__alertDangerContent"></div>
        </x-alert-danger>
        <form id="__formEditOrder" action="{{ route('purchase.update') }}" method="post"  enctype="multipart/form-data">
            <div class="text-sm mt-6">
                <div id='msg-success' class="font-medium text-green-700  dark:text-green-700 mb-3">
            </div>
                <ul id="error-list" class="text-red-500 mb-3"></ul>
            </div>
            @csrf  
            <input type="hidden" name="id" value="{{ $purchase->id }}">                   
            <div class="flex flex-col space-y-10 sm:flex-row sm:space-x-6 sm:space-y-0 md:flex-col md:space-x-0 md:space-y-10 xl:flex-row xl:space-x-6 xl:space-y-0">
                <!-- Content -->
                <div class="w-full">

                    <!-- Search form -->
                    

                    <!-- Jobs header -->
                    

                    <!-- Job list -->
                    <div class="space-y-2">                
                        <div class="bg-white dark:bg-gray-800 shadow-sm rounded-xl px-5 py-3">
                            <div class="grid gap-5 md:grid-cols-2 @if(Auth::user()->role !='staff') md:grid-cols-3 @endif">
                                <div>
                                    <label for="order_date" class="block mb-2">
                                        {{ __('Date') }}
                                        <x-form.required-mark />
                                    </label>
                                    <div class="flex flex-row gap-x-4">
                                    <input type="text" value="{{$purchase->order_date}}" autocomplete=off name="order_date" id="order_date" class="datepicker-1 form-input" required />
                                    </div>
                                </div>

                                <input id="shop_id" name="shop_id" class="form-input w-full px-2 py-1" type="hidden" value="{{Auth::user()->shop_id}}" />
                                
                            

                                <div>
                                    <label for="supplier_id" class="block mb-2">
                                        {{ __('translation.supplier') }}
                                        <x-form.required-mark />
                                    </label>
                                    <div class="flex flex-row gap-x-4">
                                        <x-select name="supplier_id" id="supplier_id" class="chosen-select form-select">
                                            <option value="">Select supplier</option>
                                                @if($suppliers)
                                                    @foreach($suppliers as $supplier)
                                                        <option @if($purchase->supplier_id==$supplier->id) selected @endif  value="{{$supplier->id}}">{{$supplier->supplier_name}}
                                                    </option>
                                                    @endforeach
                                                @endif
                                        </x-select>
                                    </div>
                                </div>
                            </div>   
                        </div>

                        <!-- Qr Enter -->
                        <div class="bg-white dark:bg-gray-800 shadow-sm rounded-xl px-5 py-4">
                            <input type="text" class="form-input w-full" id="__product_id_QR_scanner" placeholder="Enter Product Name or Product Code"
                            autocomplete="off" />
                        </div>

                        <!-- Show Product List  -->
                        <div class="bg-white dark:bg-gray-800 shadow-sm rounded-xl px-5 py-4">
                            <div class="invoice" id="invoice-container">

                                <table id="table" class="table table-striped w-full">
                                    <thead>
                                    <tr>
                                        
                                        <th class="hide-elements"></th>
                                        <th>#</th>
                                        <th>Name</th>
                                        <th class="hidden" >Stock</th>
                                        <th style="width: 82px;">Quntity</th>             
                                        <th style="width: 100px;">Price<span class="currency">(৳)</span></th>
                                        <th class="hidden">SubTotal</th>
                                        <th class="hidden" style="width: 50px;">Discount</th>
                                        <th>Total<span class="currency">(৳)</span></th>

                                    </tr>
                                    </thead>
                                    <tbody id="__productListWrapper">
                                        @php $i=count($purchase->purchase_details); @endphp
                                        @if($purchase->purchase_details)
                                            @foreach ($purchase->purchase_details as $detail)                                               
                                                <tr>
                                                    <td class="text-right hide-elements">
                                                        <input type="hidden" name="product_id[]" value="{{ !empty($detail->product_id) ? $detail->product_id : 0 }}" class="product_id" data-id="{{ $detail->product->id }}">
                                                        <button onclick="deleteProductRow(this)" class="removeItem border-none text-red-500 hover:text-red-600 rounded-full p-0 pb-2 m-0">
                                                            <span class="sr-only">Delete</span>
                                                            <svg class="w-8 h-8 fill-current" viewBox="3 5 32 32">
                                                                <path d="M13 15h2v6h-2zM17 15h2v6h-2z"></path>
                                                                <path d="M20 9c0-.6-.4-1-1-1h-6c-.6 0-1 .4-1 1v2H8v2h1v10c0 .6.4 1 1 1h12c.6 0 1-.4 1-1V13h1v-2h-4V9zm-6 1h4v1h-4v-1zm7 3v9H11v-9h10z"></path>
                                                            </svg>
                                                        </button>
                                                    </td>


                                                    <td class="index">
                                                        {{$i--}}
                                                    </td>
                                                    <td>
                                                   
                                                    <p class="name font-bold m-0">
                                                    @if($detail->product)  
                                                        <span class="name">{{$detail->product->product_name}}</span> 
                                                        <span class="product_code ml-3 text-xs italic text-gray-500 align-middle">{{$detail->product->product_code}}</span>  
                                                    
                                                    @endif
                                                    </p>
                                                    </td>
                                                    <td class="text-center hidden">
                                                    <span class="stock"></span>
                                                    </td>

                                                    
                                                    <td class="text-center">
                                                    <input type="text" class="quantity form-input text-center" name="quantity[]" value="{{ $detail->quantity }}" onClick="this.select();">     
                                                    </td>


                                                    <td class="text-right">
                                                    <input type="text" class="product-price form-input text-right" name="cost_price[]" value="{{ $detail->cost_price }}" onClick="this.select();">        
                                                    </td>
                                                    <td class="text-right hidden">
                                                        <span class="row-sub-total">{{ $detail->cost_price*$detail->quantity}}</span> 
                                                    </td>
                                                    <td class="text-right hidden">
                                                    <input type="text" class="tdiscount form-input text-right" name="product_discount[]" value="{{ $detail->product_discount}}" onClick="this.select();">  
                                                    </td>
                                                    <td class="text-right">
                                                    <span class="row-total">{{App\Http\Controllers\SettingController::takaBDFormat($detail->cost_price*$detail->quantity)}}</span>              
                                                    </td>                                    
                                                </tr>
                                            @endforeach
                                        @endif
                                    </tbody>

                                </table>
                            </div>
                        </div>

                       
                        <!-- Payments History of this Order -->
                        <!-- <div class="bg-white dark:bg-gray-800 shadow-sm rounded-xl px-5 py-4">
                            <label class="flex items-center">
                                <span class="text-sm text-gray-600 dark:text-gray-300 font-medium ml-2">Payments</span>
                            </label>

                            <div class="flex mt-2">
                                <table class="table table-striped w-full mr-5">
                                    <thead>
                                        <tr>
                                            <th scope="col">Payment Date</th>
                                            <th scope="col">Payment Method</th>
                                            <th scope="col">Amount<span class="currency">(৳)</span></th>
                                            <th class="hide-elements" style='width:15px'>Actions</th>  
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @if(isset($paymentDetailsAllManual))
                                            @foreach($paymentDetailsAllManual as $rows)
                                                <tr>
                                                    <td scope="row">{{date('d-M-Y', strtotime($rows->payment_date))}}</td>
                                                    
                                                    <td>
                                                        
                                                        @if($rows->payment_method->name=='Cash')
                                                            {{$rows->payment_method->name}}
                                                        @else  
                                                            {{$rows->bank_or_mobile_wallet->name}}                                                  
                                                            @isset($rows->bank_or_mobile_wallet_account->account_no)
                                                                #{{$rows->bank_or_mobile_wallet_account->account_no}}
                                                            @endisset
                                                        @endif
                                                    </td>
                                                    <td class='text-right'>
                                                        {{App\Http\Controllers\SettingController::takaBDFormat($rows->amount)}}</td>
                                                    <td class="text-center hide-elements">
                                                        <div class="flex justify-between space-x-1">
                                                            <button id="BtnEditPayment" data-id="{{$rows->id}}" class="text-red-500 hover:text-red-600 rounded-full p-0">
                                                                <span class="sr-only">Edit</span>
                                                                <svg class="fill-current text-gray-400 dark:text-gray-500 shrink-0" viewBox="-10 -5 35 28">
                                                                    <path d="M11.7.3c-.4-.4-1-.4-1.4 0l-10 10c-.2.2-.3.4-.3.7v4c0 .6.4 1 1 1h4c.3 0 .5-.1.7-.3l10-10c.4-.4.4-1 0-1.4l-4-4zM4.6 14H2v-2.6l6-6L10.6 8l-6 6zM12 6.6L9.4 4 11 2.4 13.6 5 12 6.6z"></path>
                                                                </svg>
                                                            </button>

                                                            <button id="BtnDeletePayment" data-id="{{$rows->id}}" class="text-red-500 hover:text-red-600 rounded-full p-0 ">
                                                                <span class="sr-only">Delete</span>
                                                                <svg class="w-8 h-8 fill-current" viewBox="0 4 32 32">
                                                                <path d="M13 15h2v6h-2zM17 15h2v6h-2z"></path>
                                                                <path d="M20 9c0-.6-.4-1-1-1h-6c-.6 0-1 .4-1 1v2H8v2h1v10c0 .6.4 1 1 1h12c.6 0 1-.4 1-1V13h1v-2h-4V9zm-6 1h4v1h-4v-1zm7 3v9H11v-9h10z"></path>
                                                                </svg>
                                                            </button>
                                                        </div>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        @endif
                                    </tbody>
                                </table>
                            </div>
                        </div> -->

                    </div>
                </div>

                @php
                    $in_total = !empty($purchase->in_total) ? $purchase->in_total : 0;
                    $product_price_total = !empty($purchase->product_price_total) ? $purchase->product_price_total : 0;
                    $extra_charge_total = !empty($purchase->extra_charge_total) ? $purchase->extra_charge_total : 0;
                @endphp
                <!-- Sidebar -->
                <div class="space-y-2">
                    <!-- Alert -->
                    <div class="relative bg-[linear-gradient(135deg,var(--tw-gradient-stops))] from-violet-500/[0.12] dark:from-violet-500/[0.24] to-violet-500/[0.04] rounded-lg px-5 py-6">
                        <div class="flex justify-between space-x-1">
                            <div class="text-xl font-medium text-gray-800 dark:text-violet-200 mb-2">Total</div>
                            <div class="text-right">
                                <a class="grandTotalCurrency text-xl font-medium text-violet-500 hover:text-violet-600" href="#0">
                                    {{number_format($in_total,2)}}
                                </a>
                            </div>
                        </div>
                    </div>
                    <!-- White box -->
                    <div class="bg-white dark:bg-gray-800 shadow-sm rounded-xl p-5 min-w-60">             
                        <div class="max-w-sm mx-auto lg:max-w-none">               
                            <!-- Bottom -->
                            <div class="bg-white dark:bg-gray-800 rounded-b-xl pt-2.5 text-sm space-y-1">
                                <div class="flex justify-between space-x-1">
                                    <span class="italic">Product's Total:</span>
                                    <x-input type="hidden" id="product_price_total" value=""/>
                                    <span id="__productTotalCurrency" class="font-medium text-gray-700 dark:text-gray-100 text-right">
                                        {{App\Http\Controllers\SettingController::takaBDFormat($product_price_total)}}</span>
                                </div>
                                <div class="flex justify-between space-x-1">
                                    <span class="italic">Other Cost:</span>
                                    <span id="__serviceCostCurrency" class="font-medium text-gray-700 dark:text-gray-100 text-right">{{number_format($extra_charge_total,2)}}</span>
                                </div>

                                <div class="grow w-full h-5 bg-white dark:bg-gray-800 flex flex-col justify-center">
                                    <div class="h-px w-full border-t border-dashed border-gray-200 dark:border-gray-700"></div>
                                </div>

                                <div class="flex justify-between space-x-1">
                                    <span class="italic">Grand Total:</span>
                                    <span class="grandTotalCurrency font-medium text-gray-700 dark:text-gray-100 text-right">
                                        {{App\Http\Controllers\SettingController::takaBDFormat($product_price_total+$extra_charge_total)}}
                                    </span>
                                </div>
                                <div class="flex justify-between space-x-1 hidden">
                                    <span class="italic">Discount:</span>
                                    <span class="font-medium text-gray-700 dark:text-gray-100 text-right">
                                    <input onClick="this.select();" type="text" style="width:100px" id="discount-total" name="total_discount" class="text-right form-input" value="{{$purchase->total_discount}}">
                                    </span>
                                </div>

                                <div class="flex justify-between space-x-1">
                                    <span class="italic">Prevous Due:</span>
                                    <span id="__previousDue" class="font-medium text-gray-700 dark:text-gray-100 text-right">
                                        {{App\Http\Controllers\SettingController::takaBDFormat($supplierDue)}}
                                    </span>
                                </div>

                                <div class="flex justify-between space-x-1">
                                    <span class="italic">To Be Paid:</span>
                                    <span id="__amountToBePaid" class="font-medium text-gray-700 dark:text-gray-100 text-right">
                                    {{App\Http\Controllers\SettingController::takaBDFormat($product_price_total+$extra_charge_total+$supplierDue-$order_payment)}}
                                    </span>
                                </div>
                                
                                <!-- <div class="flex justify-between space-x-1">
                                    <span class="italic">Paid:</span>
                                    <input onClick="this.select();" type="text" style="width:100px" id="__paid" name="paid" class="text-right form-input" value="">
                                </div> -->

                                <div class="flex justify-between space-x-1">
                                    <span class="italic font-bold text-red-500">Total Due:</span>
                                    <span id="__dueAmount" class="font-medium text-gray-700 dark:text-gray-100 text-right">
                                    {{App\Http\Controllers\SettingController::takaBDFormat($product_price_total+$extra_charge_total+$supplierDue-$order_payment)}}
                                    </span>
                                </div>
                            </div>

                            <!-- <div class="w-full mt-2">
                                <ul class="space-y-2">
                                    <li>
                                        <label class="flex items-center">
                                            <input type="checkbox" class="form-checkbox" name="is_cash_payment" id="is_cash_payment" value="1" checked="">
                                            <span class="text-sm text-gray-600 dark:text-gray-300 font-medium ml-2">Cash Payment</span>
                                        </label>
                                    </li>
                                </ul>
                                    
                                <div id="__payment_method_wrapper" class="space-y-2">
                                    <div class="space-y-1">
                                        <span class="italic">{{ __('translation.Payment Method') }}:</span>
                                        <select class='form-select' id="__payment_method" name="payment_method_id" style="width: 100%">
                                            <option disabled selected value="0">
                                                - Select Method -
                                            </option>
                                            @if($payment_methods)
                                                @foreach($payment_methods as $pm)
                                                    <option value="{{$pm->id}}">{{$pm->name}}</option>
                                                @endforeach
                                            @endif
                                        </select>
                                    </div>

                                    <div class="space-y-1 gap-4 sm:gap-x-8">
                                        

                                        <div id="_bankOrMobileDetailsWrapper" class="lg:col-span-1">
                                        </div>

                                        <div id="_AccountNoWrapper" class="lg:col-span-1">
                                        </div>

                                    </div>
                                </div>
                            </div>

                            <div class="w-full mt-2">
                                <ul class="space-y-2">
                                    <li>
                                        <label class="flex items-center">
                                            <input type="checkbox" class="form-checkbox" name="have_note" id="have_note" value="0">
                                            <span class="text-sm text-gray-600 dark:text-gray-300 font-medium ml-2">Write Note</span>
                                        </label>
                                    </li>
                                </ul>

                                </div>
                            </div>
-->

                            <!-- Notes -->
                           <!--
                              <div class="mt-2" id="__note_wrapper">
                                <div class="text-sm font-semibold text-gray-800 dark:text-gray-100 mb-2">Notes</div>
                            
                                <label class="sr-only" for="notes">Write a note</label>
                                <textarea id="notes" name="notes" class="form-textarea w-full focus:border-gray-300" rows="4" placeholder="Write a note…"></textarea>
                            
                            </div> -->

                            <!-- Submit / Button -->
                            <div class="flex items-center space-x-3 mt-6">
                                <div class="w-1/2">
                                    <button type="submit" class="btn bg-green-500 hover:bg-green-600 text-black">
                                        <svg class="fill-current text-gray-400 dark:text-gray-500 shrink-0 rotate-180" width="16" height="16" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M8 4c-.3 0-.5.1-.7.3L1.6 10 3 11.4l4-4V16h2V7.4l4 4 1.4-1.4-5.7-5.7C8.5 4.1 8.3 4 8 4ZM1 2h14V0H1v2Z"></path>
                                        </svg>
                                        <span class="ml-2">Submit</span>
                                    </button>
                                </div>
                            </div>

                        </div>                                            
                    </div>
                </div>
            
            </div>
        </form> 
    </div> 
    <!-- End div -->

    @endif


    <table class="hidden">
        <tbody id="__templateProductItem" class="">
        <tr>
            <td class="text-right hide-elements">
                <input type="hidden" name="product_id[]" class="product-id" value="">
                <button onclick="deleteProductRow(this)" class="removeItem text-red-500 hover:text-red-600 rounded-full p-0 pb-2 m-0">
                    <span class="sr-only">Delete</span>
                    <svg class="w-8 h-8 fill-current" viewBox="0 0 32 32">
                        <path d="M13 15h2v6h-2zM17 15h2v6h-2z"></path>
                        <path d="M20 9c0-.6-.4-1-1-1h-6c-.6 0-1 .4-1 1v2H8v2h1v10c0 .6.4 1 1 1h12c.6 0 1-.4 1-1V13h1v-2h-4V9zm-6 1h4v1h-4v-1zm7 3v9H11v-9h10z"></path>
                    </svg>
                </button>
            </td>


            <td class="index">
              1
            </td>
            <td>
            <p class="font-bold m-0"> 
                <span class="name"></span> 
                <span class="product_code ml-3 text-xs italic text-gray-500 align-middle"></span> 
            </p>
            
            </td>
            <td class="text-center hidden">
              <span class="stock">0</span>
            </td>
            
            <td class="text-center">
            <input type="text" class="form-input quantity text-center" name="quantity[]" value="1" onClick="this.select();">     
            </td>

            <td class="text-right">                     
              <input type="text" class="form-input product-price text-right" name="cost_price[]" value="" onClick="this.select();">        
            </td>
            
            <td class="text-right hidden">
                <span class="row-sub-total">0.00</span> 
            </td>
            <td class="text-right hidden">
            <input type="text" class="form-input tdiscount text-right" name="product_discount[]" value="" onClick="this.select();">  
            </td>
            <td class="text-right">
              <span class="row-total">0.00</span>              
            </td>
  
        </tr>
       </tbody>
    </table>


    <table class="hidden">
        <tbody id="serviceTemplate" class="">
            <tr>
                <td class="text-right hide-elements">
                    <button onclick="deleteServiceRow(this)" class="removeItem border-none text-red-500 hover:text-red-600 rounded-full p-0 pb-2 m-0">
                        <span class="sr-only">Delete</span>
                        <svg class="w-8 h-8 fill-current" viewBox="3 5 32 32">
                            <path d="M13 15h2v6h-2zM17 15h2v6h-2z"></path>
                            <path d="M20 9c0-.6-.4-1-1-1h-6c-.6 0-1 .4-1 1v2H8v2h1v10c0 .6.4 1 1 1h12c.6 0 1-.4 1-1V13h1v-2h-4V9zm-6 1h4v1h-4v-1zm7 3v9H11v-9h10z"></path>
                        </svg>
                    </button>
                </td>


                <td class="index">
                1
                </td>
                <td class="text-right">               
                <input type="text" name="service_name[]" required class="service_name form-input" value="" onClick="this.select();">        
                </td>

                <td class="text-right">               
                <input type="text" name="service_price[]" required class="service_price text-right form-input" value="" onClick="this.select();">        
                </td>
            </tr>
        </tbody>
    </table>


    <div class="modalArea modal-editPayment modal-hide">    
        <div class="overflow-auto fixed  inset-0 z-10 flex items-center justify-center">
            <div class="bg-violet rounded-lg shadow-lg overflow-auto max-w-lg w-full max-h-full" x-transition:enter="ease-out duration-300" x-transition:enter-start="opacity-0 scale-90" x-transition:enter-end="opacity-100 scale-100">
            
            <!-- Modal header -->
            <div class="px-5 py-3 border-b border-gray-200 dark:border-gray-700/60">
                <div class="flex justify-between items-center">
                    <div class="font-semibold text-gray-800 dark:text-gray-100">Edit Payment</div>
                    <button class="__closeModal text-gray-400 dark:text-gray-500 hover:text-gray-500 dark:hover:text-gray-400">
                        <div class="sr-only">Close</div>
                        <svg class="fill-current" width="16" height="16" viewBox="0 0 16 16">
                            <path d="M7.95 6.536l4.242-4.243a1 1 0 111.415 1.414L9.364 7.95l4.243 4.242a1 1 0 11-1.415 1.415L7.95 9.364l-4.243 4.243a1 1 0 01-1.414-1.415L6.536 7.95 2.293 3.707a1 1 0 011.414-1.414L7.95 6.536z" />
                        </svg>
                    </button>
                </div>
            </div>

            <form method="POST" action="{{route('receive-payment.update')}}" id="form-edit-payment" enctype="multipart/form-data">

            </form>

            </div>
            </div>
    </div>

     <!-- DELETE Modal -->        
    <div class="modalArea modal-deletePayment modal-hide">    
        <div class="overflow-auto fixed  inset-0 z-10 flex items-center justify-center">
            <div class="bg-violet rounded-lg shadow-lg overflow-auto max-w-lg w-full max-h-full" x-transition:enter="ease-out duration-300" x-transition:enter-start="opacity-0 scale-90" x-transition:enter-end="opacity-100 scale-100">
            
            <!-- Modal header -->
            <div class="px-5 py-3 border-b border-gray-200 dark:border-gray-700/60">
                <div class="flex justify-between items-center">
                    <div class="font-semibold text-gray-800 dark:text-gray-100">Delete Payment</div>
                    <button class="__closeModal text-gray-400 dark:text-gray-500 hover:text-gray-500 dark:hover:text-gray-400">
                        <div class="sr-only">Close</div>
                        <svg class="fill-current" width="16" height="16" viewBox="0 0 16 16">
                            <path d="M7.95 6.536l4.242-4.243a1 1 0 111.415 1.414L9.364 7.95l4.243 4.242a1 1 0 11-1.415 1.415L7.95 9.364l-4.243 4.243a1 1 0 01-1.414-1.415L6.536 7.95 2.293 3.707a1 1 0 011.414-1.414L7.95 6.536z" />
                        </svg>
                    </button>
                </div>
            </div>

            <!-- DELETE Modal content -->
            <form id="form-delete-payment" method="POST"></form>

            </div>
        </div>
    </div>


    @push('bottom_js')
    <script src="https://cdn.jsdelivr.net/npm/typeahead.js@0.11.1/dist/typeahead.bundle.min.js"></script>
    
    <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/clipboard@2.0.8/dist/clipboard.min.js"></script>
    <script src="{{ asset('js/delayKeyup.js?_=' . rand()) }}"></script>

    
    <script>
    $(".chosen-select").chosen({no_results_text: "Oops, nothing found!"}); 
    const enterKeyCode = 13;
    const BDTSymbol = '{{ currency_symbol('BDT') }}';

    var selectedProductsToList = [];
    var productsource = {!!$products->toJson() !!};

    var subTotal = 0;
    var serviceCost = 0;
    var discountTotal = 0;
    var totalAmount = 0;

    function formatNumber(number) {
        return number.toFixed(2).toString().replace(/(\d+?)(?=(\d\d)+(\d)(?!\d))/g, "$1,");
         
    }

    function replaceComma(number) {
        return number.replace(/,/g, '');
    }

    
    const calculateCartSummary = () => {
        let productTotal = 0;
        let serviceTotal = 0;
        let grandTotalCurrency = 0;
        let discount_total = 0;
        let previousDue = 0;
        
        previousDue = parseFloat(replaceComma($('#__previousDue').text()));
        productTotal = parseFloat(replaceComma($('#__productTotalCurrency').text()));
        serviceTotal = parseFloat(replaceComma($('#__serviceCostCurrency').text()));
        discount_total = parseFloat(replaceComma($('#discount-total').val())) || 0;
        grandTotalCurrency = productTotal+serviceTotal;

        $('.grandTotalCurrency').text(formatNumber(grandTotalCurrency));
        $('#__amountToBePaid').text(formatNumber(previousDue+grandTotalCurrency-discount_total));
        //$('#__paid').val((grandTotalCurrency-discount_total).toFixed(2));
        
        
    }




    const updateProductRowTotal = (row) => {
        let price = parseFloat(row.find('.product-price').val()) || 0;
        let quantity = parseFloat(row.find('.quantity').val()) || 0;
        let discount = parseFloat(row.find('.tdiscount').val()) || 0;
        let rowSubTotal = price * quantity;
        let total = rowSubTotal - discount;
        row.find('.row-sub-total').text(formatNumber(rowSubTotal));
        row.find('.row-total').text(formatNumber(total));
    
        
        //console.log("Total "+total);

        updateGrandTotal();
        calculateCartSummary();
    }

    const updateGrandTotal = () => {
        let subTotal = 0;
        let grandTotal = 0;
        let discountTotal = 0;
        $('.row-total').each(function(){
            subTotal += parseFloat(replaceComma($(this).text())) || 0;
        });
        $('#sub-total').text(formatNumber(subTotal));
        discountTotal += parseFloat($("#discount-total").val()) || 0;
        $('#product_price_total').val(formatNumber(subTotal-discountTotal));
        $('#__productTotalCurrency').text(formatNumber(subTotal-discountTotal));
        
    }

    const productHandlers = (row) => {
        row.find('.quantity, .product-price, .tdiscount').on('keyup', function() {
            var currentRow = $(this).closest('tr');            
            updateProductRowTotal(currentRow);
        });
    }

    $('.quantity, .product-price, .tdiscount').on('keyup', function() {
            var currentRow = $(this).closest('tr');  
            console.log(currentRow);        
            updateProductRowTotal(currentRow);
        });

    // Initial calculation
    $('tbody.main tr').each(function(){
        updateProductRowTotal($(this));
        productHandlers($(this));
    });





    const deleteProductRow = (button) => {
      const row = button.closest('tr');
      row.remove();
      updateGrandTotal();
      calculateCartSummary();
    }


    // Services section 

    const serviceHandlers = (row) => {
        row.find('.service_price').on('keyup', function() {
            var currentRow = $(this).closest('tr');
            servicesGrandTotal();
        });
    }

    $('.service_price').on('keyup', function() {
        var currentRow = $(this).closest('tr');
        servicesGrandTotal();
    });

    const servicesGrandTotal = () => {
        let subTotal = 0;
        let grandTotal = 0;
        let discountTotal = 0;
        $('.service_price').each(function(){
            subTotal += parseFloat($(this).val()) || 0;
        });
        $('#__serviceCostCurrency').text(formatNumber(subTotal));

        calculateCartSummary();
        
    }



    // Cloning and appending a new row
    $('#add-row').on('click', function(){
        let serviceListWrapper = $('#__serviceTable tbody');
        let lastRow = $('#serviceTemplate tr');
        let newRow = lastRow.clone();
        // Update index in the cloned row
        newRow.find('.index').text($('#__serviceTable tr').length); // Update index based on current row count

        // Reset input values for the new row
        newRow.find('input').val('');

        serviceListWrapper.prepend(newRow);

        // Attach event handlers to the new row
        serviceHandlers(newRow);
        
        // Recalculate totals after adding the new row
        servicesGrandTotal();
    });


    

    const deleteServiceRow = (button) => {
      const row = button.closest('tr');
      row.remove();
      servicesGrandTotal();
      calculateCartSummary();
    }


    $('#discount-total').on('keyup', function() {
        calculateCartSummary();
    });

    $('#__paid').on('keyup', function() {

        let toBePaid = 0;
        let paid = 0;
        let due = 0;
        

        toBePaid = parseFloat(replaceComma($('#__amountToBePaid').text()));
        paid = parseFloat($(this).val());
        due = (toBePaid - paid)  || 0;

        $('#__dueAmount').text(formatNumber(due));       
        
    });



    $(document).on('click', '.__closeModal', function(event) {
        event.preventDefault();
        //$('.modal-update').addClass('modal-hide');
        $('.modalArea').hide(); // Hide the modal
    });


    $(document).on('submit', '#form-edit-payment', function(event) {
    event.preventDefault();

    var $msgSuccess = $('#form-edit-payment #msg-success');
    var $errorList = $('#form-edit-payment #error-list');

    $msgSuccess.hide();
    $errorList.hide();
    // Clear existing errors (if any)
    $errorList.empty();

    var formData = new FormData($(this)[0]);
    console.log(formData);
    $.ajax({
        url: '{{ route('receive-payment.update') }}',
        type: 'post',
        data: formData,
        contentType: false,
        processData: false, // Add this line to prevent default processing of FormData
        success: function(response) {
            $("#msg-success").html(response.status);                            
            $msgSuccess.show();
            // Hide the modal after 3 seconds (1000 ms)
            setTimeout(function() {
                //$('#add-product-modal').hide();
                location.reload();
            }, 1000);
            
        },
        error: function(error) {
            $errorList.show();
            var errorData = error.responseJSON;
            console.error('result:', errorData.errors);
            // Display errors on the UI (you can customize how to show these)
            for (const [key, message] of Object.entries(errorData.errors)) {
                // Assuming you have a way to show these errors in your UI
                $errorList.append('<li>' + message + '</li>');                                    
            }
        }

    })
});




    const substringMatcher = function(strs) {
        return function findMatches(q, cb) {
            var matches, substringRegex;
            matches = [];

            substrRegex = new RegExp(q, 'i');

            $.each(strs, function(i, str) {
                if (substrRegex.test(str)) {
                    matches.push(str);
                }
            });

            cb(matches);
        };
    };


    const initializeTypeAheadField = () => {

        $('#__product_id_QR_scanner').typeahead({
          
            hint: true,
            minLength: 1,
            highlight: true
        }, {
            source: substringMatcher(productsource),
            limit: 15
        });
    }

    initializeTypeAheadField();


    $('#__product_id_QR_scanner').on('typeahead:selected', function(event, selectedItem) {
        renderProductToList(selectedItem);
    });


    const renderProductToList = typeAheadValue => {

        
        if (typeAheadValue !== '') {
            $.ajax({
                type: 'GET',
                data: {
                    term: typeAheadValue
                },
                url: '{{ route('get_qr_code_rancon_product') }}',
                success: function(responseJson) {
                    console.log(responseJson.product);
                    if (responseJson.status === 1) {
                        //$('#error_modal').modal('show');
                    }
              
                    if (responseJson.status === 3) {
                        let lastRow = $('#invoice-container tbody');
                        let newRow = $('#__templateProductItem tr').clone();
                        // Update index in the cloned row
                        newRow.find('.index').text($('#invoice-container tr').length); // Update index based on current row count
                        let product = responseJson.product;

                        let productQuantity = 0;
                        if (typeof(product.quantity) !== 'undefined') {
                            productQuantity = product.quantity - product.sales_quantity;
                        }

                        if (product.name !== null) {
                            name = product.product_name;
                        }else{
                            name = '';
                        }

                        //if (selectedProductsToList.indexOf(product.id) === -1) {

                            selectedProductsToList.push(product.id);

                            
                            newRow.attr('class','rowNo_'+product.id); 
                       
                            newRow.find('.product-id').val(product.id || 0);
                            // Reset input values for the new row
                            newRow.find('.name').html(name || '');                            
                            newRow.find('.product_code').html(product.product_code || '');                            
                            newRow.find('.stock').html(productQuantity || 0);
                            newRow.find('.cost-price').val(product.cost_price || 0);
                            newRow.find('.product-price').val(product.price || 0);
                            newRow.find('.product-price').attr('min',product.price || 0);
                            newRow.find('.tdiscount').val('');

                            
                        //     if (selectedProductsToList.indexOf(product.id) > -1) {
                        //     let stockAdjustElement = $(`.rowNo_${product.id} .quantity`);
                        //     let currentValue = parseInt(stockAdjustElement.val());
                        //     let increasedValue = currentValue + 1;
                        //     //stockAdjustElement.val(increasedValue);
                        //     stockAdjustElement.val(increasedValue);
                        // }


                            lastRow.prepend(newRow);

                            // Attach event handlers to the new row
                            productHandlers(newRow);
                            
                            // Recalculate totals after adding the new row
                            updateProductRowTotal(newRow);                     


                            $('#__base_amount').val(product.price);
                            $('#__noProductWrapper').hide();
                            $('#__service_methods_wrapper').show();
                            $('#__payment_details_wrapper').show();
                            
                        //}


                        

                        $('#__product_id_QR_scanner').typeahead('destroy');
                        $('#__product_id_QR_scanner').val(null);

                            
                        initializeTypeAheadField();

                        $('#__product_id_QR_scanner').focus();

                    }
                }
            });
        }
    }



    $('#supplier_id').change(function() {
        $.ajax({
            url: '{{ route('supplier-due') }}',
            type: 'post',
            data: {
                'supplier_id': $(this).val(),
                '_token': $('meta[name=csrf-token]').attr('content')
            }
        }).done(function(result) {
            $('#__previousDue').html(result);
            calculateCartSummary();
        });

    });

    $('#__payment_method').change(function() {
        if ($(this).val() == 1) {
            $("#_bankOrMobileDetailsWrapper").hide();
            $("#_AccountNoWrapper").hide();
            $("#bank_or_mobile_wallet_id").val('');
            $("#account_no_id").val('');

        } else {
            $("#_bankOrMobileDetailsWrapper").show();
            $("#_AccountNoWrapper").show();
        }
        $.ajax({
            url: '{{ route('load-bank-or-mobile-dropdown') }}',
            type: 'post',
            data: {
                'id': $(this).val(),
                '_token': $('meta[name=csrf-token]').attr('content')
            }
        }).done(function(result) {
            $('#_bankOrMobileDetailsWrapper').html(result);
        });

    });

    $('#bank_or_mobile_wallet_id').on('change', function() {
        $.ajax({
            url: '{{ route('load-bank-or-mobile-account-dropdown') }}',
            type: 'post',
            data: {
                'bank_or_mobile_wallet_id': $(this).val(),
                '_token': $('meta[name=csrf-token]').attr('content')
            }
        }).done(function(result) {
            $('#_AccountNoWrapper').html(result);
        });
    });



    </script>

    <script>
    $("#wrapper_services").show();
    $("#wrapper_new").hide();


    $('#have_services').change(function() {
        if (this.checked) {
            $("#__serviceAreaWrapper").slideDown();
        } else {
            $("#__serviceAreaWrapper").slideUp();
        }

       // calculateCartTotal();
    });


    $("#__payment_method_wrapper").hide();
    $('#is_cash_payment').change(function() {
        
        if($(this).is(":checked")){
            $("#__payment_method_wrapper").slideUp();
        } else {
            $("#__payment_method_wrapper").slideDown();
        }

       // calculateCartTotal();
    });

    $("#__note_wrapper").hide();
    $('#have_note').change(function() {
        
        if($(this).is(":checked")){
            $("#__note_wrapper").slideDown();
        } else {
            $("#__note_wrapper").slideUp();
        }
    });

    

    $(document).ready(function() {

        $(".datepicker-1").datepicker({
            dateFormat: 'dd-mm-yy'
        });
    });

    $(document).on('submit', '#__formEditOrder', function(event) {
                event.preventDefault();

                var $msgSuccess = $('#__formEditOrder #msg-success');
                var $errorList = $('#__formEditOrder #error-list');
                // Clear existing errors (if any)
                $errorList.empty();
                var formData = new FormData($(this)[0]);
                console.log(formData);
                $.ajax({
                    url: '{{ route('purchase.update') }}',
                    type: 'post',
                    data: formData,
                    contentType: false,
                    processData: false, // Add this line to prevent default processing of FormData
                    success: function(response) {
                        $("#msg-success").html(response.message);                            
                        $msgSuccess.show();
                        // Hide the modal after 3 seconds (1000 ms)
                        setTimeout(function() {
                            //$('#add-lender-modal').hide();
                            location.reload();
                        }, 1000);
                        
                    },
                    error: function(error) {
                        $errorList.show();
                        var errorData = error.responseJSON;
                        console.error('result:', errorData.errors);
                        // Display errors on the UI (you can customize how to show these)
                        for (const [key, message] of Object.entries(errorData.errors)) {
                            // Assuming you have a way to show these errors in your UI
                            $errorList.append('<li>' + message + '</li>');                                    
                        }
                    }

                })
            });
   </script>

    @endpush

</x-app-layout>