<x-app-layout>
    @section('title', 'Product')

    @push('top_css')
        <link type="text/css" href="https://cdn.jsdelivr.net/npm/jquery-datatables-checkboxes@1.2.12/css/dataTables.checkboxes.css" rel="stylesheet" />
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" />
        <link rel="stylesheet" href="{{ asset('css/LC-select-theme-light.css') }}">
    @endpush

    <style type="text/css">   
    select.select2-hidden-accessible {
        width: 100%!important;
    }
    /* Small devices (tablets, 768px and 800px) */
    @media only screen and (min-width: 768px) and (max-width: 800px) {
        .btn-action--gray {
            font-size: .60rem!important;
        }
    }

    /* mobile devices  */
    @media (max-width: 767px) {

        td .flex {
            display: grid !important;
        }
        .dataTable tbody tr td {
            padding: .5rem 0rem!important;
        }
        .w-1\/2 {
            width: 100%!important;
        }

    }
    </style>

    {{-- <a href="{{asset('qrcode.svg')}}" download><img src="{{asset('qrcode.svg')}}" alt=""></a> --}}
    
        <x-card title="Product ({{ number_format($productCount) }})">
            <div class="mt-6">

                <div class="flex flex-col sm:flex-row sm:justify-between items-start mb-4">
                    <div class="w-full md:w-3/5 lg:w-3/5 mb-6 sm:mb-0">
                        <div class="flex flex-col sm:flex-row">
                            @if(Auth::user()->role != '') @endif
                            <div class="sm:mr-2">
                            <button type="button" id="BtnInsertProduct" color="green" class="inline-flex items-center justify-center text-sm font-medium leading-5 rounded-full px-3 py-1 border border-gray-200 dark:border-gray-700/60 hover:border-gray-300 dark:hover:border-gray-600 shadow-sm bg-white dark:bg-gray-800 text-gray-500 dark:text-gray-400 transition">
                                <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v3m0 0v3m0-3h3m-3 0H9m12 0a9 9 0 11-18 0 9 9 0 0118 0z" />
                                </svg>
                                <span class="ml-2">Add Product</span>
                            </button>
                            </div>
                           
                        </div>
                    </div>
                </div>

            </div>

            <div class="w-full overflow-x-auto">
                <table class="w-full" id="datatable">
                    <thead>
                    <tr class="rounded-lg text-sm font-medium text-gray-700 text-left">
                        <th></th>
                        <th class="px-4 py-2 text-center">
                            {{ __('translation.Name') }}
                        </th>
                        
                        <th class="px-4 py-2 text-center">
                            {{ __('translation.Quantity') }}
                        </th>

                        <th class="px-4 py-2 text-center">
                            {{ __('translation.Price') }}
                        </th>
                        
                        <th class="px-4 py-2 text-center">
                            {{ __('translation.Actions') }}
                        </th>
                    </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>
        </x-card>



    <!-- <span class="modal-open bg-blue-500 text-white rounded px-2 py-1 mr-1 capitalize cursor-pointer"><a href="view-qr-code/'.$row->product_code.'" ><i class="fas fa-print"></i></a></span> -->

    <div class="modalArea modal-insertProduct modal-hide">    
        <div class="overflow-auto fixed  inset-0 z-10 flex items-center justify-center">
            <div class="bg-violet rounded-lg shadow-lg overflow-auto max-w-lg w-full max-h-full" x-transition:enter="ease-out duration-300" x-transition:enter-start="opacity-0 scale-90" x-transition:enter-end="opacity-100 scale-100">
            
            <!-- Modal header -->
            <div class="px-5 py-3 border-b border-gray-200 dark:border-gray-700/60">
                <div class="flex justify-between items-center">
                    <div class="font-semibold text-gray-800 dark:text-gray-100">Insert Product</div>
                    <button type='button' class="__closeModal text-gray-400 dark:text-gray-500 hover:text-gray-500 dark:hover:text-gray-400">
                        <div class="sr-only">Close</div>
                        <svg class="fill-current" width="16" height="16" viewBox="0 0 16 16">
                            <path d="M7.95 6.536l4.242-4.243a1 1 0 111.415 1.414L9.364 7.95l4.243 4.242a1 1 0 11-1.415 1.415L7.95 9.364l-4.243 4.243a1 1 0 01-1.414-1.415L6.536 7.95 2.293 3.707a1 1 0 011.414-1.414L7.95 6.536z" />
                        </svg>
                    </button>
                </div>
            </div>

            <form method="POST" id="form-insert-product" enctype="multipart/form-data">

            </form>

            </div>
        </div>
    </div>
    <div class="modalArea modal-editProduct modal-hide">    
        <div class="overflow-auto fixed  inset-0 z-10 flex items-center justify-center">
            <div class="bg-violet rounded-lg shadow-lg overflow-auto max-w-lg w-full max-h-full" x-transition:enter="ease-out duration-300" x-transition:enter-start="opacity-0 scale-90" x-transition:enter-end="opacity-100 scale-100">
            
            <!-- Modal header -->
            <div class="px-5 py-3 border-b border-gray-200 dark:border-gray-700/60">
                <div class="flex justify-between items-center">
                    <div class="font-semibold text-gray-800 dark:text-gray-100">Edit Product</div>
                    <button type='button' class="__closeModal text-gray-400 dark:text-gray-500 hover:text-gray-500 dark:hover:text-gray-400">
                        <div class="sr-only">Close</div>
                        <svg class="fill-current" width="16" height="16" viewBox="0 0 16 16">
                            <path d="M7.95 6.536l4.242-4.243a1 1 0 111.415 1.414L9.364 7.95l4.243 4.242a1 1 0 11-1.415 1.415L7.95 9.364l-4.243 4.243a1 1 0 01-1.414-1.415L6.536 7.95 2.293 3.707a1 1 0 011.414-1.414L7.95 6.536z" />
                        </svg>
                    </button>
                </div>
            </div>

            <form method="POST" action="{{route('product.update')}}" id="form-edit-product" enctype="multipart/form-data">

            </form>

            </div>
            </div>
    </div>

     <!-- DELETE Modal -->        
    <div class="modalArea modal-deleteProduct modal-hide">    
        <div class="overflow-auto fixed  inset-0 z-10 flex items-center justify-center">
            <div class="bg-violet rounded-lg shadow-lg overflow-auto max-w-lg w-full max-h-full" x-transition:enter="ease-out duration-300" x-transition:enter-start="opacity-0 scale-90" x-transition:enter-end="opacity-100 scale-100">
            
            <!-- Modal header -->
            <div class="px-5 py-3 border-b border-gray-200 dark:border-gray-700/60">
                <div class="flex justify-between items-center">
                    <div class="font-semibold text-gray-800 dark:text-gray-100">Delete Product</div>
                    <button class="__closeModal text-gray-400 dark:text-gray-500 hover:text-gray-500 dark:hover:text-gray-400">
                        <div class="sr-only">Close</div>
                        <svg class="fill-current" width="16" height="16" viewBox="0 0 16 16">
                            <path d="M7.95 6.536l4.242-4.243a1 1 0 111.415 1.414L9.364 7.95l4.243 4.242a1 1 0 11-1.415 1.415L7.95 9.364l-4.243 4.243a1 1 0 01-1.414-1.415L6.536 7.95 2.293 3.707a1 1 0 011.414-1.414L7.95 6.536z" />
                        </svg>
                    </button>
                </div>
            </div>

            <!-- DELETE Modal content -->
            <form id="form-delete-product" method="POST"></form>

            </div>
        </div>
    </div>





@push('bottom_js')
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.0/jquery.validate.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/jquery-datatables-checkboxes@1.2.12/js/dataTables.checkboxes.min.js"></script>
        
        <script src="{{ asset('js/lc_select.js') }}"></script>

        <script>
            const productTableUrl = '{{ route('data product') }}';
            var productTable = '';

            const loadProductTable = (product_code, product_name) => {
                productTable = $('#datatable').DataTable({
                    processing: true,
                    serverSide: true,
                    bDestroy: true,
                    pageLength: 100,
                    pagingType: 'numbers',
                    columnDefs: [
                        {
                            'targets': 0,
                            'checkboxes': {
                                'selectRow': true
                            }
                        }
                    ],
                    select: {
                        style: 'multi'
                    },
                    bDeferRender: true,
                    ajax: {
                        type: 'GET',
                        url: productTableUrl                   ,
                        data: {
                            product_code: product_code,
                            product_name: product_name
                        }
                    },
                    columns: [
                        {
                            name: 'checkbox',
                            data: 'product_code'
                        },
                        {
                            name: 'product_name',
                            data: 'product_name',
                            className: "text-left"

                        },
                        {
                            name: 'quantity',
                            data: 'quantity',  
                            orderable: false
                        },                        
                        {
                            name: 'price',
                            data: 'price',  
                            orderable: false
                        },
                        {
                            name: 'actions',
                            data: 'actions',
                            orderable: false
                        }
                    ]
                });
            }

            loadProductTable();

            const sortProductTable = sortBy => {
                switch (sortBy) {
                    case 'product_code_asc':
                        productTable.order([0, 'asc']).draw();
                        break;

                    case 'product_code_desc':
                        productTable.order([0, 'desc']).draw();
                        break;

                    case 'price_asc':
                        productTable.order([1, 'asc']).draw();
                        break;

                    case 'price_desc':
                        productTable.order([1, 'desc']).draw();
                        break;

                    case 'quantity_asc':
                        productTable.order([2, 'asc']).draw();
                        break;

                    case 'quantity_desc':
                        productTable.order([2, 'desc']).draw();
                        break;

                    default:
                        productTable.order([0, 'asc']).draw();
                        break;
                }
            }

            $('#__sortByToolbar').on('change', function() {
                let sortByValue = $(this).val();
                sortProductTable(sortByValue);
            });

            $(document).on('click', '#BtnInsertProduct', function(event) {
                event.preventDefault();
        
                $('.modal-insertProduct').show();
                $.ajax({
                    url: '{{ route("form-insert-modal-product") }}',
                    type: 'post',
                    data: {
                        'id': $(this).data('id'),
                        '_token': $('meta[name=csrf-token]').attr('content')
                    }
                }).done(function(result) {                    
                    $('#form-insert-product').html(result);
                });         
            });

            $(document).on('submit', '#form-insert-product', function(event) {
                event.preventDefault();

                var $msgSuccess = $('#form-insert-product #msg-success');
                var $errorList = $('#form-insert-product #error-list');

                // Clear existing errors (if any)
                $errorList.empty();

                var formData = new FormData($(this)[0]);
                console.log(formData);
                $.ajax({
                    url: '{{ route('product.insert') }}',
                    type: 'post',
                    data: formData,
                    contentType: false,
                    processData: false, // Add this line to prevent default processing of FormData
                    success: function(response) {
                        $("#msg-success").html(response.message);                            
                        $msgSuccess.show();
                        // Hide the modal after 3 seconds (1000 ms)
                        setTimeout(function() {
                            //$('#add-product-modal').hide();
                            location.reload();
                        }, 1000);
                        
                    },
                    error: function(error) {
                        $errorList.show();
                        var errorData = error.responseJSON;
                        console.error('result:', errorData.errors);
                        // Display errors on the UI (you can customize how to show these)
                        for (const [key, message] of Object.entries(errorData.errors)) {
                            // Assuming you have a way to show these errors in your UI
                            $errorList.append('<li>' + message + '</li>');                                    
                        }
                    }

                })
            });

            $(document).on('click', '#BtnEditProduct', function(event) {
                event.preventDefault();
        
                $('.modal-editProduct').show();
                $.ajax({
                    url: '{{ route('data product') }}?id=' + $(this).data('id'),
                    type: 'get',
                    data: {
                        'id': $(this).data('id'),
                        '_token': $('meta[name=csrf-token]').attr('content')
                    }
                }).done(function(result) {                    
                    $('#form-edit-product').html(result);
                });         
            });

$(document).on('submit', '#form-edit-product', function(event) {
    event.preventDefault();

    var $msgSuccess = $('#form-edit-product #msg-success');
    var $errorList = $('#form-edit-product #error-list');

    // Clear existing errors (if any)
    $errorList.empty();

    var formData = new FormData($(this)[0]);
    console.log(formData);
    $.ajax({
        url: '{{ route('product.update') }}',
        type: 'post',
        data: formData,
        contentType: false,
        processData: false, // Add this line to prevent default processing of FormData
        success: function(response) {
            $("#msg-success").html(response.message);                            
            $msgSuccess.show();
            // Hide the modal after 3 seconds (1000 ms)
            setTimeout(function() {
                //$('#add-product-modal').hide();
                location.reload();
            }, 1000);
            
        },
        error: function(error) {
            $errorList.show();
            var errorData = error.responseJSON;
            console.error('result:', errorData.errors);
            // Display errors on the UI (you can customize how to show these)
            for (const [key, message] of Object.entries(errorData.errors)) {
                // Assuming you have a way to show these errors in your UI
                $errorList.append('<li>' + message + '</li>');                                    
            }
        }

    })
});


    $(document).on('click', '#BtnDeleteProduct', function(event) {
        event.preventDefault();
  
        $('.modal-deleteProduct').show();
        $.ajax({
            url: '{{ route('form-delete-modal-product') }}',
            type: 'post',
            data: {
                'id': $(this).data('id'),
                '_token': $('meta[name=csrf-token]').attr('content')
            }
        }).done(function(result) {
            $('#form-delete-product').html(result);
        });         
    });

    $(document).on('click', '.__closeModal', function(event) {
        event.preventDefault();
        //$('.modal-update').addClass('modal-hide');
        $('.modalArea').hide(); // Hide the modal
    });


$(document).on('submit', '#form-delete-product', function(event) {
    event.preventDefault();
    var $message = $('#form-delete-product #message');

    var formData = new FormData($(this)[0]);
    //console.log(formData);
    $.ajax({
        url: '{{ route('product.delete') }}',
        type: 'post',
        data: formData,
        contentType: false,
        processData: false, // Add this line to prevent default processing of FormData
        success: function(response) {
            if(response.status==1){
                $("#message").html(response.message);                            
                $message.show();
                // Hide the modal after 3 seconds (1000 ms)
                setTimeout(function() {
                    //$('#add-product-modal').hide();
                    location.reload();
                }, 1000);
            }else{
                $message.show();
                    // Assuming you have a way to show these errors in your UI
                $message.html(response.message);                                    
                
            }
            
            
        },
        error: function(error) {
            $errorList.show();
            var errorData = error.responseJSON;
            console.error('result:', errorData.errors);
            // Display errors on the UI (you can customize how to show these)
            for (const [key, message] of Object.entries(errorData.errors)) {
                // Assuming you have a way to show these errors in your UI
                $errorList.append('<li>' + message + '</li>');                                    
            }
        }

    })
});


            $(document).ready(function() {

                $('#__selectCategoryFilter').select2({
                    placeholder: '- Select Sub Category -',
                    allowClear: true
                });

                $('#__selectTagFilter').select2({
                    placeholder: '- Select Product Tag -',
                    allowClear: true
                });

                $('#__product_code').val('');
                $('#__product_name').val('');
            });

            $('#__btnSubmitFilter').click(function() {
                let product_name = $('#__product_code').val();

                if (product_code != '')
                    alert('Please enter product code to filter');
                else
                    loadProductTable(product_code, product_name);
            });

            $('#__btnResetFilter').on('click',function() {
                loadProductTable();

                $('#__product_code').val('');
                $('#__product_name').val('');
            });

           
            $('.new_form_new').on('submit', function(e) {
                // e.preventdefault();
                console.log(productTable.columns(0).checkboxes.selected());
                var form = this;
                var rows_selected = productTable.column(0).checkboxes.selected();

                $.each(rows_selected, function(index, rowId) {
                    $(form).append(
                        $('<input>')
                            .attr('type', 'hidden')
                            .attr('name', 'product_code[]')
                            .val(rowId)
                    );
                });
            });


            function previewFile(input){
                var preview_div = $("#preview_image_div");
                if($(preview_div).hasClass('hide'))
                {
                    $(preview_div).removeClass('hide');
                    $(preview_div).addClass('show');
                }

                var file = $("#image").get(0).files[0];

                if(file){
                    var reader = new FileReader();
                    reader.onload = function(){
                        $("#previewImg").attr("src", reader.result);
                    }
                    reader.readAsDataURL(file);
                }
            }

            $('#BtnInsert').click(function() {
                $('body').addClass('modal-open');
                $('#__modalInsert').removeClass('modal-hide');
            });

            $('#closeModalInsert').click(function() {
                $('body').removeClass('modal-open');
                $('#__modalInsert').addClass('modal-hide');
            });

            $('#__btnCancelModalInsert').click(function() {
                $('body').removeClass('modal-open');
                $('#__modalInsert').addClass('modal-hide');
            });


            $(document).on('click', '#BtnUpdate', function() {
                $('body').addClass('modal-open');
                $('#__modalUpdate').removeClass('modal-hide');

                $.ajax({
                    url: '{{ route('data product') }}?id=' + $(this).data('id'),
                    beforeSend: function() {
                        $('#form-update').html('Loading');
                    }
                }).done(function(result) {
                    $('#form-update').html(result);
                });
            });

            $('#form-update').on('submit', function(event) {
                event.preventDefault();

                let formData = new FormData($(this)[0]);
                let actionUrl = $(this).attr('action');

                $.ajax({
                    type: 'POST',
                    url: actionUrl,
                    data: formData,
                    processData: false,
                    contentType: false,
                    beforeSend: function() {
                        $('.alert').addClass('hidden');
                        $('#__alertSuccessContent').html(null);
                        $('#__alertDangerContent').html(null);
                    },
                    success: function(responseData) {
                        $('body').removeClass('modal-open');
                        $('#__modalUpdate').addClass('modal-hide');
                        $('#__alertSuccessContent').html(responseData.message);
                        $('#__alertSuccess').removeClass('hidden');
                        $("#product_tag_div_"+responseData.product_id).html(responseData.tagContent);
                    },
                    error: function(error) {
                        $('body').removeClass('modal-open');
                        $('#__modalUpdate').addClass('modal-hide');
                        let responseJson = error.responseJSON;

                        $('#__alertDangerContent').html(responseJson.message);
                        $('#__alertDanger').removeClass('hidden');
                    }
                })
            })


            $(document).on('click', '#BtnDelete', function() {
                let drop = confirm('Are you sure?');
                if (drop) {
                    $.ajax({
                        url: '{{ route('product.delete') }}',
                        type: 'post',
                        data: {
                            'id': $(this).data('id'),
                            '_token': $('meta[name=csrf-token]').attr('content')
                        },
                        beforeSend: function() {
                            // Pesan yang muncul ketika memproses delete
                        }
                    }).done(function(result) {
                        if (result.status === 1) {
                            // Pesan jika data berhasil di hapus
                            alert('Data deleted successfully');
                            $('#datatable').DataTable().ajax.reload();
                        } else {
                            alert(result.message);
                        }
                    });
                }
            });


    

            $(document).on('click', '#closeModalQuantity', function() {
                $('.modal-quantity').addClass('modal-hide');
            });          

             $(document).on('click', '#closeModalOrder', function() {
                $('#modalReserverdOrder').addClass('modal-hide');

            });
        </script>
        <script type="text/javascript">
            $('#BtnImport').click(function() {
                $('.modal-import').removeClass('modal-hide');
            });

            $('#closeModalImport').click(function() {
                $('.modal-import').addClass('modal-hide');
            });



            $(document).on('click', '#closeModalproduct', function() {
                $('.modal-producut').addClass('modal-hide');
                $('body').removeClass('modal-open');
            });
        </script>

    @endpush
</x-app-layout>
