@csrf
<input type="hidden" name='type' value='{{$type}}'>
<link rel="stylesheet" href="{{ asset('chosen/chosen.css')}}">
<div class="px-5 py-4">
    <div class="text-sm">
        <div id='msg-success' class="font-medium text-green-700  dark:text-green-700 mb-3">
        </div>
        <ul id="error-list" class="text-red-500 mb-3"></ul>
    </div>

    <div class="space-y-3">
        <div class="w-full grid gap-5 md:grid-cols-3">
            <div class="shadow-sm rounded-xl">
                <label class="block text-sm font-medium mb-1" for="payment_date">Payment Date</label>
                <input type="text" id="payment_date" class="form-input datepicker-1 w-full" name="payment_date"
                    placeholder="Enter Payment Date" value="" autocomplete="off" />
            </div>

            @if(Auth::user()->role !=='staff')    
                <!-- <div>
                    <label class="block text-sm font-medium mb-1" for="shop_id">Shop <span class="text-red-500">*</span></label>
                    <select id="__unitId" name="shop_id" class="form-select chosen-select rounded w-full py-2">
                        <option value="">Select Unit</option>
                        @if($shops)
                            @foreach($shops as $row)
                            <option value='{{$row->id}}'>{{$row->name}} ({{$row->location}})</option>
                            @endforeach
                        @endif
                    </select>
                </div> -->
            @endif
            
            <!-- Select -->
            <div class="">
                <x-label>{{ __('translation.Employee') }}<x-form.required-mark /></x-label>
                <select name="employee_id" id="employee_id" class="employee chosen-select form-select w-full">
                    <option value="">Select Employee</option>
                        @if($employees)
                            @foreach($employees as $employee)
                                <option value="{{$employee->id}}">
                                    {{$employee->employee_name}}
                                </option>
                            @endforeach
                        @endif
                </select>
            </div>

            <div class="w-full">
                <x-label>
                    {{ __('translation.Payment Method') }}
                </x-label>

                <select id="__payment_method" class="form-select chosen-select w-full" name="payment_method_id">
                    <option disabled selected value="0">
                        - {{ __('translation.Payment Method') }} -
                    </option>
                    @if($payment_methods)
                        @foreach($payment_methods as $pm)
                            <option value="{{$pm->id}}">{{$pm->name}}</option>
                        @endforeach
                    @endif
                </select>
            </div>

        </div>

        <div class="w-full grid gap-5 md:grid-cols-2">
                <div id="_bankOrMobileDetailsWrapper" class="w-full">
                </div>

                <div id="_AccountNoWrapper" class="w-full">
            </div>
        </div>

        <div id="__ajaxFormLoad" class="mt-4 flex flex-wrap items-center space-y-3">
               
        </div>
            

            <div class="w-full">
                <x-label>
                    {{ __('translation.Paid') }}
                </x-label>
                <input type="text" class='w-full form-input' autocomplete="off" onclick="this.select()" name="fake-paid" id="fake-paid" value="">
                <input type="hidden" class='w-full form-input' name="paid" id="paid" value="">
                <div class="mt-4"><strong>Taka In Word:</strong> <span id="takaInWord"></span></div>
            </div>
        </div>

        <div class='mt-2'>
            <label class="block text-sm font-medium mb-1" for="unit_id">Note</label>
            <textarea class="form-textarea w-full p-5" name="notes"></textarea>
        </div>

    </div>
</div>
<!-- Modal footer -->
<div class="px-5 py-4 border-t border-gray-200 dark:border-gray-700/60">
    <div class="flex flex-wrap justify-end space-x-2">
        <button
            class="__closeModal btn-sm border-gray-200 dark:border-gray-700/60 hover:border-gray-300 dark:hover:border-gray-600 text-gray-800 dark:text-gray-300">Cancel</button>
        <button type="submit"
            class="btn-sm bg-gray-900 text-gray-100 hover:bg-gray-800 dark:bg-gray-100 dark:text-gray-800 dark:hover:bg-white">Save</button>
    </div>
</div>



<script>

$(".chosen-select").chosen({no_results_text: "Oops, nothing found!"}); 

$(".datepicker-1").datepicker({
    dateFormat: 'dd-mm-yy'
});



var loadDuePayment = (customer_id = '') => {
    $.ajax({
        url: '{{ route('customer-due') }}',
        type: 'post',
        data: {
            'customer_id': customer_id,
            '_token': $('meta[name=csrf-token]').attr('content')
        }
    }).done(function(result) {
        $('#__previousDue').html(result);
    });
}

loadDuePayment($('#customer_id').val());

$('#customer_id').change(function() {
    loadDuePayment($(this).val());
});

$(document).on('keyup', '#fake-paid', function(event) {
    var input_val = $(this).val();
    input_val = numberToCurrency(input_val);
    $(this).val(input_val);
    var withoutComma = $(this).val().replace(/,/g, "");
    $('#paid').val(withoutComma);
    $('#takaInWord').moneyinwords(withoutComma, 'US', 'USD');
});

$('#__btnSubmitPayment').addClass('hidden');

$('#__payment_method').change(function() {
            if($(this).val()=='1'){
                $("#bank_or_mobile_wallet_id").val('');
                $("#_AccountNoWrapper").html('');
                $("#account_no_id").val('');
                
            }
            $.ajax({
                url: '{{ route('load-bank-or-mobile-dropdown') }}',
                type: 'post',
                data: {
                    'id': $(this).val(),
                    '_token': $('meta[name=csrf-token]').attr('content')
                }
            }).done(function(result) {
                $('#_bankOrMobileDetailsWrapper').html(result);       
            });

        });


$('#bank_or_mobile_wallet_id').on('change', function() {
    $.ajax({
        url: '{{ route('load-bank-or-mobile-account-dropdown') }}',
        type: 'post',
        data: {
            'bank_or_mobile_wallet_id': $(this).val(),
            '_token': $('meta[name=csrf-token]').attr('content')
        }
    }).done(function(result) {
        $('#_AccountNoWrapper').html(result);
    });
});
</script>