<x-app-layout>
    @section('title', ' Payments')

    @push('top_css')
        <link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
        <link type="text/css" href="https://cdn.jsdelivr.net/npm/jquery-datatables-checkboxes@1.2.12/css/dataTables.checkboxes.css" rel="stylesheet" />
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" />
        <link rel="stylesheet" href="{{ asset('css/typeaheadjs.css') }}">

  <link rel="stylesheet" href="{{ asset('chosen/prism.css')}}">
  <link rel="stylesheet" href="{{ asset('chosen/chosen.css')}}">

    @endpush

    <style>
        .table thead th {
            vertical-align: bottom;
            border: 1px solid #2c3545;
            background: #0c1830;
            color: #e1d492;
        }

        .table td, .table th {
            padding: 0.15rem .75rem;
            vertical-align: top;
            border-top: 1px solid #dee2e6;
            font-size: 13px;
        }

        .table td p, .table th p {
            font-size: 12px;
            letter-spacing: 1.5px;
        }
        .font-bold{
            font-weight:600 !important;
        }

        .table td {
            vertical-align: middle;
            border: 1px solid #2c3545;
            position: relative;
        }

        .removeItem {
            padding: .15rem .5rem;
            font-size: 0.675rem;
        }

        td [type=text] {
            padding: 0 5px;
            height: 30px;
            font-weight: 100;
            width: 70px;
            font-size: 12px;
            letter-spacing: 2px;
        }

        #__product_id_QR_scanner {
            box-shadow: inset 0px 1px 6px 0px #000000 !important;
        }

      </style>
    <x-card title="Payments ({{ number_format($paymentCount) }})">
        <div class="mt-6">

            <div class="flex flex-col sm:flex-row sm:justify-between items-start mb-4">
                <div class="w-full md:w-3/5 lg:w-3/5 mb-6 sm:mb-0">
                    <div class="flex flex-col sm:flex-row space-x-2">
                        @if(Auth::user()->role != '') @endif
                        <div>
                            <select id="BtnLoadNewPaymentForm"  name="type" class="form-select w-full" style="padding: .3rem .75rem;">
                                <option value="">New Payment From</option>
                                <option value="supplier">Supplier</option>
                                <option value="deposit">Deposit To Bank</option>
                                <option value="loan">Pay Loan</option>
                                <option value="bank-loan">Pay Bank Loan</option>
                                <option value="salary">Pay Salary</option>
                                <option value="others">Others</option>
                                <option value="partner">Partner</option>
                            </select>
                        </div>

                        <div class="sm:mr-2">
                            <button id='bulk_delete' type='button' class="inline-flex items-center justify-center text-sm font-medium leading-5 rounded px-3 py-1 border border-gray-200 dark:border-gray-700/60 hover:border-gray-300 dark:hover:border-gray-600 shadow-sm bg-red-500/20 text-red-700 transition">Bulk Delete</button>
                        </div>

                        <!-- Select -->
                        <!-- <div class="mb-2">                           
                            <select id="__unitId" name="shop_id" class="form-select w-full">
                                <option value="">Select Unit</option>
                                @if($shops)
                                    @foreach($shops as $row)
                                        <option value='{{$row->id}}'>{{$row->name}} ({{$row->location}})</option>
                                    @endforeach
                                @endif
                            </select>
                        </div> -->
                        
                        
                    </div>
                </div>
            </div>

        </div>
        
       

        <div class="w-full overflow-x-auto">
            <table class="w-full" id="datatable">
                <thead>
                <tr class="rounded-lg text-sm font-medium text-gray-700 text-left">
                    <th></th>
                    <th class="px-4 py-2 text-center">
                        {{ __('translation.Date') }}
                    </th>
                    <th class="px-4 py-2 text-center">
                        {{ __('translation.Type') }}
                    </th>

                    <th class="px-4 py-2 text-center">
                        {{ __('translation.Pay To') }}
                    </th>
                    
                    <th class="px-4 py-2 text-center">
                        {{ __('translation.Payment Method') }}
                    </th>

                    <th class="px-4 py-2 text-center">
                        {{ __('translation.Note') }}
                    </th>

                    <th class="px-4 py-2 text-center">
                        {{ __('translation.Total') }}
                    </th>
                    
                    <th class="px-4 py-2 text-center">
                        {{ __('translation.Actions') }}
                    </th>
                </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>
    </x-card>

    <div class="modalArea modal-insertProduct modal-hide">    
        <div class="overflow-auto fixed  inset-0 z-10 flex items-center justify-center">
            <div class="bg-violet rounded-lg shadow-lg overflow-auto max-w-4xl w-full max-h-full" x-transition:enter="ease-out duration-300" x-transition:enter-start="opacity-0 scale-90" x-transition:enter-end="opacity-100 scale-100">
            
            <!-- Modal header -->
            <div class="px-5 py-3 border-b border-gray-200 dark:border-gray-700/60">
                <div class="flex justify-between items-center">
                    <div class="font-semibold text-gray-800 dark:text-gray-100">Create New</div>
                    <button type='button' class="__closeModal text-gray-400 dark:text-gray-500 hover:text-gray-500 dark:hover:text-gray-400">
                        <div class="sr-only">Close</div>
                        <svg class="fill-current" width="16" height="16" viewBox="0 0 16 16">
                            <path d="M7.95 6.536l4.242-4.243a1 1 0 111.415 1.414L9.364 7.95l4.243 4.242a1 1 0 11-1.415 1.415L7.95 9.364l-4.243 4.243a1 1 0 01-1.414-1.415L6.536 7.95 2.293 3.707a1 1 0 011.414-1.414L7.95 6.536z" />
                        </svg>
                    </button>
                </div>
            </div>

            <form method="POST" id="form-insert-payment" enctype="multipart/form-data">

            </form>

            </div>
        </div>
    </div>
    <div class="modalArea modal-editProduct modal-hide">    
        <div class="overflow-auto fixed  inset-0 z-10 flex items-center justify-center">
            <div class="bg-violet rounded-lg shadow-lg overflow-auto max-w-4xl w-full max-h-full" x-transition:enter="ease-out duration-300" x-transition:enter-start="opacity-0 scale-90" x-transition:enter-end="opacity-100 scale-100">
            
            <!-- Modal header -->
            <div class="px-5 py-3 border-b border-gray-200 dark:border-gray-700/60">
                <div class="flex justify-between items-center">
                    <div class="font-semibold text-gray-800 dark:text-gray-100">Edit Payment</div>
                    <button type='button' class="__closeModal text-gray-400 dark:text-gray-500 hover:text-gray-500 dark:hover:text-gray-400">
                        <div class="sr-only">Close</div>
                        <svg class="fill-current" width="16" height="16" viewBox="0 0 16 16">
                            <path d="M7.95 6.536l4.242-4.243a1 1 0 111.415 1.414L9.364 7.95l4.243 4.242a1 1 0 11-1.415 1.415L7.95 9.364l-4.243 4.243a1 1 0 01-1.414-1.415L6.536 7.95 2.293 3.707a1 1 0 011.414-1.414L7.95 6.536z" />
                        </svg>
                    </button>
                </div>
            </div>

            <form method="POST" id="form-edit-payment" enctype="multipart/form-data">

            </form>

            </div>
            </div>
    </div>

     <!-- DELETE Modal -->        
    <div class="modalArea modal-deleteProduct modal-hide">    
        <div class="overflow-auto fixed  inset-0 z-10 flex items-center justify-center">
            <div class="bg-violet rounded-lg shadow-lg overflow-auto max-w-4xl w-full max-h-full" x-transition:enter="ease-out duration-300" x-transition:enter-start="opacity-0 scale-90" x-transition:enter-end="opacity-100 scale-100">
            
            <!-- Modal header -->
            <div class="px-5 py-3 border-b border-gray-200 dark:border-gray-700/60">
                <div class="flex justify-between items-center">
                    <div class="font-semibold text-gray-800 dark:text-gray-100">Delete Payment</div>
                    <button class="__closeModal text-gray-400 dark:text-gray-500 hover:text-gray-500 dark:hover:text-gray-400">
                        <div class="sr-only">Close</div>
                        <svg class="fill-current" width="16" height="16" viewBox="0 0 16 16">
                            <path d="M7.95 6.536l4.242-4.243a1 1 0 111.415 1.414L9.364 7.95l4.243 4.242a1 1 0 11-1.415 1.415L7.95 9.364l-4.243 4.243a1 1 0 01-1.414-1.415L6.536 7.95 2.293 3.707a1 1 0 011.414-1.414L7.95 6.536z" />
                        </svg>
                    </button>
                </div>
            </div>

            <!-- DELETE Modal content -->
            <form id="form-delete-payment" method="POST"></form>

            </div>
        </div>
    </div>




         <!-- DELETE Modal -->        
         <div class="modalArea modal-deleteBulkPayment modal-hide">    
            <div class="overflow-auto fixed  inset-0 z-10 flex items-center justify-center">
                <div class="bg-violet rounded-lg shadow-lg overflow-auto max-w-lg w-full max-h-full" x-transition:enter="ease-out duration-300" x-transition:enter-start="opacity-0 scale-90" x-transition:enter-end="opacity-100 scale-100">
                
                    <!-- Modal header -->
                    <div class="px-5 py-3 border-b border-gray-200 dark:border-gray-700/60">
                        <div class="flex justify-between items-center">
                            <div class="font-semibold text-gray-800 dark:text-gray-100">Bulk Delete Payment</div>
                            <button class="__closeModal text-gray-400 dark:text-gray-500 hover:text-gray-500 dark:hover:text-gray-400">
                                <div class="sr-only">Close</div>
                                <svg class="fill-current" width="16" height="16" viewBox="0 0 16 16">
                                    <path d="M7.95 6.536l4.242-4.243a1 1 0 111.415 1.414L9.364 7.95l4.243 4.242a1 1 0 11-1.415 1.415L7.95 9.364l-4.243 4.243a1 1 0 01-1.414-1.415L6.536 7.95 2.293 3.707a1 1 0 011.414-1.414L7.95 6.536z" />
                                </svg>
                            </button>
                        </div>
                    </div>

                    <!-- DELETE Modal content -->
                    <form id="form-bulk-delete-payment" method="POST">
                        @csrf
                        <input id="bulk_ids" type="hidden" name="bulk_ids" value="" />

                        <div class="p-5 flex space-x-4" id="message">
                            <!-- Icon -->
                            <div class="w-10 h-10 rounded-full flex items-center justify-center shrink-0 bg-gray-100 dark:bg-gray-700">
                                <svg class="shrink-0 fill-current text-red-500" width="16" height="16" viewBox="0 0 16 16">
                                    <path d="M8 0C3.6 0 0 3.6 0 8s3.6 8 8 8 8-3.6 8-8-3.6-8-8-8zm0 12c-.6 0-1-.4-1-1s.4-1 1-1 1 .4 1 1-.4 1-1 1zm1-3H7V4h2v5z" />
                                </svg>
                            </div>

                            <!-- Content -->
                            <div>
                                <!-- Modal header -->
                                <div class="mb-2">
                                    <div class="text-lg font-semibold text-gray-800 dark:text-gray-100">Delete Selected Items ?</div>
                                </div>
                                <!-- Modal content -->

                                <div class="mb-3 last:mb-0">
                                    <ul class="text-sm">
                                        <li>
                                            <span class="flex items-center p-2 text-gray-800 dark:text-gray-100 hover:bg-gray-100 dark:hover:bg-gray-700/20 rounded-lg" @click="searchOpen = false" @focus="searchOpen = true" @focusout="searchOpen = false">
                                                <svg class="fill-current text-gray-400 dark:text-gray-500 shrink-0 mr-3" width="16" height="16" viewBox="0 0 16 16">
                                                    <path d="M14 0H2c-.6 0-1 .4-1 1v14c0 .6.4 1 1 1h8l5-5V1c0-.6-.4-1-1-1zM3 2h10v8H9v4H3V2z"></path>
                                                </svg>
                                                <span>
                                                    <span class="font-medium">Total Items :</span> &nbsp; 
                                                    <span id='selected_items' class="text-gray-600 dark:text-gray-400"></span>
                                                </span>
                                            </span>
                                        </li>
                                    </ul>
                                </div>
                                <div class="text-sm mb-10">
                                    <div class="space-y-2 text-gray-600 dark:text-gray-400">
                                        <p>If you confirm then it will be removed.</p>
                                    </div>
                                </div>                                   

                                <!-- Modal footer -->
                                <div class="flex flex-wrap justify-end space-x-2">
                                    <button type="button" class="__closeModal btn-sm border-gray-200 dark:border-gray-700/60 hover:border-gray-300 dark:hover:border-gray-600 text-gray-800 dark:text-gray-300">Cancel</button>
                                    <button type="submit" class="btn-sm bg-red-500 hover:bg-red-600 text-white">Yes, Delete it</button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>




@push('bottom_js')


    <script src="https://cdn.jsdelivr.net/npm/typeahead.js@0.11.1/dist/typeahead.bundle.min.js"></script>
    <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>    
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.0/jquery.validate.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/jquery-datatables-checkboxes@1.2.12/js/dataTables.checkboxes.min.js"></script>
    
    <script src="{{ asset('js/lc_select.js') }}"></script>
    <script src="{{ asset('chosen/chosen.jquery.js')}}" type="text/javascript"></script>
    <script src="{{ asset('chosen/init.js')}}" type="text/javascript" charset="utf-8"></script>

        <script>
          $(".chosen-select").chosen({no_results_text: "Oops, nothing found!"});   
            const dataTableUrl = '{{ route('data payments') }}';
            var receive_paymentTable = '';

            const loadProductTable = () => {
                receive_paymentTable = $('#datatable').DataTable({
                    "autoWidth": false, // might need this
                    processing: true,
                    serverSide: true,
                    bDestroy: true,
                    pageLength: 100,
                    pagingType: 'numbers',
                    columnDefs: [
                        {
                            'targets': 0,
                            'checkboxes': {
                                'selectRow': true
                            }
                        }
                    ],
                    select: {
                        style: 'multi'
                    },
                    bDeferRender: true,
                    ajax: {
                        type: 'GET',
                        url: dataTableUrl                   ,
                        data: {
                            statusId: $('#__statusId').val(),
                            unitId: $('#__unitId').val(),
                        }
                    },
                    columns: [
                        {
                            name: 'checkbox',
                            data: 'id'
                        },
                        {
                            name: 'date',
                            data: 'date',
                            width: "110px" ,
                            className: "text-left" ,
                            orderable: true
                        },
                        {
                            name: 'type',
                            data: 'type',
                            className: "text-left" ,
                            orderable: true
                        },
                        {
                            name: 'from',
                            data: 'from',
                            className: "text-left" ,
                            orderable: true
                        },
                        {
                            name: 'payment_method',
                            data: 'payment_method',  
                            orderable: true
                        },                      
                        {
                            name: 'note',
                            data: 'note',  
                            orderable: true
                        },                                               
                        {
                            name: 'paid',
                            data: 'paid',  
                            orderable: true
                        },
                        {
                            name: 'actions',
                            data: 'actions',
                            orderable: false
                        }
                    ]
                });
            }

            loadProductTable();

            const sortProductTable = sortBy => {
                switch (sortBy) {
                    case 'part_no_asc':
                        receive_paymentTable.order([0, 'asc']).draw();
                        break;

                    case 'part_no_desc':
                        receive_paymentTable.order([0, 'desc']).draw();
                        break;

                    case 'price_asc':
                        receive_paymentTable.order([1, 'asc']).draw();
                        break;

                    case 'price_desc':
                        receive_paymentTable.order([1, 'desc']).draw();
                        break;

                    case 'quantity_asc':
                        receive_paymentTable.order([2, 'asc']).draw();
                        break;

                    case 'quantity_desc':
                        receive_paymentTable.order([2, 'desc']).draw();
                        break;

                    default:
                        receive_paymentTable.order([0, 'asc']).draw();
                        break;
                }
            }

            $('#__sortByToolbar').on('change', function() {
                let sortByValue = $(this).val();
                sortProductTable(sortByValue);
            });

            $(".__statusFilter button").click(function() {
                $('.__statusFilter button').removeClass('active');
                $(this).addClass('active');
                $('#__statusId').val($(this).data('status_id'));
                loadProductTable();
            });

            $('#__unitId').on('change', function() {
                loadProductTable();
            });



            $(document).on('change', '#BtnLoadNewPaymentForm', function(event) {
                event.preventDefault();
                $('.modal-insertProduct').show();
                $.ajax({
                    url: '{{ route("form-insert-modal-payment") }}?type=' + $(this).val(),
                    type: 'GET',
                    data: {
                        'id': $(this).data('id'),
                        '_token': $('meta[name=csrf-token]').attr('content')
                    }
                }).done(function(result) {                    
                    $('#form-insert-payment').html(result);
                });         
            });

            $(document).on('submit', '#form-insert-payment', function(event) {
                event.preventDefault();

                var $msgSuccess = $('#form-insert-payment #msg-success');
                var $errorList = $('#form-insert-payment #error-list');

                // Clear existing errors (if any)
                $errorList.empty();

                var formData = new FormData($(this)[0]);                
                $.ajax({
                    url: '{{ route('payment.insert') }}',
                    type: 'post',
                    data: formData,
                    contentType: false,
                    processData: false, // Add this line to prevent default processing of FormData
                    success: function(response) {
                        $("#msg-success").html(response.message);                            
                        $msgSuccess.show();
                        // Hide the modal after 3 seconds (1000 ms)
                        setTimeout(function() {
                            //$('#add-payment-modal').hide();
                            location.reload();
                        }, 1000);
                        
                    },
                    error: function(error) {
                        $errorList.show();
                        var errorData = error.responseJSON;
                        console.error('result:', errorData.errors);
                        // Display errors on the UI (you can customize how to show these)
                        for (const [key, message] of Object.entries(errorData.errors)) {
                            // Assuming you have a way to show these errors in your UI
                            $errorList.append('<li>' + message + '</li>');                                    
                        }
                    }

                })
            });

            $(document).on('click', '#BtnEditProduct', function(event) {
                event.preventDefault();
                $('.modal-editProduct').show();
                $.ajax({
                    url: '{{ route('data payments') }}?id=' + $(this).data('id')+'&type=' + $(this).data('type'),
                    type: 'get',
                    data: {
                        'id': $(this).data('id'),
                        '_token': $('meta[name=csrf-token]').attr('content')
                    }
                }).done(function(result) {                    
                    $('#form-edit-payment').html(result);
                });         
            });

            $(document).on('submit', '#form-edit-payment', function(event) {
                event.preventDefault();

                var $msgSuccess = $('#form-edit-payment #msg-success');
                var $errorList = $('#form-edit-payment #error-list');

                // Clear existing errors (if any)
                $errorList.empty();

                var formData = new FormData($(this)[0]);
                console.log(formData);
                $.ajax({
                    url: '{{ route('payment.update') }}',
                    type: 'post',
                    data: formData,
                    contentType: false,
                    processData: false, // Add this line to prevent default processing of FormData
                    success: function(response) {
                        $("#msg-success").html(response.message);                            
                        $msgSuccess.show();
                        // Hide the modal after 3 seconds (1000 ms)
                        setTimeout(function() {
                            //$('#add-payment-modal').hide();
                            location.reload();
                        }, 1000);
                        
                    },
                    error: function(error) {
                        $errorList.show();
                        var errorData = error.responseJSON;
                        console.error('result:', errorData.errors);
                        // Display errors on the UI (you can customize how to show these)
                        for (const [key, message] of Object.entries(errorData.errors)) {
                            // Assuming you have a way to show these errors in your UI
                            $errorList.append('<li>' + message + '</li>');                                    
                        }
                    }

                })
            });


            $(document).on('click', '#BtnDeleteProduct', function(event) {
                event.preventDefault();
        
                $('.modal-deleteProduct').show();
                $.ajax({
                    url: '{{ route('form-delete-modal-payment') }}',
                    type: 'post',
                    data: {
                        'id': $(this).data('id'),
                        '_token': $('meta[name=csrf-token]').attr('content')
                    }
                }).done(function(result) {
                    $('#form-delete-payment').html(result);
                });         
            });

            $(document).on('click', '.__closeModal', function(event) {
                event.preventDefault();
                //$('.modal-update').addClass('modal-hide');
                $('.modalArea').hide(); // Hide the modal
            });


            $(document).on('submit', '#form-delete-payment', function(event) {
                event.preventDefault();
                var $message = $('#form-delete-payment #message');

                var formData = new FormData($(this)[0]);
                //console.log(formData);
                $.ajax({
                    url: '{{ route('payment.delete') }}',
                    type: 'post',
                    data: formData,
                    contentType: false,
                    processData: false, // Add this line to prevent default processing of FormData
                    success: function(response) {
                        if(response.status==1){
                            $("#message").html(response.message);                            
                            $message.show();
                            // Hide the modal after 3 seconds (1000 ms)
                            setTimeout(function() {
                                //$('#add-payment-modal').hide();
                                location.reload();
                            }, 1000);
                        }else{
                            $message.show();
                                // Assuming you have a way to show these errors in your UI
                            $message.html(response.message);                                    
                            
                        }
                        
                        
                    },
                    error: function(error) {
                        $errorList.show();
                        var errorData = error.responseJSON;
                        console.error('result:', errorData.errors);
                        // Display errors on the UI (you can customize how to show these)
                        for (const [key, message] of Object.entries(errorData.errors)) {
                            // Assuming you have a way to show these errors in your UI
                            $errorList.append('<li>' + message + '</li>');                                    
                        }
                    }

                })
            });


            $(document).on('click', '#bulk_delete', function() {

                var rows_selected = $('#datatable').DataTable().column(0).checkboxes.selected();

                var arr = [];
                $.each(rows_selected, function(index, rowId){
                    arr[index]=rowId;
                                //datatable.cell(index,8).data(status);
                            });

    

                if(arr.length === 0){
                    alert("Please select at least 1 row");
                    return;
                }else{
                    $('.modal-deleteBulkPayment').show();
                    $("#bulk_ids").val(arr);                   
                    $("#selected_items").text(arr.length);
                }               
                });


                $(document).on('submit', '#form-bulk-delete-payment', function(event) {
                event.preventDefault();
                var $message = $('#form-bulk-delete-payment #message');

                var formData = new FormData($(this)[0]);
                //console.log(formData);
                $.ajax({
                    url: '{{ route('bulk-delete-payment') }}',
                    type: 'post',
                    data: formData,
                    contentType: false,
                    processData: false, // Add this line to prevent default processing of FormData
                    success: function(response) {
                        if(response.status==1){
                            $message.html(response.message);                            
                            $message.show();
                            // Hide the modal after 3 seconds (1000 ms)
                            setTimeout(function() {
                                //$('#add-payment-modal').hide();
                                location.reload();
                            }, 1000);
                        }else{
                            $message.show();
                                // Assuming you have a way to show these errors in your UI
                            $message.html(response.message);                                    
                            
                        }
                        
                        
                    },
                    error: function(error) {
                        $errorList.show();
                        var errorData = error.responseJSON;
                        console.error('result:', errorData.errors);
                        // Display errors on the UI (you can customize how to show these)
                        for (const [key, message] of Object.entries(errorData.errors)) {
                            // Assuming you have a way to show these errors in your UI
                            $errorList.append('<li>' + message + '</li>');                                    
                        }
                    }

                })
            });



        </script>


    @endpush
</x-app-layout>
