<x-app-layout>
    @section('title')
    {{ __('translation.Customer Report') }}
    @endsection

    @push('top_css')
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/jquery-ui-dist@1.12.1/jquery-ui.min.css">
    <link rel="stylesheet"
        href="https://cdn.jsdelivr.net/npm/jquery-datatables-checkboxes@1.2.12/css/dataTables.checkboxes.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.19/dist/sweetalert2.min.css">
    
    <link rel="stylesheet" href="{{ asset('css/custom_css.css') }}">
    @endpush

    @push('bottom_css')
    <link rel="stylesheet" href="{{ asset('css/datatable-custom-toolbar.css?_=' . rand()) }}">

    <style>
    .summary tr td {
        padding: 0.5rem !important;
        border: 1px solid #9d9696;
    }

    .grand_total td {
        background: #a3ffeb;
        border: 1px solid #9d9696;
    }

    .cash {
        background: #ffffb6 !important;
    }
    </style>
    @endpush
    <x-card class="mt-0">
        <div class="" style="margin-top: -2rem">
            <a href="{{route('partner.manage')}}">
                <button
                    class="btn mb-3 mr-2 {{ isset($title) && $title=='Owner' ? 'text-white bg-blue-500' : 'bg-gray-200 border' }}">Manage
                    Owner</button>
            </a>
            <a href="{{route('investment.manage')}}">
                <button
                    class="btn mb-3 mr-2 {{ isset($title) && $title=='Investment' ? 'text-white bg-blue-500' : 'bg-gray-200 border' }}">Investment</button>
            </a>
            <a href="{{route('partner.profit')}}">
                <button
                    class="btn mb-3 mr-2 {{ isset($title) && $title=='Profit' ? 'text-white bg-blue-500' : 'bg-gray-200 border' }}">Profit</button>
            </a>

        </div>
        <hr>

        <div class="col-span-12">

            <div class="md:flex md:justify-between md:items-center">
                <div class="w-full sm:col-span-1 lg:col-span-4 grid grid-cols-1 lg:grid-cols-1 gap-4 sm:gap-x-8 px-5 sm:mx-auto">
                    <h1 class="text-xl text-gray-800 font-bold leading-tight">Profit</h1>
                </div>
            </div>




            @php
            $arrCashOut = array();
            $arrCashIn = array();
            @endphp
            @if($cashIn)
            @foreach ($cashIn as $row)
            @php
            $arrCashIn[$row->type][$row->payment_method->name]= $row->total;
            @endphp
            @endforeach

            @endif

            @if($cashOut)
            @foreach ($cashOut as $row)
            @php
            $payment_method = $row->payment_method ? $row->payment_method->name : 'Cash';
            $arrCashOut[$row->type][$payment_method]=$row->total;
            @endphp
            @endforeach
            @endif


            <div
                class="w-full sm:col-span-1 lg:col-span-4 grid grid-cols-1 lg:grid-cols-1 gap-4 sm:gap-x-8 px-5 sm:mx-auto">

                <div class="nav justify-content-center grid grid-cols-1">
                    <div class="flex flex-row items-center justify-between mb-2">
                        <h2 class="block whitespace-nowrap text-green-500 text-base font-bold">
                            Cash In
                        </h2>
                        <hr
                            class="w-full ml-3 relative -top-1 border border-r-0 border-b-0 border-l-0 border-yellow-300">
                    </div>
                    <table class="summary">
                        <tr class="nav-item border border-solid border-gray-300 rounded-md bg-green-200">
                            <td style="width:25%"><strong>Type</strong></td>
                            <td style="width:10%" class="cash text-right"><strong>Cash</strong></td>
                            <td style="width:10%" class="text-right"><strong>Banking</strong></td>
                            <td style="width:10%" class="text-right"><strong>Mobile Banking</strong></td>
                            <td style="width:10%" class="text-right"><strong>Total</strong></td>
                        </tr>
                        @php
                        $arr_cash_in_total = array() ;
                        $arr_banking_in_total = array() ;
                        $arr_banking_in_total = array() ;
                        $arr_mobile_banking_in_total = array() ;
                        @endphp
                        @if($arrCashIn)
                        @foreach ($arrCashIn as $type=>$payment)

                        <tr class="nav-item border border-solid border-gray-300 rounded-md bg-green-200">
                            <td>
                                @if($type=='')
                                From Customer
                                @else
                                {{ ucwords(str_replace("_"," ",$type))}}
                                @endif

                            </td>
                            <td class="cash text-right">
                                @isset($payment['Cash'])
                                {{ number_format($payment['Cash'],2)}}
                                @endisset
                            </td>
                            <td class="text-right">
                                @isset($payment['Banking'])
                                {{ number_format($payment['Banking'],2)}}
                                @endisset
                            </td>
                            <td class="text-right">
                                @isset($payment['Mobile Banking'])
                                {{ number_format($payment['Mobile Banking'],2)}}
                                @endisset
                            </td>
                            <td class="text-right">
                                @php
                                $total = 0 ;
                                if(isset($payment['Cash'])){
                                $total += $payment['Cash'];
                                }
                                if(isset($payment['Banking'])){
                                $total += $payment['Banking'];
                                }
                                if(isset($payment['Mobile Banking'])){
                                $total += $payment['Mobile Banking'];
                                }
                                @endphp
                                {{number_format($total,2)}}
                            </td>
                        </tr>

                        @php
                        if(isset($payment['Cash'])){
                        $arr_cash_in_total[] = $payment['Cash'];
                        }
                        if(isset($payment['Banking'])){
                        $arr_banking_in_total[] = $payment['Banking'];
                        }
                        if(isset($payment['Mobile Banking'])){
                        $arr_mobile_banking_in_total[] = $payment['Mobile Banking'];
                        }
                        @endphp
                        @endforeach
                        @endif

                        <tr class="grand_total nav-item border border-solid border-gray-300 rounded-md bg-green-200">
                            <td><strong>Total</strong></td>
                            <td class="cash text-right">
                                <strong>{{ number_format(array_sum($arr_cash_in_total),2) }}</strong>
                            </td>
                            <td class="text-right">
                                <strong>{{number_format(array_sum($arr_banking_in_total),2) }}</strong>
                            </td>
                            <td class="text-right">
                                <strong>{{number_format(array_sum($arr_mobile_banking_in_total),2)}}</strong>
                            </td>
                            <td class="text-right">
                                <strong>{{number_format(array_sum($arr_cash_in_total)+array_sum($arr_banking_in_total)+array_sum($arr_mobile_banking_in_total),2)}}
                                </strong>
                            </td>
                        </tr>

                    </table>
                </div>

                <div class="nav justify-content-center grid grid-cols-1">
                    <div class="flex flex-row items-center justify-between mb-2">
                        <h2 class="block whitespace-nowrap text-red-500 text-base font-bold">
                            Cash Out
                        </h2>
                        <hr
                            class="w-full ml-3 relative -top-1 border border-r-0 border-b-0 border-l-0 border-yellow-300">
                    </div>
                    <table class="summary">
                        <tr class="nav-item border border-solid border-gray-300 rounded-md bg-red-200">
                            <td style="width:25%"><strong>Type</strong></td>
                            <td style="width:10%" class="cash text-right"><strong>Cash</strong></td>
                            <td style="width:10%" class="text-right"><strong>Banking</strong></td>
                            <td style="width:10%" class="text-right"><strong>Mobile Banking</strong></td>
                            <td style="width:10%" class="text-right"><strong>Total</strong></td>
                        </tr>
                        @php
                        $arr_cash_out_total = array() ;
                        $arr_banking_out_total = array() ;
                        $arr_mobile_banking_out_total = array() ;
                        @endphp
                        @if($arrCashOut)
                        @foreach ($arrCashOut as $type=>$payment)
                        <tr class="nav-item border border-solid border-gray-300 rounded-md bg-red-200">
                            <td>{{ ucwords(str_replace("_"," ",$type))}}</td>
                            <td class="cash text-right">
                                @isset($payment['Cash'])
                                {{ number_format($payment['Cash'],2)}}
                                @endisset
                            </td>
                            <td class="text-right">
                                @isset($payment['Banking'])
                                {{ number_format($payment['Banking'],2)}}
                                @endisset
                            </td>
                            <td class="text-right">
                                @isset($payment['Mobile Banking'])
                                {{ number_format($payment['Mobile Banking'],2)}}
                                @endisset
                            </td>
                            <td class="text-right">
                                @php
                                $total = 0 ;
                                if(isset($payment['Cash'])){
                                $total += $payment['Cash'];
                                }
                                if(isset($payment['Banking'])){
                                $total += $payment['Banking'];
                                }
                                if(isset($payment['Mobile Banking'])){
                                $total += $payment['Mobile Banking'];
                                }
                                @endphp
                                {{number_format($total,2)}}
                            </td>
                        </tr>

                        @php
                        if(isset($payment['Cash'])){
                        $arr_cash_out_total[] = $payment['Cash'];
                        }
                        if(isset($payment['Banking'])){
                        $arr_banking_out_total[] = $payment['Banking'];
                        }
                        if(isset($payment['Mobile Banking'])){
                        $arr_mobile_banking_out_total[] = $payment['Mobile Banking'];
                        }
                        @endphp

                        @endforeach
                        @endif

                        @if($expenses)
                        @foreach ($expenses as $expense)
                        <tr class="nav-item border border-solid border-gray-300 rounded-md bg-red-200">
                            <td>Expense</td>
                            <td class="cash text-right">
                                @isset($expense->total)
                                {{ $expense->total}}
                                @endisset
                            </td>
                            <td class="text-right">

                            </td>
                            <td class="text-right">

                            </td>
                            <td class="text-right">
                                @php
                                $total = 0 ;
                                if(isset($payment['Cash'])){
                                $total += $expense->total;
                                }
                                @endphp
                                {{number_format($total,2)}}
                            </td>
                        </tr>

                        @php
                        if(isset($expense->total)){
                        $arr_cash_out_total[] = $expense->total;
                        }
                        @endphp

                        @endforeach
                        @endif
                        <tr class="grand_total nav-item border border-solid border-gray-300 rounded-md bg-green-200">
                            <td><strong>Total</strong></td>
                            <td class="cash text-right">
                                <strong>{{array_sum($arr_cash_out_total) > 0 ? number_format(array_sum($arr_cash_out_total),2) : ''}}</strong>
                            </td>
                            <td class="text-right">
                                <strong>{{array_sum($arr_banking_out_total) > 0 ? number_format(array_sum($arr_banking_out_total),2) : ''}}</strong>
                            </td>
                            <td class="text-right">
                                <strong>{{array_sum($arr_mobile_banking_out_total) > 0 ? number_format(array_sum($arr_mobile_banking_out_total),2) : ''}}</strong>
                            </td>
                            <td class="text-right">
                                <strong>{{number_format(array_sum($arr_cash_out_total)+array_sum($arr_banking_out_total)+array_sum($arr_mobile_banking_out_total),2)}}
                                </strong>
                            </td>
                        </tr>

                        <tr class="nav-item border border-solid  rounded-md" style="background:#f3dd72 !important">
                            <td colspan=1><strong>Cash In Hand</strong></td>
                            <td class="text-right"><strong>{{
                            number_format((array_sum($arr_cash_in_total)) - (array_sum($arr_cash_out_total)),2)
                        }} </strong>
                            </td>
                            <td colspan=2 class="text-right"><strong>Total Profit/Loss</strong></td>
                            <td class="text-right">
                                @php
                                $total_profit_or_loss =
                                array_sum($arr_cash_in_total)+array_sum($arr_banking_in_total)+array_sum($arr_mobile_banking_in_total)-array_sum($arr_cash_out_total)-array_sum($arr_banking_out_total)-array_sum($arr_mobile_banking_out_total);
                                @endphp
                                <strong>
                                    {{number_format($total_profit_or_loss,2)}}
                                </strong>
                            </td>
                        </tr>
                    </table>
                </div>

                @php
                $total_investment = 0;
                $partners = array();
                if($investment){
                foreach($investment as $row){
                $partners[$row->partner->name][] = $row->amount;
                $total_investment += $row->amount;
                }

                $arr_inv = [];
                $arr_inv_percentage = [];
                foreach($partners as $partner_name=>$arr_investment){
                $partner_investment = array_sum($arr_investment);
                $arr_inv[$partner_name] = $partner_investment;
                $arr_inv_percentage[$partner_name] =
                number_format(((float)($partner_investment/$total_investment)*100),2);
                }
                }
                @endphp
                <div class="nav justify-content-center grid grid-cols-1">
                    <div class="flex flex-row items-center justify-between mb-2">
                        <h2 class="block whitespace-nowrap text-red-500 text-base font-bold">
                            Profit/Loss
                        </h2>
                        <hr
                            class="w-full ml-3 relative -top-1 border border-r-0 border-b-0 border-l-0 border-yellow-300">
                    </div>

                    <p><strong>Total Investment : {{number_format($total_investment,2)}}</strong> </p>
                    <p><strong>Total Profit/Loss : {{number_format($total_profit_or_loss,2)}}</strong> </p>
                    <table class="summary">
                        <tr class="nav-item border border-solid border-gray-300 rounded-md" style="background:#9bd5ff">
                            <td style="width:15%"><strong>Partner's Name</strong></td>
                            <td style="width:10%" class="cash text-right"><strong>Investment</strong></td>
                            <td style="width:10%" class="text-right"><strong>Percentage</strong></td>
                            <td style="width:10%" class="text-right"><strong>Profit/Loss</strong></td>
                            <td style="width:10%" class="text-right"><strong>Receive/Withdraw</strong></td>
                            <td style="width:15%" class="text-right"><strong>Available Balance</strong></td>
                        </tr>
                        @if($arr_inv_percentage)
                        @foreach($arr_inv_percentage as $partner_name=>$investment_percentage)
                        <tr class="nav-item border border-solid border-gray-300 rounded-md bg-green-200">
                            <td style="width:25%">{{$partner_name}}</td>
                            <td style="width:10%" class="cash text-right">{{number_format($arr_inv[$partner_name],2)}}
                            </td>
                            <td style="width:10%" class="text-right">{{$investment_percentage}}%</td>
                            <td style="width:10%" class="text-right">
                                @php
                                $profit_loss = $total_profit_or_loss * ($investment_percentage/100);
                                @endphp
                                {{number_format($profit_loss,2)}}
                            </td>
                            <td style="width:10%" class="text-right">
                                @isset($arr_payments[$partner_name])
                                {{number_format($arr_payments[$partner_name],2)}}
                                @endisset
                            </td>
                            <td style="width:10%" class="text-right">
                                @if(!empty($arr_payments[$partner_name]))
                                {{number_format(($profit_loss-$arr_payments[$partner_name]),2)}}
                                @else
                                {{number_format($profit_loss,2)}}
                                @endif
                            </td>
                        </tr>
                        @endforeach
                        @endif
                    </table>
                </div>
            </div>
        </div>
    </x-card>


    @push('bottom_js')
    <script src="https://cdn.jsdelivr.net/npm/jquery-ui-dist@1.12.1/jquery-ui.min.js"></script>
    
    <script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js">
    </script>
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
    @endpush

</x-app-layout>