
<x-app-layout>

    @section('title')
    Invoice
    @endsection

    @push('top_css')
    <link rel="stylesheet" href="{{ asset('css/money-receipt.css') }}">
    <style>
      td {
          color: #000 !important;
          font-size: 13px;
      }
      </style>
 
@endpush

<div class="px-4 sm:px-6 lg:px-8 py-8 w-full max-w-9xl mx-auto">

        <div class="flex flex-col sm:flex-row sm:justify-between items-start mb-4">
            <div class="text-center">
                <!-- Start -->
                <ul class="inline-flex flex-wrap text-sm font-medium">
                    <li class="flex items-center">
                        <a class="text-gray-500 dark:text-gray-400 hover:text-violet-500 dark:hover:text-violet-500" href="{{route('order_managements')}}">Sales</a>
                        <svg class="fill-current text-gray-400 dark:text-gray-600 mx-3" width="16" height="16" viewBox="0 0 16 16">
                            <path d="M6.6 13.4L5.2 12l4-4-4-4 1.4-1.4L12 8z"></path>
                        </svg>
                    </li>
                    <li class="flex items-center">
                        <span class="text-gray-500 dark:text-gray-400">Delivery Note</span>
                    </li>
                </ul>
                <!-- End -->
            </div>
                   
          </div>
        </div>



 

        <div class='certificate relative' style='width:950px;'>

        
        <div id="print-area"  class="tm_container">
        <div class="tm_invoice_wrap">
          <table>
              
              <thead>
      
                <tr>
                    <td colspan=7 class="tm_text_center"><h2>Delivery Note</h2></td>
                </tr>
      
                <tr>
                    <td colspan=2 rowspan='2'>
                      <strong>M/S Moun Enterprise</strong><br>
                      <strong>Office:</strong> Meghna Ferighat,Bhairab,Kishoreganj.<br>
                      <strong>Contact:</strong> +8801812-*****<br>
                      <strong>E-Mail:</strong> mounent@gmail.com
                    </td>
                    <td colspan=3 class="">Invoice No <br> <strong>{{$invoiceNo}}</strong></td>
                    <td colspan=2 class="">Dated <br> <strong>{{date("d M Y")}}</strong></td>
                </tr>
                <tr>
                    <td colspan=3 class="">Buyer's Order No <br> <strong>BO-{{$deliveryChallan->order_managements->id}}</strong></td>
                    <td colspan=2 class="">Dated <br> <strong>{{ $deliveryChallan->order_managements->order_date != null ? date('d M Y', strtotime($deliveryChallan->order_managements->order_date)) : '';}}</strong></td>
                </tr>
      
                <tr>
                    <td colspan=2 rowspan='2'>
                      Buyer (Bill To)<br>
                      <strong>  {{$deliveryChallan->customer->company_name !=null ? $deliveryChallan->customer->company_name : $deliveryChallan->customer->customer_name}}</strong><br>
                      <strong>Office:</strong>{{$deliveryChallan->customer->address}}<br>
                      <strong>Contact:</strong> {{$deliveryChallan->customer->phone}}<br>
                      <strong>E-Mail:</strong> {{ !empty($deliveryChallan->customer->email) ? $deliveryChallan->customer->email : 'N/A'}} <br>
                    </td>
                    <td colspan=3 class="">
                      Dispatch Through <br> <strong>Vehicle </strong>
                      @if($deliveryChallan->vehicle_no) <strong> #</strong> {{$deliveryChallan->vehicle_no}} &nbsp;@endif 
                      @if($deliveryChallan->chassis_no) <strong>, Chassis #</strong> {{$deliveryChallan->chassis_no}} &nbsp;@endif 
                  </td>
                    <td colspan=2 class="">Destination <br> <strong>{{$deliveryChallan->destination}}</strong></td>
                </tr>
                <tr>
                    <td colspan=5 class="">
                      @if($deliveryChallan->driver_name) <strong> Driver Name : </strong> {{$deliveryChallan->driver_name}} &nbsp;@endif 
                      @if($deliveryChallan->driver_mobile_no) <strong> Mobile : </strong> {{$deliveryChallan->driver_mobile_no}} &nbsp;@endif 
                      @if($deliveryChallan->driving_lic_no) <strong> License No : </strong> {{$deliveryChallan->driving_lic_no}} &nbsp;@endif 
                    </td>
                </tr>
      
                  <tr>
                      <th class="tm_text_center" style='width: 40px;'>SL.</th>
                      <th class="tm_text_center">Description of Products</th>
                      <th style='width: 85px;' class="tm_text_center">Weight</th>
                      <th style='width: 70px;' class="tm_text_center"></th>
                      <th style='width: 60px;' class="tm_text_center"></th>
                      <th style='width: 90px;' class="tm_text_center">Quantity</th>
                      <th style='width: 90px;' class="tm_text_center"></th>
                  </tr>
              </thead>
              <tbody>
                    @php 
                        $totalQty = 0;
                        $totalAmount = 0;
                      @endphp

                      @if($deliveryChallan->delivery_challan_details)
                        @foreach($deliveryChallan->delivery_challan_details as $item)
                          @php 
                              $totalQty +=$item->quantity;
                              $totalAmount +=$item->quantity*$item->price;
                          @endphp
                  <tr>
                      <td  class="tm_text_center">{{ $loop->iteration }}</td>
                      <td class="tm_text_center">{{$item->product->product_name}}</td>
                      <td class="tm_text_center">TON</td>
                      <td class="tm_text_center"></td>
                      <td class="tm_text_center"></td>
                      <td class="tm_text_center">{{$item->quantity}}</td>
                      <td class="tm_text_center"></td>
                  </tr>

                  @endforeach
                  @endif
                  <tr>
                      <td colspan=5 class="tm_text_right"><strong>Total</strong></td>
                      <td colspan=1 class="tm_text_center"><strong>{{$totalQty}}</strong></td>
                      <td class="tm_text_center"></td>
                      
                  </tr>

                  <tr>
                    <td colspan=7 class="">
                      <br/>                      
                      <br/>
                      <br/>
                      <br/>
                      <br/>
                      <br/>
                      <br/>
                      <br/>
                      
                    </td>
                </tr>

                <tr>
                      <td colspan=2 class="">
                        <br/>
                        Customer's Seal & Signature                        
                        <br/>
                        <br/>
                        <br/>
                        <br/>
                        <br/>
                      </td>
                      <td colspan=5 class="tm_text_center">
                        <br/>
                        For Moun Enterprise
                        <br/>
                        <br/>
                        <br/>
                        <br/>
                        Authorized Signatory<br/>
                      </td>
                  </tr>

              </tbody>
          </table>
        </div>

      </div><!-- End print-area-->
      <div class="tm_invoice_btns tm_hide_print">
        <a href="javascript:printDiv('print-area');" class="tm_invoice_btn tm_color1">
          <span class="tm_btn_icon">
            <svg xmlns="http://www.w3.org/2000/svg" class="ionicon" viewBox="0 0 512 512"><path d="M384 368h24a40.12 40.12 0 0040-40V168a40.12 40.12 0 00-40-40H104a40.12 40.12 0 00-40 40v160a40.12 40.12 0 0040 40h24" fill="none" stroke="currentColor" stroke-linejoin="round" stroke-width="32"></path><rect x="128" y="240" width="256" height="208" rx="24.32" ry="24.32" fill="none" stroke="currentColor" stroke-linejoin="round" stroke-width="32"></rect><path d="M384 128v-24a40.12 40.12 0 00-40-40H168a40.12 40.12 0 00-40 40v24" fill="none" stroke="currentColor" stroke-linejoin="round" stroke-width="32"></path><circle cx="392" cy="184" r="24" fill="currentColor"></circle></svg>
          </span>
          Print   
          <span class="tm_btn_text">Print</span>
        </a>
      </div>
      </div>


</div><!-- End -->

<iframe id="printing-frame" name="print_frame" src="about:blank" style="display:none;"></iframe>


@push('bottom_js')
<script src="https://cdn.jsdelivr.net/npm/typeahead.js@0.11.1/dist/typeahead.bundle.min.js"></script>
<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script> 

<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>

<script>
    function printDiv(elementId) {
    var styleSheetLink = `<link rel="stylesheet" type="text/css" href="{{asset('css/print-money-receipt.css')}}">`;
    var content = document.getElementById(elementId).innerHTML;
    var printFrame = document.getElementById("printing-frame");

    if (!printFrame) {
        console.error("Printing frame not found");
        return;
    }

    // Ensure the iframe's document is properly initialized
    var printDocument = printFrame.contentWindow.document;
    printDocument.open();
    printDocument.write(`
        <html>
            <head>
                <title>${document.title}</title>
                ${styleSheetLink}
            </head>
            <body>
                ${content}
            </body>
        </html>
    `);
    printDocument.close();

    // Wait for the iframe's content to load before printing
    printFrame.contentWindow.onload = function () {
        printFrame.contentWindow.focus();
        printFrame.contentWindow.print();
    };
}



</script>
    @endpush

</x-app-layout>