<x-app-layout>
    @section('title')
        {{ __('translation.Sales') }}
    @endsection

    @push('top_css')
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/jquery-ui-dist@1.12.1/jquery-ui.min.css">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/jquery-datatables-checkboxes@1.2.12/css/dataTables.checkboxes.css">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.19/dist/sweetalert2.min.css">
        <link rel="stylesheet" href="{{ asset('css/custom_css.css') }}">
    @endpush

    @push('bottom_css')
        <link rel="stylesheet" href="{{ asset('css/datatable-custom-toolbar.css?_=' . rand()) }}">

        
    @endpush
    <input type="hidden" id="payment-receipt-path" value="<?php echo asset('storage/');?>">
    <input type="hidden" id="no-img-path" value="<?php echo asset('img/No_Image_Available.jpg');?>">

    <div class="px-4 sm:px-6 lg:px-8 py-8 w-full max-w-9xl mx-auto">


            <p class="font-bold"> Sales List </p>
            <div class="row">
                <div class="col-lg-12">
                    <x-card.card-default>
                        <x-card.body>
                            @if(session()->has('error'))
                                <div class="alert alert-danger mb-3 background-danger" role="alert">
                                    {{ session()->get('error') }}
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            @endif

                            @if(session()->has('success'))
                                <div class="alert alert-success mb-3 background-success" role="alert">
                                    {{ session()->get('success') }}
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            @endif

                            <div class="flex flex-col sm:flex-row sm:justify-between items-start mb-2" id="datatableBtns">
                                <div class="w-full sm:mb-0">
                                    <div class="flex flex-col sm:flex-row">
                                        <div class="w-full sm:w-1/4 xl:ml-1 mb-1 sm:mb-0 relative -top-1">
                                            <input type="text" class='form-input' id="searchbar" placeholder="Search">
                                        </div>

                                        <div class="w-full sm:w-1/2 flex flex-col sm:flex-row">
                                            <div class="row sm:ml-2">
                                                <a href="{{ url('order_managements/create/') }}">
                                                    <button class="inline-flex items-center justify-center text-sm font-medium leading-5 rounded px-3 py-1 border border-gray-200 dark:border-gray-700/60 hover:border-gray-300 dark:hover:border-gray-600 shadow-sm bg-green-500/20 text-green-700 transition" color="green" id="BtnInsert">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="w-3 h-3 bi bi-plus-circle" viewBox="0 0 16 16">
                                                            <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14zm0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16z"/>
                                                            <path d="M8 4a.5.5 0 0 1 .5.5v3h3a.5.5 0 0 1 0 1h-3v3a.5.5 0 0 1-1 0v-3h-3a.5.5 0 0 1 0-1h3v-3A.5.5 0 0 1 8 4z"/>
                                                        </svg>
                                                        <span class="ml-2">Create Sale</span>
                                                    </button>
                                                </a>

                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>

                            <div class="w-full overflow-x-auto">
                                <table class="w-full" id="__orderManagementTable">
                                    <thead>
                                    <tr class="bg-blue-500">
                                        <th class="px-4 py-2 text-white"></th>
                                        
                                        <th class="px-4 py-2 text-white text-left">
                                            Order Date
                                        </th>
                                        
                                        <th class="px-4 py-2 text-white text-left">
                                            Customer Name
                                        </th>
                                        <th class="px-4 py-2 text-white text-center">
                                            Total Items
                                        </th>
                                        <th class="px-4 py-2 text-white text-center">
                                            Total
                                        </th>
                                        <th class="px-4 py-2 text-white text-center">
                                            Actions
                                        </th>
                                    </tr>
                                    </thead>
                                    <tbody></tbody>
                                </table>
                            </div>
                        </x-card.body>
                    </x-card.card-default>
                </div>
            </div>
        </div>

   

     <!-- View Modal -->        
     <div class="modalArea modal-viewOrder modal-hide">    
        <div class="overflow-auto fixed  inset-0 z-10 flex items-center justify-center">
            <div class="bg-violet rounded-lg shadow-lg overflow-auto max-w-3xl w-full max-h-full" x-transition:enter="ease-out duration-300" x-transition:enter-start="opacity-0 scale-90" x-transition:enter-end="opacity-100 scale-100">
            
            <!-- Modal header -->
            <div class="px-5 py-3 border-b border-gray-200 dark:border-gray-700/60">
                <div class="flex justify-between items-center">
                    <div class="font-semibold text-gray-800 dark:text-gray-100">Order Details</div>
                    <button class="__closeModal text-gray-400 dark:text-gray-500 hover:text-gray-500 dark:hover:text-gray-400">
                        <div class="sr-only">Close</div>
                        <svg class="fill-current" width="16" height="16" viewBox="0 0 16 16">
                            <path d="M7.95 6.536l4.242-4.243a1 1 0 111.415 1.414L9.364 7.95l4.243 4.242a1 1 0 11-1.415 1.415L7.95 9.364l-4.243 4.243a1 1 0 01-1.414-1.415L6.536 7.95 2.293 3.707a1 1 0 011.414-1.414L7.95 6.536z" />
                        </svg>
                    </button>
                </div>
            </div>

            <!-- DELETE Modal content -->
            <form id="form-view-order" method="POST"></form>

            </div>
        </div>
    </div>

    <!-- DELETE Modal -->        
    <div class="modalArea modal-deleteOrder modal-hide">    
        <div class="overflow-auto fixed  inset-0 z-10 flex items-center justify-center">
            <div class="bg-violet rounded-lg shadow-lg overflow-auto max-w-3xl w-full max-h-full" x-transition:enter="ease-out duration-300" x-transition:enter-start="opacity-0 scale-90" x-transition:enter-end="opacity-100 scale-100">
            
            <!-- Modal header -->
            <div class="px-5 py-3 border-b border-gray-200 dark:border-gray-700/60">
                <div class="flex justify-between items-center">
                    <div class="font-semibold text-gray-800 dark:text-gray-100">Delete This Order ?</div>
                    <button class="__closeModal text-gray-400 dark:text-gray-500 hover:text-gray-500 dark:hover:text-gray-400">
                        <div class="sr-only">Close</div>
                        <svg class="fill-current" width="16" height="16" viewBox="0 0 16 16">
                            <path d="M7.95 6.536l4.242-4.243a1 1 0 111.415 1.414L9.364 7.95l4.243 4.242a1 1 0 11-1.415 1.415L7.95 9.364l-4.243 4.243a1 1 0 01-1.414-1.415L6.536 7.95 2.293 3.707a1 1 0 011.414-1.414L7.95 6.536z" />
                        </svg>
                    </button>
                </div>
            </div>

            <!-- DELETE Modal content -->
            <form id="form-delete-order" method="POST"></form>

            </div>
        </div>
    </div>




    @push('bottom_js')
        <script src="{{ asset('js/jquery.validate.js') }}"></script>
        <script src="https://cdn.jsdelivr.net/npm/jquery-datatables-checkboxes@1.2.12/js/dataTables.checkboxes.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/jquery-ui-dist@1.12.1/jquery-ui.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.19/dist/sweetalert2.min.js"></script>

        <script>
            const customerType = '0';
   
  
            const servicesDataUrl = '{{ route('get_services_items') }}';

            var selectedStatusIds = '';
            var selectedSubStatusIds = '';
            var orderManagementTable = '';

            const textProcessing = '{{ __('translation.Processing') }}';
            const textYesDelete = '{{ __('translation.Yes, Delete') }}';

            var totalProductPackOrder = 0;
            var totalDodoProductsOrdered = 0;



            var syncBtn = document.getElementById('datatableBtns');
            $("div.datatable_buttons").html(syncBtn);

         

            const loadOrderManagementTable = (statusIds = -1) => {
                orderManagementTable = $('#__orderManagementTable').DataTable({
                    dom: '<<"datatable_buttons"><rt>lip>',
                    bDestroy: true,
                    processing: true,
                    serverSide: true,
                    pageLength:100,
                    ajax: {
                        type: 'GET',
                        url: "{{ route('data order_managements') }}",
                        data: {
                            customerType: customerType,
                            status: statusIds
                        }
                    },
                    columnDefs : [
                        {
                            targets: [0],
                            checkboxes: {
                                selectRow: true
                            }
                        },
                    ],
                    order: [
                        [1, 'desc']
                    ],
                    columns: [
                        {
                            name: 'checkbox',
                            data: 'checkbox'
                        },
                        {
                            name: 'order_date',
                            data: 'order_date',
                            className : 'text-left'
                        },
                        {
                            name: 'customer_name',
                            data: 'customer_name',
                            className : 'text-left'
                        },
                        {
                            name: 'total_items',
                            data: 'total_items',
                            width : '140px'
                        },
                        {
                            name: 'amount',
                            data: 'amount',
                            className : 'text-right',
                             width : '150px'
                        },
                        
                        {
                            data: 'actions',
                            name: 'actions',
                            className : 'text-center',
                            width : '220px'
                        }
                    ]
                });
            }

            loadOrderManagementTable(selectedStatusIds);

            $("#searchbar").keyup(function() {
                orderManagementTable.search(this.value).draw();
            });

            const loadOrderStatusList = (parentStatusId) => {
                $.ajax({
                    url: getOrderStatusUrl,
                    type: "POST",
                    data: {
                        parentStatusId: parentStatusId,
                        customerType: customerType,
                    },
                    dataType: 'json',
                    success: function (result) {
                        $('#order-status-filter').html('<option disabled value="0">- Select Status -</option>');

                        $.each(result.orderStatusCounts, function (key, value) {
                            $("#order-status-filter").append('<option value="' + value.id + '">' + value.text + ' (' + value.count + ')</option>');
                        });
                    }
                });
            }


            $(document).on('click', '#batch_print', function() {
                var rows_selected = orderManagementTable.column(0).checkboxes.selected();

                var arr = [];
                $.each(rows_selected, function(index, rowId){
                    arr[index]=rowId;
                });

                if(arr.length === 0){
                    alert("Please Select Order ID");
                    return;
                }

                $('#order_ids_input_array').val( arr );

                $("#__modalBatchPrint").doModal('open');

                $("#total_orders_print").text('You have selected total '+arr.length+' shipments.');
            });

            $('#__btnCancelCreatePrintBulk').on('click', function() {
                $('.alert').addClass('hidden');
                $('#__alertDangerContentCreatePrintBulk').html(null);

                $('#__modalBatchPrint').doModal('close');
            });

            const productsOrdered = (el) => {
                const orderId = el.getAttribute('data-order-id');
               

                $('#__orderIdOutputProductsOrder').html(`#${orderId}`);

                $('#__tblProductProductsOrder').DataTable().destroy();
                const productTable = $('#__tblProductProductsOrder').DataTable({
                    ajax: {
                        type: 'GET',
                        url: OrderedProductDataUrl,
                        data: {
                            orderId: orderId,
                        }
                    },
                    columnDefs : [
                        {
                            targets: [0],
                            orderable: false
                        },
                        {
                            targets: [1],
                            className: 'text-left'
                        }
                    ],
                    paging: false,
                    filter : false,
                    info : false,
                });


                productTable.on('draw', function() {
                    const { recordsTotal } = productTable.page.info();
                    totalDodoProductsOrdered = recordsTotal;

                    if (recordsTotal > 0) {
                        $('#__actionButtonWrapperProductsOrder').removeClass('hidden');
                    }
                });

                $('#__modalProductsOrdered').doModal('open');

                $('#__modalProductsOrdered').doModal('open');
            }

            


            $(document).on('click', '.__closeModal', function(event) {
                event.preventDefault();
                //$('.modal-update').addClass('modal-hide');
                $('.modalArea').hide(); // Hide the modal
                //location.reload();
            });


            $(document).on('click', '#BtnView', function(event) {
                event.preventDefault();
                var type = $(this).data('type');    
                $('.modal-viewOrder').show();
                

                $.ajax({
                    url: '{{ route('form-view-modal-order') }}?id=' + $(this).data('id'),
                    type: 'post',
                    data: {
                        'id': $(this).data('id'),
                        '_token': $('meta[name=csrf-token]').attr('content')
                    }
                }).done(function(result) {
                   
                    $('#form-view-order').html(result);
                });         
            });

            $(document).on('click', '#BtnDelete', function(event) {
                event.preventDefault();
                var type = $(this).data('type');    
                $('.modal-deleteOrder').show();
                
                $.ajax({
                    url: '{{ route('form-delete-modal-order') }}?id=' + $(this).data('id'),
                    type: 'post',
                    data: {
                        'id': $(this).data('id'),
                        '_token': $('meta[name=csrf-token]').attr('content')
                    }
                }).done(function(result) {
                   
                    $('#form-delete-order').html(result);
                });         
            });


            $(document).on('submit', '#form-bulk-delete-daily-production', function(event) {
                event.preventDefault();
                var $message = $('#form-bulk-delete-daily-production #message');

                var formData = new FormData($(this)[0]);
                //console.log(formData);
                $.ajax({
                    url: '{{ route('bulk-delete-daily-production') }}',
                    type: 'post',
                    data: formData,
                    contentType: false,
                    processData: false, // Add this line to prevent default processing of FormData
                    success: function(response) {
                        if(response.status==1){
                            $message.html(response.message);                            
                            $message.show();
                            // Hide the modal after 3 seconds (1000 ms)
                            setTimeout(function() {
                                //$('#add-daily-production-modal').hide();
                                location.reload();
                            }, 1000);
                        }else{
                            $message.show();
                                // Assuming you have a way to show these errors in your UI
                            $message.html(response.message);                                    
                            
                        }
                        
                        
                    },
                    error: function(error) {
                        $errorList.show();
                        var errorData = error.responseJSON;
                        console.error('result:', errorData.errors);
                        // Display errors on the UI (you can customize how to show these)
                        for (const [key, message] of Object.entries(errorData.errors)) {
                            // Assuming you have a way to show these errors in your UI
                            $errorList.append('<li>' + message + '</li>');                                    
                        }
                    }

                })
            });


            $(document).on('click', '.BtnDelete', function() {
                let drop = confirm('Are you sure?');

                if (drop) {
                    $.ajax({
                        url: orderManagementDeleteUrl,
                        type: 'post',
                        data: {
                            'id': $(this).data('id'),
                            '_token': $('meta[name=csrf-token]').attr('content')
                        }
                    }).done(function(result) {
                        if (result.status === 1) {
                            alert('Order deleted successfully');

                            loadOrderManagementTable(selectedStatusIds);
                            loadStatusList();

                        } else {
                            alert(result.message);

                        }
                    });
                }
            });


           

            $(document).on('click', '.BtnCancel', function() {
                let drop = confirm('Are you sure to CANCEL this order?');
                if (drop) {
                    $.ajax({
                        type: 'POST',
                        url: orderManagementCancelUrl,
                        data: {
                            'id': $(this).data('id'),
                            '_token': $('meta[name=csrf-token]').attr('content')
                        }
                    }).done(function(result) {
                        if (result.status === 1) {
                            alert('Order cancelled successfully');

                            loadOrderManagementTable(selectedStatusIds);
                            loadStatusList();

                        } else {
                            alert(result.message);

                        }
                    });
                }
            });

    

            $(document).on('click', '#confirmPayment', function() {
                $("#confirmPaymentModal").modal('show');
                var order_id = $(this).data('id');

                //var order_id = $(this).attr('order-id');
                $("#order_id_confirm_payment").val(order_id);

                $.ajax
                ({
                    type: 'GET',
                    data: {order_id:order_id},
                    url: '{{url('getOrderPaymentDetails')}}',
                    success: function(result)
                    {
                        console.log(result);
                        // alert(result.payment_slip);
                        var payment_slip = '/'+result.payment_slip;
                        var paymentReceiptPath = $("#payment-receipt-path").val();
                        var noImgPath = $("#no-img-path").val();

                        $("#total_amount").text('Tk.'+result.amount);
                        $("#bank_payment_date").text(result.payment_date);
                        $("#bank_payment_time").text(result.payment_time);
                        $("#payment_slip").text('');
                        if(result.payment_slip){
                            $("#payment_slip").append('<img class="margin_top_10 border_1" width="100%" src="'+paymentReceiptPath+payment_slip+'">');
                            
                        }
                        else{
                            $("#payment_slip").append('<img class="margin_top_10 border_1" width="100%" src="'+noImgPath+'">');
                        }
                        
                    }
                });
            });

            function confirmPaymentBtn(){

                var result = confirm("Are you Sure?");
                if (result) {
                    var order_id = $("#order_id_confirm_payment").val();
                    $.ajax
                    ({
                        type: 'POST',
                        data: {order_id:order_id},
                        url: '{{url('confirmPaymentForOrder')}}',
                        success: function(result)
                        {
                            if(result === 'ok'){
                                $("#confirmPaymentModal").modal('hide');
                                alert("Payment has been successfully confirmed");
                                window.location.href = "{{ url('order_management')}}";
                            }
                        }
                    });
                }
            }


            $('.__btnCloseModalPackOrder').on('click', function() {
                $('#__modalPackOrder').doModal('close');
                $('#__actionButtonWrapperPackOrder').addClass('hidden');
            });



            const updateStatus = (el) => {
                const shipmentId = el.getAttribute('data-shipment-id');
                const orderId = el.getAttribute('data-order-id');
                var selectedStatus = $("#order-status-filter").val();
                $("#shipment-status option[value=" + selectedStatus + "]").attr('disabled', true);

                $('#__btnConfirmUpdateStatus').attr('data-id', shipmentId);

                $('#__modalUpdateShipmentStatus').doModal('open');
            }

            $('.__btnCloseModalUpdateStatus').on('click', function() {
                $('#__modalUpdateShipmentStatus').doModal('close');
                $("#shipment-status").val(0);
                $("#shipment-status option").removeAttr('disabled');
                $("#shipment-status option[value='0']").attr('disabled', true);
            });



            // for update status from Processed Order status
            const updateStatusForProcessed = (el) => {
                const shipmentId = el.getAttribute('data-shipment-id');
                const orderId = el.getAttribute('data-order-id');
                var selectedStatus = $("#order-status-filter").val();
                $("#shipment-status option[value=" + selectedStatus + "]").attr('disabled', true);

                $('#__btnConfirmUpdateStatusForProcessed').attr('data-id', orderId);

                $('#__modalUpdateShipmentStatusForProcessed').doModal('open');
            }


            $('.__btnCloseModalUpdateStatusForProcessed').on('click', function() {
                $('#__modalUpdateShipmentStatusForProcessed').doModal('close');
                $("#shipment-status").val(0);
                $("#shipment-status option").removeAttr('disabled');
                $("#shipment-status option[value='0']").attr('disabled', true);
            });

  

            $(document).on('click', '#editOrder', function() {
                var order_id = $(this).data('id');
                var order_status = $(this).attr('order-status-id');

                // alert(order_status);
                if(order_status === '3'  || order_status === '4' || order_status === '5'){
                    $("#order_locked").modal('show');
                }
                else{
                    $("#order_locked").modal('hide');
                    var url = "{{ url('/order_management/') }}";
                    window.location.href = url+'/'+order_id+'/edit';
                }
            });

        </script>

        <script src="{{ asset('pages/seller/order_management/index/status_filter.js?_=' . rand()) }}"></script>
        <script src="{{ asset('js/orderManagementJs.js') }}"></script>
    @endpush

</x-app-layout>
