
    @push('top_css')
    <link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
   
    <link rel="stylesheet" href="{{ asset('css/typeaheadjs.css') }}">
    <link rel="stylesheet" href="{{ asset('css/custom_css.css') }}">
    <style>
.table thead th {
    vertical-align: bottom;
    border: 1px solid #2c3545;
    background: #0c1830;
    color: #e1d492;
}

.table td, .table th {
    padding: 0.15rem .75rem;
    vertical-align: top;
    border-top: 1px solid #dee2e6;
    font-size: 13px;
}

.table td p, .table th p {
    font-size: 12px;
    letter-spacing: 1.5px;
}
.font-bold{
    font-weight:600 !important;
}

.table td {
    vertical-align: middle;
    border: 1px solid #2c3545;
    position: relative;
}

#total-tdiscount{
    width: 100%;
    height: 32px;
    background: #7ac0e1;
    border: none;
    color: black;
}

.removeItem {
    position: absolute;
    top: 4px;
    left: 5px;
    padding: .15rem .5rem;
    font-size: 0.675rem;
}

td [type=text] {
    padding: 0 5px;
    height: 30px;
    font-weight: 100;
    font-size: 12px;
    letter-spacing: 2px;
}


      .text-right {
        text-align: right
      }




      .currency {
            display: inline-block;
            width: 0.65em;
            height: 1.2em;
            margin-left: 3px;
            --svg: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 384 512'%3E%3Cpath fill='%23000' d='M36 32.3C18.4 30.1 2.4 42.5.2 60S10.5 93.6 28 95.8l7.9 1c16 2 28 15.6 28 31.8L64 160H32c-17.7 0-32 14.3-32 32s14.3 32 32 32h32v160c0 53 43 96 96 96h32c106 0 192-86 192-192v-32c0-53-43-96-96-96h-16c-17.7 0-32 14.3-32 32s14.3 32 32 32h16c17.7 0 32 14.3 32 32v32c0 70.7-57.3 128-128 128h-32c-17.7 0-32-14.3-32-32V224h32c17.7 0 32-14.3 32-32s-14.3-32-32-32h-32v-31.5c0-48.4-36.1-89.3-84.1-95.3l-7.9-1z'/%3E%3C/svg%3E");
            background-color: currentColor;
            -webkit-mask-image: var(--svg);
            mask-image: var(--svg);
            -webkit-mask-repeat: no-repeat;
            mask-repeat: no-repeat;
            -webkit-mask-size: 100% 100%;
            mask-size: 100% 100%;
            }

      </style>
    @endpush


    <div class="px-4 sm:px-6 lg:px-8 py-8 w-full max-w-9xl mx-auto">

        <div class="px-0 pb-3 rounded-lg flex rounded-lg">
            <div class="text-center">
                <!-- Start -->
                <ul class="inline-flex flex-wrap text-sm font-medium">
                    <li class="flex items-center">
                        <a class="text-gray-500 dark:text-gray-400 hover:text-violet-500 dark:hover:text-violet-500" href="{{route('order_managements')}}">Sales</a>
                        <svg class="fill-current text-gray-400 dark:text-gray-600 mx-3" width="16" height="16" viewBox="0 0 16 16">
                            <path d="M6.6 13.4L5.2 12l4-4-4-4 1.4-1.4L12 8z"></path>
                        </svg>
                    </li>
                    <li class="flex items-center">
                        <span class="text-gray-500 dark:text-gray-400">Delivery Note</span>
                    </li>
                </ul>
                <!-- End -->
            </div>
        </div>
   
        
        <form id="__formInsertDeliveryChallan" action="{{ route('delivery.store') }}" method="post">
            <div class="text-sm mt-6">
                <div id='msg-success' class="font-medium text-green-700  dark:text-green-700 mb-3">
            </div>
                <ul id="error-list" class="text-red-500 mb-3"></ul>
            </div>
            @csrf  
            <input type="hidden" name="order_management_id" value="{{ $orderManagement->id }}">                   
            <div class="flex flex-col space-y-10 sm:flex-row sm:space-x-6 sm:space-y-0 md:flex-col md:space-x-0 md:space-y-10 xl:flex-row xl:space-x-6 xl:space-y-0">
                <!-- Content -->
                <div class="w-1/2">
                    <!-- Job list -->
                    <div class="space-y-2">                
                        <div class="bg-white dark:bg-gray-800 shadow-sm rounded-xl px-5 py-3">
                            <div class="grid gap-5 md:grid-cols-2 @if(Auth::user()->role !='staff') md:grid-cols-2 @endif">
                                <div>
                                    <label for="delivery_date" class="block mb-2">
                                        {{ __('Date') }}
                                        <x-form.required-mark />
                                    </label>
                                    <div class="flex flex-row gap-x-4">
                                    <input type="text" value="" autocomplete=off name="delivery_date" id="delivery_date" class="datepicker-1 form-input" required />
                                    </div>
                                </div>

                                @if(Auth::user()->role !='staff')
                                    <!-- Select -->
                                    <div hidden>
                                        <label class="block text-sm font-medium mb-2" for="shop_id">Production Unit</label>
                                        <select name="shop_id" class="form-select w-full">
                                            <option value="">Select Unit</option>
                                            @if($shops)
                                                @foreach($shops as $row)
                                                <option @if($orderManagement->shop_id==$row->id) selected @endif value='{{$row->id}}'>{{$row->name}} ({{$row->location}})</option>
                                                @endforeach
                                            @endif
                                        </select>
                                    </div>
                                @else
                                    <input id="shop_id" name="shop_id" class="form-input w-full px-2 py-1" type="hidden" value="{{Auth::user()->shop_id}}" />
                                @endif
                            

                                <div>
                                    <label for="customer_id" class="block mb-2">
                                        {{ __('translation.Customer') }}
                                        <x-form.required-mark />
                                    </label>
                                    <div class="flex flex-row gap-x-4">
                                        <x-select name="customer_id" id="customer_id" class="chosen-select form-select">
                                            <option value="">Select Customer</option>
                                                @if($customers)
                                                    @foreach($customers as $customer)
                                                        <option @if($orderManagement->customer_id==$customer->id) selected @endif  value="{{$customer->id}}">{{$customer->customer_name}}
                                                    </option>
                                                    @endforeach
                                                @endif
                                        </x-select>
                                    </div>
                                </div>
                            </div>   
                        </div>

                        <!-- Qr Enter -->
                        <div class="bg-white dark:bg-gray-800 shadow-sm rounded-xl px-5 py-4">
                            <input type="text" class="form-input w-full" id="__product_id_QR_scanner" placeholder="Enter Product Name or Product Code"
                            autocomplete="off" />
                        </div>

                        <!-- Show Product List  -->
                        <div class="bg-white dark:bg-gray-800 shadow-sm rounded-xl px-5 py-4">
                            <div class="invoice" id="invoice-container">

                                <table id="table" class="table table-striped w-full">
                                    <thead>
                                    <tr>
                                        
                                        <th style="width: 32px;" class="hide-elements text-center"></th>
                                        <th style="width: 52px;" class="text-center">#</th>
                                        <th data-editable="true">Name</th>
                                        <th style="width: 182px;">Quntity</th>
                                    </tr>
                                    </thead>
                                    <tbody id="__productListWrapper">
                                        @php $i=count($orderManagement->order_management_details); @endphp
                                        @if ($orderManagement->order_management_details->isNotEmpty())
                                            @foreach ($orderManagement->order_management_details as $detail)                                                   
                                                <tr>
                                                    <td class="text-right hide-elements">
                                                        <input type="hidden" name="product_id[]" value="{{ !empty($detail->product_id) ? $detail->product_id : 0 }}" class="product_id" data-id="{{ $detail->product->id }}">
                                                        <button onclick="deleteProductRow(this)" class="removeItem border-none text-red-500 hover:text-red-600 rounded-full p-0 pb-2 m-0">
                                                            <span class="sr-only">Delete</span>
                                                            <svg class="w-8 h-8 fill-current" viewBox="8 5 32 32">
                                                                <path d="M13 15h2v6h-2zM17 15h2v6h-2z"></path>
                                                                <path d="M20 9c0-.6-.4-1-1-1h-6c-.6 0-1 .4-1 1v2H8v2h1v10c0 .6.4 1 1 1h12c.6 0 1-.4 1-1V13h1v-2h-4V9zm-6 1h4v1h-4v-1zm7 3v9H11v-9h10z"></path>
                                                            </svg>
                                                        </button>
                                                    </td>


                                                    <td class="index text-center">
                                                        {{$i--}}
                                                    </td>
                                                    <td>
                                                    <p class="font-bold m-0">
                                                    @if($detail->product->product_name)   
                                                        <span class="product_name">{{ $detail->product->product_name }}</span> 
                                                    @endif

                                                    </p>
                                                    </td>



                                                    <td class="text-center">
                                                    <input type="text" class="quantity form-input text-center" name="product_qty[]" value="{{ $detail->quantity }}" onClick="this.select();">     
                                                    </td>                                
                                                </tr>
                                            @endforeach
                                        @endif
                                    </tbody>

                                </table>
                            </div>
                        </div>

                      

                        <!-- Payments History of this Order -->
                        <div class="bg-white dark:bg-gray-800 shadow-sm rounded-xl px-5 py-4">
                            <label class="flex items-center">
                                <span class="text-sm text-gray-600 dark:text-gray-300 font-medium ml-2">Delivery List</span>
                            </label>

                            <div class="flex mt-2">
                                <table class="table table-striped w-full mr-5">
                                    <thead>
                                        <tr>
                                            <th scope="col">Payment Date</th>
                                            <th scope="col">Payment Method</th>
                                            <th scope="col">Amount<span class="currency">(৳)</span></th>
                                            <th class="hide-elements" style='width:15px'>Actions</th>  
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @if(isset($paymentDetailsAllManual))
                                            @foreach($paymentDetailsAllManual as $rows)
                                                <tr>
                                                    <td scope="row">{{date('d-M-Y', strtotime($rows->payment_date))}}</td>
                                                    
                                                    <td>
                                                        
                                                        @if($rows->payment_method->name=='Cash')
                                                            {{$rows->payment_method->name}}
                                                        @else  
                                                            {{$rows->bank_or_mobile_wallet->name}}                                                  
                                                            @isset($rows->bank_or_mobile_wallet_account->account_no)
                                                                #{{$rows->bank_or_mobile_wallet_account->account_no}}
                                                            @endisset
                                                        @endif
                                                    </td>
                                                    <td class='text-right'>
                                                        {{App\Http\Controllers\SettingController::takaBDFormat($rows->amount)}}</td>
                                                    <td class="text-center hide-elements">
                                                        <div class="flex justify-between space-x-1">
                                                            <button id="BtnEditPayment" data-id="{{$rows->id}}" class="text-red-500 hover:text-red-600 rounded-full p-0">
                                                                <span class="sr-only">Edit</span>
                                                                <svg class="fill-current text-gray-400 dark:text-gray-500 shrink-0" viewBox="-10 -5 35 28">
                                                                    <path d="M11.7.3c-.4-.4-1-.4-1.4 0l-10 10c-.2.2-.3.4-.3.7v4c0 .6.4 1 1 1h4c.3 0 .5-.1.7-.3l10-10c.4-.4.4-1 0-1.4l-4-4zM4.6 14H2v-2.6l6-6L10.6 8l-6 6zM12 6.6L9.4 4 11 2.4 13.6 5 12 6.6z"></path>
                                                                </svg>
                                                            </button>

                                                            <button id="BtnDeletePayment" data-id="{{$rows->id}}" class="text-red-500 hover:text-red-600 rounded-full p-0 ">
                                                                <span class="sr-only">Delete</span>
                                                                <svg class="w-8 h-8 fill-current" viewBox="0 4 32 32">
                                                                <path d="M13 15h2v6h-2zM17 15h2v6h-2z"></path>
                                                                <path d="M20 9c0-.6-.4-1-1-1h-6c-.6 0-1 .4-1 1v2H8v2h1v10c0 .6.4 1 1 1h12c.6 0 1-.4 1-1V13h1v-2h-4V9zm-6 1h4v1h-4v-1zm7 3v9H11v-9h10z"></path>
                                                                </svg>
                                                            </button>
                                                        </div>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        @endif
                                    </tbody>
                                </table>
                            </div>
                        </div>

                    </div>
                </div>
                <!-- Sidebar -->
                <div class="space-y-2">
                <div class="bg-white dark:bg-gray-800 shadow-sm rounded-xl px-5 py-3">
                            <div class="grid gap-5 md:grid-cols-2 @if(Auth::user()->role !='staff') md:grid-cols-2 @endif">
                                <div>
                                    <label for="order_date" class="block mb-2">
                                        Vehicle No
                                    </label>
                                    <div class="flex flex-row gap-x-4">
                                    <input type="text" value="" autocomplete=off name="vehicle_no" id="order_date" class="form-input" />
                                    </div>
                                </div>

                                <div>
                                    <label for="chassis_no" class="block mb-2">
                                        Chassis No
                                        <x-form.required-mark />
                                    </label>
                                    <div class="flex flex-row gap-x-4">
                                        <input type="text" value="" autocomplete=off name="chassis_no" id="chassis_no" class="form-input" />
                                    </div>
                                </div>

                                <div>
                                    <label for="driver_name" class="block mb-2">
                                        Driver's Name
                                        <x-form.required-mark />
                                    </label>
                                    <div class="flex flex-row gap-x-4">
                                        <input type="text" value="" autocomplete=off name="driver_name" id="driver_name" class="form-input" />
                                    </div>
                                </div>

                                <div>
                                    <label for="driver_mobile_no" class="block mb-2">
                                        Driver's Mobile
                                        <x-form.required-mark />
                                    </label>
                                    <div class="flex flex-row gap-x-4">
                                        <input type="text" value="" autocomplete=off name="driver_mobile_no" id="driver_mobile_no" class="form-input" />
                                    </div>
                                </div>

                                <div>
                                    <label for="driving_lic_no" class="block mb-2">
                                        Driving License No.
                                        <x-form.required-mark />
                                    </label>
                                    <div class="flex flex-row gap-x-4">
                                        <input type="text" value="" autocomplete=off name="driving_lic_no" id="driving_lic_no" class="form-input" />
                                    </div>
                                </div>
                            </div>   

                            <div class="block mt-2 w-full">
                                    <label for="driving_lic_no" class="block mb-2">
                                        Destination
                                        <x-form.required-mark />
                                    </label>
                                    <div class="flex flex-row gap-x-4">
                                        <textarea id="notes" name="destination" class="form-textarea w-full focus:border-gray-300" rows="2" placeholder="Write a destination…"></textarea>
                                    </div>
                                </div>

                        </div>
                 
                    <!-- White box -->
                    <div class="bg-white dark:bg-gray-800 shadow-sm rounded-xl p-5 min-w-60">             
                        <div class="max-w-sm mx-auto lg:max-w-none">               
                         
                            <!-- Download / Report -->
                            <div class="flex items-center space-x-3 mt-6">
                                <div class="w-1/2">
                                    <button type="submit" class="btn bg-green-500 hover:bg-green-600 text-black">
                                        <svg class="fill-current text-gray-400 dark:text-gray-500 shrink-0 rotate-180" width="16" height="16" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M8 4c-.3 0-.5.1-.7.3L1.6 10 3 11.4l4-4V16h2V7.4l4 4 1.4-1.4-5.7-5.7C8.5 4.1 8.3 4 8 4ZM1 2h14V0H1v2Z"></path>
                                        </svg>
                                        <span class="ml-2">Submit</span>
                                    </button>
                                </div>
                            </div>

                        </div>                                            
                    </div>
                </div>
            
            </div>
        </form> 
    </div> 
    <!-- End div -->


    <table class="hidden">
        <tbody id="__templateProductItem" class="">
        <tr>
            <td class="text-right hide-elements">
                <input type="hidden" name="product_id[]" class="product-id" value="">
                <button onclick="deleteProductRow(this)" class="removeItem border-none text-red-500 hover:text-red-600 rounded-full p-0 pb-2 m-0">
                    <span class="sr-only">Delete</span>
                    <svg class="w-8 h-8 fill-current" viewBox="8 5 32 32">
                        <path d="M13 15h2v6h-2zM17 15h2v6h-2z"></path>
                        <path d="M20 9c0-.6-.4-1-1-1h-6c-.6 0-1 .4-1 1v2H8v2h1v10c0 .6.4 1 1 1h12c.6 0 1-.4 1-1V13h1v-2h-4V9zm-6 1h4v1h-4v-1zm7 3v9H11v-9h10z"></path>
                    </svg>
                </button>
            </td>


            <td class="index">
              1
            </td>
            <td>
            <p class="font-bold m-0"> 
                <span class="product_name"></span> 
            </p>
            
            </td>
            
            <td class="text-center">
                <input type="text" class="form-input quantity text-center" name="product_qty[]" value="1" onClick="this.select();">     
            </td>

  
        </tr>
       </tbody>
    </table>


 

    @push('bottom_js')
    <script src="https://cdn.jsdelivr.net/npm/typeahead.js@0.11.1/dist/typeahead.bundle.min.js"></script>
    
    <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/clipboard@2.0.8/dist/clipboard.min.js"></script>
    <script src="{{ asset('js/delayKeyup.js?_=' . rand()) }}"></script>

    
    <script>

    const enterKeyCode = 13;
    const BDTSymbol = '{{ currency_symbol('BDT') }}';

    var selectedProductsToList = [];
    var productSource = {!!$products->toJson() !!};


    var subTotal = 0;
    var serviceCost = 0;
    var discountTotal = 0;
    var totalAmount = 0;

    function formatNumber(number) {
        return number.toFixed(2).toString().replace(/(\d+?)(?=(\d\d)+(\d)(?!\d))/g, "$1,");
         
    }

    function replaceComma(number) {
        return number.replace(/,/g, '');
    }

    
    const calculateCartSummary = () => {
        let productTotal = 0;
        let serviceTotal = 0;
        let grandTotalCurrency = 0;
        let discount_total = 0;
        let previousDue = 0;
        
        previousDue = parseFloat(replaceComma($('#__previousDue').text()));
        productTotal = parseFloat(replaceComma($('#__productTotalCurrency').text()));
        serviceTotal = parseFloat(replaceComma($('#__serviceCostCurrency').text()));
        discount_total = parseFloat(replaceComma($('#discount-total').val())) || 0;
        grandTotalCurrency = productTotal+serviceTotal;

        $('.grandTotalCurrency').text(formatNumber(grandTotalCurrency));
        $('#__amountToBePaid').text(formatNumber(previousDue+grandTotalCurrency-discount_total));
        //$('#__paid').val((grandTotalCurrency-discount_total).toFixed(2));
        
        
    }




    const updateProductRowTotal = (row) => {
        let price = parseFloat(row.find('.product-price').val()) || 0;
        let quantity = parseFloat(row.find('.quantity').val()) || 0;
        let discount = parseFloat(row.find('.tdiscount').val()) || 0;
        let rowSubTotal = price * quantity;
        let total = rowSubTotal - discount;
        row.find('.row-sub-total').text(formatNumber(rowSubTotal));
        row.find('.row-total').text(formatNumber(total));
    
        
        //console.log("Total "+total);

        updateGrandTotal();
        calculateCartSummary();
    }

    const updateGrandTotal = () => {
        let subTotal = 0;
        let grandTotal = 0;
        let discountTotal = 0;
        $('.row-total').each(function(){
            subTotal += parseFloat(replaceComma($(this).text())) || 0;
        });
        $('#sub-total').text(formatNumber(subTotal));
        discountTotal += parseFloat($("#discount-total").val()) || 0;
        $('#product_price_total').val(formatNumber(subTotal-discountTotal));
        $('#__productTotalCurrency').text(formatNumber(subTotal-discountTotal));
        
    }

    const productHandlers = (row) => {
        row.find('.quantity, .product-price, .tdiscount').on('keyup', function() {
            var currentRow = $(this).closest('tr');            
            updateProductRowTotal(currentRow);
        });
    }

    $('.quantity, .product-price, .tdiscount').on('keyup', function() {
            var currentRow = $(this).closest('tr');  
            console.log(currentRow);        
            updateProductRowTotal(currentRow);
        });

    // Initial calculation
    $('tbody.main tr').each(function(){
        updateProductRowTotal($(this));
        productHandlers($(this));
    });





    const deleteProductRow = (button) => {
      const row = button.closest('tr');
      row.remove();
      updateGrandTotal();
      calculateCartSummary();
    }


    // Services section 

    const serviceHandlers = (row) => {
        row.find('.service_price').on('keyup', function() {
            var currentRow = $(this).closest('tr');
            servicesGrandTotal();
        });
    }

    $('.service_price').on('keyup', function() {
        var currentRow = $(this).closest('tr');
        servicesGrandTotal();
    });

    const servicesGrandTotal = () => {
        let subTotal = 0;
        let grandTotal = 0;
        let discountTotal = 0;
        $('.service_price').each(function(){
            subTotal += parseFloat($(this).val()) || 0;
        });
        $('#__serviceCostCurrency').text(formatNumber(subTotal));

        calculateCartSummary();
        
    }



    // Cloning and appending a new row
    $('#add-row').on('click', function(){
        let serviceListWrapper = $('#__serviceTable tbody');
        let lastRow = $('#serviceTemplate tr');
        let newRow = lastRow.clone();
        // Update index in the cloned row
        newRow.find('.index').text($('#__serviceTable tr').length); // Update index based on current row count

        // Reset input values for the new row
        newRow.find('input').val('');

        serviceListWrapper.prepend(newRow);

        // Attach event handlers to the new row
        serviceHandlers(newRow);
        
        // Recalculate totals after adding the new row
        servicesGrandTotal();
    });


    

    const deleteServiceRow = (button) => {
      const row = button.closest('tr');
      row.remove();
      servicesGrandTotal();
      calculateCartSummary();
    }


    $('#discount-total').on('keyup', function() {
        calculateCartSummary();
    });

    $('#__paid').on('keyup', function() {

        let toBePaid = 0;
        let paid = 0;
        let due = 0;
        

        toBePaid = parseFloat(replaceComma($('#__amountToBePaid').text()));
        paid = parseFloat($(this).val());
        due = (toBePaid - paid)  || 0;

        $('#__dueAmount').text(formatNumber(due));       
        
    });


    $(document).on('click', '#BtnEditPayment', function(event) {
        event.preventDefault();
  
        $('.modal-editPayment').show();
        $.ajax({
            
            type: 'post',
            data: {
                'id': $(this).data('id'),
                '_token': $('meta[name=csrf-token]').attr('content')
            }
        }).done(function(result) {
            $('#form-edit-payment').html(result);
        });         
    });

    $(document).on('click', '#BtnDeletePayment', function(event) {
        event.preventDefault();
  
        $('.modal-deletePayment').show();
        $.ajax({
            
            type: 'post',
            data: {
                'id': $(this).data('id'),
                '_token': $('meta[name=csrf-token]').attr('content')
            }
        }).done(function(result) {
            $('#form-delete-payment').html(result);
        });         
    });

    $(document).on('click', '.__closeModal', function(event) {
        event.preventDefault();
        //$('.modal-update').addClass('modal-hide');
        $('.modalArea').hide(); // Hide the modal
    });


    $(document).on('submit', '#form-edit-payment', function(event) {
    event.preventDefault();

    var $msgSuccess = $('#form-edit-payment #msg-success');
    var $errorList = $('#form-edit-payment #error-list');

    $msgSuccess.hide();
    $errorList.hide();
    // Clear existing errors (if any)
    $errorList.empty();

    var formData = new FormData($(this)[0]);
    console.log(formData);
    $.ajax({
        url: '{{ route('receive-payment.update') }}',
        type: 'post',
        data: formData,
        contentType: false,
        processData: false, // Add this line to prevent default processing of FormData
        success: function(response) {
            $("#msg-success").html(response.status);                            
            $msgSuccess.show();
            // Hide the modal after 3 seconds (1000 ms)
            setTimeout(function() {
                //$('#add-product-modal').hide();
                location.reload();
            }, 1000);
            
        },
        error: function(error) {
            $errorList.show();
            var errorData = error.responseJSON;
            console.error('result:', errorData.errors);
            // Display errors on the UI (you can customize how to show these)
            for (const [key, message] of Object.entries(errorData.errors)) {
                // Assuming you have a way to show these errors in your UI
                $errorList.append('<li>' + message + '</li>');                                    
            }
        }

    })
});


$(document).on('submit', '#form-delete-payment', function(event) {
    event.preventDefault();

    var $message = $('#form-edit-payment #message');
    $message.hide();
    // Clear existing errors (if any)
    $message.empty();

    var formData = new FormData($(this)[0]);
    //console.log(formData);
    $.ajax({
       
        type: 'post',
        data: formData,
        contentType: false,
        processData: false, // Add this line to prevent default processing of FormData
        success: function(response) {
            $("#message").html(response.status);                            
            $message.show();
            // Hide the modal after 3 seconds (1000 ms)
            setTimeout(function() {
                //$('#add-product-modal').hide();
                location.reload();
            }, 1000);
            
        },
        error: function(error) {
            $message.show();
            var errorData = error.responseJSON;
            console.error('result:', errorData.errors);
            // Display errors on the UI (you can customize how to show these)
            for (const [key, message] of Object.entries(errorData.errors)) {
                // Assuming you have a way to show these errors in your UI
                $errorList.append('<li>' + message + '</li>');                                    
            }
        }

    })
});


    const substringMatcher = function(strs) {
        return function findMatches(q, cb) {
            var matches, substringRegex;
            matches = [];

            substrRegex = new RegExp(q, 'i');

            $.each(strs, function(i, str) {
                if (substrRegex.test(str)) {
                    matches.push(str);
                }
            });

            cb(matches);
        };
    };


    const initializeTypeAheadField = () => {

        $('#__product_id_QR_scanner').typeahead({
          
            hint: true,
            minLength: 1,
            highlight: true
        }, {
            source: substringMatcher(productSource),
            limit: 15
        });
    }

    initializeTypeAheadField();


    $('#__product_id_QR_scanner').on('typeahead:selected', function(event, selectedItem) {
        renderProductToList(selectedItem);
    });


    const renderProductToList = typeAheadValue => {

        
        if (typeAheadValue !== '') {
            $.ajax({
                type: 'GET',
                data: {
                    term: typeAheadValue
                },
                url: '{{ route('get_qr_code_product') }}',
                success: function(responseJson) {
                    console.log(responseJson);
                    if (responseJson.status === 1) {
                        //$('#error_modal').modal('show');
                    }
              
                    if (responseJson.status === 3) {
                        let lastRow = $('#invoice-container tbody');
                        let newRow = $('#__templateProductItem tr').clone();
                        // Update index in the cloned row
                        newRow.find('.index').text($('#invoice-container tr').length); // Update index based on current row count
                        let product = responseJson.product;

                        let productQuantity = 0;
                        productQuantity = product.check_in - product.check_out - product.defect;

                        if (product.product_name !== null) {
                            product_name = product.product_name;
                        }else{
                            product_name = '';
                        }

                        //if (selectedProductsToList.indexOf(product.id) === -1) {

                            selectedProductsToList.push(product.id);

                            
                            newRow.attr('class','rowNo_'+product.id); 
                       
                            newRow.find('.product-id').val(product.id || 0);
                            // Reset input values for the new row
                            newRow.find('.product_name').html(product_name || '');                            
                            newRow.find('.stock').html(productQuantity || 0);
                            newRow.find('.cost-price').val(product.cost_price || 0);
                            newRow.find('.product-price').val(product.price || 0);
                            newRow.find('.product-price').attr('min',product.price || 0);
                            newRow.find('.tdiscount').val('');

                            
                        //     if (selectedProductsToList.indexOf(product.id) > -1) {
                        //     let stockAdjustElement = $(`.rowNo_${product.id} .quantity`);
                        //     let currentValue = parseInt(stockAdjustElement.val());
                        //     let increasedValue = currentValue + 1;
                        //     //stockAdjustElement.val(increasedValue);
                        //     stockAdjustElement.val(increasedValue);
                        // }


                            lastRow.prepend(newRow);

                            // Attach event handlers to the new row
                            productHandlers(newRow);
                            
                            // Recalculate totals after adding the new row
                            updateProductRowTotal(newRow);                     


                            $('#__base_amount').val(product.price);
                            $('#__noProductWrapper').hide();
                            $('#__service_methods_wrapper').show();
                            $('#__payment_details_wrapper').show();
                            
                        //}


                        

                        $('#__product_id_QR_scanner').typeahead('destroy');
                        $('#__product_id_QR_scanner').val(null);

                            
                        initializeTypeAheadField();

                        $('#__product_id_QR_scanner').focus();

                    }
                }
            });
        }
    }



    $('#customer_id').change(function() {
        $.ajax({
            url: '{{ route('customer-due') }}',
            type: 'post',
            data: {
                'customer_id': $(this).val(),
                '_token': $('meta[name=csrf-token]').attr('content')
            }
        }).done(function(result) {
            $('#__previousDue').html(result);
            calculateCartSummary();
        });

    });

    $('#__payment_method').change(function() {
        if ($(this).val() == 1) {
            $("#_bankOrMobileDetailsWrapper").hide();
            $("#_AccountNoWrapper").hide();
            $("#bank_or_mobile_wallet_id").val('');
            $("#account_no_id").val('');

        } else {
            $("#_bankOrMobileDetailsWrapper").show();
            $("#_AccountNoWrapper").show();
        }
        $.ajax({
            url: '{{ route('load-bank-or-mobile-dropdown') }}',
            type: 'post',
            data: {
                'id': $(this).val(),
                '_token': $('meta[name=csrf-token]').attr('content')
            }
        }).done(function(result) {
            $('#_bankOrMobileDetailsWrapper').html(result);
        });

    });

    $('#bank_or_mobile_wallet_id').on('change', function() {
        $.ajax({
            url: '{{ route('load-bank-or-mobile-account-dropdown') }}',
            type: 'post',
            data: {
                'bank_or_mobile_wallet_id': $(this).val(),
                '_token': $('meta[name=csrf-token]').attr('content')
            }
        }).done(function(result) {
            $('#_AccountNoWrapper').html(result);
        });
    });



    </script>

    <script>
    $("#wrapper_services").show();
    $("#wrapper_new").hide();
  

    $('#have_services').change(function() {
        if (this.checked) {
            $("#__serviceAreaWrapper").slideDown();
        } else {
            $("#__serviceAreaWrapper").slideUp();
        }

       // calculateCartTotal();
    });


    $("#__payment_method_wrapper").hide();
    $('#is_cash_payment').change(function() {
        
        if($(this).is(":checked")){
            $("#__payment_method_wrapper").slideUp();
        } else {
            $("#__payment_method_wrapper").slideDown();
        }

       // calculateCartTotal();
    });

    $("#__note_wrapper").hide();
    $('#have_note').change(function() {
        
        if($(this).is(":checked")){
            $("#__note_wrapper").slideDown();
        } else {
            $("#__note_wrapper").slideUp();
        }
    });

    

    $(document).ready(function() {

        $(".datepicker-1").datepicker({
            dateFormat: 'dd-mm-yy'
        });

        $('.customer').select2({
            placeholder: '- Select Customer -',
            width: 'resolve'
        });

        

        $('.employee').select2({
            placeholder: '- Select Service Man -',
            width: 'resolve'
        });



        $('#bank_id').select2({
            placeholder: '- Select A Bank -',
            width: 'resolve'
        });

        $('#mobile_banking_id').select2({
            placeholder: '- Select Mobile Wallet -',
            width: 'resolve'
        });

    });


            $(document).on('submit', '#__formInsertDeliveryChallan', function(event) {
                event.preventDefault();

                var $msgSuccess = $('#__formInsertDeliveryChallan #msg-success');
                var $errorList = $('#__formInsertDeliveryChallan #error-list');
                // Clear existing errors (if any)
                $errorList.empty();
                var formData = new FormData($(this)[0]);
                //console.log(formData);
                $.ajax({
                    url: '{{ route('delivery.store') }}',
                    type: 'post',
                    data: formData,
                    contentType: false,
                    processData: false, // Add this line to prevent default processing of FormData
                    success: function(response) {
                        $("#msg-success").html(response.message);                            
                        $msgSuccess.show();
                        // Hide the modal after 3 seconds (1000 ms)
                        setTimeout(function() {
                            window.location.href = `/print-delivery-challan/${response.deliveryChallanId}`;
                            //$('#add-lender-modal').hide();
                            //location.reload();
                        }, 1000);
                        
                    },
                    error: function(error) {
                        $errorList.show();
                        var errorData = error.responseJSON;
                        console.error('result:', errorData.errors);
                        // Display errors on the UI (you can customize how to show these)
                        for (const [key, message] of Object.entries(errorData.errors)) {
                            // Assuming you have a way to show these errors in your UI
                            $errorList.append('<li>' + message + '</li>');                                    
                        }
                    }

                })
            });
    </script>

    @endpush