<x-app-layout>
    @section('title', 'Manage Partner Payments')
    <link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
        
    @if(\App\Models\Role::checkRolePermissions('Can access menu: Manage Users - Users'))
        <x-card class="mt-0">
            <div class="" style="margin-top: -2rem">
                <a href="{{route('partner.manage')}}">
                    <button class="btn mb-3 mr-2 {{ isset($title) && $title=='Owner' ? 'text-white bg-blue-500' : 'bg-gray-200 border' }}">Manage Owner</button>
                </a>
                <a href="{{route('investment.manage')}}">
                    <button class="btn mb-3 mr-2 {{ isset($title) && $title=='Investment' ? 'text-white bg-blue-500' : 'bg-gray-200 border' }}">Investment</button>
                </a>
                <a href="{{route('partner.profit')}}">
                    <button class="btn mb-3 mr-2 {{ isset($title) && $title=='Profit' ? 'text-white bg-blue-500' : 'bg-gray-200 border' }}">Profit</button>
                </a>

            </div>
            <hr>

            <card class="bg-gray-500 ">
                <div class="card-title my-4">
                    <h4><strong>Manage Payments</strong></h4>
                </div>

                <input type="hidden" id="partner_id" value="{{$partner_id}}" >
                <div class="flex justify-between flex-col">
                    <div class="overflow-x-auto">
                        <table class="w-full" id="datatable">
                            <thead>
                            <tr class="rounded-lg text-sm font-medium text-gray-700 text-left">
                                <th class="px-4 py-2 border-2">Date</th>
                                <th class="px-4 py-2 border-2">Owner Name</th>
                                <th class="px-4 py-2 border-2">Payment Method</th>
                                <th class="px-4 py-2 border-2">Amount</th>
                            </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </card>
        </x-card>
    @endif

    @push('bottom_js')
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.0/jquery.validate.js"></script>
        
       
        
        <script>

        

            $(document).ready(function() {
                dataTables("{{ route('partner_payment.data') }}") ;
                var datatable;
                function dataTables(url) {
                    // Datatable
                    datatable = $('#datatable').DataTable({
                        processing: true,
                        serverSide: true,
                        ajax: {
                        type: 'POST',
                        url: url,
                        data: {
                            partner_id: $("#partner_id").val()
                        }
                    },
                        columns: [{
                            name: 'payment_date',
                            data: 'payment_date'
                            },
                            {
                                name: 'partner_name',
                                data: 'partner_name'
                            },
                            {
                                name: 'payment_method',
                                data: 'payment_method'
                            },

                            
                            {
                                name: 'paid',
                                data: 'paid'
                            }
                        ]
                    });
                }
                $('#BtnInsert').click(function() {
                    $('.modal-insert').removeClass('modal-hide');
                });

                $(document).on('click', '#BtnShopUpdate', function() {
                    $('.modal-assign-shop').removeClass('modal-hide');
                    $.ajax({
                        url: '{{ route('staff.data') }}?assign_shop=true&id='+$(this).data('id'),
                        beforeSend: function() {
                            $('#form-assign-shop').html('Loading...');
                        }
                    }).done(function(result) {
                        $('#form-assign-shop').html(result);
                    });
                });

                $(document).on('click', '#closeAssignShopModal', function() {
                    $('.modal-assign-shop').addClass('modal-hide');
                });

                $(document).on('click', '#BtnUpdate', function() {
                    $('.modal-update').removeClass('modal-hide');
                    $.ajax({
                        url: '{{ route('investment.data') }}?id=' + $(this).data('id'),
                        beforeSend: function() {
                            $('#form-update').html('Loading...');
                        }
                    }).done(function(result) {
                        $('#form-update').html(result);
                    });
                });

                $(document).on('click', '#closeModalUpdate', function() {
                    $('.modal-update').addClass('modal-hide');
                });

                $('#closeModalInsert').click(function() {
                    $('.modal-insert').addClass('modal-hide');
                });


                $(document).on('click', '#BtnDelete', function() {
                    let drop = confirm('Are you sure?');
                    if (drop) {
                        $.ajax({
                            url: '{{ route('investment.delete') }}',
                            type: 'post',
                            data: {
                                'id': $(this).data('id'),
                                '_token': $('meta[name=csrf-token]').attr('content')
                            },
                            beforeSend: function() {
                                // Pesan yang muncul ketika memproses delete
                            }
                        }).done(function(result) {
                            if (result.status === 1) {
                                // Pesan jika data berhasil di hapus
                                alert('Data deleted successfully');
                                $('#datatable').DataTable().ajax.reload();
                            } else {
                                alert(result.message);
                            }
                        });
                    }
                });


                $('#partner_id').select2({
                    width: 'resolve',
                    placeholder: '- Select Owner Name -',
                    allowClear: true
                });

            });

        </script>
    @endpush

</x-app-layout>
