<style>
body {
    font-size: 15px;
}

.justify-between {
    justify-content: space-between !important;
}

.items-center {
    align-items: center !important;
}

.flex-row {
    flex-direction: row !important;
}

.flex {
    display: flex !important;
}

.mb-2 {
    margin-bottom: .5rem !important;
}

.text-yellow-green {
    color: rgba(16, 185, 129, var(--tw-bg-opacity)) !important;
}

.border-green-300 {
    --tw-border-opacity: 1 !important;
    border-color: rgba(16, 185, 129, var(--tw-bg-opacity)) !important;
}

.border-b-0 {
    border-bottom-width: 0 !important;
}

.border-l-0 {
    border-left-width: 0 !important;
}

.pr-3 {
    padding-right: .75rem !important;
}

.py-2 {
    padding-top: .5rem !important;
    padding-bottom: .5rem !important;
}

.text-uppercase {
    text-transform: uppercase !important;
}

.font-bold {
    font-weight: 700 !important;
}
</style>

<div class="mt-6">
    <div class="w-11/12 sm:w-3/5 xl:max-w-3xl mx-auto">
        <h2 class="text-xl text-center text-gray-800 font-bold leading-tight text-uppercase relative top-1">
            Owner's particulars/speciment signature
        </h2>
    </div>
</div>



<x-section.section>
    <x-section.body>
        <div class="w-full">
            <table class="w-full -mt-1">
                <tbody>
                    <tr>
                        <td class="pr-3 py-2 text-uppercase">
                            <span class="font-bold mr-2">
                                1.
                            </span>
                            <span class="font-bold">
                                Name
                            </span>
                        </td>
                        <td class="pl-3 py-2 text-left text-uppercase">
                            {{$orderManagement->customer->customer_name}}
                        </td>
                    </tr>

                    <tr>
                        <td class="pr-3 py-2 text-uppercase">
                            <span class="font-bold mr-2">
                                2.
                            </span>
                            <span class="font-bold">
                                Father's Name
                            </span>
                        </td>
                        <td class="pl-3 py-2 text-left text-uppercase">
                            {{$orderManagement->customer->father_or_husband_name}}
                        </td>
                    </tr>

                    <tr>
                        <td class="pr-3 py-2 text-uppercase">
                            <span class="font-bold mr-2">
                                3.
                            </span>
                            <span class="font-bold">
                                Guardian's Name
                            </span>
                        </td>
                        <td class="pl-3 py-2 text-left text-uppercase">
                            {{$orderManagement->customer->guardians_name}}
                        </td>
                    </tr>

                    <tr>
                        <td class="pr-3 py-2 text-uppercase">
                            <span class="font-bold mr-2">
                                4.
                            </span>
                            <span class="font-bold">
                                Sex
                            </span>
                        </td>
                        <td class="pl-3 py-2 text-left text-uppercase">
                            {{$orderManagement->customer->sex}}
                        </td>
                    </tr>


                    <tr>
                        <td class="pr-3 py-2 text-uppercase">
                            <span class="font-bold mr-2">
                                5.
                            </span>
                            <span class="font-bold">
                                Phone No
                            </span>
                        </td>
                        <td class="pl-3 py-2 text-left text-uppercase">
                            {{$orderManagement->customer->contact_phone}}
                        </td>
                    </tr>

                    <tr>
                        <td class="pr-3 py-2 text-uppercase">
                            <span class="font-bold mr-2">
                                6.
                            </span>
                            <span class="font-bold">
                                Nationality
                            </span>
                        </td>
                        <td class="pl-3 py-2 text-left text-uppercase">
                            {{$orderManagement->customer->nationality}}
                        </td>
                    </tr>

                    <tr>
                        <td class="pr-3 py-2 text-uppercase">
                            <span class="font-bold mr-2">
                                7.
                            </span>
                            <span class="font-bold">
                                Date of Birth
                            </span>
                        </td>
                        <td class="pl-3 py-2 text-left text-uppercase">
                            {{$orderManagement->customer->dob}}
                        </td>
                    </tr>

                    <tr>
                        <td class="pr-3 py-2 text-uppercase">
                            <span class="font-bold mr-2">
                                8.
                            </span>
                            <span class="font-bold">
                                Present Address
                            </span>
                        </td>
                        <td class="pl-3 py-2 text-left text-uppercase">
                            @php
                            $present_district = '';
                            $present_thana = '';
                            $present_postoffice = '';
                            $present_postcode = '';
                            if(!empty($orderManagement->customer->present_address)){
                            $arr_present_address = json_decode($orderManagement->customer->present_address);
                            $present_district = isset($arr_present_address->present_district) ?
                            $arr_present_address->present_district : '-';
                            $present_thana = isset($arr_present_address->present_thana) ?
                            $arr_present_address->present_thana : '-';
                            $present_postoffice = isset($arr_present_address->present_postoffice) ?
                            $arr_present_address->present_postoffice : '-';
                            $present_postcode = isset($arr_present_address->present_postcode) ?
                            $arr_present_address->present_postcode : '-';
                            }
                            @endphp
                            <span class="font-bold">District : </span> {{$present_district}},
                            <span class="font-bold">Thana : </span> {{$present_thana}},
                            <span class="font-bold">Post Office : </span> {{$present_postoffice}},
                            <span class="font-bold">Post Code : </span> {{$present_postcode}}
                        </td>
                    </tr>

                    <tr>
                        <td class="pr-3 py-2 text-uppercase">
                            <span class="font-bold mr-2">
                                9.
                            </span>
                            <span class="font-bold">
                                Permanent Address
                            </span>
                        </td>
                        <td class="pl-3 py-2 text-left text-uppercase">
                            @php

                            $permanent_district = '';
                            $permanent_thana = '';
                            $permanent_postoffice = '';
                            $permanent_postcode = '';

                            if(!empty($orderManagement->customer->permanent_address)){
                            $arr_permanent_address = json_decode($orderManagement->customer->permanent_address);
                            $permanent_district = isset($arr_permanent_address->permanent_district) ?
                            $arr_permanent_address->permanent_district : '-';
                            $permanent_thana = isset($arr_permanent_address->permanent_thana) ?
                            $arr_permanent_address->permanent_thana : '-';
                            $permanent_postoffice = isset($arr_permanent_address->permanent_postoffice) ?
                            $arr_permanent_address->permanent_postoffice : '-';
                            $permanent_postcode = isset($arr_permanent_address->permanent_postcode) ?
                            $arr_permanent_address->permanent_postcode : '-';
                            }
                            @endphp
                            @if($orderManagement->customer->same_as_present == 0)
                            <span class="font-bold">District : </span> {{$permanent_district}},
                            <span class="font-bold">Thana : </span> {{$permanent_thana}},
                            <span class="font-bold">Post Office : </span> {{$permanent_postoffice}},
                            <span class="font-bold">Post Code : </span> {{$permanent_postcode}}
                            @else
                            Same as present
                            @endif
                        </td>
                    </tr>

                    <tr>
                        <td class="pr-3 py-2 text-uppercase">
                            <span class="font-bold mr-2">
                                10.
                            </span>
                            <span class="font-bold">
                                Part Name.
                            </span>
                        </td>
                        <td class="pl-3 py-2 text-left text-uppercase">
                            {{$orderManagement->order_management_details[0]->product->part_name}}
                        </td>
                    </tr>

                    <tr>
                        <td class="pr-3 py-2 text-uppercase">
                            <span class="font-bold mr-2">
                                11.
                            </span>
                            <span class="font-bold">
                                Part No.
                            </span>
                        </td>
                        <td class="pl-3 py-2 text-left text-uppercase">
                            {{$orderManagement->order_management_details[0]->product->part_no}}
                        </td>
                    </tr>

                    <tr>
                        <td style="width:250px;" class="pr-3 py-2 text-uppercase">
                            <span class="font-bold mr-2">
                                12.
                            </span>
                            <span class="font-bold">
                                Year of Manufacture
                            </span>
                        </td>
                        <td class="pl-3 py-2 text-left text-uppercase">
                            @php
                            $year_of_mfg = '';
                            $arr_features =
                            json_decode($orderManagement->order_management_details[0]->product->features);
                            foreach($arr_features as $key=>$value){
                            if($key=='Year of Manufacture')
                            $year_of_mfg = $value;
                            }
                            @endphp

                            {{$year_of_mfg}}
                        </td>
                    </tr>



                </tbody>
            </table>
        </div>
    </x-section.body>
</x-section.section>

<x-section.section>
    <div class="flex flex-row items-center justify-between mb-2">
        <h2 class="block whitespace-nowrap text-green-500 text-base font-bold">
            Speciment signature
        </h2>
    </div>
    <x-section.body>
        <div class="w-full">
            <table class="w-full -mt-1" style="width:100%">
                <tbody>
                    <tr>
                        <td class="pr-3 py-2 text-uppercase" style="width:40%">
                            <span class="font-bold mr-2">
                                1.
                            </span>
                            <input type="text" style="border:none;border-bottom:1px dotted;width:95%;margin-top:10px;margin-left:10px;">
                        </td>
                        <td class="pl-3 py-2 text-left text-uppercase" style="width:40%;float:right;">
                            <span class="font-bold mr-2">
                                2.
                            </span>
                            <input type="text" style="border:none;border-bottom:1px dotted;width:95%;margin-top:10px;margin-left:10px;">
                        </td>
                    </tr>

                    <tr>
                        <td class="pr-3 py-8 text-uppercase" style="padding-top:50px;">
                            <span class="font-bold mr-2">
                                3.
                            </span>
                            <input type="text" style="border:none;border-bottom:1px dotted;width:95%;margin-top:10px;margin-left:10px;">
                        </td>
                        <td class="pl-3 py-8 text-left text-uppercase" style="padding-top:50px;float:right;">
                            <span class="font-bold mr-2">
                                4.
                            </span>
                            <input type="text" style="border:none;border-bottom:1px dotted;width:95%;margin-top:10px;margin-left:10px;">
                        </td>
                    </tr>

                </tbody>
            </table>
        </div>
    </x-section.body>
</x-section.section>