@php
$statusForStepContent = [
$orderStatusPending,
$orderStatusPendingPayment,
$orderStatusPaymentUnconfirmed
];

$statusForEnabledForm = [
$orderStatusPending
];

$statusForConfirmationStepDefault = [
$orderStatusPending
];

$statusForDisableReceiptForm = [
$orderStatusPaymentUnconfirmed
];
@endphp

<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name') }} - Owner Particulars</title>

    <link rel="preconnect" href="https://fonts.googleapis.com/" crossorigin>
    <link rel="preconnect" href="https://cdn.jsdelivr.net/" crossorigin>
    <link rel="preconnect" href="https://cdnjs.cloudflare.com/" crossorigin>
    <link rel="preconnect" href="https://code.jquery.com/" crossorigin>
    <link rel="dns-prefetch" href="https://fonts.googleapis.com/">
    <link rel="dns-prefetch" href="https://cdn.jsdelivr.net/">
    <link rel="dns-prefetch" href="https://cdnjs.cloudflare.com/">
    <link rel="dns-prefetch" href="https://code.jquery.com/">

    <!-- Fonts and Icons -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Nunito:wght@400;600;700&display=swap">

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/animate.css@4.1.1/animate.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/jquery-ui-dist@1.12.1/jquery-ui.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.19/dist/sweetalert2.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/jquery-timepicker@1.3.3/jquery.timepicker.min.css">
    

    <link rel="stylesheet" href="{{ asset('css/app.css?_=' . rand()) }}">

    <script src="https://cdn.jsdelivr.net/npm/jquery@3.6.0/dist/jquery.min.js"></script>
    <script src="{{ asset('js/dodo-modal.js?_=' . rand()) }}"></script>
    <link rel="stylesheet" href="{{ asset('css/buyer_page.css') }}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
</head>

<body class="font-sans antialiased min-h-screen bg-gray-100">
    

    <main class="mt-10">

        <div class="w-11/12 sm:w-3/5 xl:max-w-3xl mx-auto">
            <x-card.card-default>
                <x-card.body>
                    <form method="POST" target="_blank" action="{{route('pdfPrintOwnerParticulars')}}"
                        enctype="multipart/form-data">
                        @csrf
                        <input type="hidden" name="order_id" value="{{$orderManagement->order_id}}">
                        <div id="printArea">
                            <style>
                                body {
                                    font-size: 15px;
                                }

                                .justify-between {
                                    justify-content: space-between !important;
                                }

                                .items-center {
                                    align-items: center !important;
                                }

                                .flex-row {
                                    flex-direction: row !important;
                                }

                                .flex {
                                    display: flex !important;
                                }

                                .mb-2 {
                                    margin-bottom: .5rem !important;
                                }

                                .text-yellow-green {
                                    color: rgba(16, 185, 129, var(--tw-bg-opacity)) !important;
                                }

                                .border-green-300 {
                                    --tw-border-opacity: 1 !important;
                                    border-color: rgba(16, 185, 129, var(--tw-bg-opacity)) !important;
                                }

                                .border-b-0 {
                                    border-bottom-width: 0 !important;
                                }

                                .border-l-0 {
                                    border-left-width: 0 !important;
                                }

                                .pr-3 {
                                    padding-right: .75rem !important;
                                }

                                .py-2 {
                                    padding-top: .5rem !important;
                                    padding-bottom: .5rem !important;
                                }

                                .text-uppercase {
                                    text-transform: uppercase !important;
                                }

                                .font-bold {
                                    font-weight: 700 !important;
                                }
                                </style>
                            <header class="mt-6">
                                <div class="w-1/4 sm:w-32 xl:w-28 mx-auto">
                                    <img src="{{ $orderManagement->shop->logo_url }}" alt="{{ $orderManagement->shop->name }}"
                                        class="w-full h-auto">
                                </div>

                                <div class="w-11/12 sm:w-4/5 xl:max-w-3xl mx-auto">
                                    <h1 class="text-xl text-center text-gray-800 font-bold leading-tight text-uppercase relative top-1">
                                        Owner's particulars/speciment signature
                                    </h1>
                                </div>
                            </header>
                            <br/>

                            <x-section.section>
                                <x-section.title>
                                    Personal Info
                                </x-section.title>
                                <x-section.body>
                                    <div class="w-full">
                                        <table class="w-full -mt-1">
                                            <tbody>
                                                <tr>
                                                    <td class="pr-3 py-2 text-uppercase">
                                                        <span class="font-bold mr-2">
                                                            1.
                                                        </span>
                                                        <span class="font-bold">
                                                            Name
                                                        </span>
                                                    </td>
                                                    <td class="pl-3 py-2 text-left text-uppercase">
                                                        {{$orderManagement->customer->customer_name}}
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <td class="pr-3 py-2 text-uppercase">
                                                        <span class="font-bold mr-2">
                                                            2.
                                                        </span>
                                                        <span class="font-bold">
                                                            Father's Name
                                                        </span>
                                                    </td>
                                                    <td class="pl-3 py-2 text-left text-uppercase">
                                                        {{$orderManagement->customer->father_or_husband_name}}
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <td class="pr-3 py-2 text-uppercase">
                                                        <span class="font-bold mr-2">
                                                            3.
                                                        </span>
                                                        <span class="font-bold">
                                                            Guardian's Name
                                                        </span>
                                                    </td>
                                                    <td class="pl-3 py-2 text-left text-uppercase">
                                                        {{$orderManagement->customer->guardians_name}}
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <td class="pr-3 py-2 text-uppercase">
                                                        <span class="font-bold mr-2">
                                                            4.
                                                        </span>
                                                        <span class="font-bold">
                                                            Sex
                                                        </span>
                                                    </td>
                                                    <td class="pl-3 py-2 text-left text-uppercase">
                                                        {{$orderManagement->customer->sex}}
                                                    </td>
                                                </tr>


                                                <tr>
                                                    <td class="pr-3 py-2 text-uppercase">
                                                        <span class="font-bold mr-2">
                                                            5.
                                                        </span>
                                                        <span class="font-bold">
                                                            Phone No
                                                        </span>
                                                    </td>
                                                    <td class="pl-3 py-2 text-left text-uppercase">
                                                        {{$orderManagement->customer->contact_phone}}
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <td class="pr-3 py-2 text-uppercase">
                                                        <span class="font-bold mr-2">
                                                            6.
                                                        </span>
                                                        <span class="font-bold">
                                                            Nationality
                                                        </span>
                                                    </td>
                                                    <td class="pl-3 py-2 text-left text-uppercase">
                                                        {{$orderManagement->customer->nationality}}
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <td class="pr-3 py-2 text-uppercase">
                                                        <span class="font-bold mr-2">
                                                            7.
                                                        </span>
                                                        <span class="font-bold">
                                                            Date of Birth
                                                        </span>
                                                    </td>
                                                    <td class="pl-3 py-2 text-left text-uppercase">
                                                        {{$orderManagement->customer->dob}}
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <td class="pr-3 py-2 text-uppercase">
                                                        <span class="font-bold mr-2">
                                                            8.
                                                        </span>
                                                        <span class="font-bold">
                                                            Present Address
                                                        </span>
                                                    </td>
                                                    <td class="pl-3 py-2 text-left text-uppercase">
                                                        @php
                                                        $present_district = '';
                                                        $present_thana = '';
                                                        $present_postoffice = '';
                                                        $present_postcode = '';
                                                        if(!empty($orderManagement->customer->present_address)){
                                                        $arr_present_address =
                                                        json_decode($orderManagement->customer->present_address);
                                                        $present_district =
                                                        isset($arr_present_address->present_district) ?
                                                        $arr_present_address->present_district : '-';
                                                        $present_thana = isset($arr_present_address->present_thana) ?
                                                        $arr_present_address->present_thana : '-';
                                                        $present_postoffice =
                                                        isset($arr_present_address->present_postoffice) ?
                                                        $arr_present_address->present_postoffice : '-';
                                                        $present_postcode =
                                                        isset($arr_present_address->present_postcode) ?
                                                        $arr_present_address->present_postcode : '-';
                                                        }
                                                        @endphp
                                                        <span class="font-bold">District : </span>
                                                        {{$present_district}},
                                                        <span class="font-bold">Thana : </span> {{$present_thana}},
                                                        <span class="font-bold">Post Office : </span>
                                                        {{$present_postoffice}},<br />
                                                        <span class="font-bold">Post Code : </span>
                                                        {{$present_postcode}}
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <td class="pr-3 py-2 text-uppercase">
                                                        <span class="font-bold mr-2">
                                                            9.
                                                        </span>
                                                        <span class="font-bold">
                                                            Permanent Address
                                                        </span>
                                                    </td>
                                                    <td class="pl-3 py-2 text-left text-uppercase">
                                                        @php
                                                        $permanent_district = '';
                                                        $permanent_thana = '';
                                                        $permanent_postoffice = '';
                                                        $permanent_postcode = '';
                                                        if(!empty($orderManagement->customer->permanent_address)){
                                                        $arr_permanent_address =
                                                        json_decode($orderManagement->customer->permanent_address);
                                                        $permanent_district =
                                                        isset($arr_permanent_address->permanent_district) ?
                                                        $arr_permanent_address->permanent_district : '-';
                                                        $permanent_thana =
                                                        isset($arr_permanent_address->permanent_thana) ?
                                                        $arr_permanent_address->permanent_thana : '-';
                                                        $permanent_postoffice =
                                                        isset($arr_permanent_address->permanent_postoffice) ?
                                                        $arr_permanent_address->permanent_postoffice : '-';
                                                        $permanent_postcode =
                                                        isset($arr_permanent_address->permanent_postcode) ?
                                                        $arr_permanent_address->permanent_postcode : '-';
                                                        }
                                                        @endphp
                                                        @if($orderManagement->customer->same_as_present == 0)
                                                        <span class="font-bold">District : </span>
                                                        {{$permanent_district}},
                                                        <span class="font-bold">Thana : </span> {{$permanent_thana}},
                                                        <span class="font-bold">Post Office : </span>
                                                        {{$permanent_postoffice}},<br />
                                                        <span class="font-bold">Post Code : </span>
                                                        {{$permanent_postcode}}
                                                        @else
                                                        Same as present
                                                        @endif
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <td class="pr-3 py-2 text-uppercase">
                                                        <span class="font-bold mr-2">
                                                            10.
                                                        </span>
                                                        <span class="font-bold">
                                                            Part Name.
                                                        </span>
                                                    </td>
                                                    <td class="pl-3 py-2 text-left text-uppercase">
                                                        {{$orderManagement->order_management_details[0]->product->part_name}}
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <td class="pr-3 py-2 text-uppercase">
                                                        <span class="font-bold mr-2">
                                                            11.
                                                        </span>
                                                        <span class="font-bold">
                                                            Part No.
                                                        </span>
                                                    </td>
                                                    <td class="pl-3 py-2 text-left text-uppercase">
                                                        {{$orderManagement->order_management_details[0]->product->part_no}}
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <td class="pr-3 py-2 text-uppercase">
                                                        <span class="font-bold mr-2">
                                                            12.
                                                        </span>
                                                        <span class="font-bold">
                                                            Year of Manufacture
                                                        </span>
                                                    </td>
                                                    <td class="pl-3 py-2 text-left text-uppercase">
                                                        @php
                                                        $year_of_mfg = '';
                                                        $arr_features =
                                                        json_decode($orderManagement->order_management_details[0]->product->features);
                                                        foreach($arr_features as $key=>$value){
                                                        if($key=='Year of Manufacture')
                                                        $year_of_mfg = $value;
                                                        }
                                                        @endphp

                                                        {{$year_of_mfg}}
                                                    </td>
                                                </tr>



                                            </tbody>
                                        </table>
                                    </div>
                                </x-section.body>
                            </x-section.section>

                            <x-section.section>
                                <x-section.title>
                                    Speciment signature
                                </x-section.title>
                                <x-section.body>
                                    <br/>
                                    <br/>
                                    <div class="w-full">
                                        <table class="w-full -mt-1">
                                            <tbody>
                                                <tr>
                                                    <td class="pr-3 py-2 text-uppercase" style="width:40%">
                                                        <span class="font-bold mr-2">
                                                            1.
                                                        </span>
                                                        <input type="text" disabled style="border:none;border-bottom:1px dotted;margin-top:10px;margin-left:10px;">
                                                    </td>
                                                    <td class="pl-3 py-2 text-left text-uppercase"
                                                        style="float:right;">
                                                        <span class="font-bold mr-2">
                                                            2.
                                                        </span>
                                                        <input type="text" disabled style="border:none;border-bottom:1px dotted;margin-top:10px;margin-left:10px;">
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <td class="pr-3 py-8 text-uppercase" style="padding-top:50px;">
                                                        <span class="font-bold mr-2">
                                                            3.
                                                        </span>
                                                        <input type="text" disabled style="border:none;border-bottom:1px dotted;margin-top:10px;margin-left:10px;">
                                                    </td>
                                                    <td class="pl-3 py-8 text-left text-uppercase"
                                                        style="padding-top:50px;float:right;">
                                                        <span class="font-bold mr-2">
                                                            4.
                                                        </span>
                                                        <input type="text" disabled style="border:none;border-bottom:1px dotted;margin-top:10px;margin-left:10px;">
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </x-section.body>
                            </x-section.section>
                        </div> 
                                                           
                        <div class="pb-3">
                            <div class="flex items-center justify-center gap-1">
                                <x-button type="submit" color="green"  onclick="printDiv()">
                                    <i class="fa fa-print"></i>
                                    <span class="ml-2">
                                        Print
                                    </span>

                                </x-button>
                                <x-button type="submit" color="green" id="__btnPrint">
                                    <i class="fa fa-print"></i>
                                    <span class="ml-2">
                                        Make PDF
                                    </span>

                                </x-button>
                            </div>
                        </div>
                        
                    </form>
                </x-card.body>
            </x-card.card-default>
        </div>

    </main>

    <footer class="w-full">
        <div class="text-center py-6">
            <span class="text-gray-500">Powered By</span>
            <a href="" target="_blank" class="no-underline hover:underline text-gray-900 font-bold">
                TechCityIT,Bhairab</a>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/jquery-ui-dist@1.12.1/jquery-ui.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.19/dist/sweetalert2.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/jquery-timepicker@1.3.3/jquery.timepicker.min.js"></script>
    

    <!-- Script to print the content of a div -->
    <script>

    function printDiv() {
        var myStyle = '<link rel="stylesheet" href="{{ asset('css/app.css?_=' . rand()) }}">'
        var divContents = document.getElementById("printArea").innerHTML;
        var a = window.open('', '', 'height=600, width=900');
        a.document.write('<html>'+myStyle);
        a.document.write('<body >');
        a.document.write(divContents);
        a.document.write('</body></html>');
        a.document.close();
        a.print();
    }
    </script>


</body>

</html>