<x-app-layout>
    @section('title')
        {{ __('translation.Sales') }}
    @endsection

    @push('top_css')
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/jquery-ui-dist@1.12.1/jquery-ui.min.css">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/jquery-datatables-checkboxes@1.2.12/css/dataTables.checkboxes.css">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.19/dist/sweetalert2.min.css">
        <link rel="stylesheet" href="{{ asset('css/custom_css.css') }}">
    @endpush

    @push('bottom_css')
        <link rel="stylesheet" href="{{ asset('css/datatable-custom-toolbar.css?_=' . rand()) }}">

        <style>
            .dataTable tbody tr td {
                border-width: 0px !important;
                padding-top: 1rem !important;
                padding-bottom: 1rem !important;
            }
        </style>
    @endpush
    <input type="hidden" id="payment-receipt-path" value="<?php echo asset('storage/');?>">
    <input type="hidden" id="no-img-path" value="<?php echo asset('img/No_Image_Available.jpg');?>">

    @if (in_array('Can access menu: Order Management', session('assignedPermissions')))

        <div class="col-span-12">

            

            <div class="row">
                <div class="col-lg-12">
                    <x-card.card-default>
                        <x-card.body>
                            @if(session()->has('error'))
                                <div class="alert alert-danger mb-3 background-danger" role="alert">
                                    {{ session()->get('error') }}
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            @endif

                            @if(session()->has('success'))
                                <div class="alert alert-success mb-3 background-success" role="alert">
                                    {{ session()->get('success') }}
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            @endif

                            

                            <div class="flex flex-col sm:flex-row sm:justify-between items-start mb-2" id="datatableBtns">
                                <div class="w-full sm:mb-0">
                                    <div class="flex flex-col sm:flex-row">
                                        <div class="w-full sm:w-1/4 xl:ml-1 mb-1 sm:mb-0 relative -top-1">
                                            <x-input type="text" id="searchbar" placeholder="Search"></x-input>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="w-full overflow-x-auto">
                                <table class="w-full" id="__orderManagementTable">
                                    <thead>
                                    <tr class="bg-blue-500">
                                        <th class="px-4 py-2 text-white"></th>
                                        <th class="px-4 py-2 text-white text-center">
                                            {{ __('translation.Sales Data') }}
                                        </th>
                                    </tr>
                                    </thead>
                                    <tbody></tbody>
                                </table>
                            </div>
                        </x-card.body>
                    </x-card.card-default>
                </div>
            </div>
        </div>

    @endif



    @push('bottom_js')
        <script src="{{ asset('js/jquery.validate.js') }}"></script>
        <script src="https://cdn.jsdelivr.net/npm/jquery-datatables-checkboxes@1.2.12/js/dataTables.checkboxes.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/jquery-ui-dist@1.12.1/jquery-ui.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.19/dist/sweetalert2.min.js"></script>

        <script>
            const customerType = '{{ $customerType }}';
            const formManagementDatatableUrl = '{{ route('formsList') }}';
            var selectedSubStatusIds = '';
            var orderManagementTable = '';

            const textProcessing = '{{ __('translation.Processing') }}';
            const textCreateShipment = '{{ __('translation.Create Shipment') }}';
            const textUpdateShipment = '{{ __('translation.Update Shipment') }}';
            const textYesDelete = '{{ __('translation.Yes, Delete') }}';

            var totalProductPackOrder = 0;
            var totalDodoProductsOrdered = 0;

            const waitingForStock = {{ \App\Models\Shipment::SHIPMENT_STATUS_PENDING_STOCK }};
            const readyToShip = {{ \App\Models\Shipment::SHIPMENT_STATUS_READY_TO_SHIP }};

            var syncBtn = document.getElementById('datatableBtns');
            $("div.datatable_buttons").html(syncBtn);


        

            const loadOrderManagementTable = () => {
                orderManagementTable = $('#__orderManagementTable').DataTable({
                    dom: '<<"datatable_buttons"><rt>lip>',
                    bDestroy: true,
                    processing: true,
                    serverSide: true,
                    ajax: {
                        type: 'GET',
                        url: formManagementDatatableUrl,
                        data: {
                            customerType: customerType
                        }
                    },
                    columnDefs : [
                        {
                            targets: [0],
                            checkboxes: {
                                selectRow: true
                            }
                        },
                    ],
                    order: [
                        [1, 'desc']
                    ],
                    columns: [
                        {
                            name: 'checkbox',
                            data: 'checkbox'
                        },
                        {
                            data: 'order_data',
                            name: 'order_data'
                        }
                    ]
                });
            }

            loadOrderManagementTable();

            $("#searchbar").keyup(function() {
                orderManagementTable.search(this.value).draw();
            });

         
        </script>

        <script src="{{ asset('pages/seller/order_management/index/status_filter.js?_=' . rand()) }}"></script>
        <script src="{{ asset('js/orderManagementJs.js') }}"></script>
    @endpush

</x-app-layout>
