<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name') }} - Fees Detail BRTA</title>

    <link rel="preconnect" href="https://fonts.googleapis.com/" crossorigin>
    <link rel="preconnect" href="https://cdn.jsdelivr.net/" crossorigin>
    <link rel="preconnect" href="https://cdnjs.cloudflare.com/" crossorigin>
    <link rel="preconnect" href="https://code.jquery.com/" crossorigin>
    <link rel="dns-prefetch" href="https://fonts.googleapis.com/">
    <link rel="dns-prefetch" href="https://cdn.jsdelivr.net/">
    <link rel="dns-prefetch" href="https://cdnjs.cloudflare.com/">
    <link rel="dns-prefetch" href="https://code.jquery.com/">

    <!-- Fonts and Icons -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Nunito:wght@400;600;700&display=swap">

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/animate.css@4.1.1/animate.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/jquery-ui-dist@1.12.1/jquery-ui.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.19/dist/sweetalert2.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/jquery-timepicker@1.3.3/jquery.timepicker.min.css">
    

    <link rel="stylesheet" href="{{ asset('css/app.css?_=' . rand()) }}">

    <script src="https://cdn.jsdelivr.net/npm/jquery@3.6.0/dist/jquery.min.js"></script>
    <script src="{{ asset('js/dodo-modal.js?_=' . rand()) }}"></script>
    <link rel="stylesheet" href="{{ asset('css/buyer_page.css') }}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <style>
        table{
            border-collapse: collapse;
        }
        td{
            border:1px solid;
        }
    </style>
</head>

<body class="font-sans antialiased min-h-screen bg-gray-100">

    <main class="mt-10">

        <div class="w-11/12 sm:w-3/5 xl:max-w-3xl mx-auto">
            <x-card.card-default>
                <x-card.body>
                    <form method="POST" target="_blank" action="{{route('pdfFeesDetailBRTA')}}"
                        enctype="multipart/form-data">
                        @csrf
                        <input type="hidden" name="order_id" value="{{$orderManagement->order_id}}">
                        <div id="printArea">
                            <style>
                                table{
                                    border-collapse: collapse;
                                }
                                td{
                                    border:1px solid;
                                }
                            </style>
                            <header class="mt-6">
                                <div class="w-1/4 sm:w-32 xl:w-28 mx-auto">
                                    <img src="{{ $orderManagement->shop->logo_url }}" alt="{{ $orderManagement->shop->name }}"
                                        class="w-full h-auto">
                                </div>

                                <div class="w-11/12 sm:w-3/5 xl:max-w-3xl mt-5 mx-auto">
                                    <h1 class="text-xl text-center text-gray-800 font-bold leading-tight relative top-1">
                                        Government of the People's Republic of Bangladesh
                                    </h1>
                                    <p class="text-sm text-center text-gray-800 font-bold leading-tight relative mb-1">
                                        Bangladesh Road Transport Authority
                                    </p>
                                    <p class="text-sm text-center text-gray-800 font-bold leading-tight relative">
                                        Allenbary, Tejgaon, Dhaka-1210
                                    </p>
                                </div>
                            </header>
                            <br/>
                            <br/>
                            <x-section.section>
                                <x-section.body>
                                    <div class="w-full">
                                        <table class="w-full -mt-1">
                                            <tbody>
                                                <tr>
                                                    <td class="p-2" style="width:175px">
                                                        <span class="font-bold">
                                                            Name of Circle/Zone
                                                        </span>
                                                    </td>
                                                    <td class="p-2" style="width:350px">
                                                        
                                                    </td>
                                                    <td class="p-2 text-center">
                                                        <span class="font-bold">
                                                            District
                                                        </span>
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <td class="p-2">
                                                        <span class="font-bold">
                                                            Branch Name
                                                        </span>
                                                    </td>
                                                    <td class="p-2">
                                                        
                                                    </td>
                                                    <td class="p-2">
                                                        <span class="font-bold">
                                                            
                                                        </span>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </x-section.body>
                            </x-section.section>

                            <x-section.section>
                                <h5 class="text-center">
                                    Vehicle Information
                                </h5>
                                <x-section.body>
                                    <div class="w-full">
                                        <table class="w-full -mt-1">
                                            <tbody>
                                                <tr>
                                                    <td class="p-2 font-bold">
                                                        Registration No.
                                                    </td>
                                                    <td class="p-2 font-bold">
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <td class="p-2 font-bold">
                                                        Part Name.
                                                    </td>
                                                    <td class="p-2 font-bold">
                                                    {{$orderManagement->order_management_details[0]->product->part_name}}
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <td class="p-2 font-bold">
                                                        Part No.
                                                    </td>
                                                    <td class="p-2 font-bold">
                                                        {{$orderManagement->order_management_details[0]->product->part_no}}
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <td class="p-2 font-bold">
                                                        Owner Name
                                                    </td>
                                                    <td class="p-2 font-bold">
                                                        {{$orderManagement->customer->customer_name}}
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <td class="p-2 font-bold">
                                                        Father's Name
                                                    </td>
                                                    <td class="p-2 font-bold">
                                                        {{$orderManagement->customer->father_or_husband_name}}
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <td class="p-2 font-bold">
                                                        Type
                                                    </td>
                                                    <td class="p-2 font-bold">
                                                        Motorcycle
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <td class="p-2 font-bold" style="width:200px">
                                                        Setting Capacity/Weight
                                                    </td>
                                                    <td class="p-2 font-bold">
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <td class="p-2 font-bold">
                                                        Address
                                                    </td>
                                                    <td class="p-2 text-center font-bold">
                                                    </td>
                                                </tr>

                                            </tbody>
                                        </table>
                                    </div>
                                </x-section.body>
                            </x-section.section>

                            <x-section.section>
                                <h5 class="text-center">
                                    Fee Assesment
                                </h5>
                                <x-section.body>
                                    <div class="w-full">
                                        <table class="w-full -mt-1">
                                            <tbody>
                                                <tr>
                                                    <td class="p-2 font-bold text-center" style="width:50px">
                                                        No.
                                                    </td>
                                                    <td class="p-2 text-center font-bold">
                                                        Particular
                                                    </td>
                                                    <td class="p-2 text-center font-bold">
                                                        Main Fee
                                                    </td>
                                                    <td class="p-2 text-center font-bold">
                                                        Other's Fee
                                                    </td>
                                                    <td class="p-2 text-center font-bold">
                                                        Total
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <td class="p-2 font-bold text-center" style="width:50px">
                                                        1
                                                    </td>
                                                    <td class="p-2 text-left">
                                                        New Registration
                                                    </td>
                                                    <td class="p-2 text-center">
                                                        3000
                                                    </td>
                                                    <td class="p-2 text-center">
                                                        518
                                                    </td>
                                                    <td class="p-2 text-center">
                                                        3518
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <td class="p-2 font-bold text-center" style="width:50px">
                                                        2 
                                                    </td>
                                                    <td class="p-2 text-left">
                                                        Digital Registration Certificate
                                                    </td>
                                                    <td class="p-2 text-center">
                                                        540
                                                    </td>
                                                    <td class="p-2 text-center">
                                                        15
                                                    </td>
                                                    <td class="p-2 text-center">
                                                        555
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <td class="p-2 font-bold text-center" style="width:50px">
                                                        3
                                                    </td>
                                                    <td class="p-2 text-left">
                                                        Retro-Reflective Number Plate With RFID Tag
                                                    </td>
                                                    <td class="p-2 text-center">
                                                        2200
                                                    </td>
                                                    <td class="p-2 text-center">
                                                        60
                                                    </td>
                                                    <td class="p-2 text-center">
                                                        2260
                                                    </td>
                                                </tr>

                                                

                                                <tr>
                                                    <td class="p-2 font-bold text-center" style="width:50px">
                                                        4
                                                    </td>
                                                    <td class="p-2 text-left">
                                                       Inspection Fee
                                                    </td>
                                                    <td class="p-2 text-center">
                                                        450
                                                    </td>
                                                    <td class="p-2 text-center">
                                                        
                                                    </td>
                                                    <td class="p-2 text-center">
                                                        450
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <td class="p-2 font-bold text-center" style="width:50px">
                                                        5
                                                    </td>
                                                    <td class="p-2 text-left">
                                                        Road Tax (For 02 Years)[Total Road Tax is 11,500 Taka. Rest amount of Road Tax 11,500-2,300=9,200 Taka is payable @ 2300/- in next 4 installments at every 2 years with in 10 years from the date of registration]
                                                    </td>
                                                    <td class="p-2 text-center">
                                                        2000
                                                    </td>
                                                    <td class="p-2 text-center">
                                                        300
                                                    </td>
                                                    <td class="p-2 text-center">
                                                        2300
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <td class="p-2 font-bold text-center" colspan=2>
                                                        
                                                    </td>
                                                    
                                                    <td class="p-2 text-center font-bold">
                                                        8190
                                                    </td>
                                                    <td class="p-2 text-center font-bold">
                                                        893
                                                    </td>
                                                    <td class="p-2 text-center font-bold">
                                                        9083
                                                    </td>
                                                </tr>


                                            </tbody>
                                        </table>
                                    </div>
                                </x-section.body>
                            </x-section.section>
                        </div>
                        

                        <div class="pb-3">
                            <div class="flex items-center justify-center gap-1">
                                <x-button type="submit" color="green"  onclick="printDiv()">
                                    <i class="fa fa-print"></i>
                                    <span class="ml-2">
                                        Print
                                    </span>

                                </x-button>
                                <x-button type="submit" color="green" id="__btnPrint">
                                    <i class="fa fa-print"></i>
                                    <span class="ml-2">
                                        Make PDF
                                    </span>

                                </x-button>
                            </div>
                        </div>
                    </form>
                </x-card.body>
            </x-card.card-default>
        </div>

    </main>

    <footer class="w-full">
        <div class="text-center py-6">
            <span class="text-gray-500">Powered By</span>
            <a href="" target="_blank" class="no-underline hover:underline text-gray-900 font-bold">
                TechCityIT,Bhairab</a>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/jquery-ui-dist@1.12.1/jquery-ui.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.19/dist/sweetalert2.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/jquery-timepicker@1.3.3/jquery.timepicker.min.js"></script>
    

    <!-- Script to print the content of a div -->
    <script>

    function printDiv() {
        var myStyle = '<link rel="stylesheet" href="{{ asset('css/app.css?_=' . rand()) }}">'
        var divContents = document.getElementById("printArea").innerHTML;
        var a = window.open('', '', 'height=600, width=900');
        a.document.write('<html>'+myStyle);
        a.document.write('<body >');
        a.document.write(divContents);
        a.document.write('</body></html>');
        a.document.close();
        a.print();
    }
    </script>


</body>

</html>