<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name') }} - Delivery Challan</title>

    <link rel="preconnect" href="https://fonts.googleapis.com/" crossorigin>
    <link rel="preconnect" href="https://cdn.jsdelivr.net/" crossorigin>
    <link rel="preconnect" href="https://cdnjs.cloudflare.com/" crossorigin>
    <link rel="preconnect" href="https://code.jquery.com/" crossorigin>
    <link rel="dns-prefetch" href="https://fonts.googleapis.com/">
    <link rel="dns-prefetch" href="https://cdn.jsdelivr.net/">
    <link rel="dns-prefetch" href="https://cdnjs.cloudflare.com/">
    <link rel="dns-prefetch" href="https://code.jquery.com/">

    <!-- Fonts and Icons -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Nunito:wght@400;600;700&display=swap">

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/animate.css@4.1.1/animate.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/jquery-ui-dist@1.12.1/jquery-ui.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.19/dist/sweetalert2.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/jquery-timepicker@1.3.3/jquery.timepicker.min.css">
    

    <link rel="stylesheet" href="{{ asset('css/app.css?_=' . rand()) }}">

    <script src="https://cdn.jsdelivr.net/npm/jquery@3.6.0/dist/jquery.min.js"></script>
    <script src="{{ asset('js/dodo-modal.js?_=' . rand()) }}"></script>
    <link rel="stylesheet" href="{{ asset('css/buyer_page.css') }}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <style>
        table{
            border-collapse: collapse;
        }
        td{
            border:1px solid;
        }
        h1{
            border-bottom: double;
            padding:8px;
        }
    </style>
</head>

<body class="font-sans antialiased min-h-screen bg-gray-100">
    <header class="mt-6">
        <div class="w-1/4 sm:w-32 xl:w-28 mx-auto">
            <img src="{{ $orderManagement->shop->logo_url }}" alt="{{ $orderManagement->shop->name }}"
                class="w-full h-auto">
        </div>

        <div class="w-11/12 sm:w-3/5 xl:max-w-3xl mx-auto">
            <h1 class="text-xl text-center text-gray-800 font-bold leading-tight relative top-1">
                Delivery Challan
            </h1>
            <p class="text-right font-bold"><span>Date: </span> {{date("d/m/Y")}} </p>           
        </div>
    </header>

    {{-- @if (in_array($orderManagement->order_status, $statusForStepContent)) --}}
    <main class="mt-10">

        <div class="w-11/12 sm:w-3/5 xl:max-w-3xl mx-auto">
            <x-card.card-default>
                <x-card.body>
                    <form method="POST" target="_blank" action="{{route('pdfDeliveryChallan')}}"
                        enctype="multipart/form-data">
                        @csrf
                        <input type="hidden" name="order_id" value="{{$orderManagement->order_id}}">
                        <div id="__confirmOrderStepContentWrapper">

                            <x-section.section>
                                <x-section.body>
                                    <div class="w-full">
                                        <table class="w-full -mt-1">
                                            <tbody>
                                                <tr>
                                                    <td class="p-2" style="width:200px">
                                                        <span class="font-bold">
                                                            Name
                                                        </span>
                                                    </td>
                                                    <td class="p-2 font-bold" style="width:10px">
                                                        : 
                                                    </td>
                                                    <td class="p-2">
                                                        
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <td class="p-2">
                                                        <span class="font-bold">
                                                            Father's/Husband's Name
                                                        </span>
                                                    </td>
                                                    <td class="p-2 font-bold" style="width:10px">
                                                        : 
                                                    </td>
                                                    <td class="p-2">
                                                        <span class="font-bold">
                                                            
                                                        </span>
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <td class="p-2">
                                                        <span class="font-bold">
                                                            Address
                                                        </span>
                                                    </td>
                                                    <td class="p-2 font-bold" style="width:10px">
                                                        : 
                                                    </td>
                                                    <td class="p-2">
                                                        <span class="font-bold">
                                                            
                                                        </span>
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <td class="p-2">
                                                        <span class="font-bold">
                                                            Phone No.
                                                        </span>
                                                    </td>
                                                    <td class="p-2 font-bold" style="width:10px">
                                                        : 
                                                    </td>
                                                    <td class="p-2">
                                                        <span class="font-bold">
                                                            
                                                        </span>
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <td class="pt-2 px-2" colspan="3">
                                                        <span class="font-bold" style="font-size: 8.53pt;">
                                                            Please receive the undermentioned vehicles/which standard/Extra tools with spara wheel and accessories on the following perticulars:
                                                        </span>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>

                                    <div class="w-full mt-10">
                                        <table class="w-full -mt-1">
                                            <tbody>
                                                <tr>
                                                    <td class="p-2 font-bold" style="width:10px">
                                                        1 
                                                    </td>
                                                    <td class="p-2" style="width:200px">
                                                        <span class="font-bold">
                                                            Part Name.
                                                        </span>
                                                    </td>
                                                    <td class="p-2 font-bold" style="width:10px">
                                                        : 
                                                    </td>
                                                    <td class="p-2">
                                                        
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <td class="p-2 font-bold" style="width:10px">
                                                        2 
                                                    </td>
                                                    <td class="p-2" style="width:200px">
                                                        <span class="font-bold">
                                                            Part No.
                                                        </span>
                                                    </td>
                                                    <td class="p-2 font-bold" style="width:10px">
                                                        : 
                                                    </td>
                                                    <td class="p-2">
                                                        
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <td class="p-2 font-bold" style="width:10px">
                                                        2 
                                                    </td>
                                                    <td class="p-2" style="width:200px">
                                                        <span class="font-bold">
                                                            Taka
                                                        </span>
                                                    </td>
                                                    <td class="p-2 font-bold" style="width:10px">
                                                        : 
                                                    </td>
                                                    <td class="p-2">
                                                        
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <td class="p-2 font-bold" style="width:10px">
                                                        2 
                                                    </td>
                                                    <td class="p-2" style="width:200px">
                                                        <span class="font-bold">
                                                            Taka (In Word)
                                                        </span>
                                                    </td>
                                                    <td class="p-2 font-bold" style="width:10px">
                                                        : 
                                                    </td>
                                                    <td class="p-2">
                                                        
                                                    </td>
                                                </tr>


                                            </tbody>
                                        </table>
                                    </div>
                                </x-section.body>
                            </x-section.section>

                            <x-section.section>
                                <x-section.body>
                                    <div class="w-full">
                                        <table class="w-full -mt-1">
                                            <tbody>
                                                <tr>
                                                    <td style="border:1px solid;padding:50px;">
                                                        
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td style="border:none;padding:0px;">
                                                      Receive with thanks the above mentioned Vehicle(s) with Perfect Condition along with tools and Accessories. 
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </x-section.body>
                            </x-section.section>

                            <x-section.section>
                                <x-section.body>
                                    <div class="w-full" style="margin-top:100px">
                                        <table class="w-full -mt-1">
                                            <tbody>
                                                <tr>
                                                    <td class="p-0 font-bold text-center" style="width:100px;border:none;">
                                                        
                                                    </td>
                                                    <td class="p-0 text-center font-bold" style="width:200px;border:none;border-top:1px solid;">
                                                        (Buyer's Signature)
                                                    </td>
                                                    <td class="p-0 font-bold text-center" style="width:100px;border:none;">
                                                        
                                                    </td>
                                                    <td class="p-0 text-center font-bold" style="width:200px;border:none;border-top:1px solid;">
                                                        For:
                                                    </td>
                                                    <td class="p-0 font-bold text-center" style="width:100px;border:none;">
                                                        
                                                    </td>
                                                </tr>

                                                


                                            </tbody>
                                        </table>
                                    </div>
                                </x-section.body>
                            </x-section.section>

                            <div class="pb-3">
                                <div class="flex items-center justify-center gap-1">
                                    <x-button type="submit" color="green" id="__btnPrint">
                                        <i class="fa fa-print"></i>
                                        <span class="ml-2">
                                            Print
                                        </span>

                                    </x-button>
                                </div>
                            </div>
                        </div>
                    </form>
                </x-card.body>
            </x-card.card-default>
        </div>

    </main>

    <footer class="w-full">
        <div class="text-center py-6">
            <span class="text-gray-500">Powered By</span>
            <a href="" target="_blank" class="no-underline hover:underline text-gray-900 font-bold">
                TechCityIT,Bhairab</a>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/jquery-ui-dist@1.12.1/jquery-ui.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.19/dist/sweetalert2.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/jquery-timepicker@1.3.3/jquery.timepicker.min.js"></script>
    

    <script>

    </script>


</body>

</html>