<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name') }} - Application For Registration</title>

    <link rel="preconnect" href="https://fonts.googleapis.com/" crossorigin>
    <link rel="preconnect" href="https://cdn.jsdelivr.net/" crossorigin>
    <link rel="preconnect" href="https://cdnjs.cloudflare.com/" crossorigin>
    <link rel="preconnect" href="https://code.jquery.com/" crossorigin>
    <link rel="dns-prefetch" href="https://fonts.googleapis.com/">
    <link rel="dns-prefetch" href="https://cdn.jsdelivr.net/">
    <link rel="dns-prefetch" href="https://cdnjs.cloudflare.com/">
    <link rel="dns-prefetch" href="https://code.jquery.com/">

    <!-- Fonts and Icons -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Nunito:wght@400;600;700&display=swap">

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/animate.css@4.1.1/animate.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/jquery-ui-dist@1.12.1/jquery-ui.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.19/dist/sweetalert2.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/jquery-timepicker@1.3.3/jquery.timepicker.min.css">
    

    <link rel="stylesheet" href="{{ asset('css/app.css?_=' . rand()) }}">

    <script src="https://cdn.jsdelivr.net/npm/jquery@3.6.0/dist/jquery.min.js"></script>
    <script src="{{ asset('js/dodo-modal.js?_=' . rand()) }}"></script>
    <link rel="stylesheet" href="{{ asset('css/buyer_page.css') }}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <style>
        table{
            border-collapse: collapse;
        }
        td{
            border:1px solid;
        }
    </style>
</head>

<body class="font-sans antialiased min-h-screen bg-gray-100">

    <main class="mt-10">

        <div class="w-11/12 sm:w-3/5 xl:max-w-3xl mx-auto">
            <x-card.card-default>
                <x-card.body>
                    <form method="POST" target="_blank" action="{{route('pdfFeesDetailBRTA')}}"
                        enctype="multipart/form-data">
                        @csrf
                        <input type="hidden" name="order_id" value="{{$orderManagement->order_id}}">
                        <div id="printArea">
                            <style>
                                table{
                                    border-collapse: collapse;
                                }
                                td{
                                    border:0px solid;
                                }
                                p {
                                    margin-top: 0;
                                    margin-bottom: 0.5rem;
                                }
                            </style>
                            <header class="mt-6">
                                <!-- <div class="w-1/4 sm:w-32 xl:w-28 mx-auto">
                                    <img src="{{ $orderManagement->shop->logo_url }}" alt="{{ $orderManagement->shop->name }}"
                                        class="w-full h-auto">
                                </div> -->

                                <div class="w-full sm:w-w-full xl:max-w-3xl mt-5 mx-auto">
                                    <h1 class="text-xl text-center text-uppercase text-gray-800 font-bold leading-tight relative top-1">
                                        Form of application for the registration of motor vehicle
                                    </h1>
                                </div>
                            </header>
                            <br/>
                            <br/>

                            <x-section.section>
                                <x-section.body>
                                    <div class="w-full">
                                        <p class="text-sm text-center text-gray-800 font-bold leading-tight relative">
                                            To be filled in by the office
                                        </p>
                                        <p class="text-sm text-center text-gray-800 font-bold leading-tight relative">
                                            Section-I
                                        </p>
                                        
                                        <table class="w-full -mt-1">
                                            <tbody>
                                                <tr>
                                                    <td class="py-0" style="width:141px">
                                                        <span class="font-bold">
                                                            Reg No. :
                                                        </span>
                                                    </td>
                                                    <td class="py-0" style="width:175px">
                                                        
                                                    </td>
                                                    <td class="py-0" style="width:136px">
                                                        <span class="font-bold">
                                                            Date :
                                                        </span>
                                                    </td>
                                                    <td class="py-0" style="width:175px">
                                                        
                                                    </td>
                                                    <td class="py-0" style="width:189px">
                                                        <span class="font-bold">
                                                            Prev. Reg. No (If any) :
                                                        </span>
                                                    </td>
                                                    <td class="py-0" style="width:175px">
                                                        
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <td class="py-0">
                                                        <span class="font-bold">
                                                            Issue :
                                                        </span>
                                                    </td>
                                                    <td class="py-0">
                                                        
                                                    </td>
                                                    <td class="py-0">
                                                        <span class="font-bold">
                                                            Date :
                                                        </span>
                                                    </td>
                                                    <td class="py-0">
                                                        
                                                    </td>
                                                    <td class="py-0" >
                                                        <span class="font-bold">
                                                            Issued by :
                                                        </span>
                                                    </td>
                                                    <td class="py-0">
                                                        
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <td class="py-0">
                                                        <span class="font-bold">
                                                            Diary No :
                                                        </span>
                                                    </td>
                                                    <td class="py-0">
                                                        
                                                    </td>
                                                    <td class="py-0">
                                                        <span class="font-bold">
                                                            Date :
                                                        </span>
                                                    </td>
                                                    <td class="py-0">
                                                        
                                                    </td>
                                                    <td class="py-0" >
                                                        <span class="font-bold">
                                                            Received by :
                                                        </span>
                                                    </td>
                                                    <td class="py-0">
                                                        
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <td class="py-0">
                                                        <span class="font-bold">
                                                            Customer ID :
                                                        </span>
                                                    </td>
                                                    <td class="py-0">
                                                        
                                                    </td>
                                                    <td class="py-0">
                                                        <span class="font-bold">
                                                            District :
                                                        </span>
                                                    </td>
                                                    <td class="py-0">
                                                        
                                                    </td>
                                                    <td class="py-0" >
                                                        <span class="font-bold">
                                                            Vehicle ID :
                                                        </span>
                                                    </td>
                                                    <td class="py-0">
                                                        
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <td class="py-0">
                                                        <span class="font-bold">
                                                            Veh. Decription :
                                                        </span>
                                                    </td>
                                                    <td class="py-0" colspan=3>
                                                        
                                                    </td>
                                                    
                                                    <td class="py-0" >
                                                        <span class="font-bold">
                                                            Call on Date :
                                                        </span>
                                                    </td>
                                                    <td class="py-0">
                                                        
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <td class="py-0">
                                                        <span class="font-bold">
                                                            Refusal Date :
                                                        </span>
                                                    </td>
                                                    <td class="py-0">
                                                        
                                                    </td>
                                                    <td class="py-0">
                                                        <span class="font-bold">
                                                        Refusal Code :
                                                        </span>
                                                    </td>
                                                    <td class="py-0">
                                                        
                                                    </td>
                                                    <td class="py-0" >
                                                        <span class="font-bold">
                                                        Refused by :
                                                        </span>
                                                    </td>
                                                    <td class="py-0">
                                                        
                                                    </td>
                                                </tr>


                                            </tbody>
                                        </table>
                                    </div>
                                </x-section.body>
                            </x-section.section>
                      
                            <x-section.section>
                                <x-section.body>
                                    <div class="w-full">
                                        <p class="text-sm text-center text-gray-800 font-bold leading-tight relative">
                                            To be filled in by the office
                                        </p>
                                        <p class="text-sm text-center text-gray-800 font-bold leading-tight relative">
                                            Section-II
                                        </p>
                                        <table class="w-full -mt-1">
                                            <tbody>
                                                <tr>
                                                    <td class="py-0" style="width:174px">
                                                        <span class="font-bold">
                                                            1. Name Of Owner :
                                                        </span>
                                                    </td>
                                                    <td class="py-0" style="width:175px">
                                                        {{$orderManagement->customer->customer_name}}
                                                    </td>
                                                    <td class="py-0" style="width:127px">
                                                        <span class="font-bold">
                                                            2. Date of birth :
                                                        </span>
                                                    </td>
                                                    <td class="py-0" style="width:175px">
                                                        {{$orderManagement->customer->dob}}
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <td class="py-0">
                                                        <span class="font-bold">
                                                            3. Father/Husband :
                                                        </span>
                                                    </td>
                                                    <td class="py-0">
                                                        {{$orderManagement->customer->father_or_husband_name}}
                                                    </td>
                                                    <td class="py-0">
                                                        <span class="font-bold">
                                                            4. Nationality :
                                                        </span>
                                                    </td>
                                                    <td class="py-0">
                                                        {{$orderManagement->customer->nationality}}
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <td class="py-0">
                                                        <span class="font-bold">
                                                            5. Sex :
                                                        </span>
                                                    </td>
                                                    <td class="py-0">
                                                        {{$orderManagement->customer->sex}}
                                                    </td>
                                                    <td class="py-0">
                                                        <span class="font-bold">
                                                            6. Guardian's Name :
                                                        </span>
                                                    </td>
                                                    <td class="py-0">
                                                        {{$orderManagement->customer->guardians_name}}
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <td class="py-0">
                                                        <span class="font-bold">
                                                            7. Owner's Present Address :
                                                        </span>
                                                    </td>
                                                    <td class="py-0" colspan=3>
                                                    @php
                                                        $present_district = '';
                                                        $present_thana = '';
                                                        $present_postoffice = '';
                                                        $present_postcode = '';
                                                        if(!empty($orderManagement->customer->present_address)){
                                                        $arr_present_address = json_decode($orderManagement->customer->present_address);
                                                        $present_district = isset($arr_present_address->present_district) ?
                                                        $arr_present_address->present_district : '-';
                                                        $present_thana = isset($arr_present_address->present_thana) ?
                                                        $arr_present_address->present_thana : '-';
                                                        $present_postoffice = isset($arr_present_address->present_postoffice) ?
                                                        $arr_present_address->present_postoffice : '-';
                                                        $present_postcode = isset($arr_present_address->present_postcode) ?
                                                        $arr_present_address->present_postcode : '-';
                                                        }
                                                        @endphp
                                                        <span class="font-bold">District : </span> {{$present_district}},
                                                        <span class="font-bold">Thana : </span> {{$present_thana}},
                                                        <span class="font-bold">Post Office : </span> {{$present_postoffice}},
                                                        <span class="font-bold">Post Code : </span> {{$present_postcode}}
                                                    </td>
                                                    
                                                </tr>

                                                <tr>
                                                    <td class="py-0">
                                                        <span class="font-bold">
                                                            8. Phone (if any) :
                                                        </span>
                                                    </td>
                                                    <td class="py-0">
                                                        {{$orderManagement->customer->contact_phone}}
                                                    </td>
                                                    
                                                    <td class="py-0" >
                                                        <span class="font-bold">
                                                            9. P.o/Bank :
                                                        </span>
                                                    </td>
                                                    <td class="py-0">
                                                        
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <td class="py-0">
                                                        <span class="font-bold">
                                                            10. Joint Owner :
                                                        </span>
                                                    </td>
                                                    <td class="py-0 text-capitalize">
                                                     @if($orderManagement->owner_type=='joint') Yes
                                                        @else No
                                                     @endif    
                                                    </td>
                                                    <td class="py-0">
                                                        <span class="font-bold">
                                                        11. Ownter type :
                                                        </span>
                                                    </td>
                                                    <td class="py-0 text-capitalize">
                                                        {{$orderManagement->owner_type}}
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <td class="py-0">
                                                        <span class="font-bold">
                                                            12. Hire :
                                                        </span>
                                                    </td>
                                                    <td class="py-0">
                                                        
                                                    </td>
                                                    <td class="py-0">
                                                        <span class="font-bold">
                                                        13. Hire Purchase :
                                                        </span>
                                                    </td>
                                                    <td class="py-0">
                                                        
                                                    </td>
                                                </tr>


                                            </tbody>
                                        </table>
                                    </div>
                                </x-section.body>
                            </x-section.section>
                            <br/>
                            <x-section.section>
                                <x-section.body>
                                    <div class="w-full">
                                        <p class="text-sm text-center text-gray-800 font-bold leading-tight relative">
                                        Vehicle Information
                                        </p>
                                        <p class="text-sm text-center text-gray-800 font-bold leading-tight relative">
                                            Section-III
                                        </p>
                                        <table class="w-full -mt-1">
                                            <tbody>
                                                <tr>
                                                    <td class="py-0" style="width:174px">
                                                        <span class="font-bold">
                                                            14. Part Name. :
                                                        </span>
                                                    </td>
                                                    <td class="py-0" style="width:175px">
                                                        {{$orderManagement->order_management_details[0]->product->part_name}}
                                                    </td>
                                                    <td class="py-0" style="width:157px">
                                                        <span class="font-bold">
                                                            15. Part No. :
                                                        </span>
                                                    </td>
                                                    <td class="py-0" style="width:175px">
                                                        {{$orderManagement->order_management_details[0]->product->part_no}}
                                                    </td>
                                                </tr>
                                               
                                                @php 
                                                $i=16;
                                                $features = $orderManagement->order_management_details[0]->product->features;
                                                $arr_features = json_decode($features);
                                                @endphp
                                                <tr>
                                                @if(!empty($arr_features))
                                                    @foreach($arr_features as $key=>$value)
                                                    
                                                        <td class="py-0">
                                                            <span class="font-bold text-capitalize">
                                                                {{$i++}}. {{ str_replace("_"," ", $key)}} :
                                                            </span>
                                                        </td>
                                                        <td class="py-0">
                                                            {{ $value }}
                                                        </td>
                                                    @if($i%2==0) </tr> @endif
                                                    
                                                    @endforeach
                                                @endif
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </x-section.body>
                            </x-section.section>

                            <x-section.section>
                                <p class="text-sm text-center text-gray-800 font-bold leading-tight relative">
                                    Section-IV
                                </p>
                                <x-section.body>
                                    <div class="w-full">
                                        <table class="w-full -mt-1">
                                            <tbody>
                                            @php 
                                                $overall_length =  '';   
                                                $overall_width =  '';   
                                                $overall_height =  '';   
                                                $getDimensions = json_decode($orderManagement->order_management_details[0]->product->dimensions,true); 
                                                if(!empty($getDimensions)){
                                                    $overall_length = $getDimensions['overall_length'];
                                                    $overall_width = $getDimensions['overall_width'];
                                                    $overall_height = $getDimensions['overall_height'];
                                                }               
                                            @endphp

                                                <tr>
                                                    <td class="py-0 font-bold" colspan=3>
                                                        {{$i++}}. Dimensions (mm).
                                                    </td>
                                                </tr>

                                                <tr>
                                                    
                                                    <td class="py-0 font-bold pl-5">
                                                        a) Overall length : {{$overall_length}}
                                                    </td>
                                                    <td class="py-0 font-bold pl-5">
                                                        b) Overall width : {{$overall_width}}
                                                    </td>
                                                    <td class="py-0 font-bold pl-5">
                                                        c) Overall height : {{$overall_height}}
                                                    </td>
                                                </tr>

                                                @php 
                                                    $front =  '';   
                                                    $rear =  '';   
                                                    $other =  '';   
                                                    $getOverhangs = json_decode($orderManagement->order_management_details[0]->product->overhangs,true); 
                                                    if(!empty($getOverhangs)){
                                                        $front = $getOverhangs['front'];
                                                        $rear = $getOverhangs['rear'];
                                                        $other = $getOverhangs['other'];
                                                    }               
                                                @endphp

                                                <tr>
                                                    <td class="py-0 font-bold" colspan=3>
                                                        {{$i++}}. Overhangs (%).
                                                    </td>
                                                </tr>

                                                <tr>
                                                    
                                                    <td class="py-0 font-bold pl-5">
                                                        a) Front : {{$front}}
                                                    </td>
                                                    <td class="py-0 font-bold pl-5">
                                                        b) Rear : {{$rear}}
                                                    </td>
                                                    <td class="py-0 font-bold pl-5">
                                                        c) Other : {{$other}}
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <td class="py-0" colspan=3>
                                                        {{$i++}}. A copy of the drawing showing the vehicle dimension. Specification of the body and the agreements approved by ................................................................... on .................................. is attached.
                                                    <td>
                                                </tr>

                                                <tr>
                                                    <td class="py-0 font-bold" colspan=3>
                                                        {{$i++}}. Hire purchase/hypothecation information:<br/>
                                                        The vehicle is subject of hire purchase/hypothecation with:
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="py-0 font-bold pl-5" colspan=2>
                                                        a) Name : <br/>
                                                         Addrres :
                                                    </td>
                                                    <td class="py-0 font-bold pl-5">
                                                        b) Date :
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <td class="py-0 font-bold" colspan=3>
                                                        {{$i++}}. Insurance information:
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="py-0 font-bold pl-2">
                                                        a) Policy no :
                                                    </td>
                                                    <td class="py-0 font-bold pl-2">
                                                        b) Type of policy :
                                                    </td>
                                                    <td class="py-0 font-bold pl-2">
                                                        b) Insurer's name : <br/>
                                                        Address :
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <td class="py-0 font-bold" colspan=3>
                                                        {{$i++}}. Joint owner information:
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="py-0 font-bold pl-2">
                                                        a) Name:
                                                        <br/> Father/Husband:
                                                    </td>
                                                    <td></td>
                                                    <td class="py-0 font-bold pl-2">
                                                        b) Name:
                                                        <br/> Father/Husband:
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>

                                        

                                        

                                    </div>
                                </x-section.body>
                            </x-section.section>

                            <x-section.section>
                                <p class="text-sm text-center text-gray-800 font-bold leading-tight relative">
                                    Section-V
                                </p>
                                <x-section.body>
                                <table class="w-full -mt-1">
                                    <tbody>
                                    <tr>
                                        <td class="w-full font-bold" colspan=2>
                                            {{$i++}} Declaration by owner :
                                        </td>
                                    </tr>
                                    <tr>
                                    <td class="py-0 " colspan=2>
                                    (Declaration Certificates and documents)
                                    signed do her by declare that to the best of my knowledge and belief, the information give and the documents
                                    enclosed (as per list attached) are true. I also declare that in case the papers/documents and information
                                    furnished to be incorrect at any latter stage, I shall be liable for legal action.
                                    </td>
                                    </tr>
                                    <tr>
                                    <td class="py-0 font-bold"><br/><br/>
                                        Date:<br/>
                                        Encl: List of documents
                                    </td>
                                    <td class="py-0 text-center font-bold" style='width:180px;'>
                                    <br/><br/>
                                        Signature of Owner
                                    </td>
                                    </tr>
                                    <tr>
                                        <td class="w-full font-bold" colspan=2>
                                            {{$i++}} Registered dealer's certificate :
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="py-0 " colspan=2>
                                        I the undersigned do here by certify that the vehicle in question has been sold by me/my firm and the ownership
                                        documents attached with the application for registration are true. The information / specifications pertaining to
                                        the vehicle are correct and the vehicle complies with all the requirements of the registration.
                                        </td>
                                    </tr>
                                    <tr>
                                    <td class="py-0 font-bold"><br/><br/>
                                        Date:<br/>
                                        Encl: List of documents
                                    </td>
                                    <td class="py-0 text-center font-bold" style='width:180px;'>
                                    <br/><br/>
                                        Signature of registered dealer
                                    </td>
                                    </tr>

                                    <tr>
                                        <td class="w-full font-bold" colspan=2>
                                            {{$i++}} Certificate by the Inspector of Motor Vehicles :
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="py-0 " colspan=2>
                                        Certified that the particulars pertaining to the owner and the vehicle <span class="font-bold">(Chasis no.
                                        Engin no. {{$orderManagement->order_management_details[0]->product->part_name}}-{{$orderManagement->order_management_details[0]->product->part_no}} )</span> Given in the application match with the ownership documents attached to this
                                        application. It is further certified that he vehicle complies with the registration requirements specified in the
                                        MV Act and the Rules and/ or Regulation made the under and the vehicle is not mechanically defective.
                                        The necessary documents/papers are available as per list enclosed.
                                        </td>
                                    </tr>
                                    <tr>
                                    <td class="py-0 font-bold"><br/><br/>
                                        Date:<br/>
                                        Encl: List of documents
                                    </td>
                                    <td class="py-0 text-center font-bold" style='width:180px;'>
                                    <br/><br/>
                                    Signature of Inspector of Motors Vehicles<br/>
                                Officer Seal
                                    </td>
                                    </tr>


                                    <tr>
                                        <td class="w-full font-bold" colspan=2>
                                            {{$i++}} Registration Status :
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="py-0 " colspan=2>
                                            Registration allowed/ not allowed
                                        </td>
                                    </tr>
                                    <tr>
                                    <td class="py-0 font-bold"><br/><br/>
                                        Date:<br/>
                                        Encl: List of documents
                                    </td>
                                    <td class="py-0 text-center font-bold" style='width:180px;'>
                                    <br/><br/>
                                    Signature of registering Authority<br/>
                                    Seal
                                    </td>
                                    </tr>



                                    <tr>
                                        <td class="w-full font-bold" colspan=2>
                                            {{$i++}} Fees and Tax Account :
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="py-0 " colspan=2>
                                        Necessary feeds and taxes amounting to taka .......................................................................................................... has
                                        been paid to PO/Bank ............................................................................................ vide vouchers and receipts enclosed.
                                        </td>
                                    </tr>
                                    <tr>
                                    <td class="py-0 font-bold"><br/><br/>
                                    Signature of Owner<br/>
                                        of this representative
                                    </td>
                                    <td class="py-0 text-center font-bold" style='width:180px;'>
                                    <br/><br/>
                                    Signature of dealing assistant                                   
                                    </td>
                                    </tr>

                                    <tr>
                                    <td class="py-5 font-bold text-center" colspan=2><br/><br/>
                                    Counter signature by the registering authority
                                    </td>
                                    </tr>


                                    </tbody>
                                    </table>

                                </x-section.body>
                            </x-section.section>
                        </div>
                        

                        <div class="pb-3">
                            <div class="flex items-center justify-center gap-1">
                                <x-button type="submit" color="green"  onclick="printDiv()">
                                    <i class="fa fa-print"></i>
                                    <span class="ml-2">
                                        Print
                                    </span>

                                </x-button>
                                <x-button type="submit" color="green" id="__btnPrint">
                                    <i class="fa fa-print"></i>
                                    <span class="ml-2">
                                        Make PDF
                                    </span>

                                </x-button>
                            </div>
                        </div>
                    </form>
                </x-card.body>
            </x-card.card-default>
        </div>

    </main>

    <footer class="w-full">
        <div class="text-center py-6">
            <span class="text-gray-500">Powered By</span>
            <a href="" target="_blank" class="no-underline hover:underline text-gray-900 font-bold">
                TechCityIT,Bhairab</a>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/jquery-ui-dist@1.12.1/jquery-ui.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.19/dist/sweetalert2.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/jquery-timepicker@1.3.3/jquery.timepicker.min.js"></script>
    

    <!-- Script to print the content of a div -->
    <script>

    function printDiv() {
        var myStyle = '<link rel="stylesheet" href="{{ asset('css/app.css?_=' . rand()) }}">'
        var divContents = document.getElementById("printArea").innerHTML;
        var a = window.open('', '', 'height=600, width=900');
        a.document.write('<html>'+myStyle);
        a.document.write('<body >');
        a.document.write(divContents);
        a.document.write('</body></html>');
        a.document.close();
        a.print();
    }
    </script>


</body>

</html>