@csrf
<link rel="stylesheet" href="{{ asset('chosen/chosen.css')}}">
<div class="px-5 py-4">
    <div class="text-sm">
        <div id='msg-success' class="font-medium text-green-700  dark:text-green-700 mb-3">
        </div>
        <ul id="error-list" class="text-red-500 mb-3"></ul>
    </div>

        @if(Auth::user()->role !='staff')
        <!-- Select -->
        <!-- <div class="mb-2">
            <label class="block text-sm font-medium mb-1" for="shop_id">Shop</label>
            <select name="shop_id" class="form-select w-full">
                <option value="">Select Unit</option>
                @if($shops)
                    @foreach($shops as $row)
                    <option value='{{$row->id}}'>{{$row->name}} ({{$row->location}})</option>
                    @endforeach
                @endif
            </select>
        </div> -->
        @else
            <input id="shop_id" name="shop_id" class="form-input w-full px-2 py-1" type="hidden" value="{{Auth::user()->shop_id}}" />
        @endif

        <div class="w-full mb-2">
            <div class="shadow-sm flex flex-row flex-wrap">
                <label class="text-sm font-medium mb-1" for="entry_date">Payment Date</label>
                <input type="text" id="entry_date" class="form-input datepicker-1 w-full" name="entry_date"
                    placeholder="Enter Payment Date" value="" autocomplete="off" />
            </div>
        </div>

        <div id="__expenseAreaWrapper" class="mt-2">
                <table id="__expenseTable" class="table table-striped w-full">
                    <thead>
                    <tr>                                        
                        <th style="width:20px;"></th>
                        <th class="text-left">Name</th>           
                        <th class="text-center" style="width: 100px;">Amount<span class="currency">(৳)</span></th>
                    </tr>
                    </thead>
                    <tbody>
                    </tbody>

                </table>
                
                <div class="flex flex-wrap items-center justify-between  mt-3">
                    <div class="form-group">
                        <button type="button" id="add-row" class="btn-xs bg-white dark:bg-gray-800 border-gray-200 dark:border-gray-700/60 hover:border-gray-300 dark:hover:border-gray-600 text-green-500">
                            <svg class="fill-current text-gray-400 shrink-0" width="16" height="16" viewBox="0 0 16 16">
                                <path d="M15 7H9V1c0-.6-.4-1-1-1S7 .4 7 1v6H1c-.6 0-1 .4-1 1s.4 1 1 1h6v6c0 .6.4 1 1 1s1-.4 1-1V9h6c.6 0 1-.4 1-1s-.4-1-1-1z"></path>
                            </svg>
                            <span class="ml-2">Add More</span>
                        </button>
                    </div>
                    <input id='total' type ='hidden' name='total' class='form-input' value=''>
                    <div class=""><strong>Total:</strong> <span id="sub-total">0.00</span></div>
                </div>

            </div>
    </div>
</div>
<!-- Modal footer -->
<div class="px-5 py-4 border-t border-gray-200 dark:border-gray-700/60">
    <div class="flex flex-wrap justify-end space-x-2">
        <button
            class="__closeModal btn-sm border-gray-200 dark:border-gray-700/60 hover:border-gray-300 dark:hover:border-gray-600 text-gray-800 dark:text-gray-300">Cancel</button>
        <button type="submit"
            class="btn-sm bg-gray-900 text-gray-100 hover:bg-gray-800 dark:bg-gray-100 dark:text-gray-800 dark:hover:bg-white">Save</button>
    </div>
</div>


<table class="hidden">
        <tbody id="expenseTemplate" class="">
            <tr>
                <td class="text-right hide-elements">
                    <button onclick="deleteExpenseRow(this)" class="removeItem text-red-500 border-0 hover:text-red-600  p-0 pb-2 m-0">
                        <span class="sr-only">Delete</span>
                        <svg class="w-8 h-8 fill-current" viewBox="0 0 32 32">
                            <path d="M13 15h2v6h-2zM17 15h2v6h-2z"></path>
                            <path d="M20 9c0-.6-.4-1-1-1h-6c-.6 0-1 .4-1 1v2H8v2h1v10c0 .6.4 1 1 1h12c.6 0 1-.4 1-1V13h1v-2h-4V9zm-6 1h4v1h-4v-1zm7 3v9H11v-9h10z"></path>
                        </svg>
                    </button>
                </td>
                <td class="text-right">               
                <input style="width: 100%;" type="text" name="expense_name[]" class="expense_name form-input w-full" value="" onClick="this.select();">        
                </td>

                <td class="text-right">               
                <input type="text" name="amount[]" class="amount text-right form-input" value="" onClick="this.select();">        
                </td>
            </tr>
        </tbody>
    </table>


<script>

$(".chosen-select").chosen({no_results_text: "Oops, nothing found!"}); 

$(".datepicker-1").datepicker({
    dateFormat: 'dd-mm-yy'
});

    function formatNumber(number) {
        return number.toFixed(2).toString().replace(/(\d+?)(?=(\d\d)+(\d)(?!\d))/g, "$1,");
         
    }

    function replaceComma(number) {
        return number.replace(/,/g, '');
    }

    var expensesGrandTotal = () => {
        var subTotal = 0;
        $('.amount').each(function(){
            subTotal += parseFloat(replaceComma($(this).val())) || 0;
        });
        $('#total').val(subTotal);        
        $('#sub-total').html(formatNumber(subTotal));        
    }

    var expenseHandlers = (row) => {
        row.find('.amount').on('keyup', function() {
            let currentRow = $(this).closest('tr');
            expensesGrandTotal();
        });
    }

    // Cloning and appending a new row
    $('#add-row').on('click', function(){
        let expenseListWrapper = $('#__expenseTable tbody');
        let lastRow = $('#expenseTemplate tr');
        let newRow = lastRow.clone();
        // Update index in the cloned row
        //newRow.find('.index').text($('#__expenseTable tr').length); // Update index based on current row count

        // Reset input values for the new row
        newRow.find('input').val('');

        expenseListWrapper.prepend(newRow);

        // Attach event handlers to the new row
        expenseHandlers(newRow);
        
        // Recalculate totals after adding the new row
        //calculateCartSummary();
    });


    

    var deleteExpenseRow = (button) => {
      const row = button.closest('tr');
      row.remove();
      
      //calculateCartSummary();
    }

$(document).on('keyup', '#fake-paid', function(event) {
    var input_val = $(this).val();
    input_val = numberToCurrency(input_val);
    $(this).val(input_val);
    var withoutComma = $(this).val().replace(/,/g, "");
    $('#paid').val(withoutComma);
    $('#takaInWord').moneyinwords(withoutComma, 'US', 'USD');
});

$('#__btnSubmitPayment').addClass('hidden');




$('#__payment_method').change(function() {
            if($(this).val()=='1'){
                $("#bank_or_mobile_wallet_id").val('');
                $("#_AccountNoWrapper").html('');
                $("#account_no_id").val('');
                
            }
            $.ajax({
                url: '{{ route('load-bank-or-mobile-dropdown') }}',
                type: 'post',
                data: {
                    'id': $(this).val(),
                    '_token': $('meta[name=csrf-token]').attr('content')
                }
            }).done(function(result) {
                $('#_bankOrMobileDetailsWrapper').html(result);       
            });

        });


$('#bank_or_mobile_wallet_id').on('change', function() {
    $.ajax({
        url: '{{ route('load-bank-or-mobile-account-dropdown') }}',
        type: 'post',
        data: {
            'bank_or_mobile_wallet_id': $(this).val(),
            '_token': $('meta[name=csrf-token]').attr('content')
        }
    }).done(function(result) {
        $('#_AccountNoWrapper').html(result);
    });
});
</script>