<x-app-layout>
    @section('title', 'Dashboard')

    @if(session('roleName') != 'dropshipper')
        <div class="w-full overflow-hidden col-span-12 md:col-span-4">
            <div class="flex flex-row w-full bg-white shadow-sm rounded p-4">
                <div class="flex items-center justify-center flex-shrink-0 h-16 w-16 rounded-xl bg-blue-100 text-blue-500">
                    <svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" fill="currentColor" class="bi bi-archive" viewBox="0 0 16 16">
                        <path d="M0 2a1 1 0 0 1 1-1h14a1 1 0 0 1 1 1v2a1 1 0 0 1-1 1v7.5a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 1 12.5V5a1 1 0 0 1-1-1V2zm2 3v7.5A1.5 1.5 0 0 0 3.5 14h9a1.5 1.5 0 0 0 1.5-1.5V5H2zm13-3H1v2h14V2zM5 7.5a.5.5 0 0 1 .5-.5h5a.5.5 0 0 1 0 1h-5a.5.5 0 0 1-.5-.5z"/>
                    </svg>
                </div>
                <div class="flex flex-col justify-center flex-grow ml-4">
                    <div class="text-md text-gray-500">Total Orders Today</div>
                    <div class="font-bold text-xl">
                        @if(isset($series_data['orders_today'])) {{ $series_data['orders_today'] }}@endif
                    </div>
                </div>
            </div>
        </div>

        <div class="w-full overflow-hidden col-span-12 md:col-span-4">
            <div class="flex flex-row w-full bg-white shadow-sm rounded p-4">
                <div class="flex items-center justify-center flex-shrink-0 h-16 w-16 rounded-xl bg-blue-100 text-blue-500">
                    <svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" fill="currentColor" class="bi bi-archive" viewBox="0 0 16 16">
                        <path d="M0 2a1 1 0 0 1 1-1h14a1 1 0 0 1 1 1v2a1 1 0 0 1-1 1v7.5a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 1 12.5V5a1 1 0 0 1-1-1V2zm2 3v7.5A1.5 1.5 0 0 0 3.5 14h9a1.5 1.5 0 0 0 1.5-1.5V5H2zm13-3H1v2h14V2zM5 7.5a.5.5 0 0 1 .5-.5h5a.5.5 0 0 1 0 1h-5a.5.5 0 0 1-.5-.5z"/>
                    </svg>
                </div>
                <div class="flex flex-col justify-center flex-grow ml-4">
                    <div class="text-md text-gray-500">Orders To Process</div>
                    <div class="font-bold text-xl">
                        @if(isset($series_data['orderPurchaseTotalProcess'])){{ $series_data['orderPurchaseTotalProcess'] }}@endif
                    </div>
                </div>
            </div>
        </div>

        <div class="w-full overflow-hidden col-span-12 md:col-span-4">
            <div class="flex flex-row w-full bg-white shadow-sm rounded p-4">
                <div class="flex items-center justify-center flex-shrink-0 h-16 w-16 rounded-xl bg-blue-100 text-blue-500">
                    <svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" fill="currentColor" class="bi bi-archive" viewBox="0 0 16 16">
                        <path d="M0 2a1 1 0 0 1 1-1h14a1 1 0 0 1 1 1v2a1 1 0 0 1-1 1v7.5a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 1 12.5V5a1 1 0 0 1-1-1V2zm2 3v7.5A1.5 1.5 0 0 0 3.5 14h9a1.5 1.5 0 0 0 1.5-1.5V5H2zm13-3H1v2h14V2zM5 7.5a.5.5 0 0 1 .5-.5h5a.5.5 0 0 1 0 1h-5a.5.5 0 0 1-.5-.5z"/>
                    </svg>
                </div>
                <div class="flex flex-col justify-center flex-grow ml-4">
                    <div class="text-md text-gray-500">Orders</div>
                    <div class="font-bold text-xl">
                        @if(isset($series_data['shipmentsTotal'])){{ $series_data['shipmentsTotal'] }}@endif
                    </div>
                </div>
            </div>
        </div>

        <div class="w-full overflow-hidden col-span-12 md:col-span-4">
            <div class="flex flex-row w-full bg-white shadow-sm rounded p-4">
                <div class="flex items-center justify-center flex-shrink-0 h-16 w-16 rounded-xl bg-blue-100 text-blue-500">
                    <svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" fill="currentColor" class="bi bi-archive" viewBox="0 0 16 16">
                        <path d="M0 2a1 1 0 0 1 1-1h14a1 1 0 0 1 1 1v2a1 1 0 0 1-1 1v7.5a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 1 12.5V5a1 1 0 0 1-1-1V2zm2 3v7.5A1.5 1.5 0 0 0 3.5 14h9a1.5 1.5 0 0 0 1.5-1.5V5H2zm13-3H1v2h14V2zM5 7.5a.5.5 0 0 1 .5-.5h5a.5.5 0 0 1 0 1h-5a.5.5 0 0 1-.5-.5z"/>
                    </svg>
                </div>
                <div class="flex flex-col justify-center flex-grow ml-4">
                    <div class="text-md text-gray-500">Low Stock Total</div>
                    <div class="font-bold text-xl">
                        @if(isset($series_data['total_low_stock'])){{ $series_data['total_low_stock'] }}@endif
                    </div>
                </div>
            </div>
        </div>

        <div class="w-full overflow-hidden col-span-12 md:col-span-4">
            <div class="flex flex-row w-full bg-white shadow-sm rounded p-4">
                <div class="flex items-center justify-center flex-shrink-0 h-16 w-16 rounded-xl bg-blue-100 text-blue-500">
                    <svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" fill="currentColor" class="bi bi-archive" viewBox="0 0 16 16">
                        <path d="M0 2a1 1 0 0 1 1-1h14a1 1 0 0 1 1 1v2a1 1 0 0 1-1 1v7.5a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 1 12.5V5a1 1 0 0 1-1-1V2zm2 3v7.5A1.5 1.5 0 0 0 3.5 14h9a1.5 1.5 0 0 0 1.5-1.5V5H2zm13-3H1v2h14V2zM5 7.5a.5.5 0 0 1 .5-.5h5a.5.5 0 0 1 0 1h-5a.5.5 0 0 1-.5-.5z"/>
                    </svg>
                </div>
                <div class="flex flex-col justify-center flex-grow ml-4">
                    <div class="text-md text-gray-500">Out of Stock Total</div>
                    <div class="font-bold text-xl">
                        @if(isset($series_data['total_out_of_stock'])){{ $series_data['total_out_of_stock'] }}@endif
                    </div>
                </div>
            </div>
        </div>

        <div class="w-full overflow-hidden col-span-12 md:col-span-4">
            <div class="flex flex-row w-full bg-white shadow-sm rounded p-4">
                <div class="flex items-center justify-center flex-shrink-0 h-16 w-16 rounded-xl bg-blue-100 text-blue-500">
                    <svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" fill="currentColor" class="bi bi-archive" viewBox="0 0 16 16">
                        <path d="M0 2a1 1 0 0 1 1-1h14a1 1 0 0 1 1 1v2a1 1 0 0 1-1 1v7.5a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 1 12.5V5a1 1 0 0 1-1-1V2zm2 3v7.5A1.5 1.5 0 0 0 3.5 14h9a1.5 1.5 0 0 0 1.5-1.5V5H2zm13-3H1v2h14V2zM5 7.5a.5.5 0 0 1 .5-.5h5a.5.5 0 0 1 0 1h-5a.5.5 0 0 1-.5-.5z"/>
                    </svg>
                </div>
                <div class="flex flex-col justify-center flex-grow ml-4">
                    <div class="text-md text-gray-500">Defect Stock Total</div>
                    <div class="font-bold text-xl">
                        @if(isset($series_data['defect_stock'])){{ $series_data['defect_stock'] }}@endif
                    </div>
                </div>
            </div>
        </div>

        <style type="text/css">
            .chart{
                height: 400px;
                width:600px;
                margin: 0 auto;
                overflow-y: hidden;
            }
            .history{
                max-height: 700px;overflow-y: scroll;
            }
        </style>

        <x-card title="Daily Summary" md="8">
            <div class="overflow-x-auto">
                <div id="lineChartContainer" class="chart"></div>
            </div>
        </x-card>

        <div class="w-full col-span-12 md:col-span-4 history">
            <div class="flex flex-row w-full bg-white shadow-sm rounded p-4">
                <div class="flex flex-col justify-center flex-grow ml-4">
                    <div class="font-bold text-xl">Last Changes</div>
                </div>
            </div>
            @if(isset($last_changes))
                @foreach($last_changes as $arrItem)
                    <div class="flex flex-row w-full bg-white shadow-sm rounded p-4 mt-4">
                        <div class="flex items-center justify-center flex-shrink-0 h-16 w-16 rounded-xl bg-blue-100 text-blue-500">
                            <img class="w-1/2" src="{{ isset($arrItem->product->image) && file_exists(public_path($arrItem->product->image)) ? asset($arrItem->product->image) : asset('No-Image-Found.png') }}">
                        </div>
                        <div class="flex flex-col justify-center flex-grow ml-4">
                            <div class="text-gray-700">{{ $arrItem->product->part_name }}  </div>
                            <div class="text-blue-600">
                                {{ isset($arrItem->product->part_no) ? $arrItem->product->part_no : '' }}
                            </div>
                            <div class="font-bold text-sl">
                                @if($arrItem->str_in_out == 'Add') Qty: {{ $arrItem->main_stock->quantity ?? 0 }}  (+{{ $arrItem->quantity ?? 0 }})@endif
                                @if($arrItem->str_in_out == 'Remove') Qty: {{ $arrItem->main_stock->quantity ?? 0 }}  (-{{ $arrItem->quantity ?? 0 }})@endif
                            </div>
                            <div class="font-500 text-sl">
                                Created at :{{ date("Y-m-d H:i:s", strtotime($arrItem->date)) }}
                            </div>
                            <div class="font-500 text-sl">
                                User : {{ isset($arrItem->seller->name) ? $arrItem->seller->name : ''}}
                            </div>
                        </div>
                    </div>
                @endforeach
            @endif
        </div>

        <div class="w-full col-span-12 md:col-span-4">
            <div class="flex flex-row w-full bg-white shadow-sm rounded p-4">
                <div class="flex flex-col justify-center flex-grow ml-4">
                    <div class="font-bold text-l">Top 5 Highest Stock</div>
                </div>
            </div>
            @if(isset($top_five_stock))
                @foreach($top_five_stock as $arrItem)
                    <div class="flex flex-row w-full bg-white shadow-sm rounded p-4 mt-4">
                        <div class="flex items-center justify-center flex-shrink-0 h-16 w-16 rounded-xl bg-blue-100 text-blue-500">
                            <img class="w-1/2" src="{{ isset($arrItem->product->image) && file_exists(public_path($arrItem->product->image)) ? asset($arrItem->product->image) : asset('No-Image-Found.png') }}">
                        </div>
                        <div class="flex flex-col justify-center flex-grow ml-4">
                            <div class="text-gray-700 ">{{ isset($arrItem->product->part_name) ? $arrItem->product->part_name : '' }}</div>
                            <div class="text-blue-600">
                                {{ isset($arrItem->product->part_no) ? $arrItem->product->part_no : '' }}
                            </div>
                            <div class="text-sl">
                                Qty:
                                <span class="font-bold">{{isset($arrItem->quantity) ? $arrItem->quantity : '' }}</span>
                            </div>
                            <div class="font-500 text-sl">
                                Created at :{{isset($arrItem->created_at) ? $arrItem->created_at : '' }}
                            </div>
                            <div class="font-500 text-sl">
                                User : {{ isset($arrItem->product->seller->name) ? $arrItem->product->seller->name : ''}}
                            </div>
                        </div>
                    </div>
                @endforeach
            @endif
        </div>

        <div class="w-full col-span-12 md:col-span-4">
            <div class="flex flex-row w-full bg-white shadow-sm rounded p-4">
                <div class="flex flex-col justify-center flex-grow ml-4">
                    <div class="font-bold text-l">Top 5 Added Stock (7 days)</div>
                </div>
            </div>

            @php
                $i = 0
            @endphp
            @if(isset($latest_stock))
                @foreach($latest_stock as $addItem)
                    @if($addItem->str_in_out=='Add')
                        <div class="flex flex-row w-full bg-white shadow-sm rounded p-4 mt-4">
                            <div class="flex items-center justify-center flex-shrink-0 h-16 w-16 rounded-xl bg-blue-100 text-blue-500">
                                @if(isset($addItem->product->image))
                                    <img class="w-1/2" src="{{ isset($addItem->product->image) && file_exists(public_path($addItem->product->image)) ? asset($addItem->product->image) : asset('No-Image-Found.png') }}">
                                @endif
                            </div>
                            <div class="flex flex-col justify-center flex-grow ml-4">
                                <div class="text-gray-700">{{ $addItem->product->part_name }}  </div>
                                <div class="text-blue-600">
                                    @if(isset($addItem->product->part_no))
                                        {{ $addItem->product->part_no }}
                                    @endif
                                </div>
                                <div class="text-sl">
                                    Qty:
                                    <span class="font-bold">
                                        @isset($addItem->main_stock->quantity){{$addItem->main_stock->quantity }} 
                                        @endisset
                                        (+{{ $addItem->quantity }})</span>
                                </div>
                                <div class="font-500 text-sl">
                                    Created at :{{ date("Y-m-d H:i:s", strtotime($addItem->date)) }}
                                </div>
                                <div class="font-500 text-sl">
                                    User : {{ isset($addItem->seller->name) ? $addItem->seller->name : ''}}
                                </div>
                            </div>
                        </div>
                        @php
                            $i++;
                            if($i==5) break;
                        @endphp
                    @endif
                @endforeach
            @endif
        </div>

        <div class="w-full col-span-12 md:col-span-4">
            <div class="flex flex-row w-full bg-white shadow-sm rounded p-4">
                <div class="flex flex-col justify-center flex-grow ml-4">
                    <div class="font-bold text-l">Top 5 Removed Stock (7 days)</div>
                </div>
            </div>
            @php
                $i = 0
            @endphp
            @if(isset($latest_stock))
                @foreach($latest_stock as $removeItem)
                    @if($removeItem->str_in_out=='Remove')
                        <div class="flex flex-row w-full bg-white shadow-sm rounded p-4 mt-4">
                            <div class="flex items-center justify-center flex-shrink-0 h-16 w-16 rounded-xl bg-blue-100 text-blue-500">
                                @if(isset($removeItem->product->image))
                                    <img class="w-1/2" src="{{ isset($removeItem->product->image) && file_exists(public_path($removeItem->product->image)) ? asset($removeItem->product->image) : asset('No-Image-Found.png') }}">
                                @endif
                            </div>
                            <div class="flex flex-col justify-center flex-grow ml-4">
                                <div class="text-gray-700">{{ $removeItem->product->part_name }}  </div>
                                <div class="text-blue-600">
                                    @if(isset($removeItem->product->part_no))
                                        {{ $removeItem->product->part_no }}
                                    @endif
                                </div>
                                <div class="text-sl">
                                    Qty:
                                    <span class="font-bold">
                                        @isset($removeItem->main_stock->quantity){{$removeItem->main_stock->quantity }} 
                                        @endisset
                                        (-{{ $removeItem->quantity }})</span>
                                </div>
                                <div class="font-500 text-sl">
                                    Created at :{{ date("Y-m-d H:i:s", strtotime($removeItem->date)) }}
                                </div>
                                <div class="font-500 text-sl">
                                    User : {{ isset($removeItem->seller->name) ? $removeItem->seller->name : ''}}
                                </div>
                            </div>
                        </div>
                        @php
                            $i++;
                            if($i==5) break;
                        @endphp
                    @endif

                @endforeach
            @endif
        </div>
    @endif

    <script src="https://cdnjs.cloudflare.com/ajax/libs/apexcharts/3.27.1/apexcharts.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.22.2/moment.min.js"></script>
    @if(isset($data_add_to_stock) || isset($data_remove_from_stock))
        <script type="text/javascript">
            window.Apex = {
                chart: {
                    foreColor: "#222",
                    toolbar: {
                        show: false
                    }
                },
                colors: [ "#17ead9", "#f1bcbc","#f02fc2"],
                stroke: {
                    width: 3
                },
                dataLabels: {
                    enabled: true
                },
                grid: {
                    borderColor: "#40475D"
                },
                xaxis: {
                    labels: {
                        datetimeUTC: false
                    },
                    axisTicks: {
                        color: "#333"
                    },
                    axisBorder: {
                        color: "#333"
                    }
                },
                fill: {
                    type: "gradient",
                    gradient: {
                        gradientToColors: ["#fff", "#fff", "#fff"]
                    }
                },
                tooltip: {
                    theme: "dark",
                    x: {
                        formatter: function (val) {
                            return moment(val);
                        }
                    }
                },
                yaxis: {
                    decimalsInFloat: 0,
                    opposite: true,
                    labels: {
                        offsetX: -10
                    }
                }
            };

            var options = {
                series: [{
                    name: 'Add',
                    data: [
                        {{$data_add_to_stock[0]}},
                        {{$data_add_to_stock[1]}},
                        {{$data_add_to_stock[2]}},
                        {{$data_add_to_stock[3]}},
                        {{$data_add_to_stock[4]}},
                        {{$data_add_to_stock[5]}},
                        {{$data_add_to_stock[6]}},
                        {{$data_add_to_stock[7]}},
                        {{$data_add_to_stock[8]}},
                        {{$data_add_to_stock[9]}},
                        {{$data_add_to_stock[10]}},
                        {{$data_add_to_stock[11]}},
                        {{$data_add_to_stock[12]}},
                        {{$data_add_to_stock[13]}},
                        {{$data_add_to_stock[14]}},
                        {{$data_add_to_stock[15]}},
                        {{$data_add_to_stock[16]}},
                        {{$data_add_to_stock[17]}},
                        {{$data_add_to_stock[18]}},
                        {{$data_add_to_stock[19]}},
                        {{$data_add_to_stock[20]}},
                        {{$data_add_to_stock[21]}},
                        {{$data_add_to_stock[22]}},
                        {{$data_add_to_stock[23]}}

                    ]
                }, {
                    name: 'Remove',
                    data: [
                        {{$data_remove_from_stock[0]}},
                        {{$data_remove_from_stock[1]}},
                        {{$data_remove_from_stock[2]}},
                        {{$data_remove_from_stock[3]}},
                        {{$data_remove_from_stock[4]}},
                        {{$data_remove_from_stock[5]}},
                        {{$data_remove_from_stock[6]}},
                        {{$data_remove_from_stock[7]}},
                        {{$data_remove_from_stock[8]}},
                        {{$data_remove_from_stock[9]}},
                        {{$data_remove_from_stock[10]}},
                        {{$data_remove_from_stock[11]}},
                        {{$data_remove_from_stock[12]}},
                        {{$data_remove_from_stock[13]}},
                        {{$data_remove_from_stock[14]}},
                        {{$data_remove_from_stock[15]}},
                        {{$data_remove_from_stock[16]}},
                        {{$data_remove_from_stock[17]}},
                        {{$data_remove_from_stock[18]}},
                        {{$data_remove_from_stock[19]}},
                        {{$data_remove_from_stock[20]}},
                        {{$data_remove_from_stock[21]}},
                        {{$data_remove_from_stock[22]}},
                        {{$data_remove_from_stock[23]}}
                    ]
                }],
                chart: {
                    height: 520,
                    type: 'area'
                },
                dataLabels: {
                    enabled: false
                },
                stroke: {
                    curve: 'smooth'
                },


                xaxis: {
                    type: 'datetime',
                    categories: [
                        "{{$arr_date[0]}}",
                        "{{$arr_date[1]}}",
                        "{{$arr_date[2]}}",
                        "{{$arr_date[3]}}",
                        "{{$arr_date[4]}}",
                        "{{$arr_date[5]}}",
                        "{{$arr_date[6]}}",
                        "{{$arr_date[7]}}",
                        "{{$arr_date[8]}}",
                        "{{$arr_date[9]}}",
                        "{{$arr_date[10]}}",
                        "{{$arr_date[11]}}",
                        "{{$arr_date[12]}}",
                        "{{$arr_date[13]}}",
                        "{{$arr_date[14]}}",
                        "{{$arr_date[15]}}",
                        "{{$arr_date[16]}}",
                        "{{$arr_date[17]}}",
                        "{{$arr_date[18]}}",
                        "{{$arr_date[19]}}",
                        "{{$arr_date[20]}}",
                        "{{$arr_date[21]}}",
                        "{{$arr_date[22]}}",
                        "{{$arr_date[23]}}",
                    ]
                },

                tooltip: {
                    theme: "dark",
                    x: {
                        formatter: function (val) {
                            return moment(new Date(val)).format("HH:mm:ss");
                        }
                    }
                },

                title: {
                    text: "Daily Stock ",
                    align: "left",
                    style: {
                        fontSize: "12px"
                    }
                },
                subtitle: {
                    text: "Quantity",
                    floating: true,
                    align: "right",
                    offsetY: 0,
                    style: {
                        fontSize: "22px"
                    }
                },
                legend: {
                    show: true,
                    floating: true,
                    horizontalAlign: "left",
                    onItemClick: {
                        toggleDataSeries: false
                    },
                    position: "top",
                    offsetY: -33,
                    offsetX: 60
                }
            };
            var chart = new ApexCharts(document.querySelector("#lineChartContainer"), options);
            chart.render();

        </script>
    @endif
</x-app-layout>
