@csrf
<input type="hidden" id="id" name="id" value="{{$dailyProduction->id}}">
<div class="px-5 py-4">
    <div class="">
        <div class="text-sm">
            <div id='msg-success' class="font-medium text-green-700  dark:text-green-700 mb-3">
            </div>
            <ul id="error-list" class="text-red-500 mb-3"></ul>
        </div>

        <div class="space-y-3">
            <div class="w-full grid gap-5 md:grid-cols-2">
                <div class="shadow-sm rounded-xl">
                    <label class="block text-sm font-medium mb-1" for="production_date">Date</label>
                    <input type="text" id="production_date" class="form-input datepicker-1 w-full" name="production_date"
                        placeholder="Enter Date" value="{{$dailyProduction->production_date}}" autocomplete="off" />
                </div>
                <!-- Select -->
                <!-- <div>
                    <label class="block text-sm font-medium mb-1" for="shop_id">Shop</label>
                    <select name="shop_id" class="form-select w-full">
                        <option value="">Select Unit</option>
                        @if($shops)
                            @foreach($shops as $row)
                            <option @if($dailyProduction->shop_id==$row->id) selected @endif value='{{$row->id}}'>{{$row->name}} ({{$row->location}})</option>
                            @endforeach
                        @endif
                    </select>
                </div> -->
            </div>

            <div class="shadow-sm rounded-xl">
                <input type="text" class="form-input w-full" id="__rm_id_QR_scanner" placeholder="Enter Rm Name or Rm Code"
                autocomplete="off" />
            </div>

            <div class="invoice" id="invoice-container">
                <table id="table" class="table table-striped w-full">
                    <thead>
                    <tr>                        
                        <th class="hide-elements" style="width: 20px;"></th>
                        <th>#</th>
                        <th class="text-left">Name</th>
                        <th class="hidden">Stock</th>                        
                        <th style="width: 20px;">Unit</th>            
                        <th style="width: 82px;">Quntity</th>
                        <th style="width: 82px;">Price<span class="currency">(৳)</span></th>
                        <th style="width: 82px;">Total<span class="currency">(৳)</span></th>

                    </tr>
                    </thead>
                    <tbody id="__rmListWrapper">
                            @php $subtotal = 0; @endphp
                            
                        @if($dailyProduction)
                            @php $i=count($dailyProduction->rmStockLog); @endphp
                            
                            @foreach($dailyProduction->rmStockLog as $item)
                                <tr>
                                    <td class="text-right hide-elements">
                                        <input type="hidden" name="raw_material_id[]" class="rm-id" value="{{$item->raw_material->id}}">
                                        <button onclick="deleteRmRow(this)" class="removeItem btn bg-white dark:bg-gray-800 border-gray-200 dark:border-gray-700/60 hover:border-gray-300 dark:hover:border-gray-600">
                                            <span class="sr-only">Delete</span>
                                            <svg class="w-8 h-8 fill-current text-red-500 shrink-0" viewBox="0 0 33 32">
                                                <path d="M13 15h2v6h-2zM17 15h2v6h-2z"></path>
                                                <path d="M20 9c0-.6-.4-1-1-1h-6c-.6 0-1 .4-1 1v2H8v2h1v10c0 .6.4 1 1 1h12c.6 0 1-.4 1-1V13h1v-2h-4V9zm-6 1h4v1h-4v-1zm7 3v9H11v-9h10z"></path>
                                            </svg>
                                        </button>
                                    </td>


                                    <td>
                                    {{$i--}}
                                    </td>
                                    <td>
                                    <p class="font-bold m-0"> 
                                        <span class="rm_name">{{$item->raw_material->name}}</span> 
                                    </p>
                                    
                                    </td>
                                    <td class="text-center hidden">
                                    <span class="stock">0</span>
                                    </td>
                                    
                                    <td class="text-center">
                                    <span class="rm_unit">{{$item->raw_material->unit}}</span>
                                    </td>

                                    <td class="text-center">
                                    <input type="text" class="form-input quantity text-center" name="quantity[]" value="{{$item->quantity}}" onClick="this.select();">     
                                    </td>

                                    <td class="text-center">
                                    <input type="text" class="form-input rm-price text-center" name="price[]" value="{{$item->price}}" onClick="this.select();">     
                                    </td>

                                    <td class="text-right">
                                    <span class="row-total">{{App\Http\Controllers\SettingController::takaBDFormat($item->price*$item->quantity)}}</span>              
                                    </td>
                                @php 
                                $subtotal += $item->price*$item->quantity;
                                @endphp
                                </tr>
                            @endforeach
                           
                        @endif
                        <tfoot>
                            <tr class="subtotal">
                                <td colspan=6>Sub Total </td>
                                <td class='text-right'> 
                                    <span id="__raw_materialTotalCurrency" class="font-medium text-gray-700 dark:text-gray-100 text-right">{{App\Http\Controllers\SettingController::takaBDFormat($subtotal)}}</span>
                                    <input type="hidden" class='rm_total_price form-input' name='rm_total_price' value='{{$subtotal}}'>
                                </td>
                            </tr>
                        </tfoot>
                        @php $i-- @endphp
                    </tbody>

                </table>
            </div>

            <div id="__noRmWrapper">
                <div class="w-full py-4 rounded-lg text-center">
                    <span class="font-bold text-base text-gray-500">
                        --- {{ __('translation.No Raw Material Added') }} ---
                    </span>
                </div>
            </div>


            <div class="w-full">Carton Production</div>
            <div class="production" id="productionTable">
                <table id="table" class="table table-striped w-full">
                    <thead>
                    <tr>             
                        <th class="text-left">Name</th>
                        <th class="hidden">Stock</th>                        
                        <th style="width: 20px;">Unit</th>            
                        <th style="width: 82px;">Quntity</th>
                        <th style="width: 82px;">Total<span class="currency">(৳)</span></th>

                    </tr>
                    </thead>
                    <tbody>
                        <tr class="rowNo">
                        <td class='px-0'>
                            <select class="chosen-select form-select w-full rounded-none" name='product_id'>
                                <option value="">Select Product</option>
                                @if($products)
                                    @foreach($products as $item)
                                        <option @if($dailyProduction->product_id==$item->id) selected @endif value="{{$item->id}}">{{$item->product_name}}</option>
                                    @endforeach
                                @endif
                            </select>                        
                        </td>
                        <td class="text-center hidden">
                        <span class="stock">0</span>
                        </td>
                        
                        <td class="text-center">
                        <span class="rm_unit">carton</span>
                        </td>

                        <td class="text-center">
                        <input type="text" class="form-input production_qty text-center" name="production_qty" value="{{$dailyProduction->production_qty}}" onclick="this.select();">     
                        </td>


                        <td class="text-right">
                        <span class="perCartonPrice">{{App\Http\Controllers\SettingController::takaBDFormat($subtotal/$dailyProduction->production_qty)}}</span> 
                        <input type="hidden" class='per_carton_cost form-input' name='per_carton_cost' value='{{$subtotal/$dailyProduction->production_qty}}'>             
                        </td>
            
                    </tr>
                        <tr class="subtotal">
                            <td class="text-right" colspan="3">Price/Carton</td>
                            <td class="text-right"> 
                                <span class="perCartonPrice font-medium text-gray-700 dark:text-gray-100 text-right">{{App\Http\Controllers\SettingController::takaBDFormat($subtotal/$dailyProduction->production_qty)}}</span>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <div>
                <label class="block text-sm font-medium mb-1" for="defect_note">Note</label>
                <textarea class="form-textarea w-full p-5" name="defect_note"></textarea>
            </div>

        </div>

        <!-- Modal footer -->
        <div class="px-5 py-4 border-t border-gray-200 dark:border-gray-700/60">
            <div class="flex flex-wrap justify-end space-x-2">
                <button
                    class="__closeModal btn-sm border-gray-200 dark:border-gray-700/60 hover:border-gray-300 dark:hover:border-gray-600 text-gray-800 dark:text-gray-300">Cancel</button>
                <button type="submit"
                    class="btn-sm bg-gray-900 text-gray-100 hover:bg-gray-800 dark:bg-gray-100 dark:text-gray-800 dark:hover:bg-white">Save</button>
            </div>
        </div>
    </div>
</div>


<table class="hidden">
        <tbody id="__templateRmItem" class="">
        <tr>
            <td class="text-right hide-elements">
                <input type="hidden" name="raw_material_id[]" class="rm-id" value="">
                <button onclick="deleteRmRow(this)" class="removeItem btn bg-white dark:bg-gray-800 border-gray-200 dark:border-gray-700/60 hover:border-gray-300 dark:hover:border-gray-600">
                    <span class="sr-only">Delete</span>
                    <svg class="w-8 h-8 fill-current text-red-500 shrink-0" viewBox="0 0 33 32">
                        <path d="M13 15h2v6h-2zM17 15h2v6h-2z"></path>
                        <path d="M20 9c0-.6-.4-1-1-1h-6c-.6 0-1 .4-1 1v2H8v2h1v10c0 .6.4 1 1 1h12c.6 0 1-.4 1-1V13h1v-2h-4V9zm-6 1h4v1h-4v-1zm7 3v9H11v-9h10z"></path>
                    </svg>
                </button>
            </td>


            <td class="index">
              1
            </td>
            <td>
            <p class="font-bold m-0"> 
                <span class="rm_name"></span> 
            </p>
            
            </td>
            <td class="text-center hidden">
              <span class="stock">0</span>
            </td>
            
            <td class="text-center">
              <span class="rm_unit"></span>
            </td>

            <td class="text-center">
            <input type="text" class="form-input quantity text-center" name="quantity[]" value="1" onClick="this.select();">     
            </td>

            <td class="text-center">
            <input type="text" class="form-input rm-price text-center" name="price[]" value="" onClick="this.select();">     
            </td>

            <td class="text-right">
              <span class="row-total">0.00</span>              
            </td>
  
        </tr>
       </tbody>
    </table>

<script>
    $(".chosen-select").chosen({no_results_text: "Oops, nothing found!"}); 

    $(".datepicker-1").datepicker({
        dateFormat: 'dd-mm-yy'
    });

    

    var subTotal = 0;
    var serviceCost = 0;
    var discountTotal = 0;
    var totalAmount = 0;

    function formatNumber(number) {
        return number.toFixed(2).toString().replace(/(\d+?)(?=(\d\d)+(\d)(?!\d))/g, "$1,");
         
    }

    function replaceComma(number) {
        return number.replace(/,/g, '');
    }

    var selectedRmsToList = [];
            var rmSource = {!!$raw_materials->toJson() !!};
            //console.log(rmSource);

            
    var rmHandlers = (row) => {
        row.find('.quantity, .rm-price, .tdiscount').on('keyup', function() {
            let currentRow = $(this).closest('tr');             
            updateraw_materialRowTotal(currentRow);          
        });
    }

    const updateraw_materialRowTotal = (row) => {
        let price = parseFloat(row.find('.rm-price').val()) || 0;
        let quantity = parseFloat(row.find('.quantity').val()) || 0;
        let discount = parseFloat(row.find('.tdiscount').val()) || 0;
        let rowSubTotal = price * quantity;
        let total = rowSubTotal - discount;
        row.find('.row-sub-total').text(formatNumber(rowSubTotal));
        row.find('.row-total').text(formatNumber(total));
    
        
        //console.log("Total "+total);

        updateGrandTotal();
    }

    $('.production_qty').on('keyup', function() {
        perCartonPrice();        
    });
    

    const updateGrandTotal = () => {
        let subTotal = 0;
        let grandTotal = 0;
        let discountTotal = 0;
        $('.row-total').each(function(){
            subTotal += parseFloat(replaceComma($(this).text())) || 0;
        });
        $('#sub-total').text(formatNumber(subTotal));
        discountTotal += parseFloat($("#discount-total").val()) || 0;
        $('#raw_material_price_total').val(formatNumber(subTotal-discountTotal));
        $('#__raw_materialTotalCurrency').text(formatNumber(subTotal-discountTotal));
        $('.rm_total_price').val(subTotal-discountTotal);
        

        perCartonPrice();
        
    }

    const perCartonPrice = () =>{
        var totalRmPrice =  $('#__raw_materialTotalCurrency').html();
        let production_qty = $(".production_qty").val();  
        var perCartonPrice = parseFloat(replaceComma(totalRmPrice)/production_qty).toFixed(2);
        $('.perCartonPrice').html(parseFloat(perCartonPrice).toFixed(2));  
        $('.per_carton_cost').val(perCartonPrice);  

        
    }

    // Initial calculation
    $('tbody.main tr').each(function(){
        rmHandlers($(this));
    });

    var deleteRmRow = (button) => {
      const row = button.closest('tr');
      row.remove();
      updateGrandTotal();
    }

        
    var substringMatcher = function(strs) {
        return function findMatches(q, cb) {
            var matches, substringRegex;
            matches = [];

            substrRegex = new RegExp(q, 'i');

            $.each(strs, function(i, str) {
                if (substrRegex.test(str)) {
                    matches.push(str);
                }
            });

            cb(matches);
        };
    };


    var initializeTypeAheadField = () => {

        $('#__rm_id_QR_scanner').typeahead({
          
            hint: true,
            minLength: 1,
            highlight: true
        }, {
            source: substringMatcher(rmSource),
            limit: 15
        });
    }

    initializeTypeAheadField();


    $('#__rm_id_QR_scanner').on('typeahead:selected', function(event, selectedItem) {
        renderRmToList(selectedItem);
    });


    var renderRmToList = typeAheadValue => {

        
        if (typeAheadValue !== '') {
            $.ajax({
                type: 'GET',
                data: {
                    term: typeAheadValue
                },
                url: '{{ route('get_qr_code_raw_material') }}',
                success: function(responseJson) {
                    //console.log(responseJson);
                    if (responseJson.status === 1) {
                        //$('#error_modal').modal('show');
                    }
              
                    if (responseJson.status === 3) {
                        let lastRow = $('#invoice-container tbody');
                        let newRow = $('#__templateRmItem tr').clone();
                        // Update index in the cloned row
                        newRow.find('.index').text($('#invoice-container tr').length-1); // Update index based on current row count
                        let rm = responseJson.raw_material;

                        let rmQuantity = 0;
                        
                        
                       

                        //if (selectedRmsToList.indexOf(rm.id) === -1) {

                            selectedRmsToList.push(rm.id);

                            console.log(rm);
                            newRow.attr('class','rowNo_'+rm.id); 
                       
                            newRow.find('.rm-id').val(rm.id || 0);
                            // Reset input values for the new row
                            newRow.find('.rm_name').html(rm.name || '');                            
                            newRow.find('.stock').html(rmQuantity || 0);
                            newRow.find('.rm-price').val(rm.price || 0);
                            newRow.find('.rm-price').attr('min',rm.price || 0);
                            newRow.find('.tdiscount').val('');
                            newRow.find('.rm_unit').html(rm.unit || ''); 

                            
                        //     if (selectedRmsToList.indexOf(rm.id) > -1) {
                        //     let stockAdjustElement = $(`.rowNo_${rm.id} .quantity`);
                        //     let currentValue = parseInt(stockAdjustElement.val());
                        //     let increasedValue = currentValue + 1;
                        //     //stockAdjustElement.val(increasedValue);
                        //     stockAdjustElement.val(increasedValue);
                        // }


                            lastRow.prepend(newRow);

                            // Attach event handlers to the new row
                            rmHandlers(newRow);
                            
                            // Recalculate totals after adding the new row

                            $('#__noRmWrapper').hide();
                   
                        //}


                        

                        $('#__rm_id_QR_scanner').typeahead('destroy');
                        $('#__rm_id_QR_scanner').val(null);

                            
                        initializeTypeAheadField();

                        $('#__rm_id_QR_scanner').focus();

                    }
                }
            });
        }
    }

</script>

