<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    {{-- <meta name="viewport" content="width=device-width, initial-scale=1.0"> --}}
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>
        {{ $title }}
    </title>

    <style type="text/css">
        * {
            margin: 0px;
            padding: 0px;
        }

        @font-face {
            font-family: 'THSarabunNew';
            font-style: normal;
            font-weight: normal;
            src: url('./fonts/Sarabun/Sarabun-Bold.ttf');
        }

        body {
            font-family: 'THSarabunNew', sans-serif;
            font-size: 25px;
        }
    </style>
</head>
<body style="padding: 1.5cm">

    <div style="clear: both; width: 100%;">
        <div style="float: left;">
            <h4 style="font-weight: bold; font-size: 24px">
                <span style="text-decoration: underline">
                    Shipment ID # {{ $orderManagement->shipment->id }}
                </span>
                <br>
                <span style="text-decoration: underline">
                    Order ID #{{ $orderManagement->id }}
                </span>
            </h4>
        </div>
        <div style="float: right; width: 100px">
           asif 1
        </div>
    </div>

    <div style="clear: both; width: 100%;">
        <div style="padding: 25px; border-radius: 5px; border: 1px solid #000000; margin-top: 40px;">
            <p style="font-weight: bold; color: #444">
                From
            </p>
            <p style="font-size: 34px; margin-top: 20px">
                @if(empty($orderManagement->shop->name) && empty($orderManagement->shop->phone))
                    No Address Selected Yet
                @endif

                @if(!empty($orderManagement->shop->name))
                    <span style="font-weight: bold">
                        {{ $orderManagement->shop->name }}
                    </span>
                @endif
            </p>

            <p>
                @if (!empty($orderManagement->shop->address))
                    {{ $orderManagement->shop->address }}
                    <br>
                @endif
                @if(!empty($orderManagement->shop->district))
                    {{ $orderManagement->shop->district }}
                @endif
                @if(!empty($orderManagement->shop->sub_district))
                    {{ $orderManagement->shop->sub_district }}
                    <br>
                @endif
                @if(!empty($orderManagement->shop->province))
                    {{ $orderManagement->shop->province }}
                    <br>
                @endif
                @if(!empty($orderManagement->shop->postcode))
                    {{ $orderManagement->shop->postcode }}
                @endif
                <br>
                @if(!empty($orderManagement->shop->phone))
                    {{ $orderManagement->shop->phone }}
                @endif
            </p>
        </div>
    </div>

    <div style="clear: both; width: 100%;">
        <div style="padding: 25px; border-radius: 5px; border: 1px solid #000000; margin-top: 20px;">
            <p style="font-weight: bold; color: #444">
                To
            </p>
            <p style="font-size: 34px; margin-top: 20px">
                @if(empty($orderManagement->shipping_name))
                    No Address Selected Yet
                @endif

                @if(!empty($orderManagement->shipping_name))
                    <span style="font-weight: bold">
                        {{ $orderManagement->shipping_name }}
                    </span>
                @endif
            </p>

            <p>
                @if (!empty($orderManagement->shipping_address))
                    {{ $orderManagement->shipping_address }}
                    <br>
                @endif
                @if(!empty($orderManagement->shipping_district))
                    {{ $orderManagement->shipping_district }}
                @endif
                @if(!empty($orderManagement->shipping_sub_district))
                    {{ $orderManagement->shipping_sub_district }}
                    <br>
                @endif
                @if(!empty($orderManagement->shipping_province))
                    {{ $orderManagement->shipping_province }}
                    <br>
                @endif
                @if(!empty($orderManagement->shipping_postcode))
                    {{ $orderManagement->shipping_postcode }}
                @endif
                <br>
                @if(!empty($orderManagement->shipping_phone))
                    {{ $orderManagement->shipping_phone }}
                @endif
            </p>
        </div>
    </div>

    <div style="width: 100%; clear: both; font-size: 20px; margin-top: 50px; position: absolute; bottom: 0; height: 60px;">
        <div style="float: left; width: 33%">
          SHOP NAME:<br>
          <strong>{{$shopName}}</strong>
        </div>

        <div style="float: left; width: 33%">
          CHANNEL NAME:<br>
          <strong>{{$channelName}}</strong>
        </div>

        <div style="float: left; width: 33%">
          SHIPPING METHOD:<br>
          <strong>{{$shippingMethod}}</strong>
        </div>
      </div> 

    <div style="page-break-before: always;"></div>

    <div style="clear: both; width: 100%;">
        <div style="float: left;">
            <h4 style="font-weight: bold; font-size: 24px">
                <span style="text-decoration: underline">
                    Shipment ID #{{ $orderManagement->shipment->id }}
                </span>
                <br>
                <span style="text-decoration: underline">
                    Order ID #{{ $orderManagement->id }}
                </span>
            </h4>
        </div>
        <div style="float: right; width: 100px">
            asif 2
        </div>
    </div>

    <div style="clear: both; width: 100%;">
        <div style="margin-top: 30px;">
            <table style="width: 100%">
                <thead>
                    <tr>
                        <th style="padding: 10px; background-color: #ccc; text-align: left; font-size: 18px; width: 120px;">
                            Image
                        </th>
                        <th style="padding: 10px; background-color: #ccc; text-align: left; font-size: 18px">
                            Product Details
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($orderManagement->order_management_details as $detail)
                        <tr>
                            <td style="border-bottom: 1px solid #ccc; padding: 15px 5px; text-align: center; vertical-align: top;">
                                @if (!empty($detail->product->image) && file_exists(public_path($detail->product->image)))
                                    <img src="{{ public_path($detail->product->image) }}" alt="{{ $detail->product->part_name }}" style="width: 100px; height: auto">
                                @else
                                    <img src="{{ public_path('No-Image-Found.png') }}" alt="{{ $detail->product->part_name }}" style="width: 100px; height: auto">
                                @endif
                            </td>
                            <td style="border-bottom: 1px solid #ccc; padding: 5px 10px; padding-bottom: 20px;">
                                <p style="font-size: 18px">
                                    {{ $detail->product->part_name }}
                                </p>
                                <p style="font-size: 18px">
                                    <span style="color: #444">
                                        Code:
                                    </span>
                                    {{ $detail->product->part_no }}
                                </p>
                                <p style="font-size: 18px">
                                    <span style="color: #444">
                                        Price:
                                    </span>
                                    {{ currency_symbol('BDT') }}
                                    {{ currency_number($detail->price, 3) }}
                                </p>
                                <p style="font-size: 18px">
                                    <span style="color: #444">
                                        Order Qty:
                                    </span>
                                    {{ currency_number($detail->quantity) }}
                                </p>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>

    <div style="width: 100%; clear: both; font-size: 20px; margin-top: 50px; position: absolute; bottom: 0; height: 60px;">
        <div style="float: left; width: 33%">
          SHOP NAME:<br>
          <strong>{{$shopName}}</strong>
        </div>

        <div style="float: left; width: 33%">
          CHANNEL NAME:<br>
          <strong>{{$channelName}}</strong>
        </div>

        <div style="float: left; width: 33%">
          SHIPPING METHOD:<br>
          <strong>{{$shippingMethod}}</strong>
        </div>
      </div> 
</body>
</html>
