<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>
        {{ config('app.name') }} - @yield('title')
    </title>

    @stack('top_css')

    <!-- CUSTOM STYLE NEW THEME  -->
    <link href="{{ asset('mk_theme/css/vendors/flatpickr.min.css') }}" rel="stylesheet">
    <link href="{{ asset('mk_theme/style.css') }}" rel="stylesheet">
    <link href="{{ asset('mk_theme/css/custom.css') }}" rel="stylesheet">
    <link href="{{ asset('mk_theme/css/custom.css') }}" rel="stylesheet">
    <link rel="stylesheet" href="{{ asset('chosen/prism.css')}}">
  <link rel="stylesheet" href="{{ asset('chosen/chosen.css')}}">
    
    @stack('bottom_css')
    <!-- CUSTOM STYLE NEW THEME  -->
    <script>

        document.querySelector('html').classList.add('white');
        document.querySelector('html').style.colorScheme = 'white';
    
    </script>


    @stack('top_js')

    @routes
</head>

 <body
    class="font-inter antialiased bg-gray-100 dark:bg-gray-900 text-gray-600 dark:text-gray-400"
    :class="{ 'sidebar-expanded': sidebarExpanded }"
    x-data="{ sidebarOpen: false, sidebarExpanded: localStorage.getItem('sidebar-expanded') == 'true', transactionOpen: true }"
    @set-transactionopen="transactionOpen = $event.detail"
    x-init="$watch('sidebarExpanded', value => localStorage.setItem('sidebar-expanded', value))"
>
    <script>
    if (localStorage.getItem('sidebar-expanded') == 'true') {
        document.querySelector('body').classList.add('sidebar-expanded');
    } else {
        document.querySelector('body').classList.remove('sidebar-expanded');
    }
    </script>

    <!-- Page wrapper -->
    <div class="flex h-[100dvh] overflow-hidden">
        @include('layouts.sidebar-navigation')

        <!-- Content area -->
        <div class="relative flex flex-col flex-1 overflow-y-auto overflow-x-hidden bg-white dark:bg-gray-900">

            <main class="grow">
                @if(session('registration-success'))
                    <div class="w-full  col-span-12 md:col-span-12 px-6 pt-6">
                        {{ session('registration-success') }}
                    </div>
                @endif
                {{ $slot }}                
            </main>
        </div>

    </div>

    <!-- @if (request()->routeIs('dashboard'))
    @include('elements.mobile-quick-links')
    @endif -->
    <script src="{{ asset('mk_theme/js/vendors/alpinejs.min.js') }}" defer></script>
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/jquery-datatables-checkboxes@1.2.12/js/dataTables.checkboxes.min.js">
    <script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
    <script src="{{ asset('js/jquery-numbersinwords.js') }}"></script>

    <script src="{{ asset('chosen/chosen.jquery.js')}}" type="text/javascript"></script>
    <script src="{{ asset('chosen/init.js')}}" type="text/javascript" charset="utf-8"></script>


    <script src="{{ asset('js/custom.js') }}"></script>
    <script>
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });
    </script>

    @stack('bottom_js')

</body>

</html>