@csrf


        <div class="mb-5">
            <x-label>
                {{ __('translation.Date') }} <x-form.required-mark />
            </x-label>
            <input type="hidden" name="reference" id="reference" value="{{ $expenses[0]->reference }}">
            <x-input type="text" autocomplete=off class="datepicker" name="entry_date" value="{{ $expenses[0]->entry_date ?? old('entry_date')}}" required/>
        </div>
        <div id="__wrapperAdditionalContact2">
            @foreach ($expenses as $row )
                <div class="additional-contact flex flex-col md:flex-row md:gap-x-5">
                    <div class="mb-5 md:w-2/5">
                        <x-label>
                            {{ __('translation.Description') }}
                        </x-label>
                        <x-input type="text" name="name[]" id="name" value="{{ $row->name ?? old('name') }}"/>
                    </div>
                    <div class="mb-5 md:w-2/5">
                        <x-label>
                            {{ __('translation.Amount') }}
                        </x-label>
                        <x-input type="text" name="amount[]" id="amount" value="{{ $row->amount ?? old('amount') }}"/>
                    </div>
                    <div class="mb-8 md:mb-5 md:pt-7 md:w-1/8">
                            <x-button type="button" color="red" class="w-full __btnRemoveContact2">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                                </svg>
                            </x-button>
                        </div>
                </div>
            @endforeach
        </div>

        <div class="mb-8 md:mb-5 md:pt-7 md:w-1/8">
            <x-button type="button" color="green" class="w-full" id="__btnAddNewContact">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6" />
                </svg>
                Add More
            </x-button>
        </div>

            <div class="hide" id="__newContactTemplate2">
                <div class="additional-contact flex flex-col md:flex-row md:gap-x-5">
                    <div class="mb-5 md:w-2/5">
                    <x-label>
                        {{ __('translation.Description') }}
                    </x-label>
                    <x-input type="text" name="name[]" />
                </div>
                <div class="mb-5 md:w-2/5">
                    <x-label>
                        {{ __('translation.Amount') }}
                    </x-label>
                    <x-input type="text" name="amount[]" />
                </div>
                    <div class="mb-8 md:mb-5 md:pt-7 md:w-1/8">
                        <x-button type="button" color="red" class="w-full __btnRemoveContact2">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                            </svg>
                        </x-button>
                    </div>
                </div>
            </div>


        <div class="mb-5">
            <label class="font-weight-bold">
                {{ __('translation.Note') }}
            </label>
            <x-form.textarea name="note" rows="3">{{ $expenses[0]->note ?? old('note') }}</x-form.textarea>
        </div>

        <div class="flex justify-end py-6">
            <x-button type="reset" color="gray" class="mr-1" id="__btnCancelModalUpdate">
                {{ __('translation.Cancel') }}
            </x-button>
            <x-button type="submit" color="blue" id="__btnUpdateSubmit">
                {{ __('translation.Update') }}
            </x-button>
        </div>

      <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
        <script src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
        <script src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.0/jquery.validate.js"></script>

 <script>
    $(".datepicker").datepicker({
        dateFormat: 'dd-mm-yy'
    });

    $(document).on('click','#__btnAddNewContact',function(){
        let newContactTemplate2 = $('#__newContactTemplate2').html();
        $('#__wrapperAdditionalContact2').append(newContactTemplate2);
    });

         $(document).on('click','.__btnRemoveContact2',function(){
            $(this).parents(".additional-contact").remove();
        });

</script>

<script>
    $(document).ready(function() {
        $('#__btnCancelModalUpdate').click(function() {
            $('body').removeClass('modal-open');
            $('#__modalUpdate').addClass('modal-hide');
        });
    });

</script>
