<x-app-layout>
    @section('title', 'Employees')
        <x-card title="Employees">
            <div class="mt-6">
                @if(session('success'))
                    <x-alert-success>{{ session('success') }}</x-alert-success>
                @endif
                @if(session('danger'))
                    <x-alert-danger>{{ session('danger') }}</x-alert-danger>
                @endif
                @if ($errors->any())
                    <x-alert-danger>
                        <ul class="mt-3 list-disc list-inside text-sm text-red-600">
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </x-alert-danger>
                @endif

                <x-button class="mb-6" color="green" id="BtnInsert">
                    <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v3m0 0v3m0-3h3m-3 0H9m12 0a9 9 0 11-18 0 9 9 0 0118 0z" />
                    </svg>
                    <span class="ml-2">
                    {{ __('translation.Add Employee') }}
                </span>
                </x-button>
            </div>

            <div class="flex justify-between flex-col">
                <div class="overflow-x-auto">
                    <table class="w-full" id="datatable">
                        <thead>
                        <tr class="rounded-lg text-sm font-medium text-gray-700 text-left">
                            <th>{{ __('translation.ID') }}</th>
                            <th>{{ __('translation.Employee Name') }}</th>
                            <th>{{ __('translation.Phone') }}</th>
                            <th>{{ __('translation.Email') }}</th>
                            <th>{{ __('translation.Address') }}</th>
                            <th>{{ __('translation.Action') }}</th>
                        </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </x-card>


<!-- insert modal -->
    <x-modal.modal-large class="modal-hide modal-insert">
        <x-modal.header>
            <x-modal.title>
                {{ __('translation.Add Employee') }}
            </x-modal.title>
            <x-modal.close-button id="closeModalInsert" />
        </x-modal.header>
        <x-modal.body>
            <div class="pb-6">
                <form method="POST" action="{{ route('employees.store') }}" id="form-insert">
                    @csrf
                    <div>
                        <!-- Select -->
                        <!-- <div>
                            <label class="block text-sm font-medium mb-1" for="shop_id">Shop</label>
                            <select name="shop_id" class="form-select w-full">
                                <option value="">Select Unit</option>
                                @if($shops)
                                    @foreach($shops as $row)
                                    <option value='{{$row->id}}'>{{$row->name}} ({{$row->location}})</option>
                                    @endforeach
                                @endif
                            </select>
                        </div> -->
                        @else
                            <input id="shop_id" name="shop_id" class="form-input w-full px-2 py-1" type="hidden" value="{{Auth::user()->shop_id}}" />
                        @endif

                        <div class="form-group font-weight-bold">
                            <label for="employee_name">Employee Name</label>
                            <input type="text" class="form-control mt-1" name="employee_name" id="employee_name" value="{{ old('employee_name') }}" required autocomplete="off">
                        </div>
                        <div class="flex flex-col md:flex-row md:gap-x-5">
                        <div class="mb-5 md:w-3/4">
                            <label class="font-weight-bold">
                                {{ __('translation.Email') }}
                            </label>
                            <x-input type="email" name="email" id="email"/>
                        </div>
                        <div class="mb-5 md:w-3/4">
                            <label class="font-weight-bold">
                                {{ __('translation.Phone') }}
                            </label>
                            <x-input type="text" name="phone" id="phone"/>
                        </div>
                    </div>

                    <div class="mb-5">
                        <label class="font-weight-bold">
                            {{ __('translation.Address') }}
                        </label>
                        <x-form.textarea name="address" rows="3">{{ old('address') }}</x-form.textarea>
                    </div>

                    <div class="mb-5">
                        <label class="font-weight-bold">
                            {{ __('translation.Note') }}
                        </label>
                        <x-form.textarea name="note" rows="3">{{ old('note') }}</x-form.textarea>
                    </div>

                    </div>

                    <div class="flex justify-end py-6">
                        <x-button type="reset" color="gray" class="mr-1" id="cancelModalInsert">
                            {{ __('translation.Cancel') }}
                        </x-button>
                        <x-button type="submit" color="blue">
                            {{ __('translation.Submit') }}
                        </x-button>
                    </div>
                </form>
            </div>
        </x-modal.body>
    </x-modal.modal-large>

    {{-- update modal --}}
    <x-modal.modal-large class="modal-hide modal-update">
        <x-modal.header>
            <x-modal.title>
                {{ __('translation.Update Employee') }}
            </x-modal.title>
            <x-modal.close-button id="closeModalUpdate" />
        </x-modal.header>
        <x-modal.body>
            <div class="pb-6">
                <form style="max-height:90vh" method="POST" action="{{ route('employees.update') }}" id="form-update"></form>
            </div>
        </x-modal.body>
    </x-modal.modal-large>


    @push('bottom_js')
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.0/jquery.validate.js"></script>
        <script>
            $(document).ready(function() {
                dataTables("{{ route('employees.data') }}?date=" + $(this).val());

                var datatable;
                $('#inputDate').change(function() {
                    datatable.destroy();
                    dataTables("{{ route('employees.data') }}?date=" + $(this).val());
                });

                function dataTables(url) {
                    // Datatable
                    datatable = $('#datatable').DataTable({
                        processing: true,
                        serverSide: true,
                        ajax: url,
                        columns: [
                            {
                                name: 'id',
                                data: 'id',
                                render: function (data, type, row, meta) {
                                    return meta.row + meta.settings._iDisplayStart + 1
                                }
                            },
                            {
                                name: 'employee_name',
                                data: 'employee_name'
                            },
                            {
                                name: 'phone',
                                data: 'phone'
                            },
                            {
                                name: 'email',
                                data: 'email'
                            },
                            {
                                name: 'address',
                                data: 'address'
                            },
                            {
                                name: 'action',
                                data: 'action'
                            }
                        ],
                        columnDefs: [
                            {
                                targets: 0,
                                searchable: false,
                                orderable: false
                            }
                        ]
                    });
                }

                $('#BtnInsert').click(function() {
                    $('.modal-insert').removeClass('modal-hide');
                });

                $(document).on('click', '#closeModalUpdate', function() {
                    $('.modal-update').addClass('modal-hide');
                });

                $(document).on('click', '#BtnUpdate', function() {
                    $('.modal-update').removeClass('modal-hide');
                    $.ajax({
                        url: '{{ route('employees.data') }}?id=' + $(this).data('id'),
                        beforeSend: function() {
                            $('#form-update').html('Loading');
                        }
                    }).done(function(result) {
                        $('#form-update').html(result);
                    });
                });

                $('#closeModalInsert').click(function() {
                    $('.modal-insert').addClass('modal-hide');
                });

                $('#cancelModalInsert').click(function() {
                    $('.modal-insert').addClass('modal-hide');
                });

                $(document).on('click', '#BtnDelete', function() {
                    let drop = confirm('Are you sure?');
                    if (drop) {
                        $.ajax({
                            url: '{{ route('employees.delete') }}',
                            type: 'post',
                            data: {
                                'id': $(this).data('id'),
                                '_token': $('meta[name=csrf-token]').attr('content')
                            },
                            beforeSend: function() {
                                // Pesan yang muncul ketika memproses delete
                            }
                        }).done(function(result) {
                            if (result.status === 1) {
                                // Pesan jika data berhasil di hapus
                                alert('Data deleted successfully');
                                $('#datatable').DataTable().ajax.reload();
                            } else {
                                alert(result.message);
                            }
                        });
                    }
                });
            });

        </script>
    @endpush

</x-app-layout>
